/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.RemoveCastNodes;
import com.google.javascript.jscomp.serialization.SerializationOptions;
import com.google.javascript.jscomp.serialization.TypedAst;
import com.google.javascript.jscomp.serialization.TypedAstSerializer;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;

public final class SerializeTypedAstPass
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Consumer<TypedAst> consumer;
    private final SerializationOptions serializationOptions;

    SerializeTypedAstPass(AbstractCompiler compiler, Consumer<TypedAst> astConsumer, SerializationOptions serializationOptions) {
        this.compiler = compiler;
        this.consumer = astConsumer;
        this.serializationOptions = serializationOptions;
    }

    public static SerializeTypedAstPass createFromOutputStream(AbstractCompiler c, OutputStream out, SerializationOptions serializationOptions) {
        Consumer<TypedAst> toOutputStream = ast -> {
            try {
                TypedAst.List.newBuilder().addTypedAsts((TypedAst)ast).build().writeTo(out);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot write to stream", e);
            }
        };
        return new SerializeTypedAstPass(c, toOutputStream, serializationOptions);
    }

    public static SerializeTypedAstPass createFromPath(AbstractCompiler compiler, Path outputPath, SerializationOptions serializationOptions) {
        Consumer<TypedAst> toPath = ast -> {
            try (GZIPOutputStream out = new GZIPOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
                TypedAst.List.newBuilder().addTypedAsts((TypedAst)ast).build().writeTo(out);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot create TypedAst output file", e);
            }
        };
        return new SerializeTypedAstPass(compiler, toPath, serializationOptions);
    }

    @Override
    public void process(Node externs, Node root) {
        new RemoveCastNodes(this.compiler).process(externs, root);
        TypedAstSerializer serializer = new TypedAstSerializer(this.compiler, this.serializationOptions);
        TypedAst ast = serializer.serializeRoots(externs, root);
        this.consumer.accept(ast);
    }
}

