/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.resources;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.resources.PropertiesParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

@GwtIncompatible(value="getResource, java.io.InputStreamReader")
public final class ResourceLoader {
    public static String loadTextResource(Class<?> clazz, String path) {
        try {
            return CharStreams.toString((Readable)new InputStreamReader(clazz.getResourceAsStream(path), StandardCharsets.UTF_8));
        }
        catch (NullPointerException e) {
            if (!ResourceLoader.resourceExists(clazz, path)) {
                throw new RuntimeException("No such resource: " + path);
            }
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImmutableMap<String, String> loadPropertiesMap(Class<?> clazz, String resourceName) {
        return PropertiesParser.parse(ResourceLoader.loadTextResource(clazz, resourceName));
    }

    public static ConformanceConfig loadGlobalConformance(Class<?> clazz) {
        ConformanceConfig.Builder builder = ConformanceConfig.newBuilder();
        if (ResourceLoader.resourceExists(clazz, "global_conformance.binarypb")) {
            try {
                builder.mergeFrom(clazz.getResourceAsStream("global_conformance.binarypb"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.build();
    }

    public static boolean resourceExists(Class<?> clazz, String path) {
        return clazz.getResource(path) != null;
    }

    private ResourceLoader() {
    }
}

