/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.regex;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.regex.CaseCanonicalize;
import com.google.javascript.jscomp.regex.CharRanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public abstract class RegExpTree {
    private static final RegExpTree NEVER_MATCHES = new LookaheadAssertion(Empty.INSTANCE, false);
    private static final CharRanges DIGITS = CharRanges.inclusive(48, 57);
    private static final CharRanges UCASE_LETTERS = CharRanges.inclusive(65, 90);
    private static final CharRanges LCASE_LETTERS = CharRanges.inclusive(97, 122);
    private static final CharRanges LETTERS = UCASE_LETTERS.union(LCASE_LETTERS);
    private static final CharRanges WORD_CHARS = DIGITS.union(LETTERS).union(CharRanges.withMembers(95));
    private static final CharRanges INVERSE_WORD_CHARS = CharRanges.ALL_CODE_UNITS.difference(WORD_CHARS);
    private static final CharRanges SPACE_CHARS = CharRanges.withMembers(9, 10, 11, 12, 13, 32, 160, 5760, 6158, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288, 65279);
    private static final CharRanges IE_SPACE_CHARS = CharRanges.withMembers(9, 10, 11, 12, 13, 32);
    private static final CharRanges IE_SPEC_ERRORS = SPACE_CHARS.difference(IE_SPACE_CHARS);
    private static final ImmutableMap<Character, CharRanges> NAMED_CHAR_GROUPS = ImmutableMap.builder().put((Object)Character.valueOf('d'), (Object)DIGITS).put((Object)Character.valueOf('D'), (Object)CharRanges.ALL_CODE_UNITS.difference(DIGITS)).put((Object)Character.valueOf('s'), (Object)SPACE_CHARS).put((Object)Character.valueOf('S'), (Object)CharRanges.ALL_CODE_UNITS.difference(SPACE_CHARS)).put((Object)Character.valueOf('w'), (Object)WORD_CHARS).put((Object)Character.valueOf('W'), (Object)INVERSE_WORD_CHARS).buildOrThrow();
    private static final Charset DOT_CHARSET = new Charset(CharRanges.ALL_CODE_UNITS.difference(CharRanges.withMembers(10, 13, 8232, 8233)), CharRanges.EMPTY);

    public abstract RegExpTree simplify(String var1);

    public abstract boolean isCaseSensitive();

    public abstract boolean containsAnchor();

    public final boolean hasCapturingGroup() {
        return this.numCapturingGroups() != 0;
    }

    public abstract int numCapturingGroups();

    public abstract List<? extends RegExpTree> children();

    protected abstract void appendSourceCode(StringBuilder var1);

    protected abstract void appendDebugInfo(StringBuilder var1);

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        this.appendSourceCode(sb);
        if (sb.length() == 1) {
            sb.append("(?:)");
        }
        sb.append('/');
        return sb.toString();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static RegExpTree parseRegExp(final String pattern, final String flags) {
        class Parser {
            int pos;
            int numCapturingGroups;
            Set<String> capturingGroupNames = new HashSet<String>();
            final int limit = pattern.length();
            boolean lookForNamedCaptureBackreferences;

            Parser() {
            }

            RegExpTree parseTopLevel() {
                this.pos = 0;
                this.numCapturingGroups = 0;
                this.lookForNamedCaptureBackreferences = false;
                RegExpTree out = this.parse();
                if (!this.capturingGroupNames.isEmpty()) {
                    this.pos = 0;
                    this.numCapturingGroups = 0;
                    this.lookForNamedCaptureBackreferences = true;
                    out = this.parse();
                }
                if (this.pos < this.limit) {
                    throw new IllegalArgumentException(pattern.substring(this.pos));
                }
                return out;
            }

            RegExpTree parse() {
                ImmutableList.Builder alternatives = null;
                RegExpTree preceder = null;
                block12: while (this.pos < this.limit) {
                    RegExpTree atom;
                    char ch = pattern.charAt(this.pos);
                    switch (ch) {
                        case '[': {
                            atom = this.parseCharset();
                            break;
                        }
                        case '(': {
                            atom = this.parseParenthetical();
                            break;
                        }
                        case ')': {
                            break block12;
                        }
                        case '\\': {
                            atom = this.parseEscape();
                            break;
                        }
                        case '$': 
                        case '^': {
                            atom = new Anchor(ch);
                            ++this.pos;
                            break;
                        }
                        case '.': {
                            atom = DOT_CHARSET;
                            ++this.pos;
                            break;
                        }
                        case '|': {
                            atom = Empty.INSTANCE;
                            break;
                        }
                        default: {
                            int end;
                            int start = this.pos;
                            block13: for (end = this.pos + 1; end < this.limit; ++end) {
                                switch (pattern.charAt(end)) {
                                    case '$': 
                                    case '(': 
                                    case ')': 
                                    case '*': 
                                    case '+': 
                                    case '.': 
                                    case '?': 
                                    case '[': 
                                    case '\\': 
                                    case '^': 
                                    case '{': 
                                    case '|': {
                                        break block13;
                                    }
                                    default: {
                                        if (end + 1 < this.limit && this.isRepetitionStart(pattern.charAt(end + 1))) break block13;
                                        continue block13;
                                    }
                                }
                            }
                            atom = new Text(pattern.substring(start, end));
                            this.pos = end;
                        }
                    }
                    if (this.pos < this.limit && this.isRepetitionStart(pattern.charAt(this.pos))) {
                        atom = this.parseRepetition(atom);
                    }
                    preceder = preceder == null ? atom : new Concatenation(preceder, atom);
                    if (this.pos >= this.limit || pattern.charAt(this.pos) != '|') continue;
                    if (alternatives == null) {
                        alternatives = ImmutableList.builder();
                    }
                    alternatives.add((Object)preceder);
                    preceder = null;
                    ++this.pos;
                }
                if (preceder == null) {
                    preceder = Empty.INSTANCE;
                }
                if (alternatives != null) {
                    alternatives.add((Object)preceder);
                    return new Alternation((List<? extends RegExpTree>)alternatives.build());
                }
                return preceder;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private RegExpTree parseParenthetical() {
                ParentheticalType type;
                Preconditions.checkState((pattern.charAt(this.pos) == '(' ? 1 : 0) != 0);
                int start = this.pos++;
                String captureName = null;
                if (this.pos < this.limit && pattern.charAt(this.pos) == '?') {
                    if (this.pos + 1 >= this.limit) throw new IllegalArgumentException("Malformed parenthetical: " + pattern.substring(start));
                    char ch = pattern.charAt(this.pos + 1);
                    switch (ch) {
                        case ':': {
                            this.pos += 2;
                            type = ParentheticalType.NONCAPTURING;
                            break;
                        }
                        case '=': {
                            this.pos += 2;
                            type = ParentheticalType.POSITIVE_LOOKAHEAD;
                            break;
                        }
                        case '!': {
                            this.pos += 2;
                            type = ParentheticalType.NEGATIVE_LOOKAHEAD;
                            break;
                        }
                        case '<': {
                            if (this.pos + 2 < this.limit && pattern.charAt(this.pos + 2) == '=') {
                                this.pos += 3;
                                type = ParentheticalType.POSITIVE_LOOKBEHIND;
                                break;
                            }
                            if (this.pos + 2 < this.limit && pattern.charAt(this.pos + 2) == '!') {
                                this.pos += 3;
                                type = ParentheticalType.NEGATIVE_LOOKBEHIND;
                                break;
                            }
                            this.pos += 2;
                            captureName = this.scanNamedGroupName();
                            this.capturingGroupNames.add(captureName);
                            type = ParentheticalType.NAMED_GROUPS;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Malformed parenthetical: " + pattern.substring(start));
                        }
                    }
                } else {
                    type = ParentheticalType.CAPTURING;
                }
                RegExpTree body = this.parse();
                if (this.pos >= this.limit || pattern.charAt(this.pos) != ')') throw new IllegalArgumentException("Unclosed parenthetical group: " + pattern.substring(start));
                ++this.pos;
                switch (type) {
                    case CAPTURING: {
                        ++this.numCapturingGroups;
                        return new CapturingGroup(body);
                    }
                    case NONCAPTURING: {
                        return body;
                    }
                    case POSITIVE_LOOKAHEAD: {
                        return new LookaheadAssertion(body, true);
                    }
                    case NEGATIVE_LOOKAHEAD: {
                        return new LookaheadAssertion(body, false);
                    }
                    case POSITIVE_LOOKBEHIND: {
                        return new LookbehindAssertion(body, true);
                    }
                    case NEGATIVE_LOOKBEHIND: {
                        return new LookbehindAssertion(body, false);
                    }
                    case NAMED_GROUPS: {
                        if (captureName == null) throw new IllegalArgumentException("Malformed named capture group: " + pattern.substring(start));
                        ++this.numCapturingGroups;
                        return new NamedCaptureGroup(body, captureName);
                    }
                }
                throw new AssertionError((Object)("Unrecognized ParentheticalType " + type));
            }

            private String scanNamedGroupName() {
                int start = this.pos;
                int end = this.pos;
                if (!RegExpTree.isIdentifierStart(pattern.charAt(start))) {
                    throw new IllegalArgumentException("Invalid capture group name: <" + pattern.substring(start));
                }
                ++end;
                while (end < this.limit) {
                    if (pattern.charAt(end) == '>') {
                        this.pos = end + 1;
                        return pattern.substring(start, end);
                    }
                    if (RegExpTree.isIdentifierPart(pattern.charAt(end))) {
                        ++end;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid capture group name: <" + pattern.substring(start));
                }
                throw new IllegalArgumentException("Malformed named capture group: <" + pattern.substring(start));
            }

            private RegExpTree parseCharset() {
                boolean inverse;
                Preconditions.checkState((pattern.charAt(this.pos) == '[' ? 1 : 0) != 0);
                ++this.pos;
                boolean isCaseInsensitive = flags.indexOf(105) >= 0;
                boolean bl = inverse = this.pos < this.limit && pattern.charAt(this.pos) == '^';
                if (inverse) {
                    ++this.pos;
                }
                CharRanges ranges = CharRanges.EMPTY;
                CharRanges ieExplicits = CharRanges.EMPTY;
                while (this.pos < this.limit && pattern.charAt(this.pos) != ']') {
                    int start;
                    int ch = pattern.charAt(this.pos);
                    if (ch == 92) {
                        ++this.pos;
                        char possibleGroupName = pattern.charAt(this.pos);
                        CharRanges group = (CharRanges)NAMED_CHAR_GROUPS.get((Object)Character.valueOf(possibleGroupName));
                        if (group != null) {
                            ++this.pos;
                            ranges = ranges.union(group);
                            continue;
                        }
                        start = this.parseEscapeChar();
                    } else {
                        start = ch;
                        ++this.pos;
                    }
                    int end = start;
                    if (this.pos + 1 < this.limit && pattern.charAt(this.pos) == '-' && pattern.charAt(this.pos + 1) != ']') {
                        ++this.pos;
                        ch = pattern.charAt(this.pos);
                        if (ch == 92) {
                            ++this.pos;
                            end = this.parseEscapeChar();
                        } else {
                            end = ch;
                            ++this.pos;
                        }
                    }
                    CharRanges range = CharRanges.inclusive(start, end);
                    ranges = ranges.union(range);
                    if (IE_SPEC_ERRORS.contains(start) && IE_SPEC_ERRORS.contains(end)) {
                        ieExplicits = ieExplicits.union(range.intersection(IE_SPEC_ERRORS));
                    }
                    if (!isCaseInsensitive) continue;
                    ranges = CaseCanonicalize.expandToAllMatched(ranges);
                }
                ++this.pos;
                if (inverse) {
                    ranges = CharRanges.ALL_CODE_UNITS.difference(ranges);
                }
                return new Charset(ranges, ieExplicits);
            }

            private int parseEscapeChar() {
                char ch = pattern.charAt(this.pos++);
                switch (ch) {
                    case 'b': {
                        return 8;
                    }
                    case 'f': {
                        return 12;
                    }
                    case 'n': {
                        return 10;
                    }
                    case 'r': {
                        return 13;
                    }
                    case 't': {
                        return 9;
                    }
                    case 'u': {
                        return flags.contains("u") && this.pos < this.limit && pattern.charAt(this.pos) == '{' ? this.parseBracedUnicodeEscape() : this.parseHex(4);
                    }
                    case 'v': {
                        return 11;
                    }
                    case 'x': {
                        return this.parseHex(2);
                    }
                }
                if ('0' <= ch && ch <= '7') {
                    char codeUnit = (char)(ch - 48);
                    int octLimit = Math.min(this.limit, this.pos + (ch <= '3' ? 2 : 1) + (ch == '0' ? 1 : 0));
                    while (this.pos < octLimit && '0' <= (ch = pattern.charAt(this.pos)) && ch <= '7') {
                        codeUnit = (char)((codeUnit << 3) + (ch - 48));
                        ++this.pos;
                    }
                    return codeUnit;
                }
                return ch;
            }

            private RegExpTree parseEscape() {
                Preconditions.checkState((pattern.charAt(this.pos) == '\\' ? 1 : 0) != 0);
                int start = this.pos++;
                char ch = pattern.charAt(this.pos);
                if (ch == 'b' || ch == 'B') {
                    ++this.pos;
                    return new WordBoundary(ch);
                }
                if ((ch == 'p' || ch == 'P') && flags.contains("u")) {
                    boolean negated = ch == 'P';
                    ++this.pos;
                    if (this.pos < this.limit && pattern.charAt(this.pos) == '{') {
                        StringBuilder lhs = new StringBuilder();
                        while (++this.pos < this.limit && ((ch = pattern.charAt(this.pos)) == '_' || 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9')) {
                            lhs.append(ch);
                        }
                        if (this.pos < this.limit && ch == '}') {
                            ++this.pos;
                            return new UnicodePropertyEscape(null, lhs.toString(), negated);
                        }
                        if (this.pos < this.limit && ch == '=') {
                            StringBuilder rhs = new StringBuilder();
                            while (++this.pos < this.limit && ((ch = pattern.charAt(this.pos)) == '_' || 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9')) {
                                rhs.append(ch);
                            }
                            if (this.pos < this.limit && ch == '}') {
                                ++this.pos;
                                return new UnicodePropertyEscape(lhs.toString(), rhs.toString(), negated);
                            }
                            throw new IllegalArgumentException("Malformed Unicode Property Escape: expected '}' after " + pattern.substring(start, this.pos));
                        }
                        throw new IllegalArgumentException("Malformed Unicode Property Escape: expected '=' or '}' after " + pattern.substring(start, this.pos));
                    }
                    throw new IllegalArgumentException("Malformed Unicode Property Escape: expected '{' after " + pattern.substring(start, this.pos));
                }
                if ('1' <= ch && ch <= '9') {
                    ++this.pos;
                    int possibleGroupIndex = ch - 48;
                    if (this.numCapturingGroups >= possibleGroupIndex) {
                        int twoDigitGroupIndex;
                        char next;
                        if (this.pos < this.limit && '0' <= (next = pattern.charAt(this.pos)) && next <= '9' && this.numCapturingGroups >= (twoDigitGroupIndex = possibleGroupIndex * 10 + (next - 48))) {
                            ++this.pos;
                            possibleGroupIndex = twoDigitGroupIndex;
                        }
                        return new BackReference(possibleGroupIndex);
                    }
                    return new Text(Character.toString(possibleGroupIndex <= 7 ? (char)possibleGroupIndex : ch));
                }
                if (this.lookForNamedCaptureBackreferences && ch == 'k' && this.pos + 1 < this.limit && pattern.charAt(this.pos + 1) == '<' && !this.capturingGroupNames.isEmpty()) {
                    this.pos += 2;
                    String potentialName = this.scanNamedGroupName();
                    if (!this.capturingGroupNames.contains(potentialName)) {
                        throw new IllegalArgumentException("Invalid named capture referenced: " + pattern.substring(start));
                    }
                    return new NamedBackReference(potentialName);
                }
                CharRanges charGroup = (CharRanges)NAMED_CHAR_GROUPS.get((Object)Character.valueOf(ch));
                if (charGroup != null) {
                    ++this.pos;
                    return new Charset(charGroup, CharRanges.EMPTY);
                }
                return new Text(new String(Character.toChars(this.parseEscapeChar())));
            }

            private int parseHex(int n) {
                if (this.pos + n > this.limit) {
                    throw new IllegalArgumentException("Abbreviated hex escape " + pattern.substring(this.pos));
                }
                if (n > 7) {
                    throw new IllegalArgumentException("Cannot parse hexadecimal encoding wider than 28 bits: " + pattern.substring(this.pos, this.pos + n));
                }
                int result = 0;
                while (--n >= 0) {
                    int digit;
                    char ch = pattern.charAt(this.pos);
                    if ('0' <= ch && ch <= '9') {
                        digit = ch - 48;
                    } else if ('a' <= ch && ch <= 'f') {
                        digit = ch + -87;
                    } else if ('A' <= ch && ch <= 'F') {
                        digit = ch + -55;
                    } else {
                        throw new IllegalArgumentException(pattern.substring(this.pos));
                    }
                    ++this.pos;
                    result = result << 4 | digit;
                }
                return result;
            }

            private int parseBracedUnicodeEscape() {
                int closeBrace;
                int openBrace = this.pos;
                Preconditions.checkState((pattern.charAt(this.pos++) == '{' ? 1 : 0) != 0);
                for (closeBrace = this.pos; closeBrace < this.limit && pattern.charAt(closeBrace) != '}'; ++closeBrace) {
                }
                if (closeBrace == this.limit) {
                    throw new IllegalArgumentException("Malformed unicode escape: expected '}' after " + pattern.substring(openBrace));
                }
                if (closeBrace == this.pos) {
                    throw new IllegalArgumentException("Empty unicode escape");
                }
                int result = this.parseHex(closeBrace - this.pos);
                if (result > 0x10FFFF) {
                    throw new IllegalArgumentException("Unicode must be at most 0x10FFFF: " + pattern.substring(openBrace + 1, this.pos));
                }
                ++this.pos;
                return result;
            }

            private boolean isRepetitionStart(char ch) {
                switch (ch) {
                    case '*': 
                    case '+': 
                    case '?': 
                    case '{': {
                        return true;
                    }
                }
                return false;
            }

            private RegExpTree parseRepetition(RegExpTree body) {
                int max;
                int min;
                if (this.pos == this.limit) {
                    return body;
                }
                switch (pattern.charAt(this.pos)) {
                    case '+': {
                        ++this.pos;
                        min = 1;
                        max = Integer.MAX_VALUE;
                        break;
                    }
                    case '*': {
                        ++this.pos;
                        min = 0;
                        max = Integer.MAX_VALUE;
                        break;
                    }
                    case '?': {
                        ++this.pos;
                        min = 0;
                        max = 1;
                        break;
                    }
                    case '{': {
                        ++this.pos;
                        int start = this.pos;
                        int end = pattern.indexOf(125, start);
                        if (end < 0) {
                            this.pos = start - 1;
                            return body;
                        }
                        String counts = pattern.substring(start, end);
                        this.pos = end + 1;
                        int comma = counts.indexOf(44);
                        try {
                            min = Integer.parseInt(comma >= 0 ? counts.substring(0, comma) : counts);
                            max = comma >= 0 ? (comma + 1 != counts.length() ? Integer.parseInt(counts.substring(comma + 1)) : Integer.MAX_VALUE) : min;
                        }
                        catch (NumberFormatException ex) {
                            max = -1;
                            min = -1;
                        }
                        if (min >= 0 && min <= max) break;
                        this.pos = start - 1;
                        return body;
                    }
                    default: {
                        return body;
                    }
                }
                boolean greedy = true;
                if (this.pos < this.limit && pattern.charAt(this.pos) == '?') {
                    greedy = false;
                    ++this.pos;
                }
                return new Repetition(body, min, max, greedy);
            }
        }
        return new Parser().parseTopLevel();
    }

    private static boolean isIdentifierStart(char ch) {
        if (ch <= '\u007f') {
            return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_' || ch == '$';
        }
        return ch == '\u0275' || Character.isLetter(ch);
    }

    private static boolean isIdentifierPart(char ch) {
        if (ch <= '\u007f') {
            return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '$';
        }
        return RegExpTree.isIdentifierStart(ch) || Character.isDigit(ch);
    }

    public static boolean matchesWholeInput(RegExpTree t, String flags) {
        if (flags.indexOf(109) >= 0) {
            return false;
        }
        if (!(t instanceof Concatenation)) {
            return false;
        }
        Concatenation c = (Concatenation)t;
        if (c.elements.isEmpty()) {
            return false;
        }
        RegExpTree first = (RegExpTree)c.elements.get(0);
        RegExpTree last = (RegExpTree)Iterables.getLast(c.elements);
        if (!(first instanceof Anchor) || !(last instanceof Anchor)) {
            return false;
        }
        return ((Anchor)first).type == '^' && ((Anchor)last).type == '$';
    }

    static void escapeCharOnto(char ch, StringBuilder sb) {
        switch (ch) {
            case '\u0000': {
                sb.append("\\0");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            default: {
                if (ch < ' ' || ch >= '\u007f') {
                    if (ch >= '\u0100') {
                        sb.append("\\u");
                        sb.append("0123456789abcdef".charAt(ch >> 12 & 0xF));
                        sb.append("0123456789abcdef".charAt(ch >> 8 & 0xF));
                        sb.append("0123456789abcdef".charAt(ch >> 4 & 0xF));
                        sb.append("0123456789abcdef".charAt(ch & 0xF));
                        break;
                    }
                    sb.append("\\x");
                    sb.append("0123456789abcdef".charAt(ch >> 4 & 0xF));
                    sb.append("0123456789abcdef".charAt(ch & 0xF));
                    break;
                }
                sb.append(ch);
            }
        }
    }

    public static final class Concatenation
    extends RegExpTree {
        final ImmutableList<RegExpTree> elements;

        Concatenation(RegExpTree a, RegExpTree b) {
            this.elements = ImmutableList.of((Object)a, (Object)b);
        }

        Concatenation(List<? extends RegExpTree> elements) {
            this.elements = ImmutableList.copyOf(elements);
        }

        @Override
        public RegExpTree simplify(final String flags) {
            class Simplifier {
                final List<RegExpTree> simplified = new ArrayList<RegExpTree>();

                Simplifier() {
                }

                void simplify(RegExpTree t) {
                    if (t instanceof Concatenation) {
                        for (RegExpTree child : ((Concatenation)t).elements) {
                            this.simplify(child);
                        }
                    } else if (!(t instanceof Empty)) {
                        RegExpTree pairwise;
                        int lastIndex = this.simplified.size() - 1;
                        if (lastIndex >= 0 && (pairwise = this.simplifyPairwise(this.simplified.get(lastIndex), t)) != null) {
                            this.simplified.set(lastIndex, pairwise);
                            return;
                        }
                        this.simplified.add(t);
                    }
                }

                @Nullable RegExpTree simplifyPairwise(RegExpTree before, RegExpTree after) {
                    if (before instanceof Text && after instanceof Text) {
                        return new Text(((Text)before).text + ((Text)after).text).simplify(flags);
                    }
                    int beforeMin = 1;
                    int beforeMax = 1;
                    RegExpTree beforeBody = before;
                    boolean beforeGreedy = false;
                    if (before instanceof Repetition) {
                        Repetition r = (Repetition)before;
                        beforeMin = r.min;
                        beforeMax = r.max;
                        beforeBody = r.body;
                        beforeGreedy = r.greedy;
                    }
                    int afterMin = 1;
                    int afterMax = 1;
                    RegExpTree afterBody = after;
                    boolean afterGreedy = false;
                    if (after instanceof Repetition) {
                        Repetition r = (Repetition)after;
                        afterMin = r.min;
                        afterMax = r.max;
                        afterBody = r.body;
                        afterGreedy = r.greedy;
                    }
                    if (beforeBody.equals(afterBody) && !beforeBody.hasCapturingGroup()) {
                        long lmin = (long)beforeMin + (long)afterMin;
                        long lmax = (long)beforeMax + (long)afterMax;
                        if (lmin < Integer.MAX_VALUE) {
                            int min = (int)lmin;
                            int max = lmax >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lmax;
                            return new Repetition(beforeBody, min, max, beforeGreedy || afterGreedy || min == max);
                        }
                    }
                    return null;
                }
            }
            Simplifier s = new Simplifier();
            for (RegExpTree element : this.elements) {
                s.simplify(element.simplify(flags));
            }
            switch (s.simplified.size()) {
                case 0: {
                    return Empty.INSTANCE;
                }
                case 1: {
                    return s.simplified.get(0);
                }
            }
            return new Concatenation(s.simplified);
        }

        @Override
        public boolean isCaseSensitive() {
            for (RegExpTree element : this.elements) {
                if (!element.isCaseSensitive()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAnchor() {
            for (RegExpTree element : this.elements) {
                if (!element.containsAnchor()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int numCapturingGroups() {
            int n = 0;
            for (RegExpTree element : this.elements) {
                n += element.numCapturingGroups();
            }
            return n;
        }

        public ImmutableList<? extends RegExpTree> children() {
            return this.elements;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            boolean digitsMightBleed = false;
            for (RegExpTree element : this.elements) {
                boolean parenthesize = false;
                if (element instanceof Alternation || element instanceof Concatenation) {
                    parenthesize = true;
                }
                if (parenthesize) {
                    sb.append("(?:");
                    element.appendSourceCode(sb);
                    sb.append(')');
                } else {
                    char firstChar;
                    int start = sb.length();
                    element.appendSourceCode(sb);
                    if (digitsMightBleed && sb.length() > start && '0' <= (firstChar = sb.charAt(start)) && firstChar <= '9') {
                        if (sb.charAt(start - 1) == '{') {
                            sb.insert(start - 1, '\\');
                        } else {
                            sb.insert(start, "(?:").append(')');
                        }
                    }
                }
                digitsMightBleed = element instanceof BackReference && ((BackReference)element).groupIndex < 10 || element instanceof Text && ((Text)element).text.endsWith("{");
            }
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Concatenation && this.elements.equals(((Concatenation)o).elements);
        }

        @Override
        public int hashCode() {
            return 0x20997E3E ^ this.elements.hashCode();
        }
    }

    static final class DecomposedCharset {
        boolean inverted;
        final CharRanges ranges;
        final String namedGroups;

        DecomposedCharset(boolean inverted, CharRanges ranges, String namedGroups) {
            this.inverted = inverted;
            this.ranges = ranges;
            this.namedGroups = namedGroups;
        }

        int complexity() {
            return (this.inverted ? 1 : 0) + this.namedGroups.length() + DecomposedCharset.complexity(this.ranges);
        }

        void appendSourceCode(StringBuilder sb) {
            if (this.ranges.isEmpty()) {
                if (!this.inverted && this.namedGroups.length() == 2) {
                    sb.append(this.namedGroups);
                    return;
                }
                if (this.ranges.isEmpty() && this.namedGroups.isEmpty()) {
                    sb.append(this.inverted ? "[\\S\\s]" : "(?!)");
                    return;
                }
            }
            sb.append('[');
            if (this.inverted) {
                sb.append('^');
            }
            sb.append(this.namedGroups);
            boolean rangesStartCharset = !this.inverted && this.namedGroups.isEmpty();
            boolean emitDashAtEnd = false;
            int n = this.ranges.getNumRanges();
            block4: for (int i = 0; i < n; ++i) {
                char start = (char)this.ranges.start(i);
                char end = (char)(this.ranges.end(i) - 1);
                switch (end - start) {
                    case 0: {
                        if (start == '-') {
                            emitDashAtEnd = true;
                            continue block4;
                        }
                        DecomposedCharset.escapeRangeCharOnto(start, rangesStartCharset, i == 0, i + 1 == n, sb);
                        continue block4;
                    }
                    case 1: {
                        DecomposedCharset.escapeRangeCharOnto(start, rangesStartCharset, i == 0, false, sb);
                        DecomposedCharset.escapeRangeCharOnto(end, rangesStartCharset, false, i + 1 == n, sb);
                        continue block4;
                    }
                    default: {
                        DecomposedCharset.escapeRangeCharOnto(start, rangesStartCharset, i == 0, false, sb);
                        sb.append('-');
                        DecomposedCharset.escapeRangeCharOnto(end, rangesStartCharset, false, true, sb);
                    }
                }
            }
            if (emitDashAtEnd) {
                sb.append('-');
            }
            sb.append(']');
        }

        static void escapeRangeCharOnto(char ch, boolean startIsFlush, boolean atStart, boolean atEnd, StringBuilder sb) {
            switch (ch) {
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '^': {
                    sb.append(atStart && startIsFlush ? "\\^" : "^");
                    break;
                }
                case '-': {
                    sb.append(atStart || atEnd ? "-" : "\\-");
                    break;
                }
                case '\\': 
                case ']': {
                    sb.append('\\').append(ch);
                    break;
                }
                default: {
                    RegExpTree.escapeCharOnto(ch, sb);
                }
            }
        }

        static int complexity(CharRanges ranges) {
            int complexity = 0;
            int n = ranges.getNumRanges();
            block4: for (int i = 0; i < n; ++i) {
                int start = ranges.start(i);
                int end = ranges.end(i) - 1;
                complexity = start < 32 || start >= 127 ? (complexity += start >= 256 ? 6 : 4) : ++complexity;
                switch (end - start) {
                    case 0: {
                        continue block4;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        ++complexity;
                    }
                }
                if (end < 32 || end >= 127) {
                    complexity += end >= 256 ? 6 : 4;
                    continue;
                }
                ++complexity;
            }
            return complexity;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DecomposedCharset)) {
                return false;
            }
            DecomposedCharset that = (DecomposedCharset)o;
            this.inverted = that.inverted && this.ranges.equals(that.ranges) && this.namedGroups.equals(that.namedGroups);
            return this.inverted;
        }

        public int hashCode() {
            return this.ranges.hashCode() + 31 * (this.namedGroups.hashCode() + (this.inverted ? 1 : 0));
        }
    }

    public static final class Charset
    extends RegExpTreeAtom {
        final CharRanges ranges;
        final CharRanges ieExplicits;

        Charset(CharRanges ranges, CharRanges ieExplicits) {
            this.ranges = ranges;
            this.ieExplicits = ieExplicits;
        }

        private static int complexityWordFolded(CharRanges ranges) {
            return Math.min(Charset.complexityWordFoldedHelper(ranges), 1 + Charset.complexityWordFoldedHelper(CharRanges.ALL_CODE_UNITS.difference(ranges)));
        }

        private static int complexityWordFoldedHelper(CharRanges ranges) {
            int complexity = DecomposedCharset.complexity(ranges);
            if (ranges.containsAll(WORD_CHARS)) {
                complexity = Math.min(complexity, 1 + DecomposedCharset.complexity(ranges.difference(WORD_CHARS)));
            }
            if (ranges.containsAll(INVERSE_WORD_CHARS)) {
                complexity = Math.min(complexity, 1 + DecomposedCharset.complexity(ranges.difference(INVERSE_WORD_CHARS)));
            }
            return complexity;
        }

        @Override
        public RegExpTree simplify(String flags) {
            if (this.ranges.isEmpty()) {
                return NEVER_MATCHES;
            }
            CharRanges best = this.ranges;
            if (flags.indexOf(105) >= 0) {
                LinkedHashSet<CharRanges> options = new LinkedHashSet<CharRanges>();
                options.add(CaseCanonicalize.expandToAllMatched(this.ranges));
                options.add(CaseCanonicalize.reduceToMinimum(this.ranges));
                CharRanges lcaseLetters = this.ranges.intersection(LCASE_LETTERS);
                CharRanges ucaseLetters = this.ranges.intersection(UCASE_LETTERS);
                CharRanges lcaseLettersToUpper = lcaseLetters.shift(-32);
                CharRanges ucaseLettersToLower = ucaseLetters.shift(32);
                options.add(this.ranges.union(ucaseLettersToLower));
                options.add(this.ranges.union(lcaseLettersToUpper));
                options.add(this.ranges.union(lcaseLettersToUpper).union(ucaseLettersToLower));
                options.add(this.ranges.union(ucaseLettersToLower).difference(ucaseLetters));
                options.add(this.ranges.union(lcaseLettersToUpper).difference(lcaseLetters));
                int bestComplexity = Charset.complexityWordFolded(this.ranges);
                for (CharRanges option : options) {
                    int complexity = Charset.complexityWordFolded(option);
                    if (complexity >= bestComplexity) continue;
                    bestComplexity = complexity;
                    best = option;
                }
            }
            if (best.getNumRanges() == 1 && best.end(0) - best.start(0) == 1) {
                return new Text(Character.toString((char)best.start(0)));
            }
            if (!best.equals(this.ranges)) {
                return new Charset(best, this.ieExplicits);
            }
            return this;
        }

        @Override
        public boolean isCaseSensitive() {
            CharRanges withoutNamedGroups = this.decompose().ranges;
            return !withoutNamedGroups.equals(CaseCanonicalize.expandToAllMatched(withoutNamedGroups));
        }

        private DecomposedCharset decompose(CharRanges ranges, boolean inverted) {
            StringBuilder namedGroups = new StringBuilder();
            CharRanges rangesInterIeExplicits = ranges.intersection(this.ieExplicits);
            while (true) {
                char groupName = '\u0000';
                CharRanges simplest = null;
                int minComplexity = DecomposedCharset.complexity(ranges);
                for (Map.Entry namedGroup : NAMED_CHAR_GROUPS.entrySet()) {
                    CharRanges withoutGroup;
                    int complexity;
                    CharRanges group = (CharRanges)namedGroup.getValue();
                    if (!ranges.containsAll(group) || (complexity = DecomposedCharset.complexity(withoutGroup = ranges.difference(group).union(rangesInterIeExplicits))) >= minComplexity) continue;
                    simplest = withoutGroup;
                    groupName = ((Character)namedGroup.getKey()).charValue();
                    minComplexity = complexity;
                }
                if (simplest == null) break;
                namedGroups.append('\\').append(groupName);
                ranges = simplest;
            }
            return new DecomposedCharset(inverted, ranges, namedGroups.toString());
        }

        DecomposedCharset decompose() {
            CharRanges negRanges = CharRanges.ALL_CODE_UNITS.difference(this.ranges);
            if (!this.ieExplicits.isEmpty()) {
                if (negRanges.intersection(this.ieExplicits).isEmpty()) {
                    return this.decompose(this.ranges, false);
                }
                if (this.ranges.intersection(this.ieExplicits).isEmpty()) {
                    return this.decompose(negRanges, true);
                }
            }
            DecomposedCharset positive = this.decompose(this.ranges, false);
            DecomposedCharset negative = this.decompose(negRanges, true);
            return positive.complexity() <= negative.complexity() ? positive : negative;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            if (RegExpTree.DOT_CHARSET.ranges.equals(this.ranges)) {
                sb.append('.');
                return;
            }
            this.decompose().appendSourceCode(sb);
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
            sb.append(this.ranges);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Charset && this.ranges.equals(((Charset)o).ranges);
        }

        @Override
        public int hashCode() {
            return this.ranges.hashCode() ^ 0xDEDE2246;
        }
    }

    public static final class UnicodePropertyEscape
    extends RegExpTreeAtom {
        private final String propertyName;
        private final String propertyValue;
        private final boolean negated;

        UnicodePropertyEscape(@Nullable String propertyName, String propertyValue, boolean negated) {
            Preconditions.checkState((propertyValue != null ? 1 : 0) != 0);
            Preconditions.checkArgument((propertyName == null || !propertyName.isEmpty() ? 1 : 0) != 0, (Object)"if '=' is present in a unicode property escape, the name cannot be empty");
            Preconditions.checkArgument((!propertyValue.isEmpty() ? 1 : 0) != 0, (Object)"unicode property escape value cannot be empty");
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
            this.negated = negated;
        }

        @Override
        public RegExpTree simplify(String flags) {
            return this;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            sb.append(this.negated ? "\\P{" : "\\p{");
            if (this.propertyName != null) {
                sb.append(this.propertyName);
                sb.append('=');
            }
            sb.append(this.propertyValue);
            sb.append("}");
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof UnicodePropertyEscape && this.negated == ((UnicodePropertyEscape)o).negated && Objects.equals(this.propertyName, ((UnicodePropertyEscape)o).propertyName) && Objects.equals(this.propertyValue, ((UnicodePropertyEscape)o).propertyValue);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.negated, this.propertyName, this.propertyValue);
        }
    }

    public static final class NamedCaptureGroup
    extends RegExpTree {
        final RegExpTree body;
        final String name;

        NamedCaptureGroup(RegExpTree body, String name) {
            this.body = body;
            this.name = name;
        }

        @Override
        public RegExpTree simplify(String flags) {
            return new NamedCaptureGroup(this.body.simplify(flags), this.name);
        }

        @Override
        public boolean isCaseSensitive() {
            return this.body.isCaseSensitive();
        }

        @Override
        public boolean containsAnchor() {
            return this.body.containsAnchor();
        }

        @Override
        public int numCapturingGroups() {
            return 1 + this.body.numCapturingGroups();
        }

        public ImmutableList<? extends RegExpTree> children() {
            return ImmutableList.of((Object)this.body);
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            sb.append("(?<");
            sb.append(this.name);
            sb.append('>');
            this.body.appendSourceCode(sb);
            sb.append(')');
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
            sb.append(" name=").append(this.name);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof NamedCaptureGroup && this.name.equals(((NamedCaptureGroup)o).name) && this.body.equals(((NamedCaptureGroup)o).body);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.name) ^ this.body.hashCode();
        }
    }

    public static final class CapturingGroup
    extends RegExpTree {
        final RegExpTree body;

        CapturingGroup(RegExpTree body) {
            this.body = body;
        }

        @Override
        public RegExpTree simplify(String flags) {
            return new CapturingGroup(this.body.simplify(flags));
        }

        @Override
        public boolean isCaseSensitive() {
            return this.body.isCaseSensitive();
        }

        @Override
        public boolean containsAnchor() {
            return this.body.containsAnchor();
        }

        @Override
        public int numCapturingGroups() {
            return 1 + this.body.numCapturingGroups();
        }

        public ImmutableList<? extends RegExpTree> children() {
            return ImmutableList.of((Object)this.body);
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            sb.append('(');
            this.body.appendSourceCode(sb);
            sb.append(')');
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof CapturingGroup && this.body.equals(((CapturingGroup)o).body);
        }

        @Override
        public int hashCode() {
            return 0x55781738 ^ this.body.hashCode();
        }
    }

    public static final class LookbehindAssertion
    extends RegExpTree {
        final RegExpTree body;
        final boolean positive;

        LookbehindAssertion(RegExpTree body, boolean positive) {
            this.body = body;
            this.positive = positive;
        }

        @Override
        public RegExpTree simplify(String flags) {
            RegExpTree simpleBody = this.body.simplify(flags);
            if (simpleBody instanceof Empty && this.positive) {
                return simpleBody;
            }
            return new LookbehindAssertion(simpleBody, this.positive);
        }

        @Override
        public boolean isCaseSensitive() {
            return this.body.isCaseSensitive();
        }

        @Override
        public boolean containsAnchor() {
            return this.body.containsAnchor();
        }

        @Override
        public int numCapturingGroups() {
            return this.body.numCapturingGroups();
        }

        public ImmutableList<? extends RegExpTree> children() {
            return ImmutableList.of((Object)this.body);
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            sb.append(this.positive ? "(?<=" : "(?<!");
            this.body.appendSourceCode(sb);
            sb.append(')');
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
            sb.append(this.positive ? "positive" : "negative");
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof LookbehindAssertion)) {
                return false;
            }
            LookbehindAssertion that = (LookbehindAssertion)o;
            return this.positive == that.positive && this.body.equals(that.body);
        }

        @Override
        public int hashCode() {
            return 0x723ABA9 ^ this.body.hashCode();
        }
    }

    public static final class LookaheadAssertion
    extends RegExpTree {
        final RegExpTree body;
        final boolean positive;

        LookaheadAssertion(RegExpTree body, boolean positive) {
            this.body = body;
            this.positive = positive;
        }

        @Override
        public RegExpTree simplify(String flags) {
            RegExpTree simpleBody = this.body.simplify(flags);
            if (simpleBody instanceof Empty && this.positive) {
                return simpleBody;
            }
            return new LookaheadAssertion(simpleBody, this.positive);
        }

        @Override
        public boolean isCaseSensitive() {
            return this.body.isCaseSensitive();
        }

        @Override
        public boolean containsAnchor() {
            return this.body.containsAnchor();
        }

        @Override
        public int numCapturingGroups() {
            return this.body.numCapturingGroups();
        }

        public ImmutableList<? extends RegExpTree> children() {
            return ImmutableList.of((Object)this.body);
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            sb.append(this.positive ? "(?=" : "(?!");
            this.body.appendSourceCode(sb);
            sb.append(')');
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
            sb.append(this.positive ? "positive" : "negative");
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof LookaheadAssertion)) {
                return false;
            }
            LookaheadAssertion that = (LookaheadAssertion)o;
            return this.positive == that.positive && this.body.equals(that.body);
        }

        @Override
        public int hashCode() {
            return 0x723ABA9 ^ this.body.hashCode();
        }
    }

    public static final class Alternation
    extends RegExpTree {
        final ImmutableList<RegExpTree> alternatives;

        Alternation(List<? extends RegExpTree> alternatives) {
            this.alternatives = ImmutableList.copyOf(alternatives);
        }

        @Override
        public RegExpTree simplify(String flags) {
            ArrayList<RegExpTree> alternatives = new ArrayList<RegExpTree>();
            for (RegExpTree alternative : this.alternatives) {
                if ((alternative = alternative.simplify(flags)) instanceof Alternation) {
                    alternatives.addAll((Collection<RegExpTree>)((Alternation)alternative).alternatives);
                    continue;
                }
                alternatives.add(alternative);
            }
            RegExpTree last = null;
            Iterator it = alternatives.iterator();
            while (it.hasNext()) {
                RegExpTree alternative = (RegExpTree)it.next();
                if (alternative.equals(NEVER_MATCHES)) continue;
                if (alternative.equals(last) && !alternative.hasCapturingGroup()) {
                    it.remove();
                    continue;
                }
                last = alternative;
            }
            int n = alternatives.size();
            for (int i = 0; i < n; ++i) {
                int end;
                RegExpTree alternative = (RegExpTree)alternatives.get(i);
                if ((!(alternative instanceof Text) || ((Text)alternative).text.length() != 1) && !(alternative instanceof Charset)) continue;
                int nCharsets = 0;
                for (end = i; end < n; ++end) {
                    RegExpTree follower = (RegExpTree)alternatives.get(end);
                    if (follower instanceof Charset) {
                        ++nCharsets;
                        continue;
                    }
                    if (!(follower instanceof Text) || ((Text)follower).text.length() != 1) break;
                }
                if (end - i < 3 && (nCharsets == 0 || end - i < 2)) continue;
                int[] members = new int[end - i - nCharsets];
                int memberIdx = 0;
                CharRanges chars = CharRanges.EMPTY;
                CharRanges ieExplicits = CharRanges.EMPTY;
                List<RegExpTree> charAlternatives = alternatives.subList(i, end);
                for (RegExpTree charAlternative : charAlternatives) {
                    if (charAlternative instanceof Text) {
                        char ch = ((Text)charAlternative).text.charAt(0);
                        members[memberIdx++] = ch;
                        if (!IE_SPEC_ERRORS.contains(ch)) continue;
                        ieExplicits = ieExplicits.union(CharRanges.inclusive(ch, ch));
                        continue;
                    }
                    if (!(charAlternative instanceof Charset)) continue;
                    Charset cs = (Charset)charAlternative;
                    chars = chars.union(cs.ranges);
                    ieExplicits = ieExplicits.union(cs.ieExplicits);
                }
                chars = chars.union(CharRanges.withMembers(members));
                charAlternatives.clear();
                charAlternatives.add(new Charset(chars, ieExplicits).simplify(flags));
                n = alternatives.size();
            }
            switch (alternatives.size()) {
                case 0: {
                    return Empty.INSTANCE;
                }
                case 1: {
                    return (RegExpTree)alternatives.get(0);
                }
                case 2: {
                    if (alternatives.get(1) instanceof Empty) {
                        return new Repetition((RegExpTree)alternatives.get(0), 0, 1, true);
                    }
                    if (!(alternatives.get(0) instanceof Empty)) break;
                    return new Repetition((RegExpTree)alternatives.get(1), 0, 1, false);
                }
            }
            return alternatives.equals(this.alternatives) ? this : new Alternation(alternatives);
        }

        @Override
        public boolean isCaseSensitive() {
            for (RegExpTree alternative : this.alternatives) {
                if (!alternative.isCaseSensitive()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAnchor() {
            for (RegExpTree alternative : this.alternatives) {
                if (!alternative.containsAnchor()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int numCapturingGroups() {
            int n = 0;
            for (RegExpTree alternative : this.alternatives) {
                n += alternative.numCapturingGroups();
            }
            return n;
        }

        public ImmutableList<? extends RegExpTree> children() {
            return this.alternatives;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            int n = this.alternatives.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    sb.append('|');
                }
                ((RegExpTree)this.alternatives.get(i)).appendSourceCode(sb);
            }
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o instanceof Alternation && this.alternatives.equals(((Alternation)o).alternatives);
        }

        @Override
        public int hashCode() {
            return 0x51B57CD1 ^ this.alternatives.hashCode();
        }
    }

    public static final class Repetition
    extends RegExpTree {
        final RegExpTree body;
        final int min;
        final int max;
        final boolean greedy;

        Repetition(RegExpTree body, int min, int max, boolean greedy) {
            this.body = body;
            this.min = min;
            this.max = max;
            this.greedy = greedy;
        }

        @Override
        public RegExpTree simplify(String flags) {
            RegExpTree body = this.body.simplify(flags);
            if (this.max == 0 && !body.hasCapturingGroup()) {
                return Empty.INSTANCE;
            }
            if (body instanceof Empty || NEVER_MATCHES.equals(body)) {
                return body;
            }
            int min = this.min;
            int max = this.max;
            if (body instanceof Repetition) {
                Repetition rbody = (Repetition)body;
                if (rbody.greedy == this.greedy) {
                    long lmin = (long)min * (long)rbody.min;
                    long lmax = (long)max * (long)rbody.max;
                    if (lmin < Integer.MAX_VALUE) {
                        body = rbody.body;
                        min = (int)lmin;
                        int n = max = lmax >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lmax;
                    }
                }
            }
            if (min == 1 && max == 1) {
                return body;
            }
            boolean greedy = this.greedy || min == max;
            return body.equals(this.body) && min == this.min && max == this.max && greedy == this.greedy ? this : new Repetition(body, min, max, greedy).simplify(flags);
        }

        @Override
        public boolean isCaseSensitive() {
            return this.body.isCaseSensitive();
        }

        @Override
        public boolean containsAnchor() {
            return this.body.containsAnchor();
        }

        @Override
        public int numCapturingGroups() {
            return this.body.numCapturingGroups();
        }

        public ImmutableList<? extends RegExpTree> children() {
            return ImmutableList.of((Object)this.body);
        }

        private void appendBodySourceCode(StringBuilder sb) {
            if (this.body instanceof Alternation || this.body instanceof Concatenation || this.body instanceof Repetition || this.body instanceof Text && ((Text)this.body).text.length() > 1) {
                sb.append("(?:");
                this.body.appendSourceCode(sb);
                sb.append(')');
            } else {
                this.body.appendSourceCode(sb);
            }
        }

        private static int suffixLen(int min, int max) {
            if (max == Integer.MAX_VALUE) {
                switch (min) {
                    case 0: 
                    case 1: {
                        return 1;
                    }
                }
                return 3 + Repetition.numDecimalDigits(min);
            }
            if (min == 0 && max == 1) {
                return 1;
            }
            if (min == max) {
                if (min == 1) {
                    return 0;
                }
                return 2 + Repetition.numDecimalDigits(min);
            }
            return 3 + Repetition.numDecimalDigits(min) + Repetition.numDecimalDigits(max);
        }

        private static int numDecimalDigits(int n) {
            if (n < 0) {
                throw new AssertionError();
            }
            int nDigits = 1;
            while (n >= 10) {
                ++nDigits;
                n /= 10;
            }
            return nDigits;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            int bodyStart = sb.length();
            this.appendBodySourceCode(sb);
            int bodyEnd = sb.length();
            int bodyLen = bodyEnd - bodyStart;
            int min = this.min;
            int max = this.max;
            if (min >= 2 && max == Integer.MAX_VALUE || max - min <= 1) {
                int expanded = min == max || max == Integer.MAX_VALUE ? min - 1 : min;
                int expandedMin = min - expanded;
                int expandedMax = max == Integer.MAX_VALUE ? max : max - expanded;
                int suffixLen = Repetition.suffixLen(min, max);
                int expandedSuffixLen = Repetition.suffixLen(expandedMin, expandedMax);
                if (bodyLen * expanded + expandedSuffixLen < suffixLen && !this.body.hasCapturingGroup()) {
                    while (--expanded >= 0) {
                        sb.append(sb, bodyStart, bodyEnd);
                    }
                    min = expandedMin;
                    max = expandedMax;
                }
            }
            if (max == Integer.MAX_VALUE) {
                switch (min) {
                    case 0: {
                        sb.append('*');
                        break;
                    }
                    case 1: {
                        sb.append('+');
                        break;
                    }
                    default: {
                        sb.append('{').append(min).append(",}");
                        break;
                    }
                }
            } else if (min == 0 && max == 1) {
                sb.append('?');
            } else if (min == max) {
                if (min != 1) {
                    sb.append('{').append(min).append('}');
                }
            } else {
                sb.append('{').append(min).append(',').append(max).append('}');
            }
            if (!this.greedy) {
                sb.append('?');
            }
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
            sb.append(" min=").append(this.min).append(", max=").append(this.max);
            if (!this.greedy) {
                sb.append("  not_greedy");
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Repetition)) {
                return false;
            }
            Repetition that = (Repetition)o;
            return this.body.equals(that.body) && this.min == that.min && this.max == that.max && this.greedy == that.greedy;
        }

        @Override
        public int hashCode() {
            return this.min + 31 * (this.max + 31 * ((this.greedy ? 1 : 0) + 31 * this.body.hashCode()));
        }
    }

    public static final class Text
    extends RegExpTreeAtom {
        final String text;

        Text(String text) {
            this.text = text;
        }

        private static void escapeRegularCharOnto(char ch, int next, StringBuilder sb) {
            switch (ch) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '/': 
                case '?': 
                case '[': 
                case '^': 
                case '|': {
                    sb.append('\\').append(ch);
                    break;
                }
                case '{': {
                    if (48 <= next && next <= 57) {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    break;
                }
                default: {
                    Text.escapeCharOnto(ch, sb);
                }
            }
        }

        @Override
        public RegExpTree simplify(String flags) {
            String canonicalized;
            int n = this.text.length();
            if (n == 0) {
                return Empty.INSTANCE;
            }
            if (flags.indexOf(105) >= 0 && !this.text.equals(canonicalized = CaseCanonicalize.caseCanonicalize(this.text))) {
                return new Text(canonicalized);
            }
            return this;
        }

        @Override
        public boolean isCaseSensitive() {
            int n = this.text.length();
            for (int i = 0; i < n; ++i) {
                if (!CaseCanonicalize.CASE_SENSITIVE.contains(this.text.charAt(i))) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            int n = this.text.length();
            for (int i = 0; i < n; ++i) {
                Text.escapeRegularCharOnto(this.text.charAt(i), i + 1 < n ? (int)this.text.charAt(i + 1) : -1, sb);
            }
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
            sb.append('`').append(this.text).append('`');
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Text && this.text.equals(((Text)o).text);
        }

        @Override
        public int hashCode() {
            return this.text.hashCode() ^ 0x617E310;
        }
    }

    public static final class NamedBackReference
    extends RegExpTreeAtom {
        final String groupName;

        NamedBackReference(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public RegExpTree simplify(String flags) {
            return this;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            sb.append("\\k<").append(this.groupName).append('>');
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
            sb.append(this.groupName);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof NamedBackReference && this.groupName.equals(((NamedBackReference)o).groupName);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.groupName);
        }
    }

    public static final class BackReference
    extends RegExpTreeAtom {
        final int groupIndex;

        BackReference(int groupIndex) {
            Preconditions.checkArgument((groupIndex >= 0 && groupIndex <= 99 ? 1 : 0) != 0);
            this.groupIndex = groupIndex;
        }

        @Override
        public RegExpTree simplify(String flags) {
            return this;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            sb.append('\\').append(this.groupIndex);
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
            sb.append(this.groupIndex);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof BackReference && this.groupIndex == ((BackReference)o).groupIndex;
        }

        @Override
        public int hashCode() {
            return 0xFF072663 ^ this.groupIndex;
        }
    }

    public static final class WordBoundary
    extends RegExpTreeAtom {
        final char type;

        WordBoundary(char type) {
            this.type = type;
        }

        @Override
        public RegExpTree simplify(String flags) {
            return this;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            sb.append('\\').append(this.type);
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
            sb.append(this.type);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof WordBoundary && this.type == ((WordBoundary)o).type;
        }

        @Override
        public int hashCode() {
            return 0x5673AA29 ^ this.type;
        }
    }

    public static final class Anchor
    extends RegExpTreeAtom {
        final char type;

        Anchor(char type) {
            this.type = type;
        }

        @Override
        public RegExpTree simplify(String flags) {
            return this;
        }

        @Override
        public boolean containsAnchor() {
            return true;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
            sb.append(this.type);
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
            sb.append(this.type);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Anchor && this.type == ((Anchor)o).type;
        }

        @Override
        public int hashCode() {
            return this.type ^ 0xE85317FF;
        }
    }

    public static final class Empty
    extends RegExpTreeAtom {
        static final Empty INSTANCE = new Empty();

        @Override
        public RegExpTree simplify(String flags) {
            return this;
        }

        @Override
        protected void appendSourceCode(StringBuilder sb) {
        }

        @Override
        protected void appendDebugInfo(StringBuilder sb) {
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Empty;
        }

        @Override
        public int hashCode() {
            return 2128634177;
        }
    }

    public static abstract class RegExpTreeAtom
    extends RegExpTree {
        @Override
        public boolean isCaseSensitive() {
            return false;
        }

        @Override
        public boolean containsAnchor() {
            return false;
        }

        @Override
        public final int numCapturingGroups() {
            return 0;
        }

        public final ImmutableList<? extends RegExpTree> children() {
            return ImmutableList.of();
        }
    }

    private static enum ParentheticalType {
        CAPTURING,
        NONCAPTURING,
        POSITIVE_LOOKAHEAD,
        NEGATIVE_LOOKAHEAD,
        POSITIVE_LOOKBEHIND,
        NEGATIVE_LOOKBEHIND,
        NAMED_GROUPS;

    }
}

