/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.parsing.Annotation;
import com.google.javascript.jscomp.parsing.Config;

final class AutoValue_Config
extends Config {
    private final Config.LanguageMode languageMode;
    private final Config.StrictMode strictMode;
    private final Config.JsDocParsing jsDocParsingMode;
    private final Config.RunMode runMode;
    private final ImmutableMap<String, Annotation> annotations;
    private final ImmutableSet<String> suppressionNames;
    private final ImmutableSet<String> closurePrimitiveNames;
    private final boolean parseInlineSourceMaps;

    private AutoValue_Config(Config.LanguageMode languageMode, Config.StrictMode strictMode, Config.JsDocParsing jsDocParsingMode, Config.RunMode runMode, ImmutableMap<String, Annotation> annotations, ImmutableSet<String> suppressionNames, ImmutableSet<String> closurePrimitiveNames, boolean parseInlineSourceMaps) {
        this.languageMode = languageMode;
        this.strictMode = strictMode;
        this.jsDocParsingMode = jsDocParsingMode;
        this.runMode = runMode;
        this.annotations = annotations;
        this.suppressionNames = suppressionNames;
        this.closurePrimitiveNames = closurePrimitiveNames;
        this.parseInlineSourceMaps = parseInlineSourceMaps;
    }

    @Override
    public Config.LanguageMode languageMode() {
        return this.languageMode;
    }

    @Override
    public Config.StrictMode strictMode() {
        return this.strictMode;
    }

    @Override
    public Config.JsDocParsing jsDocParsingMode() {
        return this.jsDocParsingMode;
    }

    @Override
    public Config.RunMode runMode() {
        return this.runMode;
    }

    @Override
    public ImmutableMap<String, Annotation> annotations() {
        return this.annotations;
    }

    @Override
    public ImmutableSet<String> suppressionNames() {
        return this.suppressionNames;
    }

    @Override
    ImmutableSet<String> closurePrimitiveNames() {
        return this.closurePrimitiveNames;
    }

    @Override
    public boolean parseInlineSourceMaps() {
        return this.parseInlineSourceMaps;
    }

    public String toString() {
        return "Config{languageMode=" + this.languageMode + ", strictMode=" + this.strictMode + ", jsDocParsingMode=" + this.jsDocParsingMode + ", runMode=" + this.runMode + ", annotations=" + this.annotations + ", suppressionNames=" + this.suppressionNames + ", closurePrimitiveNames=" + this.closurePrimitiveNames + ", parseInlineSourceMaps=" + this.parseInlineSourceMaps + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Config) {
            Config that = (Config)o;
            return this.languageMode.equals((Object)that.languageMode()) && this.strictMode.equals((Object)that.strictMode()) && this.jsDocParsingMode.equals((Object)that.jsDocParsingMode()) && this.runMode.equals((Object)that.runMode()) && this.annotations.equals(that.annotations()) && this.suppressionNames.equals(that.suppressionNames()) && this.closurePrimitiveNames.equals(that.closurePrimitiveNames()) && this.parseInlineSourceMaps == that.parseInlineSourceMaps();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.languageMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.strictMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.jsDocParsingMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.runMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.annotations.hashCode();
        h$ *= 1000003;
        h$ ^= this.suppressionNames.hashCode();
        h$ *= 1000003;
        h$ ^= this.closurePrimitiveNames.hashCode();
        h$ *= 1000003;
        return h$ ^= this.parseInlineSourceMaps ? 1231 : 1237;
    }

    static final class Builder
    extends Config.Builder {
        private Config.LanguageMode languageMode;
        private Config.StrictMode strictMode;
        private Config.JsDocParsing jsDocParsingMode;
        private Config.RunMode runMode;
        private ImmutableMap<String, Annotation> annotations;
        private ImmutableSet<String> suppressionNames;
        private ImmutableSet<String> closurePrimitiveNames;
        private Boolean parseInlineSourceMaps;

        Builder() {
        }

        @Override
        public Config.Builder setLanguageMode(Config.LanguageMode languageMode) {
            if (languageMode == null) {
                throw new NullPointerException("Null languageMode");
            }
            this.languageMode = languageMode;
            return this;
        }

        @Override
        public Config.Builder setStrictMode(Config.StrictMode strictMode) {
            if (strictMode == null) {
                throw new NullPointerException("Null strictMode");
            }
            this.strictMode = strictMode;
            return this;
        }

        @Override
        public Config.Builder setJsDocParsingMode(Config.JsDocParsing jsDocParsingMode) {
            if (jsDocParsingMode == null) {
                throw new NullPointerException("Null jsDocParsingMode");
            }
            this.jsDocParsingMode = jsDocParsingMode;
            return this;
        }

        @Override
        public Config.Builder setRunMode(Config.RunMode runMode) {
            if (runMode == null) {
                throw new NullPointerException("Null runMode");
            }
            this.runMode = runMode;
            return this;
        }

        @Override
        public Config.Builder setAnnotations(ImmutableMap<String, Annotation> annotations) {
            if (annotations == null) {
                throw new NullPointerException("Null annotations");
            }
            this.annotations = annotations;
            return this;
        }

        @Override
        public Config.Builder setSuppressionNames(Iterable<String> suppressionNames) {
            if (suppressionNames == null) {
                throw new NullPointerException("Null suppressionNames");
            }
            this.suppressionNames = ImmutableSet.copyOf(suppressionNames);
            return this;
        }

        @Override
        Config.Builder setClosurePrimitiveNames(Iterable<String> closurePrimitiveNames) {
            if (closurePrimitiveNames == null) {
                throw new NullPointerException("Null closurePrimitiveNames");
            }
            this.closurePrimitiveNames = ImmutableSet.copyOf(closurePrimitiveNames);
            return this;
        }

        @Override
        public Config.Builder setParseInlineSourceMaps(boolean parseInlineSourceMaps) {
            this.parseInlineSourceMaps = parseInlineSourceMaps;
            return this;
        }

        @Override
        public Config build() {
            Object missing = "";
            if (this.languageMode == null) {
                missing = (String)missing + " languageMode";
            }
            if (this.strictMode == null) {
                missing = (String)missing + " strictMode";
            }
            if (this.jsDocParsingMode == null) {
                missing = (String)missing + " jsDocParsingMode";
            }
            if (this.runMode == null) {
                missing = (String)missing + " runMode";
            }
            if (this.annotations == null) {
                missing = (String)missing + " annotations";
            }
            if (this.suppressionNames == null) {
                missing = (String)missing + " suppressionNames";
            }
            if (this.closurePrimitiveNames == null) {
                missing = (String)missing + " closurePrimitiveNames";
            }
            if (this.parseInlineSourceMaps == null) {
                missing = (String)missing + " parseInlineSourceMaps";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_Config(this.languageMode, this.strictMode, this.jsDocParsingMode, this.runMode, this.annotations, this.suppressionNames, this.closurePrimitiveNames, this.parseInlineSourceMaps);
        }
    }
}

