/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

public final class CheckGoogModuleTypeScriptName
implements NodeTraversal.Callback,
CompilerPass {
    public static final DiagnosticType MODULE_NAMESPACE_MISMATCHES_TYPESCRIPT_NAMESPACE = DiagnosticType.disabled("JSC_MODULE_NAMESPACE_MISMATCHES_TYPESCRIPT_NAMESPACE", "goog.module namespace does not match the future TypeScript namespace, which is generated from the file path. The correct namespace is: \"{0}\"");
    private static final Set<String> allowedDirectories = new HashSet<String>();
    private final AbstractCompiler compiler;
    private boolean finished = false;

    public CheckGoogModuleTypeScriptName(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return !this.finished && (parent == null || parent.isRoot() || parent.isScript() || parent.isModuleBody());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (NodeUtil.isGoogModuleCall(n)) {
            this.checkGoogModuleNamespace(t, n);
            this.finished = true;
        }
    }

    private void checkGoogModuleNamespace(NodeTraversal t, Node n) {
        String originalNamespace = n.getFirstChild().getSecondChild().getString();
        Object sourceName = t.getSourceName();
        if (originalNamespace == null || sourceName == null) {
            return;
        }
        int google3Index = ((String)sourceName).indexOf("google3");
        if (google3Index == -1) {
            sourceName = "google3/" + (String)sourceName;
        } else if (google3Index != 0) {
            sourceName = ((String)sourceName).substring(google3Index);
        }
        String replacementNamespace = ((String)sourceName).replace('/', '.').substring(0, ((String)sourceName).length() - ".js".length());
        if (!originalNamespace.equals(replacementNamespace)) {
            for (String allowedDirectory : allowedDirectories) {
                if (!((String)sourceName).startsWith(allowedDirectory)) continue;
                t.report(n, MODULE_NAMESPACE_MISMATCHES_TYPESCRIPT_NAMESPACE, replacementNamespace);
                return;
            }
        }
    }

    static {
        allowedDirectories.add("google3/gws/");
        allowedDirectories.add("google3/java/com/google/gws/");
        allowedDirectories.add("google3/javascript/search/");
    }
}

