/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.HashSet;

public final class CheckEnums
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType DUPLICATE_ENUM_VALUE = DiagnosticType.disabled("JSC_DUPLICATE_ENUM_VALUE", "The value {0} is duplicated in this enum.");
    public static final DiagnosticType COMPUTED_PROP_NAME_IN_ENUM = DiagnosticType.disabled("JSC_COMPUTED_PROP_NAME_IN_ENUM", "Computed property name used in enum.");
    public static final DiagnosticType SHORTHAND_ASSIGNMENT_IN_ENUM = DiagnosticType.disabled("JSC_SHORTHAND_ASSIGNMENT_IN_ENUM", "Shorthand assignment used in enum.");
    public static final DiagnosticType ENUM_PROP_NOT_CONSTANT = DiagnosticType.disabled("JSC_ENUM_PROP_NOT_CONSTANT", "enum key {0} must be in ALL_CAPS.");
    public static final DiagnosticType ENUM_TYPE_NOT_STRING_OR_NUMBER = DiagnosticType.disabled("JSC_ENUM_VALUE_NOT_STRING_OR_NUMBER", "enum type must be either string or number.");
    public static final DiagnosticType NON_STATIC_INITIALIZER_STRING_VALUE_IN_ENUM = DiagnosticType.disabled("JSC_NON_STATIC_INITIALIZER_STRING_VALUE_IN_ENUM", "Enum string values must be statically initialized as per the style guide.");
    private final AbstractCompiler compiler;

    public CheckEnums(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo jsdoc;
        if (n.isObjectLit() && (jsdoc = NodeUtil.getBestJSDocInfo(n)) != null && jsdoc.hasEnumParameterType()) {
            this.checkNamingAndAssignmentUsage(t, n);
            CheckEnums.checkDuplicateEnumValues(t, n);
            CheckEnums.checkEnumTypeAndInitializerValues(t, n, jsdoc);
        }
    }

    private static void checkEnumTypeAndInitializerValues(NodeTraversal t, Node n, JSDocInfo jsDocInfo) {
        boolean isNumberEnum;
        Preconditions.checkArgument((boolean)n.isObjectLit(), (Object)n);
        JSTypeExpression enumTypeExpr = jsDocInfo.getEnumParameterType();
        Node enumType = enumTypeExpr.getRoot();
        boolean isStringEnum = enumType.isStringLit() && enumType.getString().equals("string");
        boolean bl = isNumberEnum = enumType.isStringLit() && enumType.getString().equals("number");
        if (!isStringEnum && !isNumberEnum) {
            t.report(n, ENUM_TYPE_NOT_STRING_OR_NUMBER, new String[0]);
        }
        if (isStringEnum) {
            CheckEnums.checkStringEnumInitializerValues(t, n);
        }
    }

    private static void checkStringEnumInitializerValues(NodeTraversal t, Node enumNode) {
        Preconditions.checkArgument((boolean)enumNode.isObjectLit(), (Object)enumNode);
        for (Node prop = enumNode.getFirstChild(); prop != null; prop = prop.getNext()) {
            Node valueNode = prop.getLastChild();
            if (valueNode.isStringLit() || valueNode.isTemplateLit() && valueNode.hasOneChild()) continue;
            t.report(valueNode, NON_STATIC_INITIALIZER_STRING_VALUE_IN_ENUM, new String[0]);
        }
    }

    private void checkNamingAndAssignmentUsage(NodeTraversal t, Node objLit) {
        for (Node child = objLit.getFirstChild(); child != null; child = child.getNext()) {
            this.checkName(t, child);
        }
    }

    private void checkName(NodeTraversal t, Node prop) {
        if (prop.isComputedProp()) {
            t.report(prop, COMPUTED_PROP_NAME_IN_ENUM, new String[0]);
            return;
        }
        if (prop.isStringKey() && prop.isShorthandProperty()) {
            t.report(prop, SHORTHAND_ASSIGNMENT_IN_ENUM, new String[0]);
        }
        if (!this.compiler.getCodingConvention().isValidEnumKey(prop.getString())) {
            t.report(prop, ENUM_PROP_NOT_CONSTANT, new String[0]);
        }
    }

    private static void checkDuplicateEnumValues(NodeTraversal t, Node enumNode) {
        HashSet<String> values = new HashSet<String>();
        for (Node prop = enumNode.getFirstChild(); prop != null; prop = prop.getNext()) {
            String value;
            Node valueNode = prop.getLastChild();
            if (valueNode == null) {
                return;
            }
            if (valueNode.isStringLit()) {
                value = valueNode.getString();
            } else if (valueNode.isNumber()) {
                value = Double.toString(valueNode.getDouble());
            } else {
                return;
            }
            if (values.add(value)) continue;
            t.report(valueNode, DUPLICATE_ENUM_VALUE, value);
        }
    }
}

