/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CheckConstPrivateProperties
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType MISSING_CONST_PROPERTY = DiagnosticType.disabled("JSC_MISSING_CONST_PROPERTY", "Private property {0} is never modified, use the @const annotation");
    private final AbstractCompiler compiler;
    private final List<Node> candidates = new ArrayList<Node>();
    private final Set<String> modified = new HashSet<String>();
    private final HashSet<String> constructorsAndInterfaces = new HashSet();

    public CheckConstPrivateProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    private void reportMissingConst(NodeTraversal t) {
        for (Node n : this.candidates) {
            String propName = n.getString();
            if (this.modified.contains(propName)) continue;
            t.report(n, MISSING_CONST_PROPERTY, propName);
        }
        this.candidates.clear();
        this.modified.clear();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                this.reportMissingConst(t);
                break;
            }
            case GETELEM: 
            case GETPROP: {
                Node propNode;
                if (n.isGetProp()) {
                    propNode = n;
                } else if (n.getLastChild().isStringLit()) {
                    propNode = n.getLastChild();
                } else {
                    return;
                }
                if (this.isCandidatePropertyDefinition(n)) {
                    this.candidates.add(propNode);
                    break;
                }
                if (!this.isModificationOp(n)) break;
                this.modified.add(propNode.getString());
                break;
            }
            case FUNCTION: {
                JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
                if (info == null || !info.isConstructor() && !info.isInterface()) break;
                this.recordConstructorOrInterface(n);
                break;
            }
            case CLASS: {
                this.recordConstructorOrInterface(n);
                break;
            }
        }
    }

    private void recordConstructorOrInterface(Node n) {
        String className = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(n));
        if (className != null) {
            this.constructorsAndInterfaces.add(className);
        }
    }

    private boolean isCandidatePropertyDefinition(Node n) {
        if (!NodeUtil.isLhsOfAssign(n)) {
            return false;
        }
        Node target = n.getFirstChild();
        if (!target.isThis() && !this.constructorsAndInterfaces.contains(target.getQualifiedName())) {
            return false;
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        return info != null && info.getVisibility() == JSDocInfo.Visibility.PRIVATE && !info.isConstant() && !info.hasTypedefType() && !info.hasEnumParameterType() && !info.isInterface() && !this.isFunctionProperty(n);
    }

    private boolean isFunctionProperty(Node n) {
        if (n.isGetElem()) {
            return false;
        }
        Node assignedValue = NodeUtil.getAssignedValue(n);
        return assignedValue != null && assignedValue.isFunction();
    }

    private boolean isModificationOp(Node n) {
        return NodeUtil.isLValue(n) || n.getParent().isDelProp();
    }
}

