/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.instrumentation.reporter;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.javascript.jscomp.instrumentation.reporter.ProfilingReport;
import com.google.javascript.jscomp.instrumentation.reporter.ReportDecoder;
import com.google.javascript.jscomp.instrumentation.reporter.proto.InstrumentationPoint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

@GwtIncompatible
final class ProductionInstrumentationReporter {
    @Option(name="--mapping_file", usage="The file name of the mapping generated by the production instrumentation pass.", required=true)
    private String instrumentationMappingLocation = "";
    @Option(name="--reports_directory", usage="The folder/directory which contains all the reports created by the instrumented production code.", required=true)
    private String instrumentationReportsDirectory = "";
    @Option(name="--result_output", usage="Use this flag to provide the name of the final report that will be generated bythis reporter.", required=true)
    private String finalResultOutput = "";

    ProductionInstrumentationReporter() {
    }

    public static void main(String[] args) {
        try {
            new ProductionInstrumentationReporter().doMain(args);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public static String readFile(String filePath) throws IOException {
        return CharStreams.toString((Readable)Files.newBufferedReader(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8));
    }

    private ImmutableList<Map<String, Long>> getAllExecutionResults(File folder) throws IOException {
        ImmutableList.Builder result = ImmutableList.builder();
        for (File fileEntry : folder.listFiles()) {
            String executionResult = ProductionInstrumentationReporter.readFile(fileEntry.getAbsolutePath());
            Type type = new TypeToken<Map<String, Long>>(){}.getType();
            Map executedInstrumentationData = (Map)new Gson().fromJson(executionResult, type);
            result.add((Object)executedInstrumentationData);
        }
        return result.build();
    }

    private void createFile(String fileName, String fileContents) throws IOException {
        File fold = new File(fileName);
        fold.delete();
        File myObj = new File(fileName);
        myObj.createNewFile();
        try (BufferedWriter myWriter = Files.newBufferedWriter(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            myWriter.write(fileContents);
        }
    }

    private void doMain(String[] args) throws IOException {
        this.parseCmdLineArguments(args);
        Map<String, InstrumentationPoint> mapping = ReportDecoder.parseMappingFromFile(this.instrumentationMappingLocation);
        File folder = new File(this.instrumentationReportsDirectory);
        ImmutableList<Map<String, Long>> listOfExecutionResults = this.getAllExecutionResults(folder);
        this.createFile(this.finalResultOutput, ProfilingReport.createTabSeparatedProfilingReport(mapping, listOfExecutionResults));
    }

    private void parseCmdLineArguments(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        parser.setUsageWidth(80);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            return;
        }
    }
}

