/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphNode;
import java.util.LinkedHashSet;
import java.util.Set;

public final class FixedPointGraphTraversal<N, E> {
    private final EdgeCallback<N, E> callback;
    private final TraversalDirection traversalDirection;
    public static final String NON_HALTING_ERROR_MSG = "Fixed point computation not halting";
    private static final long MAX_NODE_COUNT_FOR_ITERATION_LIMIT = (long)Math.floor(Math.cbrt(6.0E10));

    private FixedPointGraphTraversal(EdgeCallback<N, E> callback, TraversalDirection traversalDirection) {
        this.callback = callback;
        this.traversalDirection = traversalDirection;
    }

    public static <NodeT, EdgeT> FixedPointGraphTraversal<NodeT, EdgeT> newTraversal(EdgeCallback<NodeT, EdgeT> callback) {
        return new FixedPointGraphTraversal<NodeT, EdgeT>(callback, TraversalDirection.OUTWARDS);
    }

    public static <NodeT, EdgeT> FixedPointGraphTraversal<NodeT, EdgeT> newReverseTraversal(EdgeCallback<NodeT, EdgeT> callback) {
        return new FixedPointGraphTraversal<NodeT, EdgeT>(callback, TraversalDirection.INWARDS);
    }

    public void computeFixedPoint(DiGraph<N, E> graph) {
        LinkedHashSet nodes = new LinkedHashSet();
        for (DiGraph.DiGraphNode<N, E> node : graph.getNodes()) {
            nodes.add(node.getValue());
        }
        this.computeFixedPoint(graph, nodes);
    }

    public void computeFixedPoint(DiGraph<N, E> graph, N entry) {
        LinkedHashSet<N> entrySet = new LinkedHashSet<N>();
        entrySet.add(entry);
        this.computeFixedPoint(graph, (Set<N>)entrySet);
    }

    public void computeFixedPoint(DiGraph<N, E> graph, Set<N> entrySet) {
        long cycleCount = 0L;
        long nodeCount = Math.min((long)graph.getNodeCount(), MAX_NODE_COUNT_FOR_ITERATION_LIMIT);
        long maxIterations = Math.max(nodeCount * nodeCount * nodeCount, 100L);
        LinkedHashSet<DiGraph.DiGraphNode<N, GraphNode>> workSet = new LinkedHashSet<DiGraph.DiGraphNode<N, GraphNode>>();
        for (N n : entrySet) {
            workSet.add((DiGraph.DiGraphNode<N, GraphNode>)graph.getNode((Object)n));
        }
        while (!workSet.isEmpty() && cycleCount < maxIterations) {
            this.visitNode((DiGraph.DiGraphNode)workSet.iterator().next(), workSet);
            ++cycleCount;
        }
        Preconditions.checkState((cycleCount != maxIterations ? 1 : 0) != 0, (Object)NON_HALTING_ERROR_MSG);
    }

    private void visitNode(DiGraph.DiGraphNode<N, E> node, LinkedHashSet<DiGraph.DiGraphNode<N, E>> workSet) {
        workSet.remove(node);
        switch (this.traversalDirection) {
            case OUTWARDS: {
                Object sourceValue = node.getValue();
                for (DiGraph.DiGraphEdge<N, E> edge : node.getOutEdges()) {
                    Object destValue = edge.getDestination().getValue();
                    if (!this.callback.traverseEdge(sourceValue, edge.getValue(), destValue)) continue;
                    workSet.add(edge.getDestination());
                }
                return;
            }
            case INWARDS: {
                Object revSourceValue = node.getValue();
                for (DiGraph.DiGraphEdge<N, E> edge : node.getInEdges()) {
                    Object revDestValue = edge.getSource().getValue();
                    if (!this.callback.traverseEdge(revSourceValue, edge.getValue(), revDestValue)) continue;
                    workSet.add(edge.getSource());
                }
                return;
            }
        }
        throw new AssertionError((Object)("Unrecognized direction " + this.traversalDirection));
    }

    public static interface EdgeCallback<NodeT, EdgeT> {
        public boolean traverseEdge(NodeT var1, EdgeT var2, NodeT var3);
    }

    private static enum TraversalDirection {
        INWARDS,
        OUTWARDS;

    }
}

