/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.disambiguate.ColorGraphNode;
import com.google.javascript.jscomp.disambiguate.PropertyClustering;
import com.google.javascript.rhino.Node;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

final class UseSiteRenamer {
    private static final String INVALIDATED_NAME_VALUE = "<INVALIDATED>";
    private final Consumer<Node> mutationCb;
    private final ImmutableSetMultimap.Builder<String, String> renamingIndex = ImmutableSetMultimap.builder();

    UseSiteRenamer(Consumer<Node> mutationCb) {
        this.mutationCb = mutationCb;
    }

    @CanIgnoreReturnValue
    RenameUsesResult renameUses(PropertyClustering prop) {
        if (prop.isInvalidated()) {
            this.renamingIndex.put((Object)prop.getName(), (Object)INVALIDATED_NAME_VALUE);
            return RenameUsesResult.INVALIDATED;
        }
        ImmutableMap<ColorGraphNode, String> clusterNames = UseSiteRenamer.createAllClusterNames(prop);
        if (clusterNames.size() <= 1) {
            this.renamingIndex.put((Object)prop.getName(), (Object)prop.getName());
            return RenameUsesResult.ONLY_ONE_CLUSTER;
        }
        this.renamingIndex.putAll((Object)prop.getName(), (Iterable)clusterNames.values());
        for (Map.Entry<Node, ColorGraphNode> usage : prop.getUseSites().entrySet()) {
            Node site = usage.getKey();
            ColorGraphNode flatRep = prop.getClusters().find(usage.getValue());
            String newName = (String)clusterNames.get((Object)flatRep);
            if (Objects.equals(newName, site.getString())) continue;
            site.setString(newName);
            this.mutationCb.accept(site);
        }
        return RenameUsesResult.DISAMBIGUATED;
    }

    ImmutableSetMultimap<String, String> getRenamingIndex() {
        return this.renamingIndex.build();
    }

    private static ImmutableMap<ColorGraphNode, String> createAllClusterNames(PropertyClustering prop) {
        return (ImmutableMap)prop.getClusters().allRepresentatives().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), r -> UseSiteRenamer.createClusterName(prop, r)));
    }

    private static String createClusterName(PropertyClustering prop, ColorGraphNode rep) {
        if (Objects.equals(prop.getOriginalNameClusterRep(), rep)) {
            return prop.getName();
        }
        return "JSC$" + rep.getIndex() + "_" + prop.getName();
    }

    public static enum RenameUsesResult {
        INVALIDATED,
        ONLY_ONE_CLUSTER,
        DISAMBIGUATED;

    }
}

