/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.disambiguate.ColorGraphNode;
import com.google.javascript.jscomp.disambiguate.PropertyClustering;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;

final class ClusterPropagator
implements FixedPointGraphTraversal.EdgeCallback<ColorGraphNode, Object> {
    ClusterPropagator() {
    }

    @Override
    public boolean traverseEdge(ColorGraphNode src, Object unused, ColorGraphNode dest) {
        int startDestPropCount = dest.getAssociatedProps().size();
        for (PropertyClustering prop : src.getAssociatedProps().keySet()) {
            if (prop.isInvalidated()) continue;
            dest.getAssociatedProps().putIfAbsent(prop, ColorGraphNode.PropAssociation.SUPERTYPE);
            prop.getClusters().union(src, dest);
        }
        return startDestPropCount < dest.getAssociatedProps().size();
    }
}

