/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.diagnostic;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.gson.stream.JsonWriter;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.diagnostic.LogsGson;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;

final class WritingLogFile
extends LogFile {
    private final BufferedWriter writer;

    @MustBeClosed
    static LogFile create(Path file) {
        try {
            Path dir = file.getParent();
            Files.createDirectories(dir, new FileAttribute[0]);
            CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            return new WritingLogFile(new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE), encoder)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private WritingLogFile(BufferedWriter writer) {
        this.writer = writer;
    }

    @Override
    public LogFile log(Object value) {
        return this.logInternal(value.toString());
    }

    @Override
    public LogFile log(String value) {
        return this.logInternal(value);
    }

    @Override
    public LogFile log(Supplier<String> value) {
        return this.logInternal(value.get());
    }

    @Override
    @FormatMethod
    public LogFile log(@FormatString String template, Object ... values) {
        return this.logInternal(String.format(template, values));
    }

    @Override
    public LogFile logJson(Object value) {
        return this.logInternal(LogsGson.toJson(value));
    }

    @Override
    public LogFile logJson(Supplier<Object> value) {
        return this.logInternal(LogsGson.toJson(value.get()));
    }

    @Override
    @CanIgnoreReturnValue
    public LogFile logJson(LogFile.StreamedJsonProducer producer) {
        try (JsonWriter writer = new JsonWriter((Writer)this.writer);){
            producer.writeJson(writer);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
        return this;
    }

    @CanIgnoreReturnValue
    private LogFile logInternal(String value) {
        try {
            this.writer.append(value).append('\n');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isLogging() {
        return true;
    }
}

