/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.escape.Escaper;
import java.io.IOException;

public final class SourceCodeEscapers {
    private static final char PRINTABLE_ASCII_MIN = ' ';
    private static final char PRINTABLE_ASCII_MAX = '~';
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final JavaScriptEscaper JAVASCRIPT_ESCAPER = new JavaScriptEscaper();

    private SourceCodeEscapers() {
    }

    public static Escaper javascriptEscaper() {
        return JAVASCRIPT_ESCAPER;
    }

    public static void appendWithJavascriptEscaper(CharSequence c, Appendable to) throws IOException {
        JAVASCRIPT_ESCAPER.appendTo(c, to);
    }

    private static final class JavaScriptEscaper
    extends Escaper {
        private static final char[][] REPLACEMENT_CHARS;

        private JavaScriptEscaper() {
        }

        void appendTo(CharSequence cs, Appendable to) throws IOException {
            int last = 0;
            int length = cs.length();
            for (int i = 0; i < length; ++i) {
                char[] replacement;
                char c = cs.charAt(i);
                if (c < '\u0100') {
                    replacement = REPLACEMENT_CHARS[c];
                    if (replacement == null) {
                        continue;
                    }
                } else {
                    replacement = JavaScriptEscaper.asUnicodeHexEscape(c);
                }
                if (last < i) {
                    to.append(cs, last, i);
                }
                for (char r : replacement) {
                    to.append(r);
                }
                last = i + 1;
            }
            if (last < length) {
                to.append(cs, last, length);
            }
        }

        private static char[] asUnicodeHexEscape(char c) {
            char[] r = new char[6];
            r[0] = 92;
            r[1] = 117;
            r[5] = HEX_DIGITS[c & 0xF];
            c = (char)(c >>> 4);
            r[4] = HEX_DIGITS[c & 0xF];
            c = (char)(c >>> 4);
            r[3] = HEX_DIGITS[c & 0xF];
            c = (char)(c >>> 4);
            r[2] = HEX_DIGITS[c & 0xF];
            return r;
        }

        public String escape(String string) {
            StringBuilder sb = new StringBuilder();
            try {
                this.appendTo(string, sb);
            }
            catch (IOException e) {
                throw new IllegalStateException("This should never throw - StringBuilder.append doesn't actually throw IOException", e);
            }
            return sb.toString();
        }

        static {
            char[] r;
            int c;
            int i;
            REPLACEMENT_CHARS = new char[256][];
            for (i = 0; i < 32; i = (int)((char)(i + 1))) {
                c = i;
                r = new char[4];
                r[3] = HEX_DIGITS[c & 0xF];
                c = (char)(c >>> 4);
                r[2] = HEX_DIGITS[c & 0xF];
                r[1] = 120;
                r[0] = 92;
                JavaScriptEscaper.REPLACEMENT_CHARS[i] = r;
            }
            for (i = 127; i < 256; i = (int)((char)(i + 1))) {
                c = i;
                r = new char[4];
                r[3] = HEX_DIGITS[c & 0xF];
                c = (char)(c >>> 4);
                r[2] = HEX_DIGITS[c & 0xF];
                r[1] = 120;
                r[0] = 92;
                JavaScriptEscaper.REPLACEMENT_CHARS[i] = r;
            }
            JavaScriptEscaper.REPLACEMENT_CHARS[39] = "\\x27".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[34] = "\\x22".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[60] = "\\x3c".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[61] = "\\x3d".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[62] = "\\x3e".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[38] = "\\x26".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[8] = "\\b".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[9] = "\\t".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[10] = "\\n".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[12] = "\\f".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[13] = "\\r".toCharArray();
            JavaScriptEscaper.REPLACEMENT_CHARS[92] = "\\\\".toCharArray();
        }
    }
}

