/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.ModuleNames;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SortedDependencies<InputT extends DependencyInfo> {
    private final List<InputT> userOrderedInputs = new ArrayList<InputT>();
    private final List<InputT> importOrderedInputs = new ArrayList<InputT>();
    private final Set<InputT> completedInputs = new LinkedHashSet<InputT>();
    private final Map<String, InputT> nonExportingInputs = new LinkedHashMap<String, InputT>();
    private final Map<String, InputT> exportingInputBySymbolName = new LinkedHashMap<String, InputT>();
    private final SetMultimap<InputT, InputT> importedInputByImportingInput = LinkedHashMultimap.create();

    public SortedDependencies(List<InputT> userOrderedInputs) {
        this.userOrderedInputs.addAll(userOrderedInputs);
        this.processInputs();
    }

    public ImmutableList<InputT> getStrongDependenciesOf(List<InputT> rootInputs, boolean sorted) {
        LinkedHashSet<DependencyInfo> includedInputs = new LinkedHashSet<DependencyInfo>();
        ArrayDeque<InputT> worklist = new ArrayDeque<InputT>(rootInputs);
        while (!worklist.isEmpty()) {
            DependencyInfo input = (DependencyInfo)worklist.pop();
            if (!includedInputs.add(input)) continue;
            for (String symbolName : input.getRequiredSymbols()) {
                DependencyInfo importedSymbolName = (DependencyInfo)this.exportingInputBySymbolName.get(symbolName);
                if (importedSymbolName == null) continue;
                worklist.add(importedSymbolName);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DependencyInfo input : sorted ? this.importOrderedInputs : this.userOrderedInputs) {
            if (!includedInputs.contains(input)) continue;
            builder.add((Object)input);
        }
        return builder.build();
    }

    public InputT getInputProviding(String symbolName) throws MissingProvideException {
        InputT input = this.maybeGetInputProviding(symbolName);
        if (input != null) {
            return input;
        }
        throw new MissingProvideException(symbolName);
    }

    public ImmutableList<InputT> getInputsWithoutProvides() {
        return ImmutableList.copyOf(this.nonExportingInputs.values());
    }

    public ImmutableList<InputT> getSortedStrongDependenciesOf(List<InputT> roots) {
        return this.getStrongDependenciesOf(roots, true);
    }

    public ImmutableList<InputT> getSortedWeakDependenciesOf(List<InputT> rootInputs) {
        LinkedHashSet<InputT> strongInputs = new LinkedHashSet<InputT>(this.getSortedStrongDependenciesOf(rootInputs));
        LinkedHashSet<DependencyInfo> weakInputs = new LinkedHashSet<DependencyInfo>();
        ArrayDeque<InputT> worklist = new ArrayDeque<InputT>(strongInputs);
        while (!worklist.isEmpty()) {
            ImmutableList<String> edges;
            DependencyInfo input = (DependencyInfo)worklist.pop();
            boolean isStrong = strongInputs.contains(input);
            Object object = edges = isStrong ? input.getTypeRequires() : Iterables.concat(input.getRequiredSymbols(), input.getTypeRequires());
            if (!isStrong && !weakInputs.add(input)) continue;
            for (String symbolName : edges) {
                DependencyInfo importedSymbolName = (DependencyInfo)this.exportingInputBySymbolName.get(symbolName);
                if (importedSymbolName == null || strongInputs.contains(importedSymbolName) || weakInputs.contains(importedSymbolName)) continue;
                worklist.add(importedSymbolName);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DependencyInfo input : this.importOrderedInputs) {
            if (!weakInputs.contains(input)) continue;
            builder.add((Object)input);
        }
        return builder.build();
    }

    public List<InputT> getSortedList() {
        return Collections.unmodifiableList(this.importOrderedInputs);
    }

    public InputT maybeGetInputProviding(String symbol) {
        if (this.exportingInputBySymbolName.containsKey(symbol)) {
            return (InputT)((DependencyInfo)this.exportingInputBySymbolName.get(symbol));
        }
        return (InputT)((DependencyInfo)this.nonExportingInputs.get(ModuleNames.fileToModuleName(symbol)));
    }

    private void orderInput(InputT input) {
        if (this.completedInputs.contains(input)) {
            return;
        }
        this.completedInputs.add(input);
        for (DependencyInfo importedInput : this.importedInputByImportingInput.get(input)) {
            this.orderInput(importedInput);
        }
        this.importOrderedInputs.add(input);
    }

    private void processInputs() {
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            ImmutableList<String> provides = userOrderedInput.getProvides();
            String firstProvide = (String)Iterables.getFirst(provides, null);
            if (firstProvide == null || provides.size() == 1 && firstProvide.startsWith("module$") && !userOrderedInput.isEs6Module()) {
                this.nonExportingInputs.put(ModuleNames.fileToModuleName(userOrderedInput.getName()), userOrderedInput);
            }
            for (String providedSymbolName : userOrderedInput.getProvides()) {
                this.exportingInputBySymbolName.put(providedSymbolName, userOrderedInput);
            }
        }
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            for (String symbolName : userOrderedInput.getRequiredSymbols()) {
                DependencyInfo importedInput = (DependencyInfo)this.exportingInputBySymbolName.get(symbolName);
                if (importedInput == null) continue;
                this.importedInputByImportingInput.put((Object)userOrderedInput, (Object)importedInput);
            }
        }
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            this.orderInput(userOrderedInput);
        }
        this.completedInputs.clear();
        this.importedInputByImportingInput.clear();
    }

    public static class MissingProvideException
    extends Exception {
        public MissingProvideException(String provide) {
            super(provide);
        }

        public MissingProvideException(String provide, Exception e) {
            super(provide, e);
        }
    }
}

