/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.colors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.diagnostic.LogsGson;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;

@Immutable
public final class ColorId
implements Serializable,
LogsGson.Able {
    private final long rightAligned;
    private static final HashFunction FARM_64 = Hashing.farmHashFingerprint64();
    private static final ByteAt<String> ASCII_AT = (s, i) -> {
        int c = s.codePointAt(i);
        Preconditions.checkState((0 <= c && c < 128 ? 1 : 0) != 0, (Object)c);
        return (byte)c;
    };

    public static ColorId fromUnsigned(long x) {
        return new ColorId(x);
    }

    public static ColorId fromUnsigned(int x) {
        return new ColorId((long)x & 0xFFFFFFFFL);
    }

    public static ColorId fromUnsigned(byte x) {
        return new ColorId((long)x & 0xFFL);
    }

    public static ColorId fromBytes(ByteString bytes) {
        return ColorId.fromBytesAt(bytes, bytes.size(), ByteString::byteAt);
    }

    public static ColorId fromBytes(byte[] bytes) {
        return ColorId.fromBytesAt(bytes, bytes.length, (s, i) -> s[i]);
    }

    @VisibleForTesting
    public static ColorId fromAscii(String str) {
        return ColorId.fromBytesAt(str, str.length(), ASCII_AT);
    }

    private static <T> ColorId fromBytesAt(T source, int length, ByteAt<T> byteAt) {
        Preconditions.checkState((length <= 8 ? 1 : 0) != 0, (Object)length);
        long rightAligned = 0L;
        for (int i = 0; i < length; ++i) {
            rightAligned <<= 8;
            rightAligned |= (long)byteAt.get(source, i) & 0xFFL;
        }
        return new ColorId(rightAligned);
    }

    public static ColorId union(Set<ColorId> ids) {
        if (ids.size() <= 1) {
            return (ColorId)Iterables.getOnlyElement(ids);
        }
        int index = 0;
        long[] sorted = new long[ids.size()];
        for (ColorId id : ids) {
            sorted[index++] = id.rightAligned;
        }
        Arrays.sort(sorted);
        Hasher hasher = FARM_64.newHasher();
        for (int i = 0; i < sorted.length; ++i) {
            hasher.putLong(sorted[i]);
        }
        return new ColorId(hasher.hash().asLong());
    }

    private ColorId(long rightAligned) {
        this.rightAligned = rightAligned;
    }

    public boolean equals(Object x) {
        if (!(x instanceof ColorId)) {
            return false;
        }
        ColorId that = (ColorId)x;
        return this.rightAligned == that.rightAligned;
    }

    public int hashCode() {
        return (int)this.rightAligned;
    }

    public ByteString asByteString() {
        long copy = this.rightAligned;
        byte[] out = new byte[8];
        for (int i = 7; i >= 0; --i) {
            out[i] = (byte)copy;
            copy >>>= 8;
        }
        return ByteString.copyFrom((byte[])out);
    }

    public String toString() {
        return Long.toHexString(this.rightAligned);
    }

    @Override
    public String toLogsGson() {
        return this.toString();
    }

    private static interface ByteAt<T> {
        public byte get(T var1, int var2);
    }
}

