/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.colors;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.colors.$AutoValue_Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.colors.StandardColors;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.nullness.Nullable;

@AutoValue
public abstract class Color {
    public abstract ColorId getId();

    public abstract ImmutableSet<Color> getPrototypes();

    public abstract ImmutableSet<Color> getInstanceColors();

    public abstract boolean isInvalidating();

    public abstract boolean getPropertiesKeepOriginalName();

    public abstract boolean isConstructor();

    public abstract ImmutableSet<String> getOwnProperties();

    public abstract @Nullable ColorId getBoxId();

    public abstract boolean isClosureAssert();

    public abstract ImmutableSet<Color> getUnionElements();

    public static Builder singleBuilder() {
        return new $AutoValue_Color.Builder().setClosureAssert(false).setConstructor(false).setInstanceColors((ImmutableSet<Color>)ImmutableSet.of()).setInvalidating(false).setOwnProperties((ImmutableSet<String>)ImmutableSet.of()).setPropertiesKeepOriginalName(false).setPrototypes((ImmutableSet<Color>)ImmutableSet.of()).setUnionElements((ImmutableSet<Color>)ImmutableSet.of());
    }

    public static Color createUnion(Set<Color> elements) {
        switch (elements.size()) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: {
                return (Color)Iterables.getOnlyElement(elements);
            }
        }
        ImmutableSet.Builder instanceColors = ImmutableSet.builder();
        ImmutableSet.Builder prototypes = ImmutableSet.builder();
        ImmutableSet.Builder newElements = ImmutableSet.builder();
        ImmutableSet.Builder ids = ImmutableSet.builder();
        ImmutableSet.Builder ownProperties = ImmutableSet.builder();
        boolean isClosureAssert = true;
        boolean isConstructor = true;
        boolean isInvalidating = false;
        boolean propertiesKeepOriginalName = false;
        for (Color element : elements) {
            if (element.isUnion()) {
                for (Color nestedElement : element.getUnionElements()) {
                    newElements.add((Object)nestedElement);
                    ids.add((Object)nestedElement.getId());
                }
            } else {
                newElements.add((Object)element);
                ids.add((Object)element.getId());
            }
            instanceColors.addAll(element.getInstanceColors());
            isClosureAssert &= element.isClosureAssert();
            isConstructor &= element.isConstructor();
            isInvalidating |= element.isInvalidating();
            ownProperties.addAll(element.getOwnProperties());
            propertiesKeepOriginalName |= element.getPropertiesKeepOriginalName();
            prototypes.addAll(element.getPrototypes());
        }
        return new $AutoValue_Color.Builder().setClosureAssert(isClosureAssert).setConstructor(isConstructor).setId(ColorId.union((Set<ColorId>)ids.build())).setInstanceColors((ImmutableSet<Color>)instanceColors.build()).setInvalidating(isInvalidating).setOwnProperties((ImmutableSet<String>)ownProperties.build()).setPropertiesKeepOriginalName(propertiesKeepOriginalName).setPrototypes((ImmutableSet<Color>)prototypes.build()).setUnionElements((ImmutableSet<Color>)newElements.build()).buildUnion();
    }

    Color() {
    }

    public final boolean isPrimitive() {
        Preconditions.checkState((!this.isUnion() ? 1 : 0) != 0, (Object)this);
        return StandardColors.PRIMITIVE_COLORS.containsKey((Object)this.getId());
    }

    public final boolean isUnion() {
        return !this.getUnionElements().isEmpty();
    }

    public Color subtractNullOrVoid() {
        Preconditions.checkState((boolean)this.isUnion());
        if (!this.getUnionElements().contains((Object)StandardColors.NULL_OR_VOID)) {
            return this;
        }
        LinkedHashSet<Color> elements = new LinkedHashSet<Color>((Collection<Color>)this.getUnionElements());
        elements.remove(StandardColors.NULL_OR_VOID);
        return Color.createUnion(elements);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setId(ColorId var1);

        public abstract Builder setInvalidating(boolean var1);

        public abstract Builder setPropertiesKeepOriginalName(boolean var1);

        public abstract Builder setConstructor(boolean var1);

        public abstract Builder setOwnProperties(ImmutableSet<String> var1);

        public abstract Builder setClosureAssert(boolean var1);

        public abstract Builder setInstanceColors(ImmutableSet<Color> var1);

        public abstract Builder setPrototypes(ImmutableSet<Color> var1);

        abstract Builder setUnionElements(ImmutableSet<Color> var1);

        abstract Builder setBoxId(@Nullable ColorId var1);

        public Builder setPrototype(Color x) {
            return this.setPrototypes((ImmutableSet<Color>)(x == null ? ImmutableSet.of() : ImmutableSet.of((Object)x)));
        }

        public Builder setInstanceColor(Color x) {
            return this.setInstanceColors((ImmutableSet<Color>)(x == null ? ImmutableSet.of() : ImmutableSet.of((Object)x)));
        }

        abstract Color buildInternal();

        public final Color build() {
            Color result = this.buildInternal();
            Preconditions.checkState((boolean)result.getUnionElements().isEmpty(), (Object)result);
            Preconditions.checkState((result.getBoxId() == null ? 1 : 0) != 0, (Object)result);
            Preconditions.checkState((!StandardColors.AXIOMATIC_COLORS.containsKey((Object)result.getId()) ? 1 : 0) != 0, (Object)result);
            return result;
        }

        private final Color buildUnion() {
            Color result = this.buildInternal();
            Preconditions.checkState((result.getUnionElements().size() > 1 ? 1 : 0) != 0, (Object)result);
            Preconditions.checkState((result.getBoxId() == null ? 1 : 0) != 0, (Object)result);
            return result;
        }

        final Color buildAxiomatic() {
            Preconditions.checkState((StandardColors.AXIOMATIC_COLORS == null ? 1 : 0) != 0, (Object)"StandardColors are all defined");
            Color result = this.buildInternal();
            Preconditions.checkState((boolean)result.getUnionElements().isEmpty(), (Object)result);
            return result;
        }
    }
}

