/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.nullness.Nullable;

class VarCheck
implements NodeTraversal.ScopedCallback,
CompilerPass {
    static final DiagnosticType UNDEFINED_VAR_ERROR = DiagnosticType.error("JSC_UNDEFINED_VARIABLE", "variable {0} is undeclared");
    static final DiagnosticType VIOLATED_MODULE_DEP_ERROR = DiagnosticType.error("JSC_VIOLATED_MODULE_DEPENDENCY", "module {0} cannot reference {2}, defined in module {1}, since {1} loads after {0}");
    static final DiagnosticType MISSING_MODULE_DEP_ERROR = DiagnosticType.warning("JSC_MISSING_MODULE_DEPENDENCY", "missing module dependency; module {0} should depend on module {1} because it references {2}");
    static final DiagnosticType STRICT_MODULE_DEP_ERROR = DiagnosticType.disabled("JSC_STRICT_MODULE_DEPENDENCY", "cannot reference {2} because of a missing module dependency\ndefined in module {1}, referenced from module {0}");
    static final DiagnosticType NAME_REFERENCE_IN_EXTERNS_ERROR = DiagnosticType.warning("JSC_NAME_REFERENCE_IN_EXTERNS", "accessing name {0} in externs has no effect. Perhaps you forgot to add a var keyword?");
    static final DiagnosticType UNDEFINED_EXTERN_VAR_ERROR = DiagnosticType.warning("JSC_UNDEFINED_EXTERN_VAR_ERROR", "name {0} is not defined in the externs.");
    static final DiagnosticType VAR_MULTIPLY_DECLARED_ERROR = DiagnosticType.error("JSC_VAR_MULTIPLY_DECLARED_ERROR", "Variable {0} declared more than once. First occurrence: {1}");
    static final DiagnosticType BLOCK_SCOPED_DECL_MULTIPLY_DECLARED_ERROR = DiagnosticType.error("JSC_BLOCK_SCOPED_DECL_MULTIPLY_DECLARED_ERROR", "Block-scoped variable {0} declared more than once. First occurrence: {1}");
    static final DiagnosticType VAR_ARGUMENTS_SHADOWED_ERROR = DiagnosticType.error("JSC_VAR_ARGUMENTS_SHADOWED_ERROR", "Shadowing \"arguments\" is not allowed");
    private static final String ARGUMENTS = "arguments";
    private static final Node googForwardDeclare = IR.getprop(IR.name("goog"), "forwardDeclare");
    private final Set<String> undefinedNamesFromExterns = new LinkedHashSet<String>();
    private final AbstractCompiler compiler;
    private final boolean validityCheck;
    private final boolean strictExternCheck;
    private RedeclarationCheckHandler dupHandler;
    static final ImmutableSet<String> REQUIRED_SYMBOLS = ImmutableSet.of((Object)"AggregateError", (Object)"Array", (Object)"Error", (Object)"Float32Array", (Object)"Function", (Object)"Infinity", (Object[])new String[]{"JSCompiler_renameProperty", "JSCOMPILER_PRESERVE", "Map", "Math", "NaN", "Number", "Object", "Promise", "RangeError", "Reflect", "RegExp", "Set", "String", "Symbol", "TypeError", "WeakMap", "global", "globalThis", "isNaN", "parseFloat", "parseInt", "self", "undefined", "window"});

    VarCheck(AbstractCompiler compiler) {
        this(compiler, false);
    }

    VarCheck(AbstractCompiler compiler, boolean validityCheck) {
        this.compiler = compiler;
        this.strictExternCheck = compiler.getErrorLevel(JSError.make("", 0, 0, UNDEFINED_EXTERN_VAR_ERROR, new String[0])) == CheckLevel.ERROR;
        this.validityCheck = validityCheck;
    }

    private SyntacticScopeCreator createScopeCreator() {
        if (this.validityCheck) {
            return new SyntacticScopeCreator(this.compiler);
        }
        this.dupHandler = new RedeclarationCheckHandler();
        return new SyntacticScopeCreator(this.compiler, this.dupHandler);
    }

    @Override
    public void process(Node externs, Node root) {
        SyntacticScopeCreator scopeCreator = this.createScopeCreator();
        if (!this.validityCheck) {
            NodeTraversal.builder().setCompiler(this.compiler).setCallback(new NameRefInExternsCheck()).setScopeCreator(scopeCreator).traverse(externs);
        }
        NodeTraversal.builder().setCompiler(this.compiler).setCallback(this).setScopeCreator(scopeCreator).traverseRoots(externs, root);
        for (String varName : this.undefinedNamesFromExterns) {
            this.createSynthesizedExternVar(varName, false);
        }
        if (this.dupHandler != null) {
            this.dupHandler.removeDuplicates();
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isName()) {
            this.checkName(t, n, parent);
        }
    }

    private void checkName(NodeTraversal t, Node n, Node parent) {
        CompilerInput varInput;
        String varName = n.getString();
        if (varName.isEmpty()) {
            Preconditions.checkState((NodeUtil.isFunctionExpression(parent) || NodeUtil.isMethodDeclaration(parent) ? 1 : 0) != 0);
            return;
        }
        Scope scope = t.getScope();
        Var var = (Var)scope.getVar(varName);
        if (var == null) {
            if ((NodeUtil.isFunctionExpression(parent) || NodeUtil.isClassExpression(parent)) && n.isFirstChildOf(parent)) {
                return;
            }
            if (NodeUtil.isNonlocalModuleExportName(n)) {
                return;
            }
            this.handleUndeclaredVariableRef(t, n);
            ((Scope)scope.getGlobalScope()).declare(varName, n, this.compiler.getSynthesizedExternsInput());
            return;
        }
        if (var.isImplicitGoogNamespace() && var.getImplicitGoogNamespaceStrength().equals((Object)StaticSourceFile.SourceKind.WEAK) && VarCheck.strengthOf(n).equals((Object)StaticSourceFile.SourceKind.STRONG)) {
            this.handleUndeclaredVariableRef(t, n);
            return;
        }
        CompilerInput currInput = t.getInput();
        if (currInput == (varInput = var.getInput()) || currInput == null || varInput == null) {
            return;
        }
        JSChunk currModule = currInput.getChunk();
        JSChunk varModule = varInput.getChunk();
        JSChunkGraph chunkGraph = this.compiler.getChunkGraph();
        if (!this.validityCheck && varModule != currModule && varModule != null && currModule != null) {
            if (varModule.isWeak()) {
                this.handleUndeclaredVariableRef(t, n);
            }
            if (!chunkGraph.dependsOn(currModule, varModule)) {
                if (scope.isGlobal()) {
                    if (chunkGraph.dependsOn(varModule, currModule)) {
                        t.report(n, VIOLATED_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                    } else {
                        t.report(n, MISSING_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                    }
                } else {
                    t.report(n, STRICT_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                }
            }
        }
    }

    private static final StaticSourceFile.SourceKind strengthOf(Node n) {
        StaticSourceFile source = n.getStaticSourceFile();
        if (source == null) {
            return StaticSourceFile.SourceKind.EXTERN;
        }
        return source.getKind();
    }

    private void handleUndeclaredVariableRef(NodeTraversal t, Node n) {
        Preconditions.checkState((boolean)n.isName());
        String varName = n.getString();
        if (!(n.getParent().isTypeOf() || this.strictExternCheck && t.getInput().isExtern())) {
            t.report(n, UNDEFINED_VAR_ERROR, varName);
        }
        if (this.validityCheck) {
            throw new IllegalStateException("Unexpected variable " + varName);
        }
        if (!this.undefinedNamesFromExterns.contains(varName)) {
            this.createSynthesizedExternVar(varName, true);
        }
    }

    @Override
    public void enterScope(NodeTraversal t) {
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!this.validityCheck && t.inGlobalScope()) {
            Scope scope = t.getScope();
            for (String requiredSymbol : REQUIRED_SYMBOLS) {
                Var var = (Var)scope.getVar(requiredSymbol);
                if (var != null) continue;
                this.undefinedNamesFromExterns.add(requiredSymbol);
            }
        }
    }

    private void createSynthesizedExternVar(String varName, boolean isFromUndefinedCodeRef) {
        Node nameNode = IR.name(varName);
        if (this.compiler.getCodingConvention().isConstant(varName)) {
            nameNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
        }
        Node syntheticExternVar = IR.var(nameNode);
        syntheticExternVar.setIsSynthesizedUnfulfilledNameDeclaration(isFromUndefinedCodeRef);
        VarCheck.getSynthesizedExternsRoot(this.compiler).addChildToBack(syntheticExternVar);
        this.compiler.reportChangeToEnclosingScope(syntheticExternVar);
    }

    static boolean hasDuplicateDeclarationSuppression(AbstractCompiler compiler, Node n, Node origVar) {
        if (VarCheck.isExternNamespace(n)) {
            return true;
        }
        return TypeValidator.hasDuplicateDeclarationSuppression(compiler, origVar);
    }

    static boolean isExternNamespace(Node n) {
        return n.getParent().isVar() && n.isFromExterns() && NodeUtil.isNamespaceDecl(n);
    }

    static void reportVarMultiplyDeclared(AbstractCompiler compiler, Node current, String name, @Nullable Node original) {
        compiler.report(JSError.make(current, VAR_MULTIPLY_DECLARED_ERROR, name, VarCheck.locationOf(original)));
    }

    private void reportBlockScopedMultipleDeclaration(Node current, String name, @Nullable Node original) {
        this.compiler.report(JSError.make(current, BLOCK_SCOPED_DECL_MULTIPLY_DECLARED_ERROR, name, VarCheck.locationOf(original)));
    }

    private static String locationOf(@Nullable Node n) {
        return n == null ? "<unknown>" : n.getLocation();
    }

    private static Node getSynthesizedExternsRoot(AbstractCompiler compiler) {
        return compiler.getSynthesizedExternsInput().getAstRoot(compiler);
    }

    private class RedeclarationCheckHandler
    implements SyntacticScopeCreator.RedeclarationHandler {
        private final ArrayList<Node> dupDeclNodes = new ArrayList();

        private RedeclarationCheckHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
            Node parent = NodeUtil.getDeclaringParent(n);
            Var origVar = (Var)s.getVar(name);
            Node origNode = origVar.getNode();
            Node origParent = origNode == null ? null : NodeUtil.getDeclaringParent(origNode);
            switch (parent.getToken()) {
                case LET: 
                case CONST: 
                case CLASS: {
                    VarCheck.this.reportBlockScopedMultipleDeclaration(n, name, origNode);
                    return;
                }
            }
            if (origParent != null) {
                switch (origParent.getToken()) {
                    case LET: 
                    case CONST: 
                    case CLASS: {
                        VarCheck.this.reportBlockScopedMultipleDeclaration(n, name, origNode);
                        return;
                    }
                    case FUNCTION: {
                        if (s.isGlobal() || !parent.isFunction()) break;
                        VarCheck.this.reportBlockScopedMultipleDeclaration(n, name, origNode);
                        return;
                    }
                }
            }
            if (s.isGlobal()) {
                if (origParent.isCatch() && parent.isCatch()) {
                    return;
                }
                boolean allowDupe = VarCheck.hasDuplicateDeclarationSuppression(VarCheck.this.compiler, n, origVar.getNameNode());
                if (VarCheck.isExternNamespace(n)) {
                    this.dupDeclNodes.add(parent);
                    return;
                }
                if (!allowDupe) {
                    VarCheck.reportVarMultiplyDeclared(VarCheck.this.compiler, n, name, origNode);
                }
            } else if (!(!name.equals(VarCheck.ARGUMENTS) || NodeUtil.isNameDeclaration(n.getParent()) && n.isName())) {
                VarCheck.this.compiler.report(JSError.make(n, VAR_ARGUMENTS_SHADOWED_ERROR, new String[0]));
            }
        }

        public void removeDuplicates() {
            for (Node n : this.dupDeclNodes) {
                Node parent = n.getParent();
                if (parent == null) continue;
                n.detach();
                VarCheck.this.compiler.reportChangeToEnclosingScope(parent);
            }
        }
    }

    private class NameRefInExternsCheck
    implements NodeTraversal.Callback {
        private NameRefInExternsCheck() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isScript() || !NodeUtil.isFromTypeSummary(n);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                switch (parent.getToken()) {
                    case VAR: 
                    case LET: 
                    case CONST: 
                    case FUNCTION: 
                    case CLASS: 
                    case PARAM_LIST: 
                    case DEFAULT_VALUE: 
                    case ITER_REST: 
                    case OBJECT_REST: 
                    case ARRAY_PATTERN: {
                        return;
                    }
                    case STRING_KEY: {
                        if (!parent.getParent().isObjectPattern()) break;
                        return;
                    }
                    case GETPROP: {
                        if (n == parent.getFirstChild()) {
                            Scope scope = t.getScope();
                            Var var = (Var)scope.getVar(n.getString());
                            if (var != null) {
                                return;
                            }
                            if (parent.matchesQualifiedName(googForwardDeclare)) {
                                return;
                            }
                            t.report(n, UNDEFINED_EXTERN_VAR_ERROR, n.getString());
                            VarCheck.this.undefinedNamesFromExterns.add(n.getString());
                        }
                        return;
                    }
                    case ASSIGN: {
                        if (n != parent.getLastChild() || !n.isQualifiedName() || !parent.getFirstChild().isQualifiedName()) break;
                        return;
                    }
                    case NAME: {
                        if (!NodeUtil.isNameDeclaration(parent.getParent())) break;
                        return;
                    }
                    case OR: {
                        if (!NodeUtil.isNamespaceDecl(parent.getParent())) break;
                        return;
                    }
                }
                t.report(n, NAME_REFERENCE_IN_EXTERNS_ERROR, n.getString());
                Scope scope = t.getScope();
                Var var = (Var)scope.getVar(n.getString());
                if (var == null) {
                    VarCheck.this.undefinedNamesFromExterns.add(n.getString());
                }
            }
        }
    }
}

