/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public class TypedScope
extends AbstractScope<TypedScope, TypedVar>
implements StaticTypedScope {
    private final @Nullable TypedScope parent;
    private final int depth;
    private final @Nullable Module module;
    private final boolean isBottom;
    private Set<String> reservedNames;

    TypedScope(TypedScope parent, Node rootNode) {
        this(parent, rootNode, new LinkedHashSet<String>(), null);
    }

    TypedScope(TypedScope parent, Node rootNode, Set<String> reservedNames, @Nullable Module module) {
        super(rootNode);
        this.checkChildScope(parent);
        this.parent = parent;
        this.depth = parent.depth + 1;
        this.isBottom = false;
        this.reservedNames = reservedNames.isEmpty() ? ImmutableSet.of() : new LinkedHashSet<String>(reservedNames);
        this.module = module;
    }

    private TypedScope(Node rootNode, boolean isBottom) {
        super(rootNode);
        this.checkRootScope();
        this.parent = null;
        this.depth = 0;
        this.isBottom = isBottom;
        this.reservedNames = ImmutableSet.of();
        this.module = null;
    }

    static TypedScope createGlobalScope(Node rootNode) {
        return new TypedScope(rootNode, false);
    }

    static TypedScope createLatticeBottom(Node rootNode) {
        return new TypedScope(rootNode, true);
    }

    @Override
    public TypedScope typed() {
        return this;
    }

    void validateCompletelyBuilt() {
        Preconditions.checkState((boolean)this.reservedNames.isEmpty(), (String)"Expected %s to have no reserved names, found: %s", (Object)this, this.reservedNames);
        this.reservedNames = ImmutableSet.of();
    }

    boolean isBottom() {
        return this.isBottom;
    }

    @Nullable Module getModule() {
        return this.module;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public TypedScope getParent() {
        return this.parent;
    }

    @Override
    public @Nullable JSType getTypeOfThis() {
        Node root = this.getRootNode();
        if (this.isGlobal()) {
            return ObjectType.cast(root.getJSType());
        }
        if (NodeUtil.isNonArrowFunction(root)) {
            JSType nodeType = root.getJSType();
            if (nodeType != null && nodeType.isFunctionType()) {
                return nodeType.toMaybeFunctionType().getTypeOfThis();
            }
            return null;
        }
        if (this.isStaticBlockScope()) {
            return this.getParent().getRootNode().getJSType();
        }
        if (this.isMemberFieldDefScope() || this.isComputedFieldDefRhsScope()) {
            JSType classType = this.getParent().getRootNode().getJSType();
            if (root.isStaticMember()) {
                return classType;
            }
            return classType.assertFunctionType().getInstanceType();
        }
        return this.getParent().getTypeOfThis();
    }

    TypedVar declare(String name, Node nameNode, JSType type, CompilerInput input, boolean inferred) {
        Preconditions.checkState((name != null && !name.isEmpty() ? 1 : 0) != 0);
        if (!this.reservedNames.isEmpty()) {
            this.reservedNames.remove(name);
        }
        TypedVar var = new TypedVar(inferred, name, nameNode, type, this, this.getVarCount(), input);
        this.declareInternal(name, var);
        return var;
    }

    @Override
    @Nullable TypedVar makeImplicitVar(AbstractScope.ImplicitVar var) {
        if (this.isGlobal()) {
            return null;
        }
        if (var.equals((Object)AbstractScope.ImplicitVar.EXPORTS)) {
            return null;
        }
        return new TypedVar(false, var.name, null, this.getImplicitVarType(var), this, -1, null);
    }

    @Override
    protected boolean hasOwnImplicitSlot(@Nullable AbstractScope.ImplicitVar name) {
        return name != null && !name.equals((Object)AbstractScope.ImplicitVar.EXPORTS) && name.isMadeByScope(this);
    }

    private @Nullable JSType getImplicitVarType(AbstractScope.ImplicitVar var) {
        switch (var) {
            case ARGUMENTS: {
                TypedVar globalArgs = ((TypedScope)this.getGlobalScope()).getVar("arguments");
                return globalArgs != null && globalArgs.isExtern() ? globalArgs.getType() : null;
            }
            case THIS: {
                return this.getTypeOfThis();
            }
            case SUPER: {
                ObjectType receiverType = ObjectType.cast(this.getTypeOfThis());
                if (receiverType == null) {
                    return null;
                }
                if (receiverType.isInstanceType()) {
                    FunctionType superclassCtor = receiverType.getSuperClassConstructor();
                    return superclassCtor == null ? null : superclassCtor.getInstanceType();
                }
                return receiverType.getImplicitPrototype();
            }
            case EXPORTS: {
                throw new AssertionError((Object)"TypedScopes should not contain an implicit 'exports'");
            }
        }
        throw new AssertionError();
    }

    public Iterable<TypedVar> getDeclarativelyUnboundVarsWithoutTypes() {
        return Iterables.filter(this.getVarIterable(), this::isDeclarativelyUnboundVarWithoutType);
    }

    private boolean isDeclarativelyUnboundVarWithoutType(TypedVar var) {
        return var.getParentNode() != null && var.getType() == null && var.getParentNode().isVar() && !var.isExtern();
    }

    @Override
    public final @Nullable TypedVar getVar(String name) {
        TypedVar ownSlot = (TypedVar)this.getOwnSlot(name);
        if (ownSlot != null) {
            return ownSlot;
        }
        if (this.getParent() == null) {
            return null;
        }
        int dot = name.indexOf(46);
        String rootName = dot < 0 ? name : name.substring(0, dot);
        TypedVar rootVar = (TypedVar)super.getVar(rootName);
        if (dot < 0) {
            return rootVar;
        }
        if (rootVar == null) {
            return (TypedVar)((TypedScope)this.getParent().getGlobalScope()).getOwnSlot(name);
        }
        return (TypedVar)((TypedScope)rootVar.getScope()).getOwnSlot(name);
    }

    final @Nullable JSType getTypeThroughNamespace(String moduleId) {
        int split = moduleId.lastIndexOf(46);
        if (split >= 0) {
            String parentName = moduleId.substring(0, split);
            String prop = moduleId.substring(split + 1);
            JSType parentType = this.getTypeThroughNamespace(parentName);
            if (parentType == null || parentType.toMaybeObjectType() == null) {
                return null;
            }
            return parentType.assertObjectType().getPropertyType(prop);
        }
        TypedVar var = (TypedVar)this.getSlot(moduleId);
        return var != null ? var.getType() : null;
    }

    @Override
    public @Nullable StaticScope getTopmostScopeOfEventualDeclaration(String name) {
        if (this.getOwnSlot(name) != null || this.reservedNames.contains(name)) {
            return this;
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getTopmostScopeOfEventualDeclaration(name);
    }
}

