/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import org.jspecify.nullness.Nullable;

public final class Scope
extends AbstractScope<Scope, Var> {
    private final @Nullable Scope parent;
    private final int depth;

    static Scope createGlobalScope(Node rootNode) {
        return new Scope(rootNode);
    }

    static Scope createChildScope(Scope parent, Node rootNode) {
        return new Scope(parent, rootNode);
    }

    private Scope(Scope parent, Node rootNode) {
        super(rootNode);
        this.checkChildScope(parent);
        this.parent = parent;
        this.depth = parent.getDepth() + 1;
    }

    private Scope(Node rootNode) {
        super(rootNode);
        this.checkRootScope();
        this.parent = null;
        this.depth = 0;
    }

    @Override
    public Scope untyped() {
        return this;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public Scope getParent() {
        return this.parent;
    }

    Var declare(String name, Node nameNode, CompilerInput input) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.getOwnSlot(name) == null ? 1 : 0) != 0);
        Var var = new Var(name, nameNode, this, this.getVarCount(), input, null);
        this.declareInternal(name, var);
        return var;
    }

    Var declareImplicitGoogNamespaceIfAbsent(String name, Node definition) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isGlobal(), (String)"Cannot declare implicit goog namespace in local scope %s", (Object)this);
        Var var = (Var)this.getOwnSlot(name);
        if (var == null) {
            var = Var.createImplicitGoogNamespace(name, this, definition);
            this.declareInternal(name, var);
        } else if (var.isImplicitGoogNamespace()) {
            var.addImplicitGoogNamespaceDefinition(definition);
        }
        return var;
    }

    @Override
    Var makeImplicitVar(AbstractScope.ImplicitVar var) {
        return new Var(var.name, null, this, -1, null, null);
    }
}

