/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.VariableMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public class Result {
    public final boolean success;
    public final ImmutableList<JSError> errors;
    public final ImmutableList<JSError> warnings;
    public final VariableMap variableMap;
    public final VariableMap propertyMap;
    public final VariableMap namedAnonFunctionMap;
    public final VariableMap stringMap;
    public final VariableMap instrumentationMappings;
    public final SourceMap sourceMap;
    public final Set<String> cssNames;
    public final String externExport;
    public final String idGeneratorMap;
    public final boolean transpiledFiles;

    Result(ImmutableList<JSError> errors, ImmutableList<JSError> warnings, VariableMap variableMap, VariableMap propertyMap, VariableMap namedAnonFunctionMap, @Nullable VariableMap stringMap, @Nullable VariableMap instrumentationMappings, @Nullable SourceMap sourceMap, String externExport, @Nullable Set<String> cssNames, @Nullable String idGeneratorMap, boolean transpiledFiles) {
        this.success = errors.isEmpty();
        this.errors = errors;
        this.warnings = warnings;
        this.variableMap = variableMap;
        this.propertyMap = propertyMap;
        this.namedAnonFunctionMap = namedAnonFunctionMap;
        this.stringMap = stringMap;
        this.instrumentationMappings = instrumentationMappings;
        this.sourceMap = sourceMap;
        this.externExport = externExport;
        this.cssNames = cssNames;
        this.idGeneratorMap = idGeneratorMap;
        this.transpiledFiles = transpiledFiles;
    }

    @Deprecated
    @VisibleForTesting
    public Result(ImmutableList<JSError> errors, ImmutableList<JSError> warnings, VariableMap variableMap, VariableMap propertyMap, VariableMap namedAnonFunctionMap, SourceMap sourceMap, String externExport) {
        this(errors, warnings, variableMap, propertyMap, namedAnonFunctionMap, null, null, sourceMap, externExport, null, null, false);
    }

    public static Result pruneResultForPartialCompilation(Result result) {
        VariableMap emptyVariableMap = new VariableMap((Map<String, String>)ImmutableMap.of());
        return new Result(result.errors, result.warnings, emptyVariableMap, emptyVariableMap, emptyVariableMap, null, emptyVariableMap, null, "", null, null, false);
    }
}

