/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.Token;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.jspecify.nullness.Nullable;

class ReplaceToggles
implements CompilerPass {
    static final DiagnosticType INVALID_TOGGLE_PARAMETER = DiagnosticType.error("JSC_INVALID_TOGGLE_PARAMETER", "goog.readToggleInternalDoNotCallDirectly must be called with a string literal.");
    static final DiagnosticType INVALID_ORDINAL_MAPPING = DiagnosticType.error("JSC_INVALID_ORDINAL_MAPPING", "CLOSURE_TOGGLE_ORDINALS must be initialized with an object literal mapping strings to booleans or unique whole numbers: {0}");
    private static final int TRUE_VALUE = -2;
    private static final int FALSE_VALUE = -1;
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private @Nullable ImmutableMap<String, Integer> ordinalMapping = null;
    private static final String ORDINAL_VAR_NAME = "CLOSURE_TOGGLE_ORDINALS";
    private static final QualifiedName readToggleFunctionName = QualifiedName.of("goog.readToggleInternalDoNotCallDirectly");

    ReplaceToggles(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new Traversal());
    }

    private class Traversal
    extends NodeTraversal.AbstractPostOrderCallback {
        private Traversal() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Integer ordinal;
            if (NodeUtil.isNameDeclaration(n) && n.getFirstChild().matchesName(ReplaceToggles.ORDINAL_VAR_NAME)) {
                Node rhs = n.getFirstFirstChild();
                if (rhs == null && n.getToken() == Token.VAR) {
                    return;
                }
                if (!rhs.isObjectLit()) {
                    ReplaceToggles.this.compiler.report(JSError.make(n, INVALID_ORDINAL_MAPPING, "not an object literal"));
                    return;
                }
                if (ReplaceToggles.this.ordinalMapping != null) {
                    ReplaceToggles.this.compiler.report(JSError.make(n, INVALID_ORDINAL_MAPPING, "multiple initialized copies"));
                    return;
                }
                LinkedHashMap<String, Integer> mapping = new LinkedHashMap<String, Integer>();
                HashSet<Integer> ordinals = new HashSet<Integer>();
                for (Node c = rhs.getFirstChild(); c != null; c = c.getNext()) {
                    int intValue;
                    if (!c.isStringKey() && !c.isStringLit()) {
                        ReplaceToggles.this.compiler.report(JSError.make(c, INVALID_ORDINAL_MAPPING, "non-string key"));
                        return;
                    }
                    String key = c.getString();
                    if (mapping.containsKey(key)) {
                        ReplaceToggles.this.compiler.report(JSError.make(c, INVALID_ORDINAL_MAPPING, "duplicate key: " + key));
                        return;
                    }
                    Node child = c.getFirstChild();
                    Double doubleValue = NodeUtil.getNumberValue(child);
                    int n2 = intValue = doubleValue != null ? doubleValue.intValue() : -1;
                    if (child.isTrue() || child.isFalse()) {
                        intValue = child.isTrue() ? -2 : -1;
                    } else {
                        if (!child.isNumber() || intValue < 0 || (double)intValue != doubleValue) {
                            ReplaceToggles.this.compiler.report(JSError.make(c, INVALID_ORDINAL_MAPPING, "value not a boolean or whole number literal"));
                            return;
                        }
                        if (ordinals.contains(intValue)) {
                            ReplaceToggles.this.compiler.report(JSError.make(c, INVALID_ORDINAL_MAPPING, "duplicate ordinal: " + intValue));
                            return;
                        }
                    }
                    mapping.put(key, intValue);
                    ordinals.add(intValue);
                }
                ReplaceToggles.this.ordinalMapping = ImmutableMap.copyOf(mapping);
                return;
            }
            if (!n.isCall()) {
                return;
            }
            Node qname = NodeUtil.getCallTargetResolvingIndirectCalls(n);
            if (!readToggleFunctionName.matches(qname)) {
                return;
            }
            Node arg = n.getSecondChild();
            if (arg == null || !arg.isStringLit() || !n.hasTwoChildren()) {
                ReplaceToggles.this.compiler.report(JSError.make(n, INVALID_TOGGLE_PARAMETER, new String[0]));
                return;
            }
            Integer n3 = ordinal = ReplaceToggles.this.ordinalMapping != null ? (Integer)ReplaceToggles.this.ordinalMapping.get((Object)arg.getString()) : null;
            if (ordinal == null || ordinal < 0) {
                n.replaceWith(ReplaceToggles.this.astFactory.createBoolean(ordinal != null && ordinal == -2).srcrefTreeIfMissing(n));
                t.reportCodeChange();
                return;
            }
            int index = ordinal / 30;
            int bit = ordinal % 30;
            Node getElem = ReplaceToggles.this.astFactory.createGetElem(ReplaceToggles.this.astFactory.createQNameWithUnknownType("goog.TOGGLES_"), ReplaceToggles.this.astFactory.createNumber(index));
            Node bitAnd = bit < 14 ? ReplaceToggles.this.astFactory.createBitwiseAnd(getElem, ReplaceToggles.this.astFactory.createNumber(1 << bit)) : ReplaceToggles.this.astFactory.createBitwiseAnd(ReplaceToggles.this.astFactory.createRightShift(getElem, ReplaceToggles.this.astFactory.createNumber(bit)), ReplaceToggles.this.astFactory.createNumber(1.0));
            n.replaceWith(ReplaceToggles.this.astFactory.createNot(ReplaceToggles.this.astFactory.createNot(bitAnd)).srcrefTreeIfMissing(n));
            t.reportCodeChange();
        }
    }
}

