/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.IcuTemplateDefinition;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.MessageBundle;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.nullness.Nullable;

@GwtIncompatible(value="JsMessage")
public final class ReplaceMessages {
    public static final DiagnosticType BUNDLE_DOES_NOT_HAVE_THE_MESSAGE = DiagnosticType.error("JSC_BUNDLE_DOES_NOT_HAVE_THE_MESSAGE", "Message with id = {0} could not be found in replacement bundle");
    public static final DiagnosticType INVALID_ALTERNATE_MESSAGE_PLACEHOLDERS = DiagnosticType.error("JSC_INVALID_ALTERNATE_MESSAGE_PLACEHOLDERS", "Alternate message ID={0} placeholders ({1}) differs from {2} placeholders ({3}).");
    private final AbstractCompiler compiler;
    private final MessageBundle bundle;
    private final boolean strictReplacement;
    private final AstFactory astFactory;
    private static final MsgOptions ICU_MSG_OPTIONS = new MsgOptions(){

        @Override
        public boolean isIcuTemplate() {
            return true;
        }

        @Override
        public boolean escapeLessThan() {
            return false;
        }

        @Override
        public boolean unescapeHtmlEntities() {
            return false;
        }
    };

    ReplaceMessages(AbstractCompiler compiler, MessageBundle bundle, boolean strictReplacement) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.bundle = bundle;
        this.strictReplacement = strictReplacement;
    }

    public CompilerPass getMsgProtectionPass() {
        return new MsgProtectionPass();
    }

    private MsgOptions getMsgOptionsFromDefinition(final JsMessageDefinition definition) {
        return new MsgOptions(){

            @Override
            public boolean isIcuTemplate() {
                return false;
            }

            @Override
            public boolean escapeLessThan() {
                return definition.shouldEscapeLessThan();
            }

            @Override
            public boolean unescapeHtmlEntities() {
                return definition.shouldUnescapeHtmlEntities();
            }
        };
    }

    private Node createMsgPropertiesNode(JsMessage message, MsgOptions msgOptions) {
        String meaning;
        QuotedKeyObjectLitBuilder msgPropsBuilder = new QuotedKeyObjectLitBuilder();
        msgPropsBuilder.addString("key", message.getKey());
        String altId = message.getAlternateId();
        if (altId != null) {
            msgPropsBuilder.addString("alt_id", altId);
        }
        if ((meaning = message.getMeaning()) != null) {
            msgPropsBuilder.addString("meaning", meaning);
        }
        if (msgOptions.isIcuTemplate()) {
            msgPropsBuilder.addString("msg_text", message.asIcuMessageString());
            msgPropsBuilder.addString("isIcuTemplate", "");
        } else {
            msgPropsBuilder.addString("msg_text", message.asJsMessageString());
        }
        if (msgOptions.escapeLessThan()) {
            msgPropsBuilder.addString("escapeLessThan", "");
        }
        if (msgOptions.unescapeHtmlEntities()) {
            msgPropsBuilder.addString("unescapeHtmlEntities", "");
        }
        return msgPropsBuilder.build();
    }

    public CompilerPass getReplacementCompletionPass() {
        return new ReplacementCompletionPass();
    }

    static ImmutableMap<String, Node> extractPlaceholderValuesMapOrThrow(Node valuesObjLit) {
        try {
            return JsMessageVisitor.extractObjectLiteralMap(valuesObjLit).extractAsValueMap();
        }
        catch (JsMessageVisitor.MalformedException e) {
            throw new IllegalStateException(e);
        }
    }

    private @Nullable JsMessage lookupMessage(Node callNode, MessageBundle bundle, JsMessage message) {
        ImmutableSet<String> alternateMsgPlaceholderNames;
        ImmutableSet<String> jsCodePlaceholderNames;
        JsMessage translatedMessage = bundle.getMessage(message.getId());
        if (translatedMessage != null) {
            return translatedMessage;
        }
        String alternateId = message.getAlternateId();
        if (alternateId == null) {
            return null;
        }
        JsMessage alternateMessage = bundle.getMessage(alternateId);
        if (alternateMessage != null && !Objects.equals(jsCodePlaceholderNames = message.jsPlaceholderNames(), alternateMsgPlaceholderNames = alternateMessage.jsPlaceholderNames())) {
            if (jsCodePlaceholderNames.isEmpty() && ReplaceMessages.isStartOfIcuMessage(message.asIcuMessageString())) {
                return alternateMessage;
            }
            this.compiler.report(JSError.make(callNode, INVALID_ALTERNATE_MESSAGE_PLACEHOLDERS, alternateId, String.valueOf(alternateMsgPlaceholderNames), message.getKey(), String.valueOf(jsCodePlaceholderNames)));
            return null;
        }
        return alternateMessage;
    }

    public CompilerPass getFullReplacementPass() {
        return new FullReplacementPass();
    }

    private Node constructStringExprNode(JsMessage msgToUse, Map<String, Node> placeholderMap, MsgOptions options, Node nodeToReplace) throws JsMessageVisitor.MalformedException {
        if (placeholderMap.isEmpty()) {
            if (options.isIcuTemplate()) {
                return this.createNodeForMsgString(options, msgToUse.asIcuMessageString());
            }
            if (msgToUse.jsPlaceholderNames().isEmpty()) {
                return this.createNodeForMsgString(options, msgToUse.asJsMessageString());
            }
            String icuMsgString = msgToUse.asIcuMessageString();
            if (ReplaceMessages.isStartOfIcuMessage(icuMsgString)) {
                return this.createNodeForMsgString(options, icuMsgString);
            }
            throw new JsMessageVisitor.MalformedException("The translated message has placeholders, but the definition in the JS code does not.", nodeToReplace);
        }
        List<JsMessage.Part> msgParts = ReplaceMessages.mergeStringParts(msgToUse.getParts());
        if (msgParts.isEmpty()) {
            return this.astFactory.createString("");
        }
        Node resultNode = null;
        for (JsMessage.Part msgPart : msgParts) {
            Node partNode;
            if (msgPart.isPlaceholder()) {
                String jsPlaceholderName = msgPart.getJsPlaceholderName();
                Node valueNode = placeholderMap.get(jsPlaceholderName);
                if (valueNode == null) {
                    throw new JsMessageVisitor.MalformedException("Unrecognized message placeholder referenced: " + jsPlaceholderName, nodeToReplace);
                }
                partNode = valueNode.cloneTree();
            } else {
                partNode = this.createNodeForMsgString(options, msgPart.getString());
            }
            resultNode = resultNode == null ? partNode : this.astFactory.createAdd(resultNode, partNode);
        }
        return resultNode;
    }

    private Node createNodeForMsgString(MsgOptions options, String s) {
        if (options.escapeLessThan()) {
            s = s.replace("<", "&lt;");
        }
        if (options.unescapeHtmlEntities()) {
            s = s.replace("&lt;", "<").replace("&gt;", ">").replace("&apos;", "'").replace("&quot;", "\"").replace("&amp;", "&");
        }
        return this.astFactory.createString(s);
    }

    private static List<JsMessage.Part> mergeStringParts(List<JsMessage.Part> parts) {
        ArrayList<JsMessage.Part> result = new ArrayList<JsMessage.Part>();
        for (JsMessage.Part part : parts) {
            JsMessage.Part lastPart;
            if (part.isPlaceholder()) {
                result.add(part);
                continue;
            }
            JsMessage.Part part2 = lastPart = result.isEmpty() ? null : (JsMessage.Part)Iterables.getLast(result);
            if (lastPart == null || lastPart.isPlaceholder()) {
                result.add(part);
                continue;
            }
            result.set(result.size() - 1, JsMessage.StringPart.create(lastPart.getString() + part.getString()));
        }
        return result;
    }

    static boolean isStartOfIcuMessage(String part) {
        if (!part.startsWith("{")) {
            return false;
        }
        int commaIndex = part.indexOf(44, 1);
        if (commaIndex <= 1) {
            return false;
        }
        int nextBracketIndex = part.indexOf(123, 1);
        return !(nextBracketIndex != -1 && nextBracketIndex <= commaIndex || !part.startsWith("plural,", commaIndex + 1) && !part.startsWith("select,", commaIndex + 1));
    }

    public static class ProtectedJsMessage {
        private final JsMessage jsMessage;
        private final Node definitionNode;
        private final @Nullable Node substitutionsNode;
        private final boolean isIcuTemplate;
        private final boolean escapeLessThan;
        private final boolean unescapeHtmlEntities;

        private ProtectedJsMessage(JsMessage jsMessage, Node definitionNode, @Nullable Node substitutionsNode, boolean isIcuTemplate, boolean escapeLessThan, boolean unescapeHtmlEntities) {
            this.jsMessage = jsMessage;
            this.definitionNode = definitionNode;
            this.substitutionsNode = substitutionsNode;
            this.isIcuTemplate = isIcuTemplate;
            this.escapeLessThan = escapeLessThan;
            this.unescapeHtmlEntities = unescapeHtmlEntities;
        }

        public static @Nullable ProtectedJsMessage fromAstNode(Node node, JsMessage.IdGenerator idGenerator) {
            if (!node.isCall()) {
                return null;
            }
            Node calleeNode = (Node)Preconditions.checkNotNull((Object)node.getFirstChild(), (Object)node);
            if (!calleeNode.matchesName("__jscomp_define_msg__")) {
                return null;
            }
            Node propertiesNode = (Node)Preconditions.checkNotNull((Object)calleeNode.getNext(), (Object)calleeNode);
            Node substitutionsNode = propertiesNode.getNext();
            boolean escapeLessThanOption = false;
            boolean unescapeHtmlEntitiesOption = false;
            boolean isIcuTemplate = false;
            JsMessage.Builder jsMessageBuilder = new JsMessage.Builder();
            Preconditions.checkState((boolean)propertiesNode.isObjectLit(), (Object)propertiesNode);
            String msgKey = null;
            String meaning = null;
            block20: for (Node strKey = propertiesNode.getFirstChild(); strKey != null; strKey = strKey.getNext()) {
                Preconditions.checkState((boolean)strKey.isStringKey(), (Object)strKey);
                String key = strKey.getString();
                Node valueNode = strKey.getOnlyChild();
                Preconditions.checkState((boolean)valueNode.isStringLit(), (Object)valueNode);
                String value = valueNode.getString();
                switch (key) {
                    case "key": {
                        jsMessageBuilder.setKey(value);
                        msgKey = value;
                        continue block20;
                    }
                    case "meaning": {
                        jsMessageBuilder.setMeaning(value);
                        meaning = value;
                        continue block20;
                    }
                    case "alt_id": {
                        jsMessageBuilder.setAlternateId(value);
                        continue block20;
                    }
                    case "msg_text": {
                        try {
                            jsMessageBuilder.appendParts((List<JsMessage.Part>)JsMessageVisitor.parseJsMessageTextIntoParts(value));
                            continue block20;
                        }
                        catch (JsMessage.PlaceholderFormatException unused) {
                            throw new IllegalStateException(valueNode.getLocation() + ": Placeholder incorrectly formatted: >" + value + "<");
                        }
                    }
                    case "isIcuTemplate": {
                        isIcuTemplate = true;
                        continue block20;
                    }
                    case "escapeLessThan": {
                        escapeLessThanOption = true;
                        continue block20;
                    }
                    case "unescapeHtmlEntities": {
                        unescapeHtmlEntitiesOption = true;
                        continue block20;
                    }
                    default: {
                        throw new IllegalStateException("unknown protected message key: " + strKey);
                    }
                }
            }
            String externalMessageId = JsMessageVisitor.getExternalMessageId(msgKey);
            if (externalMessageId != null) {
                jsMessageBuilder.setIsExternalMsg(true).setId(externalMessageId);
            } else {
                String meaningForIdGeneration;
                String string = meaningForIdGeneration = meaning != null ? meaning : JsMessageVisitor.removeScopedAliasesPrefix(msgKey);
                if (idGenerator != null) {
                    jsMessageBuilder.setId(idGenerator.generateId(meaningForIdGeneration, jsMessageBuilder.getParts()));
                } else {
                    jsMessageBuilder.setId(meaningForIdGeneration);
                }
            }
            return new ProtectedJsMessage(jsMessageBuilder.build(), node, substitutionsNode, isIcuTemplate, escapeLessThanOption, unescapeHtmlEntitiesOption);
        }

        MsgOptions getMsgOptions() {
            return new MsgOptions(){

                @Override
                public boolean isIcuTemplate() {
                    return isIcuTemplate;
                }

                @Override
                public boolean escapeLessThan() {
                    return escapeLessThan;
                }

                @Override
                public boolean unescapeHtmlEntities() {
                    return unescapeHtmlEntities;
                }
            };
        }
    }

    static interface MsgOptions {
        public boolean isIcuTemplate();

        public boolean escapeLessThan();

        public boolean unescapeHtmlEntities();
    }

    class FullReplacementPass
    extends JsMessageVisitor {
        public FullReplacementPass() {
            super(ReplaceMessages.this.compiler, ReplaceMessages.this.bundle.idGenerator());
        }

        @Override
        void processMessageFallback(Node callNode, JsMessage message1, JsMessage message2) {
            boolean isFirstMessageTranslated = ReplaceMessages.this.lookupMessage(callNode, ReplaceMessages.this.bundle, message1) != null;
            boolean isSecondMessageTranslated = ReplaceMessages.this.lookupMessage(callNode, ReplaceMessages.this.bundle, message2) != null;
            Node replacementNode = isSecondMessageTranslated && !isFirstMessageTranslated ? callNode.getChildAtIndex(2) : callNode.getSecondChild();
            callNode.replaceWith(replacementNode.detach());
            Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(replacementNode);
            if (changeScope != null) {
                this.compiler.reportChangeToChangeScope(changeScope);
            }
        }

        @Override
        protected void processIcuTemplateDefinition(final IcuTemplateDefinition definition) {
            this.processFullReplacement(new FullReplacementMsgData(){

                @Override
                public JsMessage getMessage() {
                    return definition.getMessage();
                }

                @Override
                public Node getMessageNode() {
                    return definition.getMessageNode();
                }

                @Override
                public MsgOptions getMessageOptions() {
                    return ICU_MSG_OPTIONS;
                }

                @Override
                public ImmutableMap<String, Node> getPlaceholderValueMap() {
                    return ImmutableMap.of();
                }
            });
        }

        @Override
        protected void processJsMessageDefinition(final JsMessageDefinition definition) {
            this.processFullReplacement(new FullReplacementMsgData(){

                @Override
                public JsMessage getMessage() {
                    return definition.getMessage();
                }

                @Override
                public Node getMessageNode() {
                    return definition.getMessageNode();
                }

                @Override
                public MsgOptions getMessageOptions() {
                    return ReplaceMessages.this.getMsgOptionsFromDefinition(definition);
                }

                @Override
                public ImmutableMap<String, Node> getPlaceholderValueMap() {
                    return definition.getPlaceholderValueMap();
                }
            });
        }

        private void processFullReplacement(FullReplacementMsgData fullReplacementMsgData) {
            Node newValue;
            JsMessage message = fullReplacementMsgData.getMessage();
            Node msgNode = fullReplacementMsgData.getMessageNode();
            MsgOptions options = fullReplacementMsgData.getMessageOptions();
            ImmutableMap<String, Node> placeholderValueMap = fullReplacementMsgData.getPlaceholderValueMap();
            JsMessage replacement = ReplaceMessages.this.lookupMessage(msgNode, ReplaceMessages.this.bundle, message);
            if (replacement == null) {
                if (ReplaceMessages.this.strictReplacement) {
                    this.compiler.report(JSError.make(msgNode, BUNDLE_DOES_NOT_HAVE_THE_MESSAGE, message.getId()));
                    return;
                }
                replacement = message;
            }
            try {
                newValue = ReplaceMessages.this.constructStringExprNode(replacement, (Map<String, Node>)placeholderValueMap, options, msgNode);
            }
            catch (JsMessageVisitor.MalformedException e) {
                this.compiler.report(JSError.make(e.getNode(), MESSAGE_TREE_MALFORMED, e.getMessage()));
                newValue = msgNode;
            }
            if (newValue != msgNode) {
                newValue.srcrefTreeIfMissing(msgNode);
                msgNode.replaceWith(newValue);
                this.compiler.reportChangeToEnclosingScope(newValue);
            }
        }
    }

    static interface FullReplacementMsgData {
        public JsMessage getMessage();

        public Node getMessageNode();

        public MsgOptions getMessageOptions();

        public ImmutableMap<String, Node> getPlaceholderValueMap();
    }

    private static class ProtectedMsgFallback {
        final Node callNode;
        final String firstMsgKey;
        final Node firstMsgValue;
        final String secondMsgKey;
        final Node secondMsgValue;

        ProtectedMsgFallback(Node callNode, String firstMsgKey, Node firstMsgValue, String secondMsgKey, Node secondMsgValue) {
            this.callNode = callNode;
            this.firstMsgKey = firstMsgKey;
            this.firstMsgValue = firstMsgValue;
            this.secondMsgKey = secondMsgKey;
            this.secondMsgValue = secondMsgValue;
        }

        static @Nullable ProtectedMsgFallback fromAstNode(Node n) {
            if (!n.isCall()) {
                return null;
            }
            Node callee = n.getFirstChild();
            if (!callee.matchesName("__jscomp_msg_fallback__")) {
                return null;
            }
            Preconditions.checkState((boolean)n.hasXChildren(5), (String)"bad message fallback call: %s", (Object)n);
            Node firstMsgKeyNode = callee.getNext();
            String firstMsgKey = firstMsgKeyNode.getString();
            Node firstMsgValue = firstMsgKeyNode.getNext();
            Node secondMsgKeyNode = firstMsgValue.getNext();
            String secondMsgKey = secondMsgKeyNode.getString();
            Node secondMsgValue = secondMsgKeyNode.getNext();
            return new ProtectedMsgFallback(n, firstMsgKey, firstMsgValue, secondMsgKey, secondMsgValue);
        }
    }

    class ReplacementCompletionPass
    implements CompilerPass {
        final Set<String> translatedMsgKeys = new HashSet<String>();

        ReplacementCompletionPass() {
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverse(ReplaceMessages.this.compiler, root, new NodeTraversal.AbstractPostOrderCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    ProtectedJsMessage protectedJsMessage = ProtectedJsMessage.fromAstNode(n, ReplaceMessages.this.bundle.idGenerator());
                    if (protectedJsMessage != null) {
                        ReplacementCompletionPass.this.visitMsgDefinition(protectedJsMessage);
                    } else {
                        ProtectedMsgFallback protectedMsgFallback = ProtectedMsgFallback.fromAstNode(n);
                        if (protectedMsgFallback != null) {
                            ReplacementCompletionPass.this.visitMsgFallback(protectedMsgFallback);
                        }
                    }
                }
            });
        }

        void visitMsgDefinition(ProtectedJsMessage protectedJsMessage) {
            try {
                JsMessage msgToUse;
                JsMessage originalMsg = protectedJsMessage.jsMessage;
                Node nodeToReplace = protectedJsMessage.definitionNode;
                JsMessage translatedMsg = ReplaceMessages.this.lookupMessage(protectedJsMessage.definitionNode, ReplaceMessages.this.bundle, originalMsg);
                if (translatedMsg != null) {
                    msgToUse = translatedMsg;
                    this.translatedMsgKeys.add(originalMsg.getKey());
                } else {
                    if (ReplaceMessages.this.strictReplacement) {
                        ReplaceMessages.this.compiler.report(JSError.make(nodeToReplace, BUNDLE_DOES_NOT_HAVE_THE_MESSAGE, originalMsg.getId()));
                    }
                    msgToUse = originalMsg;
                }
                MsgOptions msgOptions = protectedJsMessage.getMsgOptions();
                ImmutableMap<String, Node> placeholderMap = ReplaceMessages.extractPlaceholderValuesMapOrThrow(protectedJsMessage.substitutionsNode);
                Node finalMsgConstructionExpression = ReplaceMessages.this.constructStringExprNode(msgToUse, (Map<String, Node>)placeholderMap, msgOptions, nodeToReplace);
                finalMsgConstructionExpression.srcrefTreeIfMissing(nodeToReplace);
                nodeToReplace.replaceWith(finalMsgConstructionExpression);
                ReplaceMessages.this.compiler.reportChangeToEnclosingScope(finalMsgConstructionExpression);
            }
            catch (JsMessageVisitor.MalformedException e) {
                ReplaceMessages.this.compiler.report(JSError.make(e.getNode(), JsMessageVisitor.MESSAGE_TREE_MALFORMED, e.getMessage()));
            }
        }

        private void visitMsgFallback(ProtectedMsgFallback protectedMsgFallback) {
            Node valueNodeToUse = this.translatedMsgKeys.contains(protectedMsgFallback.firstMsgKey) ? protectedMsgFallback.firstMsgValue : (this.translatedMsgKeys.contains(protectedMsgFallback.secondMsgKey) ? protectedMsgFallback.secondMsgValue : protectedMsgFallback.firstMsgValue);
            valueNodeToUse.detach();
            protectedMsgFallback.callNode.replaceWith(valueNodeToUse);
            ReplaceMessages.this.compiler.reportChangeToEnclosingScope(valueNodeToUse);
        }
    }

    private final class QuotedKeyObjectLitBuilder {
        private final LinkedHashMap<String, Node> keyToValueNodeMap = new LinkedHashMap();

        private QuotedKeyObjectLitBuilder() {
        }

        private QuotedKeyObjectLitBuilder addString(String key, String value) {
            return this.addNode(key, ReplaceMessages.this.astFactory.createString(value));
        }

        @CanIgnoreReturnValue
        private QuotedKeyObjectLitBuilder addNode(String key, Node node) {
            Preconditions.checkState((!this.keyToValueNodeMap.containsKey(key) ? 1 : 0) != 0, (String)"repeated key: %s", (Object)key);
            this.keyToValueNodeMap.put(key, node);
            return this;
        }

        private Node build() {
            Node result = ReplaceMessages.this.astFactory.createObjectLit(new Node[0]);
            for (Map.Entry<String, Node> entry : this.keyToValueNodeMap.entrySet()) {
                result.addChildToBack(ReplaceMessages.this.astFactory.createQuotedStringKey(entry.getKey(), entry.getValue()));
            }
            return result;
        }
    }

    class MsgProtectionPass
    extends JsMessageVisitor {
        public MsgProtectionPass() {
            super(ReplaceMessages.this.compiler, ReplaceMessages.this.bundle.idGenerator());
        }

        @Override
        public void process(Node externs, Node root) {
            NodeUtil.createSynthesizedExternsSymbol(this.compiler, "__jscomp_define_msg__");
            NodeUtil.createSynthesizedExternsSymbol(this.compiler, "__jscomp_msg_fallback__");
            super.process(externs, root);
        }

        @Override
        protected void processIcuTemplateDefinition(final IcuTemplateDefinition definition) {
            this.performMessageProtection(new MsgProtectionData(){

                @Override
                public JsMessage getMessage() {
                    return definition.getMessage();
                }

                @Override
                public Node getMessageNode() {
                    return definition.getMessageNode();
                }

                @Override
                public Node getTemplateTextNode() {
                    return definition.getTemplateTextNode();
                }

                @Override
                public @Nullable Node getPlaceholderValuesNode() {
                    return null;
                }

                @Override
                public MsgOptions getMessageOptions() {
                    return ICU_MSG_OPTIONS;
                }
            });
        }

        @Override
        protected void processJsMessageDefinition(final JsMessageDefinition definition) {
            this.performMessageProtection(new MsgProtectionData(){

                @Override
                public JsMessage getMessage() {
                    return definition.getMessage();
                }

                @Override
                public Node getMessageNode() {
                    return definition.getMessageNode();
                }

                @Override
                public Node getTemplateTextNode() {
                    return definition.getTemplateTextNode();
                }

                @Override
                public @Nullable Node getPlaceholderValuesNode() {
                    return definition.getPlaceholderValuesNode();
                }

                @Override
                public MsgOptions getMessageOptions() {
                    return ReplaceMessages.this.getMsgOptionsFromDefinition(definition);
                }
            });
        }

        private void performMessageProtection(MsgProtectionData msgProtectionData) {
            JsMessage message = msgProtectionData.getMessage();
            Node callNode = msgProtectionData.getMessageNode();
            Node originalMessageString = msgProtectionData.getTemplateTextNode();
            Node placeholdersNode = msgProtectionData.getPlaceholderValuesNode();
            MsgOptions msgOptions = msgProtectionData.getMessageOptions();
            Preconditions.checkState((boolean)callNode.isCall(), (Object)callNode);
            Node googGetMsg = callNode.getFirstChild();
            String protectionFunctionName = "__jscomp_define_msg__";
            Node newCallee = this.createProtectionFunctionCallee("__jscomp_define_msg__").srcref(googGetMsg);
            Node msgPropertiesNode = ReplaceMessages.this.createMsgPropertiesNode(message, msgOptions).srcrefTree(originalMessageString);
            Node newCallNode = ReplaceMessages.this.astFactory.createCall(newCallee, AstFactory.type(callNode), msgPropertiesNode).srcref(callNode);
            newCallNode.setSideEffectFlags(0);
            if (placeholdersNode != null) {
                Preconditions.checkState((boolean)placeholdersNode.isObjectLit(), (Object)placeholdersNode);
                for (Node strKey = placeholdersNode.getFirstChild(); strKey != null; strKey = strKey.getNext()) {
                    Preconditions.checkState((boolean)strKey.isStringKey(), (Object)strKey);
                    strKey.setQuotedStringKey();
                }
                newCallNode.addChildToBack(placeholdersNode.detach());
            }
            callNode.replaceWith(newCallNode);
            this.compiler.reportChangeToEnclosingScope(newCallNode);
        }

        private Node createProtectionFunctionCallee(String protectionFunctionName) {
            Node callee = ReplaceMessages.this.astFactory.createNameWithUnknownType(protectionFunctionName);
            callee.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            return callee;
        }

        @Override
        void processMessageFallback(Node callNode, JsMessage message1, JsMessage message2) {
            Node originalCallee = (Node)Preconditions.checkNotNull((Object)callNode.getFirstChild(), (Object)callNode);
            Node fallbackCallee = this.createProtectionFunctionCallee("__jscomp_msg_fallback__").srcref(originalCallee);
            Node originalFirstArg = (Node)Preconditions.checkNotNull((Object)originalCallee.getNext(), (Object)callNode);
            Node firstMsgKey = ReplaceMessages.this.astFactory.createString(message1.getKey()).srcref(originalFirstArg);
            Node originalSecondArg = (Node)Preconditions.checkNotNull((Object)originalFirstArg.getNext(), (Object)callNode);
            Node secondMsgKey = ReplaceMessages.this.astFactory.createString(message2.getKey()).srcref(originalSecondArg);
            Node newCallNode = ReplaceMessages.this.astFactory.createCall(fallbackCallee, AstFactory.type(callNode), firstMsgKey, originalFirstArg.detach(), secondMsgKey, originalSecondArg.detach()).srcref(callNode);
            newCallNode.setSideEffectFlags(0);
            callNode.replaceWith(newCallNode);
            this.compiler.reportChangeToEnclosingScope(newCallNode);
        }
    }

    static interface MsgProtectionData {
        public JsMessage getMessage();

        public Node getMessageNode();

        public Node getTemplateTextNode();

        public @Nullable Node getPlaceholderValuesNode();

        public MsgOptions getMessageOptions();
    }
}

