/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

class ReplaceCssNames
implements CompilerPass {
    static final Node GET_CSS_NAME_FUNCTION = IR.getprop(IR.name("goog"), "getCssName");
    static final DiagnosticType INVALID_NUM_ARGUMENTS_ERROR = DiagnosticType.error("JSC_GETCSSNAME_NUM_ARGS", "goog.getCssName called with \"{0}\" arguments, expected 1 or 2.");
    static final DiagnosticType STRING_LITERAL_EXPECTED_ERROR = DiagnosticType.error("JSC_GETCSSNAME_STRING_LITERAL_EXPECTED", "goog.getCssName called with invalid argument, string literal expected.  Was \"{0}\".");
    static final DiagnosticType UNEXPECTED_STRING_LITERAL_ERROR = DiagnosticType.error("JSC_GETCSSNAME_UNEXPECTED_STRING_LITERAL", "goog.getCssName called with invalid arguments, string literal passed as first of two arguments.  Did you mean goog.getCssName(\"{0}-{1}\")?");
    static final DiagnosticType NESTED_CALL_ERROR = DiagnosticType.error("JSC_GETCSSNAME_NESTED_CALL", "goog.getCssName: nested call is not allowed.");
    static final DiagnosticType UNKNOWN_SYMBOL_WARNING = DiagnosticType.warning("JSC_GETCSSNAME_UNKNOWN_CSS_SYMBOL", "goog.getCssName called with unrecognized symbol \"{0}\" in class \"{1}\".");
    static final DiagnosticType UNEXPECTED_SASS_GENERATED_CSS_TS_ERROR = DiagnosticType.error("JSC_UNEXPECTED_SASS_GENERATED_CSS_TS", "@sass_generated_css_ts JSDoc annotation is only allowed on .css.closure.js files.");
    static final DiagnosticType UNKNOWN_SYMBOL_ERROR = DiagnosticType.error("JSC_UNKNOWN_CSS_SYMBOL_IN_CLASSES_OBJECT", "Symbol was not defined \"{0}\" in classes object.");
    static final DiagnosticType INVALID_USE_OF_CLASSES_OBJECT_ERROR = DiagnosticType.error("JSC_INVALID_USE_OF_CLASSES_OBJECT", "invalid use of generated classes object. Only accessing its members is allowed.");
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final CssNameCollector cssNameCollector;
    private final Map<String, String> cssNamesBySymbol;
    private final Set<String> classesObjectsQualifiedNames;
    private @Nullable CssRenamingMap symbolMap;
    private final Set<String> skiplist;
    private static final Node GOOG_SET_CSS_NAME_MAPPING = IR.getprop(IR.name("goog"), "setCssNameMapping");

    ReplaceCssNames(AbstractCompiler compiler, @Nullable CssRenamingMap symbolMap, CssNameCollector cssNameCollector, @Nullable Set<String> skiplist) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.symbolMap = symbolMap;
        this.cssNameCollector = cssNameCollector;
        this.skiplist = skiplist;
        this.cssNamesBySymbol = new LinkedHashMap<String, String>();
        this.classesObjectsQualifiedNames = new LinkedHashSet<String>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new FindSetCssNameTraversal());
        List<GetCssNameInstance> getCssNameInstances = this.gatherGetCssNameInstances(root);
        for (GetCssNameInstance getCssNameInstance : getCssNameInstances) {
            String cssClassName = getCssNameInstance.getCssClassName();
            if (getCssNameInstance.isCssClosureFileClassesMember()) {
                this.cssNamesBySymbol.put(getCssNameInstance.getCssClosureClassesMemberName(), cssClassName);
                this.classesObjectsQualifiedNames.add(getCssNameInstance.getCssClosureClassesQualifiedName());
            } else {
                this.cssNameCollector.add(cssClassName);
            }
            getCssNameInstance.replaceWithExpression();
        }
        NodeTraversal.traverse(this.compiler, root, new CountCssNamesBySymbol());
    }

    private List<GetCssNameInstance> gatherGetCssNameInstances(Node root) {
        GatherCssNamesTraversal gatherCssNamesTraversal = new GatherCssNamesTraversal();
        NodeTraversal.traverse(this.compiler, root, gatherCssNamesTraversal);
        return gatherCssNamesTraversal.listOfCssNameInstances;
    }

    private boolean isNotInCssClosureFile(Node node) {
        String sourceFileName = node.getSourceFileName();
        return sourceFileName == null || !sourceFileName.endsWith(".css.closure.js");
    }

    private boolean isGetCssNameCall(Node node) {
        return node.isCall() && node.getFirstChild().matchesQualifiedName(GET_CSS_NAME_FUNCTION);
    }

    private GetCssNameInstance createGetCssNameInstance(Node n, String cssClosureClassesQualifiedName) {
        JSError validationError = this.validateGetCssNameCall(n);
        return new GetCssNameInstance(n, validationError, cssClosureClassesQualifiedName);
    }

    private @Nullable JSError validateGetCssNameCall(Node callNode) {
        int childCount = callNode.getChildCount();
        switch (childCount) {
            case 2: {
                return this.validateSingleArgGetCssNameCall(callNode);
            }
            case 3: {
                return this.validateTwoArgGetCssNameCall(callNode);
            }
        }
        return JSError.make(callNode, INVALID_NUM_ARGUMENTS_ERROR, String.valueOf(childCount));
    }

    private @Nullable JSError validateSingleArgGetCssNameCall(Node callNode) {
        Node stringLiteralArg = (Node)Preconditions.checkNotNull((Object)callNode.getLastChild());
        if (!stringLiteralArg.isStringLit()) {
            return JSError.make(callNode, STRING_LITERAL_EXPECTED_ERROR, stringLiteralArg.getToken().toString());
        }
        return null;
    }

    private @Nullable JSError validateTwoArgGetCssNameCall(Node callNode) {
        Node firstArg = (Node)Preconditions.checkNotNull((Object)callNode.getSecondChild());
        Node secondArg = (Node)Preconditions.checkNotNull((Object)firstArg.getNext());
        if (!secondArg.isStringLit()) {
            return JSError.make(callNode, STRING_LITERAL_EXPECTED_ERROR, secondArg.getToken().toString());
        }
        if (firstArg.isStringLit()) {
            return JSError.make(callNode, UNEXPECTED_STRING_LITERAL_ERROR, firstArg.getString(), secondArg.getString());
        }
        if (this.isGetCssNameCall(firstArg)) {
            return JSError.make(firstArg, NESTED_CALL_ERROR, new String[0]);
        }
        return null;
    }

    private void processStringNode(Node n) {
        String name = n.getString();
        if (this.skiplist != null && this.skiplist.contains(name)) {
            return;
        }
        String[] parts = name.split("-");
        if (this.symbolMap != null) {
            String replacement = null;
            switch (this.symbolMap.getStyle()) {
                case BY_WHOLE: {
                    replacement = this.symbolMap.get(name);
                    if (replacement != null) break;
                    this.compiler.report(JSError.make(n, UNKNOWN_SYMBOL_WARNING, name, name));
                    return;
                }
                case BY_PART: {
                    Object[] replaced = new String[parts.length];
                    for (int i = 0; i < parts.length; ++i) {
                        String part = this.symbolMap.get(parts[i]);
                        if (part == null) {
                            this.compiler.report(JSError.make(n, UNKNOWN_SYMBOL_WARNING, parts[i], name));
                            return;
                        }
                        replaced[i] = part;
                    }
                    replacement = Joiner.on((String)"-").join(replaced);
                }
            }
            n.setString(replacement);
        }
    }

    private class CountCssNamesBySymbol
    implements NodeTraversal.Callback {
        private CountCssNamesBySymbol() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isScript()) {
                return ReplaceCssNames.this.isNotInCssClosureFile(n);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            String classesObjectQualifiedName = n.getQualifiedName();
            if (classesObjectQualifiedName == null || !ReplaceCssNames.this.classesObjectsQualifiedNames.contains(classesObjectQualifiedName)) {
                return;
            }
            Node classNameNode = n.getParent();
            if (!n.isGetProp() || !classNameNode.isGetProp()) {
                ReplaceCssNames.this.compiler.report(JSError.make(n, INVALID_USE_OF_CLASSES_OBJECT_ERROR, new String[0]));
                return;
            }
            String classQualifiedName = classNameNode.getQualifiedName();
            if (classQualifiedName == null || !ReplaceCssNames.this.cssNamesBySymbol.containsKey(classQualifiedName)) {
                ReplaceCssNames.this.compiler.report(JSError.make(n, UNKNOWN_SYMBOL_ERROR, classNameNode.getString()));
                return;
            }
            String className = ReplaceCssNames.this.cssNamesBySymbol.get(classQualifiedName);
            ReplaceCssNames.this.cssNameCollector.add(className);
        }
    }

    private class GetCssNameInstance {
        final Node callNode;
        final JSError validationError;
        final String cssClosureClassesQualifiedName;

        GetCssNameInstance(Node callNode, JSError validationError, String cssClosureClassesQualifiedName) {
            this.callNode = callNode;
            this.validationError = validationError;
            this.cssClosureClassesQualifiedName = cssClosureClassesQualifiedName;
        }

        boolean isValid() {
            return this.validationError == null;
        }

        JSError getValidationError() {
            Preconditions.checkNotNull((Object)this.validationError, (String)"No validation error found: %s", (Object)this.callNode);
            return this.validationError;
        }

        void replaceWithExpression() {
            Preconditions.checkState((boolean)this.isValid(), (String)"not a valid goog.getCssName() call: %s", (Object)this.callNode);
            Preconditions.checkNotNull((Object)this.callNode.getParent(), (String)"already replaced: %s", (Object)this.callNode);
            int childCount = this.callNode.getChildCount();
            switch (childCount) {
                case 2: {
                    this.replaceWithConvertedSingleArg();
                    break;
                }
                case 3: {
                    this.replaceWithConcatenatedArgs();
                    break;
                }
                default: {
                    throw new IllegalStateException(SimpleFormat.format("invalid number of children: %s for: %s", childCount, this.callNode));
                }
            }
        }

        private void replaceWithConvertedSingleArg() {
            Node stringLitArg = (Node)Preconditions.checkNotNull((Object)this.callNode.getSecondChild(), (Object)this.callNode);
            Preconditions.checkState((boolean)stringLitArg.isStringLit(), (String)"not a string literal: %s", (Object)stringLitArg);
            stringLitArg.detach();
            ReplaceCssNames.this.processStringNode(stringLitArg);
            this.callNode.replaceWith(stringLitArg);
            ReplaceCssNames.this.compiler.reportChangeToEnclosingScope(stringLitArg);
        }

        private void replaceWithConcatenatedArgs() {
            Node firstArg = (Node)Preconditions.checkNotNull((Object)this.callNode.getSecondChild(), (Object)this.callNode);
            Node secondArg = (Node)Preconditions.checkNotNull((Object)firstArg.getNext(), (Object)firstArg);
            firstArg.detach();
            secondArg.detach();
            ReplaceCssNames.this.processStringNode(secondArg);
            secondArg.setString("-" + secondArg.getString());
            Node replacement = ReplaceCssNames.this.astFactory.createAdd(firstArg, secondArg).srcref(this.callNode);
            this.callNode.replaceWith(replacement);
            ReplaceCssNames.this.compiler.reportChangeToEnclosingScope(replacement);
        }

        boolean isCssClosureFileClassesMember() {
            return this.cssClosureClassesQualifiedName != null;
        }

        @Nullable String getCssClosureClassesQualifiedName() {
            Preconditions.checkNotNull((Object)this.cssClosureClassesQualifiedName, (String)"Not a css closure file classes object: %s", (Object)this.callNode);
            return this.cssClosureClassesQualifiedName;
        }

        @Nullable String getCssClosureClassesMemberName() {
            Preconditions.checkNotNull((Object)this.cssClosureClassesQualifiedName, (String)"Not a css closure file classes object: %s", (Object)this.callNode);
            String memberName = this.callNode.getParent().getString();
            return this.cssClosureClassesQualifiedName + "." + memberName;
        }

        @Nullable String getCssClassName() {
            Preconditions.checkState((boolean)this.isValid(), (String)"not a valid goog.getCssName() call: %s", (Object)this.callNode);
            Preconditions.checkNotNull((Object)this.callNode.getParent(), (String)"already replaced: %s", (Object)this.callNode);
            int childCount = this.callNode.getChildCount();
            Node firstArg = (Node)Preconditions.checkNotNull((Object)this.callNode.getSecondChild(), (Object)this.callNode);
            switch (childCount) {
                case 2: {
                    Preconditions.checkState((boolean)firstArg.isStringLit(), (String)"not a string literal: %s", (Object)firstArg);
                    return firstArg.getString();
                }
                case 3: {
                    Node secondArg = (Node)Preconditions.checkNotNull((Object)firstArg.getNext(), (Object)firstArg);
                    Preconditions.checkState((boolean)secondArg.isStringLit(), (String)"not a string literal: %s", (Object)secondArg);
                    return secondArg.getString();
                }
            }
            throw new IllegalStateException(SimpleFormat.format("invalid number of children: %s for: %s", childCount, this.callNode));
        }
    }

    private class GatherCssNamesTraversal
    implements NodeTraversal.Callback {
        final List<GetCssNameInstance> listOfCssNameInstances = new ArrayList<GetCssNameInstance>();
        final TraversalState traversalState = new TraversalState();

        private GatherCssNamesTraversal() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            SassGeneratedCssTsExpert sassGeneratedCssTsExpert = this.createSassGeneratedCssTsExpert(n);
            if (sassGeneratedCssTsExpert.sassGeneratedCssTsValidationError != null) {
                ReplaceCssNames.this.compiler.report(sassGeneratedCssTsExpert.sassGeneratedCssTsValidationError);
                return false;
            }
            if (n.isScript()) {
                this.traversalState.inSassGeneratedCssTsScript = sassGeneratedCssTsExpert.hasSassGeneratedCssTsJsDoc;
                this.traversalState.cssClosureClassesQualifiedName = null;
            } else if (this.traversalState.inSassGeneratedCssTsScript && sassGeneratedCssTsExpert.isCssClosureClassesAssignment) {
                this.traversalState.cssClosureClassesQualifiedName = sassGeneratedCssTsExpert.cssClosureClassesQualifiedName;
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (ReplaceCssNames.this.isGetCssNameCall(n)) {
                GetCssNameInstance getCssNameInstance = ReplaceCssNames.this.createGetCssNameInstance(n, this.traversalState.cssClosureClassesQualifiedName);
                if (getCssNameInstance.isValid()) {
                    this.listOfCssNameInstances.add(getCssNameInstance);
                } else {
                    ReplaceCssNames.this.compiler.report(getCssNameInstance.getValidationError());
                }
            }
        }

        public SassGeneratedCssTsExpert createSassGeneratedCssTsExpert(Node n) {
            boolean isInvalidSassGeneratedCssTsJsDoc;
            boolean hasSassGeneratedCssTsJsDoc = n.getJSDocInfo() != null && n.getJSDocInfo().isSassGeneratedCssTs();
            JSError sassGeneratedCssTsValidationError = null;
            boolean bl = isInvalidSassGeneratedCssTsJsDoc = !n.isScript() || ReplaceCssNames.this.isNotInCssClosureFile(n);
            if (hasSassGeneratedCssTsJsDoc && isInvalidSassGeneratedCssTsJsDoc) {
                sassGeneratedCssTsValidationError = JSError.make(n, UNEXPECTED_SASS_GENERATED_CSS_TS_ERROR, new String[0]);
            }
            Node assignmentTarget = n.getFirstChild();
            boolean isCssClosureClassesAssignment = n.isAssign() && assignmentTarget.isGetProp() && assignmentTarget.getString().equals("classes");
            String cssClosureClassesQualifiedName = null;
            if (isCssClosureClassesAssignment) {
                cssClosureClassesQualifiedName = assignmentTarget.getQualifiedName();
            }
            return new SassGeneratedCssTsExpert(hasSassGeneratedCssTsJsDoc, sassGeneratedCssTsValidationError, isCssClosureClassesAssignment, cssClosureClassesQualifiedName);
        }

        private class TraversalState {
            public boolean inSassGeneratedCssTsScript;
            public String cssClosureClassesQualifiedName;

            private TraversalState() {
            }
        }

        private class SassGeneratedCssTsExpert {
            public final boolean hasSassGeneratedCssTsJsDoc;
            public final JSError sassGeneratedCssTsValidationError;
            public final boolean isCssClosureClassesAssignment;
            public final String cssClosureClassesQualifiedName;

            public SassGeneratedCssTsExpert(boolean hasSassGeneratedCssTsJsDoc, JSError sassGeneratedCssTsValidationError, boolean isCssClosureClassesAssignment, String cssClosureClassesQualifiedName) {
                this.hasSassGeneratedCssTsJsDoc = hasSassGeneratedCssTsJsDoc;
                this.sassGeneratedCssTsValidationError = sassGeneratedCssTsValidationError;
                this.isCssClosureClassesAssignment = isCssClosureClassesAssignment;
                this.cssClosureClassesQualifiedName = cssClosureClassesQualifiedName;
            }
        }
    }

    private class FindSetCssNameTraversal
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindSetCssNameTraversal() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            CssRenamingMap cssRenamingMap;
            if (!n.isCall() || !parent.isExprResult()) {
                return;
            }
            Node callee = n.getFirstChild();
            if (!callee.matchesQualifiedName(GOOG_SET_CSS_NAME_MAPPING)) {
                return;
            }
            ReplaceCssNames.this.symbolMap = cssRenamingMap = ProcessClosurePrimitives.processSetCssNameMapping(ReplaceCssNames.this.compiler, n, parent);
            ReplaceCssNames.this.compiler.reportChangeToEnclosingScope(parent);
            parent.detach();
        }
    }

    @FunctionalInterface
    public static interface CssNameCollector {
        public void add(String var1);
    }
}

