/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;

final class RenameLabels
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Supplier<String> nameSupplier;
    private final boolean removeUnused;
    private final boolean markChanges;

    RenameLabels(AbstractCompiler compiler) {
        this(compiler, new DefaultNameSupplier(), true, true);
    }

    RenameLabels(AbstractCompiler compiler, Supplier<String> supplier, boolean removeUnused, boolean markChanges) {
        this.compiler = compiler;
        this.nameSupplier = supplier;
        this.removeUnused = removeUnused;
        this.markChanges = markChanges;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new ProcessLabels(this.markChanges));
    }

    private static class LabelNamespace {
        final Map<String, LabelInfo> renameMap = new LinkedHashMap<String, LabelInfo>();

        private LabelNamespace() {
        }
    }

    private static class LabelInfo {
        boolean referenced = false;
        final int id;

        LabelInfo(int id) {
            this.id = id;
        }
    }

    class ProcessLabels
    implements NodeTraversal.ScopedCallback {
        private final boolean markChanges;
        final Deque<LabelNamespace> namespaceStack = new ArrayDeque<LabelNamespace>();
        final ArrayList<String> names = new ArrayList();

        ProcessLabels(boolean markChanges) {
            this.markChanges = markChanges;
            this.namespaceStack.push(new LabelNamespace());
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            if (nodeTraversal.getScopeRoot().isFunction()) {
                this.namespaceStack.push(new LabelNamespace());
            }
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
            if (nodeTraversal.getScopeRoot().isFunction()) {
                this.namespaceStack.pop();
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node parent) {
            if (node.isLabel()) {
                LabelNamespace current = this.namespaceStack.peek();
                int currentDepth = current.renameMap.size() + 1;
                String name = node.getFirstChild().getString();
                LabelInfo li = new LabelInfo(currentDepth);
                Preconditions.checkState((!current.renameMap.containsKey(name) ? 1 : 0) != 0);
                current.renameMap.put(name, li);
                if (this.names.size() < currentDepth) {
                    this.names.add(RenameLabels.this.nameSupplier.get());
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            switch (node.getToken()) {
                case LABEL: {
                    this.visitLabel(t, node);
                    break;
                }
                case BREAK: 
                case CONTINUE: {
                    this.visitBreakOrContinue(t, node);
                    break;
                }
            }
        }

        private void visitBreakOrContinue(NodeTraversal t, Node node) {
            Node nameNode = node.getFirstChild();
            if (nameNode != null) {
                String name = nameNode.getString();
                Preconditions.checkState((!name.isEmpty() ? 1 : 0) != 0);
                LabelInfo li = this.getLabelInfo(name);
                if (li != null) {
                    String newName = this.getNameForId(li.id);
                    li.referenced = true;
                    if (!name.equals(newName)) {
                        nameNode.setString(newName);
                        if (this.markChanges) {
                            t.reportCodeChange();
                        }
                    }
                }
            }
        }

        private void visitLabel(NodeTraversal t, Node node) {
            Node nameNode = node.getFirstChild();
            Preconditions.checkState((nameNode != null ? 1 : 0) != 0);
            String name = nameNode.getString();
            LabelInfo li = this.getLabelInfo(name);
            if (li.referenced || !RenameLabels.this.removeUnused) {
                String newName = this.getNameForId(li.id);
                if (!name.equals(newName)) {
                    nameNode.setString(newName);
                    if (this.markChanges) {
                        t.reportCodeChange();
                    }
                }
            } else {
                Node newChild = node.getLastChild();
                newChild.detach();
                node.replaceWith(newChild);
                if (newChild.isBlock()) {
                    NodeUtil.tryMergeBlock(newChild, false);
                }
                if (this.markChanges) {
                    t.reportCodeChange();
                }
            }
            this.namespaceStack.peek().renameMap.remove(name);
        }

        String getNameForId(int id) {
            return this.names.get(id - 1);
        }

        LabelInfo getLabelInfo(String name) {
            return this.namespaceStack.peek().renameMap.get(name);
        }
    }

    static class DefaultNameSupplier
    implements Supplier<String> {
        private final NameGenerator nameGenerator = new DefaultNameGenerator(new LinkedHashSet<String>(), "", null);

        private DefaultNameSupplier() {
        }

        @Override
        public String get() {
            return this.nameGenerator.generateNextName();
        }
    }
}

