/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import java.io.Serializable;
import org.jspecify.nullness.Nullable;

public final class Reference
implements StaticRef,
Serializable {
    private static final ImmutableSet<Token> DECLARATION_PARENTS = Sets.immutableEnumSet((Enum)Token.VAR, (Enum[])new Token[]{Token.LET, Token.CONST, Token.PARAM_LIST, Token.FUNCTION, Token.CLASS, Token.CATCH});
    private final Node nameNode;
    private final BasicBlock basicBlock;
    private final Scope scope;
    private final InputId inputId;

    Reference(Node nameNode, NodeTraversal t, BasicBlock basicBlock) {
        this(nameNode, basicBlock, t.getScope(), t.getInput().getInputId());
    }

    private Reference(Node nameNode, @Nullable BasicBlock basicBlock, @Nullable Scope scope, InputId inputId) {
        this.nameNode = nameNode;
        this.basicBlock = basicBlock;
        this.scope = scope;
        this.inputId = inputId;
    }

    public String toString() {
        return this.nameNode.toString();
    }

    @VisibleForTesting
    static Reference createRefForTest(CompilerInput input) {
        return new Reference(new Node(Token.NAME), null, null, input.getInputId());
    }

    Reference cloneWithNewScope(Scope newScope) {
        return new Reference(this.nameNode, this.basicBlock, newScope, this.inputId);
    }

    @Override
    public Var getSymbol() {
        return (Var)this.scope.getVar(this.nameNode.getString());
    }

    @Override
    public Node getNode() {
        return this.nameNode;
    }

    public InputId getInputId() {
        return this.inputId;
    }

    @Override
    public StaticSourceFile getSourceFile() {
        return this.nameNode.getStaticSourceFile();
    }

    boolean isDeclaration() {
        return Reference.isDeclarationHelper(this.nameNode);
    }

    private static boolean isDeclarationHelper(Node node) {
        Node parent = node.getParent();
        if (parent.isClass() && node != parent.getFirstChild()) {
            return false;
        }
        if (parent.getParent() == null) {
            return false;
        }
        if (NodeUtil.isNameDeclaration(parent.getParent()) && node == parent.getSecondChild()) {
            return false;
        }
        if (parent.isDestructuringLhs() || parent.isDestructuringPattern() || parent.isRest() || parent.isStringKey() && parent.getParent().isObjectPattern() || parent.isComputedProp() && parent.getParent().isObjectPattern() && node == parent.getLastChild() || parent.isDefaultValue() && node == parent.getFirstChild()) {
            return Reference.isDeclarationHelper(parent);
        }
        if (parent.isImport()) {
            return true;
        }
        if (parent.isImportSpec() && node == parent.getLastChild()) {
            return true;
        }
        if (parent.isArrowFunction()) {
            return node == parent.getFirstChild();
        }
        return DECLARATION_PARENTS.contains((Object)parent.getToken());
    }

    public boolean isVarDeclaration() {
        return this.getParent().isVar();
    }

    boolean isLetDeclaration() {
        return this.getParent().isLet();
    }

    boolean isDotPropertyAccess() {
        return this.getParent().isGetProp();
    }

    boolean isAssignedToObjectDestructuringPattern() {
        Node parent = this.getParent();
        return (parent.isDestructuringLhs() || parent.isAssign()) && parent.getFirstChild().isObjectPattern();
    }

    public boolean isConstDeclaration() {
        return this.getParent().isConst();
    }

    boolean isHoistedFunction() {
        return NodeUtil.isHoistedFunctionDeclaration(this.getParent());
    }

    public boolean isInitializingDeclaration() {
        return this.isDeclaration() && !this.getParent().isVar() && !this.getParent().isLet() || this.nameNode.hasChildren();
    }

    Node getAssignedValue() {
        return NodeUtil.getRValueOfLValue(this.nameNode);
    }

    BasicBlock getBasicBlock() {
        return this.basicBlock;
    }

    Node getParent() {
        return this.getNode().getParent();
    }

    Node getGrandparent() {
        return this.getNode().getGrandparent();
    }

    private static boolean isLhsOfEnhancedForExpression(Node n) {
        Node parent = n.getParent();
        return NodeUtil.isEnhancedFor(parent) && parent.getFirstChild() == n;
    }

    public boolean isSimpleAssignmentToName() {
        Node parent = this.getParent();
        return parent.isAssign() && parent.getFirstChild() == this.nameNode;
    }

    public boolean isLvalue() {
        Node parent = this.getParent();
        Token parentType = parent.getToken();
        switch (parentType) {
            case VAR: 
            case LET: 
            case CONST: {
                return this.nameNode.hasChildren() || Reference.isLhsOfEnhancedForExpression(this.nameNode);
            }
            case DEFAULT_VALUE: {
                return parent.getFirstChild() == this.nameNode;
            }
            case INC: 
            case DEC: 
            case CATCH: 
            case ITER_REST: 
            case OBJECT_REST: 
            case PARAM_LIST: {
                return true;
            }
            case FOR: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                return NodeUtil.isEnhancedFor(parent) && parent.getFirstChild() == this.nameNode;
            }
            case ARRAY_PATTERN: 
            case STRING_KEY: 
            case COMPUTED_PROP: {
                return NodeUtil.isLhsByDestructuring(this.nameNode);
            }
        }
        return NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == this.nameNode;
    }

    Scope getScope() {
        return this.scope;
    }
}

