/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import org.jspecify.nullness.Nullable;

public class RecoverableJsAst
implements SourceAst {
    private @Nullable Node root = null;
    private final SourceAst realSource;
    private final boolean reportParseErrors;

    public RecoverableJsAst(SourceAst realSource, boolean reportParseErrors) {
        Preconditions.checkNotNull((Object)realSource);
        this.realSource = realSource;
        this.reportParseErrors = reportParseErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Node getAstRoot(AbstractCompiler compiler) {
        if (this.root == null) {
            SourceAst sourceAst = this.realSource;
            synchronized (sourceAst) {
                this.root = this.realSource.getAstRoot(compiler).cloneTree(true);
                JsAst.ParseResult result = (JsAst.ParseResult)this.root.getProp(Node.PARSE_RESULTS);
                if (this.reportParseErrors && result != null) {
                    this.replay(compiler, result);
                }
            }
        }
        return (Node)Preconditions.checkNotNull((Object)this.root);
    }

    private void replay(AbstractCompiler compiler, JsAst.ParseResult result) {
        ErrorReporter reporter = compiler.getDefaultErrorReporter();
        for (JsAst.RhinoError error : result.errors) {
            reporter.error(error.message, error.sourceName, error.line, error.lineOffset);
        }
        for (JsAst.RhinoError warning : result.warnings) {
            reporter.warning(warning.message, warning.sourceName, warning.line, warning.lineOffset);
        }
    }

    @Override
    public void clearAst() {
        this.root = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputId getInputId() {
        SourceAst sourceAst = this.realSource;
        synchronized (sourceAst) {
            return this.realSource.getInputId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceFile getSourceFile() {
        SourceAst sourceAst = this.realSource;
        synchronized (sourceAst) {
            return this.realSource.getSourceFile();
        }
    }
}

