/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

class ProcessClosureProvidesAndRequires
implements CompilerPass {
    static final DiagnosticType TYPEDEF_CHILD_OF_PROVIDE = DiagnosticType.error("JSC_TYPEDEF_CHILD_OF_PROVIDE", "invalid @typedef goog.provide {0}\nParent namespace {1} is goog.provided and initialized in the same file");
    private static final String GOOG = "goog";
    private final AbstractCompiler compiler;
    private final JSChunkGraph chunkGraph;
    private final Map<String, ProvidedName> providedNames = new LinkedHashMap<String, ProvidedName>();
    private final boolean preserveGoogProvidesAndRequires;
    private final List<Node> requiresToBeRemoved = new ArrayList<Node>();
    private boolean hasRewritingOccurred = false;
    private final Set<Node> forwardDeclaresToRemove = new LinkedHashSet<Node>();
    private final AstFactory astFactory;

    ProcessClosureProvidesAndRequires(AbstractCompiler compiler, boolean preserveGoogProvidesAndRequires) {
        this.compiler = compiler;
        this.chunkGraph = compiler.getChunkGraph();
        this.preserveGoogProvidesAndRequires = preserveGoogProvidesAndRequires;
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void process(Node externs, Node root) {
        this.rewriteProvidesAndRequires(externs, root);
    }

    Map<String, ProvidedName> collectProvidedNames(Node externs, Node root) {
        if (this.providedNames.isEmpty()) {
            this.providedNames.put(GOOG, new ProvidedNameBuilder().setNamespace(GOOG).setNode(null).setChunk(null).build());
            NodeTraversal.traverseRoots(this.compiler, new CollectDefinitions(), externs, root);
        }
        return this.providedNames;
    }

    void rewriteProvidesAndRequires(Node externs, Node root) {
        Preconditions.checkState((!this.hasRewritingOccurred ? 1 : 0) != 0, (Object)"Cannot call rewriteProvidesAndRequires twice per instance");
        this.hasRewritingOccurred = true;
        this.collectProvidedNames(externs, root);
        for (ProvidedName pn : this.providedNames.values()) {
            pn.replace(this.preserveGoogProvidesAndRequires, this.providedNames);
        }
        for (Node closureRequire : this.requiresToBeRemoved) {
            this.compiler.reportChangeToEnclosingScope(closureRequire);
            closureRequire.detach();
        }
        for (Node forwardDeclare : this.forwardDeclaresToRemove) {
            NodeUtil.deleteNode(forwardDeclare, this.compiler);
        }
    }

    private boolean isValidPrimitiveCall(NodeTraversal t, Node n) {
        if (this.compiler.getOptions().shouldPreserveGoogModule()) {
            return true;
        }
        return t.inGlobalHoistScope() && n.getParent().isExprResult();
    }

    private void processRequireCall(Node call, Node parent) {
        if (!this.verifyOnlyArgumentIsString(call)) {
            return;
        }
        if (!this.preserveGoogProvidesAndRequires) {
            this.requiresToBeRemoved.add(parent);
        }
    }

    private void processLegacyModuleCall(String namespace, Node googModuleCall, JSChunk chunk) {
        this.registerAnyProvidedPrefixes(namespace, googModuleCall, chunk);
        this.providedNames.put(namespace, new ProvidedNameBuilder().setNamespace(namespace).setNode(googModuleCall).setChunk(chunk).setExplicit(true).setFromLegacyModule(true).build());
    }

    private void processProvideCall(NodeTraversal t, Node call, Node parent) {
        boolean isImplicitlyInitialized;
        Preconditions.checkState((boolean)call.isCall());
        if (!this.verifyOnlyArgumentIsString(call)) {
            return;
        }
        Node left = call.getFirstChild();
        Node arg = left.getNext();
        String ns = arg.getString();
        JSDocInfo info = NodeUtil.getBestJSDocInfo(call);
        boolean bl = isImplicitlyInitialized = info != null && info.isProvideAlreadyProvided();
        if (this.providedNames.containsKey(ns)) {
            ProvidedName previouslyProvided = this.providedNames.get(ns);
            if (!previouslyProvided.isExplicitlyProvided()) {
                previouslyProvided.addProvide(parent, t.getChunk(), true, this.chunkGraph);
            }
        } else {
            this.registerAnyProvidedPrefixes(ns, parent, t.getChunk());
            this.providedNames.put(ns, new ProvidedNameBuilder().setNamespace(ns).setNode(parent).setChunk(t.getChunk()).setExplicit(true).setHasImplicitInitialization(isImplicitlyInitialized).build());
        }
    }

    private void handleStubDefinition(NodeTraversal t, Node exprResult) {
        String name;
        ProvidedName pn;
        boolean isValidTypedefStubDefinition;
        if (!t.inGlobalHoistScope()) {
            return;
        }
        boolean isExternStub = exprResult.isFromExterns();
        boolean isTypedefStub = this.isTypedefStubDeclaration(exprResult);
        boolean bl = isValidTypedefStubDefinition = isTypedefStub && !this.hasRewritingOccurred;
        if ((isValidTypedefStubDefinition || isExternStub) && exprResult.getFirstChild().isQualifiedName() && (pn = this.providedNames.get(name = exprResult.getFirstChild().getQualifiedName())) != null) {
            pn.addDefinition(exprResult, t.getChunk(), this.chunkGraph);
        }
        if (isTypedefStub) {
            this.checkNestedTypedefProvide(exprResult);
        }
    }

    private void checkNestedTypedefProvide(Node exprResult) {
        String name = exprResult.getFirstChild().getQualifiedName();
        if (name == null || !name.contains(".")) {
            return;
        }
        if (!this.providedNames.containsKey(name)) {
            return;
        }
        String parentName = name.substring(0, name.lastIndexOf("."));
        ProvidedName parent = this.providedNames.get(parentName);
        Node parentDefinition = parent.getCandidateDefinition();
        if (parentDefinition == null || !parentDefinition.getStaticSourceFile().equals(exprResult.getStaticSourceFile()) || this.isTypedefStubDeclaration(parentDefinition)) {
            return;
        }
        this.compiler.report(JSError.make(exprResult, TYPEDEF_CHILD_OF_PROVIDE, name, parentName));
    }

    private boolean isTypedefStubDeclaration(Node statement) {
        if (!statement.isExprResult()) {
            return false;
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(statement);
        return info != null && info.hasTypedefType();
    }

    private void handleCandidateProvideDefinition(NodeTraversal t, Node n, Node parent) {
        if (!t.inGlobalHoistScope()) {
            return;
        }
        String name = null;
        switch (n.getParent().getToken()) {
            case LET: 
            case CONST: {
                if (!t.inGlobalScope()) {
                    return;
                }
            }
            case VAR: {
                name = n.getString();
                break;
            }
            case EXPR_RESULT: {
                if (!n.isAssign()) break;
                name = n.getFirstChild().getQualifiedName();
                break;
            }
        }
        if (name == null) {
            return;
        }
        ProvidedName pn = this.providedNames.get(name);
        if (pn != null) {
            pn.addDefinition(parent, t.getChunk(), this.chunkGraph);
        }
    }

    private void processForwardDeclare(Node n, Node parent) {
        CodingConvention convention = this.compiler.getCodingConvention();
        List<String> typeDeclarations = convention.identifyTypeDeclarationCall(n);
        if (!this.preserveGoogProvidesAndRequires && typeDeclarations != null && typeDeclarations.size() == 1) {
            Node toRemove = parent.isExprResult() ? parent : parent.getParent();
            this.forwardDeclaresToRemove.add(toRemove);
        }
    }

    private boolean verifyOnlyArgumentIsString(Node call) {
        Node arg = call.getSecondChild();
        return arg != null && arg.isStringLit() && arg.getNext() == null;
    }

    private void registerAnyProvidedPrefixes(String ns, Node node, JSChunk chunk) {
        int pos = ns.indexOf(46);
        while (pos != -1) {
            String prefixNs = ns.substring(0, pos);
            pos = ns.indexOf(46, pos + 1);
            if (this.providedNames.containsKey(prefixNs)) {
                this.providedNames.get(prefixNs).addProvide(node, chunk, false, this.chunkGraph);
                continue;
            }
            this.providedNames.put(prefixNs, new ProvidedNameBuilder().setNamespace(prefixNs).setNode(node).setChunk(chunk).setExplicit(false).build());
        }
    }

    private static boolean isNamespacePlaceholder(Node n) {
        if (!n.getBooleanProp(Node.IS_NAMESPACE)) {
            return false;
        }
        Node value = null;
        if (n.isExprResult()) {
            Node assign = n.getFirstChild();
            value = assign.getLastChild();
        } else if (n.isVar()) {
            Node name = n.getFirstChild();
            value = name.getFirstChild();
        }
        if (value == null) {
            return false;
        }
        if (value.isCast()) {
            value = value.getOnlyChild();
        }
        return value.isObjectLit() && !value.hasChildren();
    }

    static class ProvidedName {
        private final String namespace;
        private final Node firstNode;
        private final JSChunk firstChunk;
        private final boolean hasImplicitInitialization;
        private @Nullable Node explicitNode = null;
        private @Nullable Node candidateDefinition = null;
        private @Nullable JSChunk minimumChunk = null;
        private @Nullable Node replacementNode = null;
        private final boolean fromLegacyModule;
        private final AbstractCompiler compiler;
        private final AstFactory astFactory;

        private ProvidedName(ProvidedNameBuilder builder, JSChunkGraph chunkGraph, AbstractCompiler compiler, AstFactory astFactory) {
            this.compiler = compiler;
            this.astFactory = astFactory;
            Node node = builder.node;
            Preconditions.checkArgument((node == null || NodeUtil.isExprCall(node) || !builder.explicit && (NodeUtil.isExprAssign(node) || NodeUtil.isNameDeclaration(node) || node.isExprResult() && node.getFirstChild().isQualifiedName()) ? 1 : 0) != 0, (Object)node);
            this.namespace = builder.namespace;
            this.firstNode = builder.node;
            this.firstChunk = builder.chunk;
            this.fromLegacyModule = builder.fromLegacyModule;
            this.hasImplicitInitialization = builder.hasImplicitInitialization;
            this.addProvide(node, builder.chunk, builder.explicit, chunkGraph);
        }

        void addProvide(Node node, JSChunk chunk, boolean explicit, JSChunkGraph chunkGraph) {
            if (explicit) {
                Preconditions.checkState((this.explicitNode == null ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)node.isExprResult(), (Object)node);
                this.explicitNode = node;
            }
            this.updateMinimumChunk(chunk, chunkGraph);
        }

        boolean isExplicitlyProvided() {
            return this.explicitNode != null;
        }

        boolean hasImplicitInitialization() {
            return this.hasImplicitInitialization;
        }

        boolean isFromLegacyModule() {
            return this.fromLegacyModule;
        }

        private boolean hasCandidateDefinition() {
            return this.candidateDefinition != null;
        }

        Node getFirstProvideCall() {
            return this.firstNode;
        }

        Node getCandidateDefinition() {
            return this.candidateDefinition;
        }

        String getNamespace() {
            return this.namespace;
        }

        private void addDefinition(Node node, JSChunk chunk, JSChunkGraph chunkGraph) {
            Preconditions.checkArgument((node.isExprResult() || node.isFunction() || NodeUtil.isNameDeclaration(node) ? 1 : 0) != 0);
            Preconditions.checkArgument((this.explicitNode != node ? 1 : 0) != 0);
            if (this.candidateDefinition == null || !node.isExprResult()) {
                this.candidateDefinition = node;
                this.updateMinimumChunk(chunk, chunkGraph);
            }
        }

        private void updateMinimumChunk(JSChunk newChunk, JSChunkGraph chunkGraph) {
            if (this.minimumChunk == null) {
                this.minimumChunk = newChunk;
            } else if (chunkGraph.getChunkCount() > 1) {
                this.minimumChunk = chunkGraph.getDeepestCommonDependencyInclusive(this.minimumChunk, newChunk);
            } else {
                Preconditions.checkState((newChunk == this.minimumChunk ? 1 : 0) != 0, (Object)"Missing module graph");
            }
        }

        private void replace(boolean preserveGoogProvidesAndRequires, Map<String, ProvidedName> providedNames) {
            Preconditions.checkState((!this.isFromLegacyModule() ? 1 : 0) != 0, (String)"Cannot rewrite provides without having rewritten goog.modules, found %s", (Object)this.firstNode);
            if (this.firstNode == null) {
                this.replacementNode = this.candidateDefinition;
                return;
            }
            if (this.hasCandidateDefinition() && this.explicitNode != null) {
                Node exprNode;
                this.replacementNode = this.candidateDefinition;
                if (this.candidateDefinition.isExprResult() && (exprNode = this.candidateDefinition.getOnlyChild()).isAssign()) {
                    Node nameNode = exprNode.getFirstChild();
                    if (nameNode.isName()) {
                        this.convertProvideAssignmentToVarDeclaration(exprNode, nameNode);
                    } else {
                        this.candidateDefinition.putBooleanProp(Node.IS_NAMESPACE, true);
                    }
                }
            } else if (!this.hasImplicitInitialization) {
                this.createNamespaceInitialization(this.createDeclarationNode(this.astFactory.createObjectLit(new Node[0])), providedNames);
            }
            if (this.explicitNode != null) {
                if (preserveGoogProvidesAndRequires) {
                    return;
                }
                this.compiler.reportChangeToEnclosingScope(this.explicitNode);
                this.explicitNode.detach();
            }
        }

        private void convertProvideAssignmentToVarDeclaration(Node assignNode, Node nameNode) {
            Preconditions.checkArgument((boolean)assignNode.isAssign(), (Object)assignNode);
            Preconditions.checkArgument((boolean)nameNode.isName(), (Object)nameNode);
            Node valueNode = nameNode.getNext();
            nameNode.detach();
            valueNode.detach();
            Node varNode = IR.var(nameNode, valueNode).srcref(this.candidateDefinition);
            varNode.setJSDocInfo(assignNode.getJSDocInfo());
            varNode.putBooleanProp(Node.IS_NAMESPACE, true);
            this.candidateDefinition.replaceWith(varNode);
            this.replacementNode = varNode;
            this.compiler.reportChangeToEnclosingScope(varNode);
        }

        private void createNamespaceInitialization(Node replacement, Map<String, ProvidedName> providedNames) {
            this.replacementNode = replacement;
            if (this.firstChunk == this.minimumChunk) {
                this.replacementNode.insertBefore(this.firstNode);
            } else {
                int indexOfDot = this.namespace.lastIndexOf(46);
                if (indexOfDot == -1) {
                    this.compiler.getNodeForCodeInsertion(this.minimumChunk).addChildToBack(this.replacementNode);
                } else {
                    ProvidedName parentName = providedNames.get(this.namespace.substring(0, indexOfDot));
                    Preconditions.checkNotNull((Object)parentName);
                    Preconditions.checkNotNull((Object)parentName.replacementNode);
                    this.replacementNode.insertAfter(parentName.replacementNode);
                }
            }
            this.compiler.reportChangeToEnclosingScope(this.replacementNode);
        }

        private Node createDeclarationNode(Node value) {
            Preconditions.checkArgument((value.isObjectLit() || value.isCast() ? 1 : 0) != 0, (Object)value);
            if (this.namespace.indexOf(46) == -1) {
                return this.makeVarDeclNode(value);
            }
            return this.makeAssignmentExprNode(value);
        }

        private Node makeVarDeclNode(Node value) {
            Node name = IR.name(this.namespace);
            name.addChildToFront(value);
            Node decl = IR.var(name);
            decl.putBooleanProp(Node.IS_NAMESPACE, true);
            if (this.compiler.getCodingConvention().isConstant(this.namespace)) {
                name.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            }
            if (!this.hasCandidateDefinition()) {
                decl.setJSDocInfo(NodeUtil.createConstantJsDoc());
            }
            Preconditions.checkState((boolean)ProcessClosureProvidesAndRequires.isNamespacePlaceholder(decl));
            this.setSourceInfo(decl);
            return decl;
        }

        private Node makeAssignmentExprNode(Node value) {
            Node lhs = this.astFactory.createQNameWithUnknownType(this.namespace).srcrefTree(this.firstNode);
            Node decl = IR.exprResult(this.astFactory.createAssign(lhs, value));
            decl.putBooleanProp(Node.IS_NAMESPACE, true);
            if (!this.hasCandidateDefinition()) {
                decl.getFirstChild().setJSDocInfo(NodeUtil.createConstantJsDoc());
            }
            Preconditions.checkState((boolean)ProcessClosureProvidesAndRequires.isNamespacePlaceholder(decl));
            this.setSourceInfo(decl);
            lhs.getFirstChild().makeNonIndexableRecursive();
            return decl;
        }

        private void setSourceInfo(Node newNode) {
            Node sourceInfoNode = this.firstNode;
            Node provideStringNode = this.getProvideStringNode();
            if (provideStringNode != null) {
                int firstCharIndex = this.namespace.lastIndexOf(46) + 1;
                sourceInfoNode = provideStringNode.cloneNode();
                sourceInfoNode.setLinenoCharno(sourceInfoNode.getLineno(), sourceInfoNode.getCharno() + firstCharIndex + 1);
                sourceInfoNode.setLength(this.namespace.length() - firstCharIndex);
            }
            newNode.srcrefTree(sourceInfoNode);
        }

        private @Nullable Node getProvideStringNode() {
            return this.firstNode.hasChildren() && NodeUtil.isExprCall(this.firstNode) ? this.firstNode.getFirstChild().getLastChild() : null;
        }

        @GwtIncompatible(value="Unnecessary")
        public String toString() {
            String explicitOrImplicit = this.isExplicitlyProvided() ? "explicit" : "implicit";
            return String.format("ProvidedName: %s, %s", this.namespace, explicitOrImplicit);
        }
    }

    private class ProvidedNameBuilder {
        private String namespace;
        private Node node;
        private JSChunk chunk;
        private boolean explicit;
        private boolean fromLegacyModule;
        private boolean hasImplicitInitialization;

        private ProvidedNameBuilder() {
        }

        ProvidedNameBuilder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        ProvidedNameBuilder setNode(@Nullable Node node) {
            this.node = node;
            return this;
        }

        ProvidedNameBuilder setChunk(@Nullable JSChunk chunk) {
            this.chunk = chunk;
            return this;
        }

        ProvidedNameBuilder setExplicit(boolean explicit) {
            this.explicit = explicit;
            return this;
        }

        ProvidedNameBuilder setHasImplicitInitialization(boolean alreadyInitialized) {
            this.hasImplicitInitialization = alreadyInitialized;
            return this;
        }

        ProvidedNameBuilder setFromLegacyModule(boolean fromLegacyModule) {
            this.fromLegacyModule = fromLegacyModule;
            return this;
        }

        ProvidedName build() {
            return new ProvidedName(this, ProcessClosureProvidesAndRequires.this.chunkGraph, ProcessClosureProvidesAndRequires.this.compiler, ProcessClosureProvidesAndRequires.this.astFactory);
        }
    }

    private class CollectDefinitions
    implements NodeTraversal.Callback {
        private CollectDefinitions() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isModuleBody() && n.getParent().getBooleanProp(Node.GOOG_MODULE) || NodeUtil.isBundledGoogModuleScopeRoot(n)) {
                Node googModuleCall = n.getFirstChild();
                String closureNamespace = googModuleCall.getFirstChild().getSecondChild().getString();
                Node maybeLegacyNamespaceCall = googModuleCall.getNext();
                if (maybeLegacyNamespaceCall != null && NodeUtil.isGoogModuleDeclareLegacyNamespaceCall(maybeLegacyNamespaceCall)) {
                    ProcessClosureProvidesAndRequires.this.processLegacyModuleCall(closureNamespace, googModuleCall, t.getChunk());
                }
                return false;
            }
            return !n.isModuleBody();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CALL: {
                    Node left = n.getFirstChild();
                    if (!left.isGetProp()) break;
                    Node name = left.getFirstChild();
                    if (name.isName() && ProcessClosureProvidesAndRequires.GOOG.equals(name.getString())) {
                        switch (left.getString()) {
                            case "require": 
                            case "requireType": {
                                if (!ProcessClosureProvidesAndRequires.this.isValidPrimitiveCall(t, n)) break;
                                ProcessClosureProvidesAndRequires.this.processRequireCall(n, parent);
                                break;
                            }
                            case "provide": {
                                if (!ProcessClosureProvidesAndRequires.this.isValidPrimitiveCall(t, n)) break;
                                ProcessClosureProvidesAndRequires.this.processProvideCall(t, n, parent);
                                break;
                            }
                            case "forwardDeclare": {
                                if (!ProcessClosureProvidesAndRequires.this.isValidPrimitiveCall(t, n)) break;
                                ProcessClosureProvidesAndRequires.this.processForwardDeclare(n, parent);
                            }
                        }
                    }
                    break;
                }
                case ASSIGN: 
                case NAME: {
                    ProcessClosureProvidesAndRequires.this.handleCandidateProvideDefinition(t, n, parent);
                    break;
                }
                case EXPR_RESULT: {
                    ProcessClosureProvidesAndRequires.this.handleStubDefinition(t, n);
                    break;
                }
            }
        }
    }
}

