/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AutoValue_PolyfillUsageFinder_PolyfillUsage;
import com.google.javascript.jscomp.GuardedCallback;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jspecify.nullness.Nullable;

final class PolyfillUsageFinder {
    private final AbstractCompiler compiler;
    private final Polyfills polyfills;
    private static final ImmutableSet<String> GLOBAL_NAMES = ImmutableSet.of((Object)"goog.global.", (Object)"window.", (Object)"goog$global.", (Object)"globalThis.");

    PolyfillUsageFinder(AbstractCompiler compiler, Polyfills polyfills) {
        this.polyfills = polyfills;
        this.compiler = compiler;
    }

    void traverseExcludingGuarded(Node root, Consumer<PolyfillUsage> polyfillConsumer) {
        NodeTraversal.traverse(this.compiler, root, new Traverser(this.compiler, polyfillConsumer, Guard.ONLY_UNGUARDED));
    }

    void traverseIncludingGuarded(Node root, Consumer<PolyfillUsage> polyfillConsumer) {
        NodeTraversal.traverse(this.compiler, root, new Traverser(this.compiler, polyfillConsumer, Guard.ALL));
    }

    void traverseOnlyGuarded(Node root, Consumer<PolyfillUsage> polyfillConsumer) {
        NodeTraversal.traverse(this.compiler, root, new Traverser(this.compiler, polyfillConsumer, Guard.ONLY_GUARDED));
    }

    private @Nullable PolyfillUsage maybeCreateStaticPolyfillUsageForGetPropChain(NodeTraversal traversal, Node getPropNode) {
        Preconditions.checkArgument((getPropNode.isGetProp() || getPropNode.isOptChainGetProp() ? 1 : 0) != 0, (Object)getPropNode);
        String lastComponent = getPropNode.getString();
        if (!this.polyfills.suffixes.contains((Object)lastComponent)) {
            return null;
        }
        ArrayDeque<String> components = new ArrayDeque<String>();
        components.addFirst(lastComponent);
        Node ownerNode = getPropNode.getFirstChild();
        while (ownerNode.isGetProp() || ownerNode.isOptChainGetProp()) {
            components.addFirst(ownerNode.getString());
            ownerNode = ownerNode.getFirstChild();
        }
        if (!ownerNode.isName()) {
            return null;
        }
        String rootName = ownerNode.getString();
        components.addFirst(rootName);
        String fullName = String.join((CharSequence)".", components);
        String globalPrefix = PolyfillUsageFinder.findGlobalPrefix(fullName);
        if (globalPrefix != null) {
            Polyfill polyfill = (Polyfill)this.polyfills.statics.get((Object)fullName.substring(globalPrefix.length()));
            if (polyfill != null) {
                return PolyfillUsage.createExplicit(polyfill, getPropNode, polyfill.nativeSymbol);
            }
        } else {
            Polyfill polyfill = (Polyfill)this.polyfills.statics.get((Object)fullName);
            if (polyfill != null && this.isPolyfillVisibleInScope(traversal, rootName)) {
                return PolyfillUsage.createNonExplicit(polyfill, getPropNode, polyfill.nativeSymbol);
            }
        }
        return null;
    }

    private boolean isPolyfillVisibleInScope(NodeTraversal t, String globalName) {
        return this.compiler.getLifeCycleStage() == AbstractCompiler.LifeCycleStage.NORMALIZED || t.getScope().getVar(globalName) == null;
    }

    private static @Nullable String findGlobalPrefix(String qualifiedName) {
        for (String global : GLOBAL_NAMES) {
            if (!qualifiedName.startsWith(global)) continue;
            return global;
        }
        return null;
    }

    private class Traverser
    extends GuardedCallback<String> {
        private final Consumer<PolyfillUsage> polyfillConsumer;
        private final Guard includeGuardedUsages;

        Traverser(AbstractCompiler compiler, Consumer<PolyfillUsage> polyfillConsumer, Guard includeGuardedUsages) {
            super(compiler);
            this.polyfillConsumer = polyfillConsumer;
            this.includeGuardedUsages = includeGuardedUsages;
        }

        @Override
        public void visitGuarded(NodeTraversal traversal, Node node, Node parent) {
            switch (node.getToken()) {
                case NAME: {
                    this.visitName(traversal, node);
                    break;
                }
                case GETPROP: 
                case OPTCHAIN_GETPROP: {
                    this.visitGetPropChain(traversal, node);
                    break;
                }
            }
        }

        private void visitName(NodeTraversal traversal, Node nameNode) {
            String name = nameNode.getString();
            Polyfill polyfill = (Polyfill)PolyfillUsageFinder.this.polyfills.statics.get((Object)name);
            if (polyfill == null) {
                return;
            }
            if (PolyfillUsageFinder.this.isPolyfillVisibleInScope(traversal, name) && this.includeGuardedUsages.shouldInclude(this.isGuarded(name))) {
                this.polyfillConsumer.accept(PolyfillUsage.createNonExplicit(polyfill, nameNode, name));
            }
        }

        private void visitGetPropChain(NodeTraversal traversal, Node getPropNode) {
            PolyfillUsage staticPolyfillUsage = PolyfillUsageFinder.this.maybeCreateStaticPolyfillUsageForGetPropChain(traversal, getPropNode);
            if (staticPolyfillUsage != null) {
                if (this.includeGuardedUsages.shouldInclude(this.isGuarded(staticPolyfillUsage.name()))) {
                    this.polyfillConsumer.accept(staticPolyfillUsage);
                }
            } else {
                String propertyName = getPropNode.getString();
                ImmutableCollection methodPolyfills = PolyfillUsageFinder.this.polyfills.methods.get((Object)propertyName);
                if (!methodPolyfills.isEmpty() && this.includeGuardedUsages.shouldInclude(this.isGuarded("." + propertyName))) {
                    for (Polyfill polyfill : methodPolyfills) {
                        this.polyfillConsumer.accept(PolyfillUsage.createNonExplicit(polyfill, getPropNode, propertyName));
                    }
                }
            }
        }
    }

    private static enum Guard {
        ONLY_GUARDED,
        ONLY_UNGUARDED,
        ALL;


        boolean shouldInclude(boolean isGuarded) {
            switch (this) {
                case ALL: {
                    return true;
                }
                case ONLY_GUARDED: {
                    return isGuarded;
                }
                case ONLY_UNGUARDED: {
                    return !isGuarded;
                }
            }
            throw new AssertionError();
        }
    }

    @AutoValue
    static abstract class PolyfillUsage {
        PolyfillUsage() {
        }

        abstract Polyfill polyfill();

        abstract Node node();

        abstract String name();

        abstract boolean isExplicitGlobal();

        private static PolyfillUsage createExplicit(Polyfill polyfill, Node node, String name) {
            return new AutoValue_PolyfillUsageFinder_PolyfillUsage(polyfill, node, name, true);
        }

        private static PolyfillUsage createNonExplicit(Polyfill polyfill, Node node, String name) {
            return new AutoValue_PolyfillUsageFinder_PolyfillUsage(polyfill, node, name, false);
        }
    }

    static final class Polyfills {
        private final ImmutableMultimap<String, Polyfill> methods;
        private final ImmutableMap<String, Polyfill> statics;
        private final ImmutableSet<String> suffixes;

        private Polyfills(ImmutableMultimap<String, Polyfill> methods, ImmutableMap<String, Polyfill> statics) {
            this.methods = methods;
            this.statics = statics;
            this.suffixes = ImmutableSet.copyOf((Collection)statics.keySet().stream().map(arg -> arg.substring(arg.lastIndexOf(46) + 1)).collect(Collectors.toList()));
        }

        static Polyfills fromTable(String table) {
            ImmutableMultimap.Builder methods = ImmutableMultimap.builder();
            ImmutableMap.Builder statics = ImmutableMap.builder();
            for (String line : Splitter.on((char)'\n').omitEmptyStrings().split((CharSequence)table)) {
                List tokens = Splitter.on((char)' ').omitEmptyStrings().splitToList((CharSequence)line.trim());
                if (tokens.size() == 1 && ((String)tokens.get(0)).isEmpty()) continue;
                if (tokens.size() < 3) {
                    throw new IllegalArgumentException("Invalid table: too few tokens on line: " + line);
                }
                String symbol = (String)tokens.get(0);
                boolean isPrototypeMethod = symbol.contains(".prototype.");
                String nativeVersionStr = (String)tokens.get(1);
                String polyfillVersionStr = (String)tokens.get(2);
                Polyfill polyfill = new Polyfill(symbol, nativeVersionStr, polyfillVersionStr, tokens.size() > 3 ? (String)tokens.get(3) : "", isPrototypeMethod ? Polyfill.Kind.METHOD : Polyfill.Kind.STATIC);
                if (isPrototypeMethod) {
                    methods.put((Object)symbol.replaceAll(".*\\.prototype\\.", ""), (Object)polyfill);
                    continue;
                }
                statics.put((Object)symbol, (Object)polyfill);
            }
            return new Polyfills((ImmutableMultimap<String, Polyfill>)methods.build(), (ImmutableMap<String, Polyfill>)statics.buildOrThrow());
        }
    }

    static final class Polyfill {
        final String nativeSymbol;
        final String nativeVersion;
        final String polyfillVersion;
        final String library;
        final Kind kind;

        Polyfill(String nativeSymbol, String nativeVersion, String polyfillVersion, String library, Kind kind) {
            this.nativeSymbol = nativeSymbol;
            this.nativeVersion = nativeVersion;
            this.polyfillVersion = polyfillVersion;
            this.library = library;
            this.kind = kind;
        }

        static enum Kind {
            STATIC,
            METHOD;

        }
    }
}

