/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.MinimizedCondition;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import org.jspecify.nullness.Nullable;

class PeepholeMinimizeConditions
extends AbstractPeepholeOptimization {
    private static final int AND_PRECEDENCE = NodeUtil.precedence(Token.AND);
    private final boolean late;

    PeepholeMinimizeConditions(boolean late) {
        this.late = late;
    }

    @Override
    public Node optimizeSubtree(Node node) {
        switch (node.getToken()) {
            case THROW: 
            case RETURN: {
                Node result = this.tryRemoveRedundantExit(node);
                if (result != node) {
                    return result;
                }
                return this.tryReplaceExitWithBreak(node);
            }
            case NOT: {
                this.tryMinimizeCondition(node.getFirstChild());
                return this.tryMinimizeNot(node);
            }
            case IF: {
                this.performConditionSubstitutions(node.getFirstChild());
                return this.tryMinimizeIf(node);
            }
            case EXPR_RESULT: {
                this.performConditionSubstitutions(node.getFirstChild());
                return this.tryMinimizeExprResult(node);
            }
            case HOOK: {
                this.performConditionSubstitutions(node.getFirstChild());
                return this.tryMinimizeHook(node);
            }
            case WHILE: 
            case DO: {
                this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                return node;
            }
            case FOR: {
                this.tryJoinForCondition(node);
                this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                return node;
            }
            case BLOCK: {
                return this.tryReplaceIf(node);
            }
        }
        return node;
    }

    private void tryJoinForCondition(Node n) {
        Node thenBlock;
        Node maybeBreak;
        if (!this.late) {
            return;
        }
        Node block = n.getLastChild();
        Node maybeIf = block.getFirstChild();
        if (maybeIf != null && maybeIf.isIf() && (maybeBreak = (thenBlock = maybeIf.getSecondChild()).getFirstChild()) != null && maybeBreak.isBreak() && !maybeBreak.hasChildren()) {
            if (maybeIf.hasXChildren(3)) {
                maybeIf.replaceWith(maybeIf.getLastChild().detach());
            } else {
                NodeUtil.redeclareVarsInsideBranch(thenBlock);
                block.removeFirstChild();
            }
            Node ifCondition = maybeIf.removeFirstChild();
            Node fixedIfCondition = IR.not(ifCondition).srcref(ifCondition);
            Node forCondition = NodeUtil.getConditionExpression(n);
            if (forCondition.isEmpty()) {
                forCondition.replaceWith(fixedIfCondition);
                this.reportChangeToEnclosingScope(fixedIfCondition);
            } else {
                Node replacement = new Node(Token.AND);
                forCondition.replaceWith(replacement);
                replacement.addChildToBack(forCondition);
                replacement.addChildToBack(fixedIfCondition);
                this.reportChangeToEnclosingScope(replacement);
            }
        }
    }

    private Node tryReplaceIf(Node n) {
        Node next = null;
        Node child = n.getFirstChild();
        while (child != null) {
            next = child.getNext();
            if (child.isIf()) {
                Node cond = child.getFirstChild();
                Node thenBranch = cond.getNext();
                Node elseBranch = thenBranch.getNext();
                Node nextNode = child.getNext();
                if (nextNode != null && elseBranch == null && PeepholeMinimizeConditions.isReturnBlock(thenBranch) && nextNode.isIf()) {
                    Node newCond;
                    Node nextCond = nextNode.getFirstChild();
                    Node nextThen = nextCond.getNext();
                    Node nextElse = nextThen.getNext();
                    if (this.areNodesEqualForInlining(thenBranch, nextThen)) {
                        child.detach();
                        child.detachChildren();
                        newCond = new Node(Token.OR, cond);
                        nextCond.replaceWith(newCond);
                        newCond.addChildToBack(nextCond);
                        this.reportChangeToEnclosingScope(newCond);
                    } else if (nextElse != null && this.areNodesEqualForInlining(thenBranch, nextElse)) {
                        child.detach();
                        child.detachChildren();
                        newCond = new Node(Token.AND, IR.not(cond).srcref(cond));
                        nextCond.replaceWith(newCond);
                        newCond.addChildToBack(nextCond);
                        this.reportChangeToEnclosingScope(newCond);
                    }
                } else {
                    if (nextNode != null && elseBranch == null && PeepholeMinimizeConditions.isReturnBlock(thenBranch) && PeepholeMinimizeConditions.isReturnExpression(nextNode)) {
                        Node thenExpr = null;
                        if (PeepholeMinimizeConditions.isReturnExpressBlock(thenBranch)) {
                            thenExpr = PeepholeMinimizeConditions.getBlockReturnExpression(thenBranch);
                            thenExpr.detach();
                        } else {
                            thenExpr = NodeUtil.newUndefinedNode(child);
                        }
                        Node elseExpr = nextNode.getFirstChild();
                        cond.detach();
                        elseExpr.detach();
                        Node returnNode = IR.returnNode(IR.hook(cond, thenExpr, elseExpr).srcref(child));
                        child.replaceWith(returnNode);
                        nextNode.detach();
                        this.reportChangeToEnclosingScope(n);
                        break;
                    }
                    if (elseBranch != null && PeepholeMinimizeConditions.statementMustExitParent(thenBranch)) {
                        elseBranch.detach();
                        elseBranch.insertAfter(child);
                        this.reportChangeToEnclosingScope(n);
                    }
                }
            }
            child = next;
        }
        return n;
    }

    private static boolean statementMustExitParent(Node n) {
        switch (n.getToken()) {
            case THROW: 
            case RETURN: {
                return true;
            }
            case BLOCK: {
                if (n.hasChildren()) {
                    Node child = n.getLastChild();
                    return PeepholeMinimizeConditions.statementMustExitParent(child);
                }
                return false;
            }
        }
        return false;
    }

    private Node tryReplaceExitWithBreak(Node n) {
        Node result = n.getFirstChild();
        Node breakTarget = n;
        while (!ControlFlowAnalysis.isBreakTarget(breakTarget, null)) {
            if (breakTarget.isFunction() || breakTarget.isScript()) {
                return n;
            }
            breakTarget = breakTarget.getParent();
        }
        Node follow = ControlFlowAnalysis.computeFollowNode(breakTarget);
        Node prefinallyFollows = follow;
        if (prefinallyFollows != (follow = PeepholeMinimizeConditions.skipFinallyNodes(follow)) && !this.isPure(result)) {
            return n;
        }
        if (follow == null && (n.isThrow() || result != null)) {
            return n;
        }
        if (follow == null || this.areMatchingExits(n, follow)) {
            Node replacement = IR.breakNode();
            n.replaceWith(replacement);
            this.reportChangeToEnclosingScope(replacement);
            return replacement;
        }
        return n;
    }

    private @Nullable Node tryRemoveRedundantExit(Node n) {
        Node exitExpr = n.getFirstChild();
        Node follow = ControlFlowAnalysis.computeFollowNode(n);
        Node prefinallyFollows = follow;
        if (prefinallyFollows != (follow = PeepholeMinimizeConditions.skipFinallyNodes(follow)) && !this.isPure(exitExpr)) {
            return n;
        }
        if (follow == null && (n.isThrow() || exitExpr != null)) {
            return n;
        }
        if (follow == null || this.areMatchingExits(n, follow)) {
            this.reportChangeToEnclosingScope(n);
            n.detach();
            return null;
        }
        return n;
    }

    boolean isPure(Node n) {
        return n == null || !NodeUtil.canBeSideEffected(n) && !this.mayHaveSideEffects(n);
    }

    static Node skipFinallyNodes(Node n) {
        while (n != null && NodeUtil.isTryFinallyNode(n.getParent(), n)) {
            n = ControlFlowAnalysis.computeFollowNode(n);
        }
        return n;
    }

    boolean areMatchingExits(Node nodeThis, Node nodeThat) {
        if (!this.isASTNormalized() && (nodeThis.isThrow() || nodeThis.isReturn()) && nodeThis.hasChildren()) {
            return false;
        }
        return nodeThis.isEquivalentTo(nodeThat) && (!PeepholeMinimizeConditions.isExceptionPossible(nodeThis) || PeepholeMinimizeConditions.getExceptionHandler(nodeThis) == PeepholeMinimizeConditions.getExceptionHandler(nodeThat));
    }

    static boolean isExceptionPossible(Node n) {
        Preconditions.checkState((n.isReturn() || n.isThrow() ? 1 : 0) != 0, (Object)n);
        return n.isThrow() || n.hasChildren() && !NodeUtil.isLiteralValue(n.getLastChild(), true);
    }

    static Node getExceptionHandler(Node n) {
        return ControlFlowAnalysis.getExceptionHandler(n);
    }

    private Node tryMinimizeNot(Node n) {
        Token complementOperator;
        Preconditions.checkArgument((boolean)n.isNot());
        Node parent = n.getParent();
        Node notChild = n.getFirstChild();
        switch (notChild.getToken()) {
            case EQ: {
                complementOperator = Token.NE;
                break;
            }
            case NE: {
                complementOperator = Token.EQ;
                break;
            }
            case SHEQ: {
                complementOperator = Token.SHNE;
                break;
            }
            case SHNE: {
                complementOperator = Token.SHEQ;
                break;
            }
            default: {
                return n;
            }
        }
        Node newOperator = n.removeFirstChild();
        newOperator.setToken(complementOperator);
        n.replaceWith(newOperator);
        this.reportChangeToEnclosingScope(parent);
        return newOperator;
    }

    private Node tryMinimizeExprResult(Node n) {
        Node originalExpr = n.getFirstChild();
        MinimizedCondition minCond = MinimizedCondition.fromConditionNode(originalExpr);
        MinimizedCondition.MeasuredNode mNode = minCond.getMinimized(MinimizedCondition.MinimizationStyle.ALLOW_LEADING_NOT);
        if (mNode.isNot()) {
            this.replaceNode(originalExpr, mNode.withoutNot());
        } else {
            this.replaceNode(originalExpr, mNode);
        }
        return n;
    }

    private Node tryMinimizeHook(Node n) {
        Node originalCond = n.getFirstChild();
        MinimizedCondition minCond = MinimizedCondition.fromConditionNode(originalCond);
        MinimizedCondition.MeasuredNode mNode = minCond.getMinimized(MinimizedCondition.MinimizationStyle.ALLOW_LEADING_NOT);
        if (mNode.isNot()) {
            Node thenBranch = n.getSecondChild();
            this.replaceNode(originalCond, mNode.withoutNot());
            thenBranch.detach();
            n.addChildToBack(thenBranch);
            this.reportChangeToEnclosingScope(n);
        } else {
            this.replaceNode(originalCond, mNode);
        }
        return n;
    }

    private Node tryMinimizeIf(Node n) {
        Node parent = n.getParent();
        Node originalCond = n.getFirstChild();
        if (NodeUtil.isLiteralValue(originalCond, true)) {
            return n;
        }
        Node thenBranch = originalCond.getNext();
        Node elseBranch = thenBranch.getNext();
        MinimizedCondition minCond = MinimizedCondition.fromConditionNode(originalCond);
        MinimizedCondition.MeasuredNode unnegatedCond = minCond.getMinimized(MinimizedCondition.MinimizationStyle.PREFER_UNNEGATED);
        MinimizedCondition.MeasuredNode shortCond = minCond.getMinimized(MinimizedCondition.MinimizationStyle.ALLOW_LEADING_NOT);
        if (elseBranch == null) {
            Node innerCond;
            Node innerThenBranch;
            Node innerElseBranch;
            Node innerIf;
            if (PeepholeMinimizeConditions.isFoldableExpressBlock(thenBranch)) {
                Node expr = PeepholeMinimizeConditions.getBlockExpression(thenBranch);
                if (!this.late && PeepholeMinimizeConditions.isPropertyAssignmentInExpression(expr)) {
                    this.replaceNode(originalCond, unnegatedCond);
                    return n;
                }
                if (shortCond.isNot()) {
                    Node replacementCond = this.replaceNode(originalCond, shortCond.withoutNot()).detach();
                    Node or = IR.or(replacementCond, expr.removeFirstChild()).srcref(n);
                    Node newExpr = NodeUtil.newExpr(or);
                    n.replaceWith(newExpr);
                    this.reportChangeToEnclosingScope(parent);
                    return newExpr;
                }
                if (shortCond.isLowerPrecedenceThan(AND_PRECEDENCE) && PeepholeMinimizeConditions.isLowerPrecedence(expr.getFirstChild(), AND_PRECEDENCE)) {
                    this.replaceNode(originalCond, shortCond);
                    return n;
                }
                Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
                Node and = IR.and(replacementCond, expr.removeFirstChild()).srcref(n);
                Node newExpr = NodeUtil.newExpr(and);
                n.replaceWith(newExpr);
                this.reportChangeToEnclosingScope(parent);
                return newExpr;
            }
            if (NodeUtil.isStatementBlock(thenBranch) && thenBranch.hasOneChild() && (innerIf = thenBranch.getFirstChild()).isIf() && (innerElseBranch = (innerThenBranch = (innerCond = innerIf.getFirstChild()).getNext()).getNext()) == null && (!unnegatedCond.isLowerPrecedenceThan(AND_PRECEDENCE) || !PeepholeMinimizeConditions.isLowerPrecedence(innerCond, AND_PRECEDENCE))) {
                Node replacementCond = this.replaceNode(originalCond, unnegatedCond).detach();
                n.detachChildren();
                n.addChildToBack(IR.and(replacementCond, innerCond.detach()).srcref(originalCond));
                n.addChildToBack(innerThenBranch.detach());
                this.reportChangeToEnclosingScope(n);
                return n;
            }
            this.replaceNode(originalCond, unnegatedCond);
            return n;
        }
        this.tryRemoveRepeatedStatements(n);
        if (shortCond.isNot() && !PeepholeMinimizeConditions.consumesDanglingElse(elseBranch)) {
            this.replaceNode(originalCond, shortCond.withoutNot());
            thenBranch.detach();
            n.addChildToBack(thenBranch);
            this.reportChangeToEnclosingScope(n);
            return n;
        }
        if (PeepholeMinimizeConditions.isReturnExpressBlock(thenBranch) && PeepholeMinimizeConditions.isReturnExpressBlock(elseBranch)) {
            Node thenExpr = PeepholeMinimizeConditions.getBlockReturnExpression(thenBranch);
            Node elseExpr = PeepholeMinimizeConditions.getBlockReturnExpression(elseBranch);
            Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
            thenExpr.detach();
            elseExpr.detach();
            Node returnNode = IR.returnNode(IR.hook(replacementCond, thenExpr, elseExpr).srcref(n));
            n.replaceWith(returnNode);
            this.reportChangeToEnclosingScope(returnNode);
            return returnNode;
        }
        boolean thenBranchIsExpressionBlock = PeepholeMinimizeConditions.isFoldableExpressBlock(thenBranch);
        boolean elseBranchIsExpressionBlock = PeepholeMinimizeConditions.isFoldableExpressBlock(elseBranch);
        if (thenBranchIsExpressionBlock && elseBranchIsExpressionBlock) {
            Node lhs;
            Node thenOp = PeepholeMinimizeConditions.getBlockExpression(thenBranch).getFirstChild();
            Node elseOp = PeepholeMinimizeConditions.getBlockExpression(elseBranch).getFirstChild();
            if (thenOp.getToken() == elseOp.getToken() && NodeUtil.isAssignmentOp(thenOp) && this.areNodesEqualForInlining(lhs = thenOp.getFirstChild(), elseOp.getFirstChild()) && !this.mayEffectMutableState(lhs) && (!this.mayHaveSideEffects(originalCond) || thenOp.isAssign() && thenOp.getFirstChild().isName())) {
                Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
                Node assignName = thenOp.removeFirstChild();
                Node thenExpr = thenOp.removeFirstChild();
                Node elseExpr = elseOp.getLastChild();
                elseExpr.detach();
                Node hookNode = IR.hook(replacementCond, thenExpr, elseExpr).srcref(n);
                Node assign = new Node(thenOp.getToken(), assignName, hookNode).srcref(thenOp);
                Node expr = NodeUtil.newExpr(assign);
                n.replaceWith(expr);
                this.reportChangeToEnclosingScope(parent);
                return expr;
            }
            Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
            thenOp.detach();
            elseOp.detach();
            Node expr = IR.exprResult(IR.hook(replacementCond, thenOp, elseOp).srcref(n));
            n.replaceWith(expr);
            this.reportChangeToEnclosingScope(parent);
            return expr;
        }
        boolean thenBranchIsVar = PeepholeMinimizeConditions.isVarBlock(thenBranch);
        boolean elseBranchIsVar = PeepholeMinimizeConditions.isVarBlock(elseBranch);
        if (thenBranchIsVar && elseBranchIsExpressionBlock && PeepholeMinimizeConditions.getBlockExpression(elseBranch).getFirstChild().isAssign()) {
            Node var = PeepholeMinimizeConditions.getBlockVar(thenBranch);
            Node elseAssign = PeepholeMinimizeConditions.getBlockExpression(elseBranch).getFirstChild();
            Node name1 = var.getFirstChild();
            Node maybeName2 = elseAssign.getFirstChild();
            if (name1.hasChildren() && maybeName2.isName() && name1.getString().equals(maybeName2.getString())) {
                Preconditions.checkState((boolean)name1.hasOneChild());
                Node thenExpr = name1.removeFirstChild();
                Node elseExpr = elseAssign.getLastChild().detach();
                Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
                Node hookNode = IR.hook(replacementCond, thenExpr, elseExpr).srcref(n);
                var.detach();
                name1.addChildToBack(hookNode);
                n.replaceWith(var);
                this.reportChangeToEnclosingScope(parent);
                return var;
            }
        } else if (elseBranchIsVar && thenBranchIsExpressionBlock && PeepholeMinimizeConditions.getBlockExpression(thenBranch).getFirstChild().isAssign()) {
            Node var = PeepholeMinimizeConditions.getBlockVar(elseBranch);
            Node thenAssign = PeepholeMinimizeConditions.getBlockExpression(thenBranch).getFirstChild();
            Node maybeName1 = thenAssign.getFirstChild();
            Node name2 = var.getFirstChild();
            if (name2.hasChildren() && maybeName1.isName() && maybeName1.getString().equals(name2.getString())) {
                Node thenExpr = thenAssign.getLastChild().detach();
                Preconditions.checkState((boolean)name2.hasOneChild());
                Node elseExpr = name2.removeFirstChild();
                Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
                Node hookNode = IR.hook(replacementCond, thenExpr, elseExpr).srcref(n);
                var.detach();
                name2.addChildToBack(hookNode);
                n.replaceWith(var);
                this.reportChangeToEnclosingScope(parent);
                return var;
            }
        }
        this.replaceNode(originalCond, unnegatedCond);
        return n;
    }

    private void tryRemoveRepeatedStatements(Node n) {
        if (!this.isASTNormalized()) {
            return;
        }
        Preconditions.checkState((boolean)n.isIf(), (Object)n);
        Node parent = n.getParent();
        if (!NodeUtil.isStatementBlock(parent)) {
            return;
        }
        Node cond = n.getFirstChild();
        Node trueBranch = cond.getNext();
        Node falseBranch = trueBranch.getNext();
        Preconditions.checkNotNull((Object)trueBranch);
        Preconditions.checkNotNull((Object)falseBranch);
        while (true) {
            Node lastTrue = trueBranch.getLastChild();
            Node lastFalse = falseBranch.getLastChild();
            if (lastTrue == null || lastFalse == null || !this.areNodesEqualForInlining(lastTrue, lastFalse)) break;
            lastTrue.detach();
            lastFalse.detach();
            lastTrue.insertAfter(n);
            this.reportChangeToEnclosingScope(parent);
        }
    }

    private static boolean isFoldableExpressBlock(Node n) {
        if (n.isBlock() && n.hasOneChild()) {
            Node maybeExpr = n.getFirstChild();
            if (maybeExpr.isExprResult()) {
                if (maybeExpr.getFirstChild().isCall() || maybeExpr.getFirstChild().isOptChainCall()) {
                    Node calledFn = maybeExpr.getFirstFirstChild();
                    if (calledFn.isGetElem() || calledFn.isOptChainGetElem()) {
                        return false;
                    }
                    if ((calledFn.isGetProp() || calledFn.isOptChainGetProp()) && calledFn.getString().startsWith("on")) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static Node getBlockExpression(Node n) {
        Preconditions.checkState((boolean)PeepholeMinimizeConditions.isFoldableExpressBlock(n));
        return n.getFirstChild();
    }

    private static boolean isReturnBlock(Node n) {
        if (n.isBlock() && n.hasOneChild()) {
            Node first = n.getFirstChild();
            return first.isReturn();
        }
        return false;
    }

    private static boolean isReturnExpressBlock(Node n) {
        Node first;
        if (n.isBlock() && n.hasOneChild() && (first = n.getFirstChild()).isReturn()) {
            return first.hasOneChild();
        }
        return false;
    }

    private static boolean isReturnExpression(Node n) {
        if (n.isReturn()) {
            return n.hasOneChild();
        }
        return false;
    }

    private static Node getBlockReturnExpression(Node n) {
        Preconditions.checkState((boolean)PeepholeMinimizeConditions.isReturnExpressBlock(n));
        return n.getFirstFirstChild();
    }

    private static boolean isVarBlock(Node n) {
        Node first;
        if (n.isBlock() && n.hasOneChild() && (first = n.getFirstChild()).isVar()) {
            return first.hasOneChild();
        }
        return false;
    }

    private static Node getBlockVar(Node n) {
        Preconditions.checkState((boolean)PeepholeMinimizeConditions.isVarBlock(n));
        return n.getFirstChild();
    }

    private static boolean consumesDanglingElse(Node n) {
        block5: while (true) {
            switch (n.getToken()) {
                case IF: {
                    if (n.getChildCount() < 3) {
                        return true;
                    }
                    n = n.getLastChild();
                    continue block5;
                }
                case BLOCK: {
                    if (!n.hasOneChild()) {
                        return false;
                    }
                    n = n.getLastChild();
                    continue block5;
                }
                case WHILE: 
                case FOR: 
                case WITH: 
                case FOR_IN: {
                    n = n.getLastChild();
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    static boolean isLowerPrecedence(Node n, int precedence) {
        return NodeUtil.precedence(n.getToken()) < precedence;
    }

    private static boolean isPropertyAssignmentInExpression(Node n) {
        Predicate isPropertyAssignmentInExpressionPredicate = input -> input.isGetProp() && input.getParent().isAssign();
        return NodeUtil.has(n, (Predicate<Node>)isPropertyAssignmentInExpressionPredicate, NodeUtil.MATCH_NOT_FUNCTION);
    }

    private Node tryMinimizeCondition(Node n) {
        n = this.performConditionSubstitutions(n);
        MinimizedCondition minCond = MinimizedCondition.fromConditionNode(n);
        return this.replaceNode(n, minCond.getMinimized(MinimizedCondition.MinimizationStyle.PREFER_UNNEGATED));
    }

    private Node replaceNode(Node original, MinimizedCondition.MeasuredNode measuredNodeReplacement) {
        if (measuredNodeReplacement.willChange(original)) {
            Node replacement = measuredNodeReplacement.applyTo(original);
            this.reportChangeToEnclosingScope(replacement);
            return replacement;
        }
        return original;
    }

    private Node performConditionSubstitutions(Node n) {
        Node parent = n.getParent();
        switch (n.getToken()) {
            case OR: 
            case AND: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                left = this.performConditionSubstitutions(left);
                right = this.performConditionSubstitutions(right);
                Tri rightVal = this.getSideEffectFreeBooleanValue(right);
                if (this.getSideEffectFreeBooleanValue(right) != Tri.UNKNOWN) {
                    Token type = n.getToken();
                    Node replacement = null;
                    boolean rval = rightVal.toBoolean(true);
                    if (type == Token.OR && !rval || type == Token.AND && rval) {
                        replacement = left;
                    } else if (!this.mayHaveSideEffects(left)) {
                        replacement = right;
                    } else {
                        n.detachChildren();
                        replacement = IR.comma(left, right);
                    }
                    if (replacement != null) {
                        n.detachChildren();
                        n.replaceWith(replacement);
                        this.reportChangeToEnclosingScope(parent);
                        return replacement;
                    }
                }
                return n;
            }
            case HOOK: {
                Node condition = n.getFirstChild();
                Node trueNode = n.getSecondChild();
                Node falseNode = n.getLastChild();
                trueNode = this.performConditionSubstitutions(trueNode);
                falseNode = this.performConditionSubstitutions(falseNode);
                Node replacement = null;
                Tri trueNodeVal = this.getSideEffectFreeBooleanValue(trueNode);
                Tri falseNodeVal = this.getSideEffectFreeBooleanValue(falseNode);
                if (trueNodeVal == Tri.TRUE && falseNodeVal == Tri.FALSE) {
                    condition.detach();
                    replacement = condition;
                } else if (trueNodeVal == Tri.FALSE && falseNodeVal == Tri.TRUE) {
                    condition.detach();
                    replacement = IR.not(condition);
                } else if (trueNodeVal == Tri.TRUE) {
                    n.detachChildren();
                    replacement = IR.or(condition, falseNode);
                } else if (falseNodeVal == Tri.FALSE) {
                    n.detachChildren();
                    replacement = IR.and(condition, trueNode);
                } else if (!this.mayHaveSideEffects(condition) && !this.mayHaveSideEffects(trueNode) && condition.isEquivalentTo(trueNode)) {
                    n.detachChildren();
                    replacement = IR.or(trueNode, falseNode);
                }
                if (replacement != null) {
                    n.replaceWith(replacement);
                    this.reportChangeToEnclosingScope(replacement);
                    n = replacement;
                }
                return n;
            }
        }
        Tri nVal = this.getSideEffectFreeBooleanValue(n);
        if (nVal != Tri.UNKNOWN) {
            boolean result = nVal.toBoolean(true);
            int equivalentResult = result ? 1 : 0;
            return this.maybeReplaceChildWithNumber(n, equivalentResult);
        }
        return n;
    }

    private Node maybeReplaceChildWithNumber(Node n, int num) {
        Node newNode = IR.number(num);
        if (!newNode.isEquivalentTo(n)) {
            n.replaceWith(newNode);
            this.reportChangeToEnclosingScope(newNode);
            this.markFunctionsDeleted(n);
            return newNode;
        }
        return n;
    }
}

