/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PassListBuilder;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;

public abstract class PassConfig {
    protected final CompilerOptions options;

    public PassConfig(CompilerOptions options) {
        this.options = options;
    }

    protected PassListBuilder getWhitespaceOnlyPasses() {
        return new PassListBuilder(this.options);
    }

    protected PassListBuilder getTranspileOnlyPasses() {
        return new PassListBuilder(this.options);
    }

    protected abstract PassListBuilder getChecks();

    protected abstract PassListBuilder getOptimizations();

    protected abstract PassListBuilder getFinalizations();

    GraphvizGraph getPassGraph() {
        LinkedDirectedGraph<Object, String> graph = LinkedDirectedGraph.createWithoutAnnotations();
        Iterable allPasses = Iterables.concat(this.getChecks().build(), this.getOptimizations().build());
        Object lastPass = null;
        Object loopStart = null;
        for (PassFactory pass : allPasses) {
            Object passName = pass.getName();
            int i = 1;
            while (graph.hasNode(passName)) {
                passName = pass.getName() + i++;
            }
            graph.createNode(passName);
            if (loopStart == null && pass.isRunInFixedPointLoop()) {
                loopStart = passName;
            } else if (loopStart != null && !pass.isRunInFixedPointLoop()) {
                graph.connect(lastPass, "loop", loopStart);
                loopStart = null;
            }
            if (lastPass != null) {
                graph.connect(lastPass, "", passName);
            }
            lastPass = passName;
        }
        return graph;
    }

    final PassConfig getBasePassConfig() {
        PassConfig current = this;
        while (current instanceof PassConfigDelegate) {
            current = ((PassConfigDelegate)current).delegate;
        }
        return current;
    }

    public static class PassConfigDelegate
    extends PassConfig {
        private final PassConfig delegate;

        protected PassConfigDelegate(PassConfig delegate) {
            super(delegate.options);
            this.delegate = delegate;
        }

        @Override
        protected PassListBuilder getWhitespaceOnlyPasses() {
            return this.delegate.getWhitespaceOnlyPasses();
        }

        @Override
        protected PassListBuilder getChecks() {
            return this.delegate.getChecks();
        }

        @Override
        protected PassListBuilder getOptimizations() {
            return this.delegate.getOptimizations();
        }

        @Override
        protected PassListBuilder getFinalizations() {
            return this.delegate.getFinalizations();
        }

        @Override
        protected PassListBuilder getTranspileOnlyPasses() {
            return this.delegate.getTranspileOnlyPasses();
        }
    }
}

