/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.IcuTemplateDefinition;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.nullness.Nullable;

@GwtIncompatible(value="JsMessage, java.util.regex")
public abstract class JsMessageVisitor
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final String MSG_FUNCTION_NAME = "goog.getMsg";
    private static final String ICU_MSG_FUNCTION_NAME = "declareIcuTemplate";
    private static final String ICU_MSG_FUNCTION_QNAME = "goog.i18n.messages.declareIcuTemplate";
    private static final String MSG_FALLBACK_FUNCTION_NAME = "goog.getMsgWithFallback";
    private static final String MSG_EXTERNAL_PREFIX = "MSG_EXTERNAL_";
    static final DiagnosticType MESSAGE_HAS_NO_DESCRIPTION = DiagnosticType.warning("JSC_MSG_HAS_NO_DESCRIPTION", "Message {0} has no description. Add @desc JsDoc tag.");
    static final DiagnosticType MESSAGE_HAS_NO_TEXT = DiagnosticType.warning("JSC_MSG_HAS_NO_TEXT", "Message value of {0} is just an empty string. Empty messages are forbidden.");
    public static final DiagnosticType MESSAGE_TREE_MALFORMED = DiagnosticType.error("JSC_MSG_TREE_MALFORMED", "Message parse tree malformed. {0}");
    static final DiagnosticType MESSAGE_HAS_NO_VALUE = DiagnosticType.error("JSC_MSG_HAS_NO_VALUE", "message node {0} has no value");
    static final DiagnosticType MESSAGE_DUPLICATE_KEY = DiagnosticType.error("JSC_MSG_KEY_DUPLICATED", "duplicate message variable name found for {0}, initial definition {1}:{2}");
    static final DiagnosticType MESSAGE_NODE_IS_ORPHANED = DiagnosticType.error("JSC_MSG_ORPHANED_NODE", "{0}() function may be used only with MSG_* property or variable");
    public static final DiagnosticType MESSAGE_NOT_INITIALIZED_CORRECTLY = DiagnosticType.warning("JSC_MSG_NOT_INITIALIZED_CORRECTLY", "Message must be initialized using a call to goog.getMsg or goog.i18n.messages.declareIcuTemplate");
    public static final DiagnosticType BAD_FALLBACK_SYNTAX = DiagnosticType.error("JSC_MSG_BAD_FALLBACK_SYNTAX", SimpleFormat.format("Bad syntax. Expected syntax: %s(MSG_1, MSG_2)", "goog.getMsgWithFallback"));
    public static final DiagnosticType FALLBACK_ARG_ERROR = DiagnosticType.error("JSC_MSG_FALLBACK_ARG_ERROR", "Could not find message entry for fallback argument {0}");
    static final String MSG_PREFIX = "MSG_";
    private static final Pattern SCOPED_ALIASES_PREFIX_PATTERN = Pattern.compile("\\$jscomp\\$scope\\$\\S+\\$MSG_");
    private static final Pattern MSG_UNNAMED_PATTERN = Pattern.compile("MSG_UNNAMED.*");
    private final JsMessage.IdGenerator idGenerator;
    final AbstractCompiler compiler;
    private final Map<String, MessageLocation> messageNames = new LinkedHashMap<String, MessageLocation>();
    private final Map<Var, JsMessage> unnamedMessages = new LinkedHashMap<Var, JsMessage>();
    private final Set<Node> googMsgNodes = new LinkedHashSet<Node>();
    private static final Pattern ICU_PLACEHOLDER_RE = Pattern.compile("\\{([A-Z_0-9]+)\\}");
    private static final ImmutableSet<String> MESSAGE_OPTION_NAMES = ImmutableSet.of((Object)"html", (Object)"unescapeHtmlEntities", (Object)"example", (Object)"original_code");
    private static final ImmutableSet<String> ICU_TEMPLATE_OPTION_NAMES = ImmutableSet.of((Object)"description", (Object)"meaning", (Object)"alternate_message_id", (Object)"example", (Object)"original_code");

    protected JsMessageVisitor(AbstractCompiler compiler, JsMessage.IdGenerator idGenerator) {
        this.compiler = compiler;
        this.idGenerator = idGenerator;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        for (Node msgNode : this.googMsgNodes) {
            this.compiler.report(JSError.make(msgNode, MESSAGE_NODE_IS_ORPHANED, msgNode.getFirstChild().getQualifiedName()));
        }
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node unused) {
        this.collectGetMsgCall(traversal, node);
        this.checkMessageInitialization(traversal, node);
    }

    private void checkMessageInitialization(NodeTraversal traversal, Node node) {
        boolean msgNodeIsACall;
        JSDocInfo jsDocInfo;
        Node msgNode;
        String originalMessageKey;
        String possiblyObfuscatedMessageKey;
        Node parent = node.getParent();
        switch (node.getToken()) {
            case NAME: {
                if (parent == null || !NodeUtil.isNameDeclaration(parent)) {
                    return;
                }
                possiblyObfuscatedMessageKey = node.getString();
                originalMessageKey = node.getOriginalName();
                msgNode = node.getFirstChild();
                jsDocInfo = parent.getJSDocInfo();
                break;
            }
            case ASSIGN: {
                Node getProp = node.getFirstChild();
                if (!getProp.isGetProp()) {
                    return;
                }
                possiblyObfuscatedMessageKey = getProp.getString();
                originalMessageKey = getProp.getOriginalName();
                msgNode = node.getLastChild();
                jsDocInfo = node.getJSDocInfo();
                break;
            }
            case STRING_KEY: {
                if (node.isQuotedStringKey() || !node.hasChildren() || parent.isObjectPattern()) {
                    return;
                }
                Preconditions.checkState((boolean)parent.isObjectLit(), (Object)parent);
                possiblyObfuscatedMessageKey = node.getString();
                originalMessageKey = node.getOriginalName();
                msgNode = node.getFirstChild();
                jsDocInfo = node.getJSDocInfo();
                break;
            }
            case MEMBER_FIELD_DEF: {
                possiblyObfuscatedMessageKey = node.getString();
                originalMessageKey = node.getOriginalName();
                msgNode = node.getFirstChild();
                jsDocInfo = node.getJSDocInfo();
                break;
            }
            default: {
                return;
            }
        }
        String messageKeyFromLhs = originalMessageKey != null ? originalMessageKey : possiblyObfuscatedMessageKey;
        boolean bl = msgNodeIsACall = msgNode != null && msgNode.isCall();
        if (!this.isMessageName(messageKeyFromLhs)) {
            return;
        }
        if (msgNode == null) {
            this.compiler.report(JSError.make(node, MESSAGE_HAS_NO_VALUE, messageKeyFromLhs));
            return;
        }
        if (JsMessageVisitor.isLegalMessageVarAlias(msgNode)) {
            return;
        }
        if (!msgNodeIsACall) {
            this.compiler.report(JSError.make(node, MESSAGE_NOT_INITIALIZED_CORRECTLY, new String[0]));
            return;
        }
        this.googMsgNodes.remove(msgNode);
        Mapping.OriginalMapping mapping = this.compiler.getSourceMapping(traversal.getSourceName(), node.getLineno(), node.getCharno());
        String sourceName = mapping != null ? mapping.getOriginalFile() + ":" + mapping.getLineNumber() : traversal.getSourceName() + ":" + node.getLineno();
        Preconditions.checkState((boolean)msgNode.isCall());
        Node fnNameNode = msgNode.getFirstChild();
        try {
            if (this.isDeclareIcuTemplateCallee(fnNameNode)) {
                IcuTemplateDefinition icuTemplateDefinition = this.extractIcuTemplateDefinition(msgNode, jsDocInfo, messageKeyFromLhs, sourceName);
                JsMessage extractedMessage = icuTemplateDefinition.getMessage();
                this.trackMessage(traversal, possiblyObfuscatedMessageKey, msgNode, extractedMessage);
                this.reportErrorIfEmptyMessage(node, extractedMessage);
                this.processIcuTemplateDefinition(icuTemplateDefinition);
            } else if (fnNameNode.matchesQualifiedName(MSG_FUNCTION_NAME)) {
                JsMessageDefinition jsMessageDefinition = this.extractJsMessageDefinition(msgNode, jsDocInfo, messageKeyFromLhs, sourceName);
                JsMessage extractedMessage = jsMessageDefinition.getMessage();
                this.trackMessage(traversal, possiblyObfuscatedMessageKey, msgNode, extractedMessage);
                this.reportErrorIfEmptyMessage(node, extractedMessage);
                String desc = extractedMessage.getDesc();
                if ((desc == null || desc.trim().isEmpty()) && !extractedMessage.isExternal()) {
                    this.compiler.report(JSError.make(node, MESSAGE_HAS_NO_DESCRIPTION, extractedMessage.getKey()));
                }
                this.processJsMessageDefinition(jsMessageDefinition);
            } else {
                this.compiler.report(JSError.make(msgNode, MESSAGE_TREE_MALFORMED, "Message must be initialized using a call to goog.getMsg or declareIcuTemplate (from goog.i18n.messages)."));
            }
        }
        catch (MalformedException ex) {
            this.compiler.report(JSError.make(ex.getNode(), MESSAGE_TREE_MALFORMED, ex.getMessage()));
        }
    }

    private boolean isDeclareIcuTemplateCallee(Node calleeNode) {
        String qualifiedName = calleeNode.getQualifiedName();
        return qualifiedName != null && qualifiedName.endsWith(ICU_MSG_FUNCTION_NAME);
    }

    private JsMessage buildJsMessage(InputForBuildJsMsg input) {
        String messageKeyFinal;
        String messageId;
        boolean isExternal;
        boolean isAnonymous;
        ImmutableList<JsMessage.Part> messageParts = input.getMessageParts();
        String messageKeyFromLhs = input.getMessageKeyFromLhs();
        String externalMessageId = JsMessageVisitor.getExternalMessageId(messageKeyFromLhs);
        if (externalMessageId != null) {
            isAnonymous = false;
            isExternal = true;
            messageId = externalMessageId;
            messageKeyFinal = messageKeyFromLhs;
        } else {
            isExternal = false;
            String meaningForIdGeneration = input.getMeaning();
            if (JsMessageVisitor.isUnnamedMessageName(messageKeyFromLhs)) {
                isAnonymous = true;
                messageKeyFinal = this.generateKeyFromMessageText(input.getMessageText());
                if (meaningForIdGeneration == null) {
                    meaningForIdGeneration = messageKeyFinal;
                }
            } else {
                isAnonymous = false;
                messageKeyFinal = messageKeyFromLhs;
                if (meaningForIdGeneration == null) {
                    meaningForIdGeneration = JsMessageVisitor.removeScopedAliasesPrefix(messageKeyFromLhs);
                }
            }
            messageId = this.idGenerator == null ? meaningForIdGeneration : this.idGenerator.generateId(meaningForIdGeneration, (List<JsMessage.Part>)messageParts);
        }
        return new JsMessage.Builder().appendParts((List<JsMessage.Part>)messageParts).setPlaceholderNameToExampleMap(input.getPlaceholderExampleMap()).setPlaceholderNameToOriginalCodeMap(input.getPlaceholderOriginalCodeMap()).setIsAnonymous(isAnonymous).setIsExternalMsg(isExternal).setKey(messageKeyFinal).setSourceName(input.getSourceName()).setDesc(input.getDescription()).setMeaning(input.getMeaning()).setAlternateId(input.getAlternateMessageId()).setId(messageId).build();
    }

    private void trackMessage(NodeTraversal traversal, String possiblyObfuscatedMessageKey, Node msgNode, JsMessage extractedMessage) {
        if (!extractedMessage.isAnonymous() && !extractedMessage.isExternal()) {
            this.checkIfMessageDuplicated(extractedMessage.getKey(), msgNode);
        }
        if (extractedMessage.isAnonymous()) {
            this.trackUnnamedMessage(traversal, extractedMessage, possiblyObfuscatedMessageKey);
        } else {
            this.trackNormalMessage(extractedMessage, extractedMessage.getKey(), msgNode);
        }
    }

    private void reportErrorIfEmptyMessage(Node node, JsMessage extractedMessage) {
        if (extractedMessage.isEmpty()) {
            this.compiler.report(JSError.make(node, MESSAGE_HAS_NO_TEXT, extractedMessage.getKey()));
        }
    }

    public static @Nullable String getExternalMessageId(String messageKey) {
        if (messageKey.startsWith(MSG_EXTERNAL_PREFIX)) {
            int start;
            char c;
            int end;
            for (end = start = MSG_EXTERNAL_PREFIX.length(); end < messageKey.length() && (c = messageKey.charAt(end)) <= '9' && c >= '0'; ++end) {
            }
            if (end > start) {
                return messageKey.substring(start, end);
            }
        }
        return null;
    }

    private String generateKeyFromMessageText(String msgText) {
        long nonnegativeHash = Long.MAX_VALUE & JsMessage.Hash.hash64(msgText);
        return MSG_PREFIX + Ascii.toUpperCase((String)Long.toString(nonnegativeHash, 36));
    }

    private void collectGetMsgCall(NodeTraversal traversal, Node call) {
        if (!call.isCall()) {
            return;
        }
        Node callee = call.getFirstChild();
        if (callee.matchesQualifiedName(MSG_FUNCTION_NAME) || this.isDeclareIcuTemplateCallee(callee)) {
            this.googMsgNodes.add(call);
        } else if (callee.matchesQualifiedName(MSG_FALLBACK_FUNCTION_NAME)) {
            this.visitFallbackFunctionCall(traversal, call);
        }
    }

    private void trackNormalMessage(JsMessage message, String msgName, Node msgNode) {
        MessageLocation location = new MessageLocation(message, msgNode);
        this.messageNames.put(msgName, location);
    }

    private void trackUnnamedMessage(NodeTraversal t, JsMessage message, String msgNameInScope) {
        Var var = (Var)t.getScope().getVar(msgNameInScope);
        if (var != null) {
            this.unnamedMessages.put(var, message);
        }
    }

    private static boolean isLegalMessageVarAlias(Node msgNode) {
        String originalName;
        if (msgNode.isGetProp() && msgNode.isQualifiedName() && msgNode.getString().startsWith(MSG_PREFIX)) {
            return true;
        }
        if (!msgNode.isName()) {
            return false;
        }
        String string = originalName = msgNode.getOriginalName() != null ? msgNode.getOriginalName() : msgNode.getString();
        return originalName.startsWith(MSG_PREFIX);
    }

    private @Nullable JsMessage getTrackedUnnamedMessage(NodeTraversal t, String msgNameInScope) {
        Var var = (Var)t.getScope().getVar(msgNameInScope);
        if (var != null) {
            return this.unnamedMessages.get(var);
        }
        return null;
    }

    private @Nullable JsMessage getTrackedNormalMessage(String msgName) {
        MessageLocation location = this.messageNames.get(msgName);
        return location == null ? null : location.message;
    }

    private void checkIfMessageDuplicated(String msgName, Node msgNode) {
        if (this.messageNames.containsKey(msgName)) {
            MessageLocation location = this.messageNames.get(msgName);
            this.compiler.report(JSError.make(msgNode, MESSAGE_DUPLICATE_KEY, msgName, location.messageNode.getSourceFileName(), Integer.toString(location.messageNode.getLineno())));
        }
    }

    private static String extractStringFromStringExprNode(Node node) throws MalformedException {
        switch (node.getToken()) {
            case STRINGLIT: {
                return node.getString();
            }
            case TEMPLATELIT: {
                if (node.hasOneChild()) {
                    return (String)Preconditions.checkNotNull((Object)node.getFirstChild().getCookedString());
                }
                throw new MalformedException("Template literals with substitutions are not allowed.", node);
            }
            case ADD: {
                StringBuilder sb = new StringBuilder();
                for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
                    sb.append(JsMessageVisitor.extractStringFromStringExprNode(child));
                }
                return sb.toString();
            }
        }
        throw new MalformedException("literal string or concatenation expected", node);
    }

    private JsMessageDefinition extractJsMessageDefinition(final Node msgNode, JSDocInfo jsDocInfo, final String messageKeyFromLhs, final String sourceName) throws MalformedException {
        GoogGetMsgParsedText googGetMsgParsedText;
        Node unexpectedArgument;
        String alternateMessageId;
        String meaning;
        String description;
        if (jsDocInfo == null) {
            description = null;
            meaning = null;
            alternateMessageId = null;
        } else {
            description = jsDocInfo.getDescription();
            meaning = jsDocInfo.getMeaning();
            alternateMessageId = jsDocInfo.getAlternateMessageId();
        }
        final Node msgTextNode = msgNode.getSecondChild();
        if (msgTextNode == null) {
            throw new MalformedException("Message string literal expected", msgNode);
        }
        final Node valuesObjLit = msgTextNode.getNext();
        Node optionsBagArgument = valuesObjLit == null ? null : valuesObjLit.getNext();
        Node node = unexpectedArgument = optionsBagArgument == null ? null : optionsBagArgument.getNext();
        if (unexpectedArgument != null) {
            throw new MalformedException("too many arguments", unexpectedArgument);
        }
        String msgTextString = JsMessageVisitor.extractStringFromStringExprNode(msgTextNode);
        try {
            googGetMsgParsedText = JsMessageVisitor.extractGoogGetMsgParsedText(msgTextString);
        }
        catch (JsMessage.PlaceholderFormatException e) {
            throw new MalformedException(e.getMessage(), msgTextNode);
        }
        ObjectLiteralMap placeholderObjectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(valuesObjLit);
        ImmutableSet<String> placeholderNamesFromText = googGetMsgParsedText.getPlaceholderNames();
        placeholderObjectLiteralMap.checkForRequiredKeys((Set<String>)placeholderNamesFromText, placeholderName -> new MalformedException("Unrecognized message placeholder referenced: " + placeholderName, msgTextNode));
        placeholderObjectLiteralMap.checkForUnexpectedKeys((Set<String>)placeholderNamesFromText, placeholderName -> "Unused message placeholder: " + placeholderName);
        final ImmutableMap<String, Node> placeholderValuesMap = placeholderObjectLiteralMap.extractAsValueMap();
        final JsMessageOptions jsMessageOptions = this.extractJsMessageOptions(optionsBagArgument);
        jsMessageOptions.checkForUnknownPlaceholders((Set<String>)placeholderNamesFromText);
        final JsMessage jsExtractedMessage = this.buildJsMessage(new InputForBuildJsMsg(){

            @Override
            public String getMessageKeyFromLhs() {
                return messageKeyFromLhs;
            }

            @Override
            public String getSourceName() {
                return sourceName;
            }

            @Override
            public String getMessageText() {
                return googGetMsgParsedText.getText();
            }

            @Override
            public ImmutableList<JsMessage.Part> getMessageParts() {
                return googGetMsgParsedText.getParts();
            }

            public ImmutableMap<String, String> getPlaceholderExampleMap() {
                return jsMessageOptions.getPlaceholderExampleMap();
            }

            public ImmutableMap<String, String> getPlaceholderOriginalCodeMap() {
                return jsMessageOptions.getPlaceholderOriginalCodeMap();
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public String getMeaning() {
                return meaning;
            }

            @Override
            public String getAlternateMessageId() {
                return alternateMessageId;
            }
        });
        return new JsMessageDefinition(){

            @Override
            public JsMessage getMessage() {
                return jsExtractedMessage;
            }

            @Override
            public Node getMessageNode() {
                return msgNode;
            }

            @Override
            public Node getTemplateTextNode() {
                return msgTextNode;
            }

            @Override
            public @Nullable Node getPlaceholderValuesNode() {
                return valuesObjLit;
            }

            @Override
            public ImmutableMap<String, Node> getPlaceholderValueMap() {
                return placeholderValuesMap;
            }

            @Override
            public boolean shouldEscapeLessThan() {
                return jsMessageOptions.isEscapeLessThan();
            }

            @Override
            public boolean shouldUnescapeHtmlEntities() {
                return jsMessageOptions.isUnescapeHtmlEntities();
            }
        };
    }

    private IcuTemplateDefinition extractIcuTemplateDefinition(final Node msgNode, JSDocInfo jsDocInfo, final String messageKeyFromLhs, final String sourceName) throws MalformedException {
        Node stringLiteralExpression;
        if (jsDocInfo != null) {
            if (jsDocInfo.getAlternateMessageId() != null) {
                throw new MalformedException("Use the 'alternate_message_id' option, not the '@alternateMessageId' annotation", msgNode);
            }
            if (jsDocInfo.getDescription() != null) {
                throw new MalformedException("Use the 'description' option, not the '@desc' annotation", msgNode);
            }
            if (jsDocInfo.getMeaning() != null) {
                throw new MalformedException("Use the 'meaning' option, not the '@meaning' annotation", msgNode);
            }
        }
        if ((stringLiteralExpression = msgNode.getSecondChild()) == null) {
            throw new MalformedException("message string argument expected", msgNode);
        }
        final IcuMessageTemplateString icuMessageTemplateString = this.extractIcuMessageTemplateString(stringLiteralExpression);
        Node optionsBagNode = stringLiteralExpression.getNext();
        if (optionsBagNode == null) {
            throw new MalformedException("options argument expected", msgNode);
        }
        final IcuTemplateOptions icuTemplateOptions = this.extractIcuTemplateOptions(optionsBagNode);
        final ExtractedIcuTemplateParts extractedIcuTemplateParts = icuMessageTemplateString.extractParts((Set<String>)icuTemplateOptions.getPlaceholderNames());
        icuTemplateOptions.checkForUnknownPlaceholders((Set<String>)extractedIcuTemplateParts.extractedPlaceholderNames);
        Node unexpectedArgument = optionsBagNode.getNext();
        if (unexpectedArgument != null) {
            throw new MalformedException("too many arguments", unexpectedArgument);
        }
        final JsMessage extractedMessage = this.buildJsMessage(new InputForBuildJsMsg(){

            @Override
            public String getMessageKeyFromLhs() {
                return messageKeyFromLhs;
            }

            @Override
            public String getSourceName() {
                return sourceName;
            }

            @Override
            public String getMessageText() {
                return icuMessageTemplateString.template;
            }

            @Override
            public ImmutableList<JsMessage.Part> getMessageParts() {
                return extractedIcuTemplateParts.extractedParts;
            }

            public ImmutableMap<String, String> getPlaceholderExampleMap() {
                return icuTemplateOptions.getPlaceholderExampleMap();
            }

            public ImmutableMap<String, String> getPlaceholderOriginalCodeMap() {
                return icuTemplateOptions.getPlaceholderOriginalCodeMap();
            }

            @Override
            public String getDescription() {
                return icuTemplateOptions.getDescription();
            }

            @Override
            public String getMeaning() {
                return icuTemplateOptions.getMeaning();
            }

            @Override
            public String getAlternateMessageId() {
                return icuTemplateOptions.getAlternateMessageId();
            }
        });
        return new IcuTemplateDefinition(){

            @Override
            public JsMessage getMessage() {
                return extractedMessage;
            }

            @Override
            public Node getMessageNode() {
                return msgNode;
            }

            @Override
            public Node getTemplateTextNode() {
                return stringLiteralExpression;
            }
        };
    }

    private IcuMessageTemplateString extractIcuMessageTemplateString(Node stringExpression) throws MalformedException {
        String templateString = JsMessageVisitor.extractStringFromStringExprNode(stringExpression);
        return new IcuMessageTemplateString(templateString);
    }

    private JsMessageOptions extractJsMessageOptions(@Nullable Node optionsBag) throws MalformedException {
        ObjectLiteralMap objectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(optionsBag);
        objectLiteralMap.checkForUnexpectedKeys((Set<String>)MESSAGE_OPTION_NAMES, optionName -> "Unknown option: " + optionName);
        final boolean isEscapeLessThan = objectLiteralMap.getBooleanValueOrFalse("html");
        final boolean isUnescapeHtmlEntities = objectLiteralMap.getBooleanValueOrFalse("unescapeHtmlEntities");
        Node exampleValueNode = objectLiteralMap.getValueNode("example");
        final ObjectLiteralMap exampleObjectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(exampleValueNode);
        final ImmutableMap<String, String> placeholderExamplesMap = exampleObjectLiteralMap.extractAsStringToStringMap();
        Node originalCodeValueNode = objectLiteralMap.getValueNode("original_code");
        final ObjectLiteralMap originalCodeObjectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(originalCodeValueNode);
        final ImmutableMap<String, String> placeholderOriginalCodeMap = originalCodeObjectLiteralMap.extractAsStringToStringMap();
        return new JsMessageOptions(){

            @Override
            public boolean isEscapeLessThan() {
                return isEscapeLessThan;
            }

            @Override
            public boolean isUnescapeHtmlEntities() {
                return isUnescapeHtmlEntities;
            }

            @Override
            public ImmutableMap<String, String> getPlaceholderExampleMap() {
                return placeholderExamplesMap;
            }

            @Override
            public ImmutableMap<String, String> getPlaceholderOriginalCodeMap() {
                return placeholderOriginalCodeMap;
            }

            @Override
            public void checkForUnknownPlaceholders(Set<String> knownPlaceholders) throws MalformedException {
                exampleObjectLiteralMap.checkForUnexpectedKeys(knownPlaceholders, unknownName -> "Unknown placeholder: " + unknownName);
                originalCodeObjectLiteralMap.checkForUnexpectedKeys(knownPlaceholders, unknownName -> "Unknown placeholder: " + unknownName);
            }
        };
    }

    private IcuTemplateOptions extractIcuTemplateOptions(Node optionsBag) throws MalformedException {
        ObjectLiteralMap objectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(optionsBag);
        objectLiteralMap.checkForUnexpectedKeys((Set<String>)ICU_TEMPLATE_OPTION_NAMES, optionName -> "Unknown option: " + optionName);
        @Nullable Node descriptionNode = objectLiteralMap.getValueNode("description");
        if (descriptionNode == null) {
            throw new MalformedException("'description' option field is missing", optionsBag);
        }
        final String description = JsMessageVisitor.extractStringFromStringExprNode(descriptionNode);
        @Nullable Node meaningNode = objectLiteralMap.getValueNode("meaning");
        final @Nullable String meaning = meaningNode == null ? null : JsMessageVisitor.extractStringFromStringExprNode(meaningNode);
        @Nullable Node alternateMessageIdNode = objectLiteralMap.getValueNode("alternate_message_id");
        final @Nullable String alternateMessageId = alternateMessageIdNode == null ? null : JsMessageVisitor.extractStringFromStringExprNode(alternateMessageIdNode);
        Node exampleValueNode = objectLiteralMap.getValueNode("example");
        final ObjectLiteralMap exampleObjectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(exampleValueNode);
        final ImmutableMap<String, String> placeholderExamplesMap = exampleObjectLiteralMap.extractAsStringToStringMap();
        Node originalCodeValueNode = objectLiteralMap.getValueNode("original_code");
        final ObjectLiteralMap originalCodeObjectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(originalCodeValueNode);
        final ImmutableMap<String, String> placeholderOriginalCodeMap = originalCodeObjectLiteralMap.extractAsStringToStringMap();
        final ImmutableSet placeholderNames = ImmutableSet.builder().addAll((Iterable)placeholderExamplesMap.keySet()).addAll((Iterable)placeholderOriginalCodeMap.keySet()).build();
        return new IcuTemplateOptions(){

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public @Nullable String getMeaning() {
                return meaning;
            }

            @Override
            public @Nullable String getAlternateMessageId() {
                return alternateMessageId;
            }

            @Override
            public ImmutableMap<String, String> getPlaceholderExampleMap() {
                return placeholderExamplesMap;
            }

            @Override
            public ImmutableMap<String, String> getPlaceholderOriginalCodeMap() {
                return placeholderOriginalCodeMap;
            }

            @Override
            public ImmutableSet<String> getPlaceholderNames() {
                return placeholderNames;
            }

            @Override
            public void checkForUnknownPlaceholders(Set<String> knownPlaceholders) throws MalformedException {
                exampleObjectLiteralMap.checkForUnexpectedKeys(knownPlaceholders, unknownName -> "Unknown placeholder: " + unknownName);
                originalCodeObjectLiteralMap.checkForUnexpectedKeys(knownPlaceholders, unknownName -> "Unknown placeholder: " + unknownName);
            }
        };
    }

    private static boolean extractBooleanStringKeyValue(@Nullable Node stringKeyNode) throws MalformedException {
        if (stringKeyNode == null) {
            return false;
        }
        Node valueNode = stringKeyNode.getOnlyChild();
        if (valueNode.isTrue()) {
            return true;
        }
        if (valueNode.isFalse()) {
            return false;
        }
        throw new MalformedException(stringKeyNode.getString() + ": Literal true or false expected", valueNode);
    }

    public static ObjectLiteralMap extractObjectLiteralMap(@Nullable Node objLit) throws MalformedException {
        if (objLit == null) {
            return new ObjectLiteralMapImpl((Map<String, Node>)ImmutableMap.of());
        }
        if (!objLit.isObjectLit()) {
            throw new MalformedException("object literal expected", objLit);
        }
        LinkedHashMap<String, Node> stringToStringKeyMap = new LinkedHashMap<String, Node>();
        for (Node stringKey = objLit.getFirstChild(); stringKey != null; stringKey = stringKey.getNext()) {
            if (!stringKey.isStringKey()) {
                throw new MalformedException("string key expected", stringKey);
            }
            String key = stringKey.getString();
            if (stringToStringKeyMap.containsKey(key)) {
                throw new MalformedException("duplicate string key: " + key, stringKey);
            }
            stringToStringKeyMap.put(stringKey.getString(), stringKey);
        }
        return new ObjectLiteralMapImpl(stringToStringKeyMap);
    }

    public static ImmutableList<JsMessage.Part> parseJsMessageTextIntoParts(String originalMsgText) throws JsMessage.PlaceholderFormatException {
        GoogGetMsgParsedText googGetMsgParsedText = JsMessageVisitor.extractGoogGetMsgParsedText(originalMsgText);
        return googGetMsgParsedText.getParts();
    }

    private static GoogGetMsgParsedText extractGoogGetMsgParsedText(final String originalMsgText) throws JsMessage.PlaceholderFormatException {
        String msgText = originalMsgText;
        ImmutableList.Builder partsBuilder = ImmutableList.builder();
        ImmutableSet.Builder placeholderNamesBuilder = ImmutableSet.builder();
        while (true) {
            int phEnd;
            int phBegin;
            if ((phBegin = msgText.indexOf("{$")) < 0) {
                partsBuilder.add((Object)JsMessage.StringPart.create(msgText));
                break;
            }
            if (phBegin > 0) {
                partsBuilder.add((Object)JsMessage.StringPart.create(msgText.substring(0, phBegin)));
            }
            if ((phEnd = msgText.indexOf("}", phBegin)) < 0) {
                throw new JsMessage.PlaceholderFormatException("Placeholder incorrectly formatted");
            }
            String phName = msgText.substring(phBegin + "{$".length(), phEnd);
            if (!JsMessage.isLowerCamelCaseWithNumericSuffixes(phName)) {
                throw new JsMessage.PlaceholderFormatException("Placeholder name not in lowerCamelCase: " + phName);
            }
            placeholderNamesBuilder.add((Object)phName);
            partsBuilder.add((Object)JsMessage.PlaceholderReference.createForJsName(phName));
            int nextPos = phEnd + "}".length();
            if (nextPos >= msgText.length()) break;
            msgText = msgText.substring(nextPos);
        }
        final ImmutableSet placeholderNames = placeholderNamesBuilder.build();
        final ImmutableList parts = partsBuilder.build();
        return new GoogGetMsgParsedText(){

            @Override
            public String getText() {
                return originalMsgText;
            }

            @Override
            public ImmutableSet<String> getPlaceholderNames() {
                return placeholderNames;
            }

            @Override
            public ImmutableList<JsMessage.Part> getParts() {
                return parts;
            }
        };
    }

    private void visitFallbackFunctionCall(NodeTraversal t, Node call) {
        if (!(call.hasXChildren(3) && JsMessageVisitor.isMessageIdentifier(call.getSecondChild()) && JsMessageVisitor.isMessageIdentifier(call.getLastChild()))) {
            this.compiler.report(JSError.make(call, BAD_FALLBACK_SYNTAX, new String[0]));
            return;
        }
        Node firstArg = call.getSecondChild();
        JsMessage firstMessage = this.getJsMessageFromNode(t, firstArg);
        if (firstMessage == null) {
            this.compiler.report(JSError.make(firstArg, FALLBACK_ARG_ERROR, firstArg.getQualifiedName()));
            return;
        }
        Node secondArg = firstArg.getNext();
        JsMessage secondMessage = this.getJsMessageFromNode(t, secondArg);
        if (secondMessage == null) {
            this.compiler.report(JSError.make(secondArg, FALLBACK_ARG_ERROR, secondArg.getQualifiedName()));
            return;
        }
        this.processMessageFallback(call, firstMessage, secondMessage);
    }

    protected abstract void processJsMessageDefinition(JsMessageDefinition var1);

    protected abstract void processIcuTemplateDefinition(IcuTemplateDefinition var1);

    void processMessageFallback(Node callNode, JsMessage message1, JsMessage message2) {
    }

    boolean isMessageName(String identifier) {
        return identifier.startsWith(MSG_PREFIX) || JsMessageVisitor.isScopedAliasesPrefix(identifier);
    }

    private static boolean isMessageIdentifier(Node node) {
        String qname = node.getQualifiedName();
        return qname != null && qname.contains(MSG_PREFIX);
    }

    private @Nullable JsMessage getJsMessageFromNode(NodeTraversal t, Node node) {
        String messageName = node.getQualifiedName();
        if (messageName == null || !messageName.contains(MSG_PREFIX)) {
            return null;
        }
        String messageKey = messageName.substring(messageName.indexOf(MSG_PREFIX));
        if (JsMessageVisitor.isUnnamedMessageName(messageKey)) {
            return this.getTrackedUnnamedMessage(t, messageName);
        }
        return this.getTrackedNormalMessage(messageKey);
    }

    private static boolean isUnnamedMessageName(String identifier) {
        return MSG_UNNAMED_PATTERN.matcher(identifier).matches();
    }

    protected void checkNode(@Nullable Node node, Token type) throws MalformedException {
        if (node == null) {
            throw new MalformedException("Expected node type " + type + "; found: null", node);
        }
        if (node.getToken() != type) {
            throw new MalformedException("Expected node type " + type + "; found: " + node.getToken(), node);
        }
    }

    public static boolean isScopedAliasesPrefix(String name) {
        return SCOPED_ALIASES_PREFIX_PATTERN.matcher(name).lookingAt();
    }

    public static String removeScopedAliasesPrefix(String name) {
        return SCOPED_ALIASES_PREFIX_PATTERN.matcher(name).replaceFirst(MSG_PREFIX);
    }

    private static class MessageLocation {
        private final JsMessage message;
        private final Node messageNode;

        private MessageLocation(JsMessage message, Node messageNode) {
            this.message = message;
            this.messageNode = messageNode;
        }
    }

    static class MalformedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Node node;

        MalformedException(String message, Node node) {
            super(message);
            this.node = node;
        }

        Node getNode() {
            return this.node;
        }
    }

    private static interface GoogGetMsgParsedText {
        public String getText();

        public ImmutableSet<String> getPlaceholderNames();

        public ImmutableList<JsMessage.Part> getParts();
    }

    private static class ObjectLiteralMapImpl
    implements ObjectLiteralMap {
        private final Map<String, Node> stringToStringKeyMap;
        private ImmutableMap<String, Node> valueMap = null;
        private ImmutableMap<String, String> stringMap = null;

        private ObjectLiteralMapImpl(Map<String, Node> stringToStringKeyMap) {
            this.stringToStringKeyMap = stringToStringKeyMap;
        }

        @Override
        public @Nullable Node getValueNode(String key) {
            Node stringKeyNode = this.stringToStringKeyMap.get(key);
            return stringKeyNode == null ? null : stringKeyNode.getOnlyChild();
        }

        @Override
        public boolean getBooleanValueOrFalse(String key) throws MalformedException {
            Node stringKeyNode = this.stringToStringKeyMap.get(key);
            return JsMessageVisitor.extractBooleanStringKeyValue(stringKeyNode);
        }

        @Override
        public ImmutableMap<String, Node> extractAsValueMap() {
            if (this.valueMap == null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<String, Node> entry : this.stringToStringKeyMap.entrySet()) {
                    builder.put((Object)entry.getKey(), (Object)entry.getValue().getOnlyChild());
                }
                this.valueMap = builder.buildOrThrow();
            }
            return this.valueMap;
        }

        @Override
        public ImmutableMap<String, String> extractAsStringToStringMap() throws MalformedException {
            if (this.stringMap == null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<String, Node> entry : this.stringToStringKeyMap.entrySet()) {
                    builder.put((Object)entry.getKey(), (Object)JsMessageVisitor.extractStringFromStringExprNode(entry.getValue().getOnlyChild()));
                }
                this.stringMap = builder.buildOrThrow();
            }
            return this.stringMap;
        }

        @Override
        public void checkForUnexpectedKeys(Set<String> expectedKeys, Function<String, String> createErrorMessage) throws MalformedException {
            for (String key : this.stringToStringKeyMap.keySet()) {
                if (expectedKeys.contains(key)) continue;
                throw new MalformedException(createErrorMessage.apply(key), this.stringToStringKeyMap.get(key));
            }
        }

        @Override
        public void checkForRequiredKeys(Set<String> requiredKeys, Function<String, MalformedException> createException) throws MalformedException {
            for (String requiredKey : requiredKeys) {
                if (this.stringToStringKeyMap.containsKey(requiredKey)) continue;
                throw createException.apply(requiredKey);
            }
        }
    }

    public static interface ObjectLiteralMap {
        public boolean getBooleanValueOrFalse(String var1) throws MalformedException;

        public ImmutableMap<String, Node> extractAsValueMap();

        public ImmutableMap<String, String> extractAsStringToStringMap() throws MalformedException;

        public @Nullable Node getValueNode(String var1);

        public void checkForUnexpectedKeys(Set<String> var1, Function<String, String> var2) throws MalformedException;

        public void checkForRequiredKeys(Set<String> var1, Function<String, MalformedException> var2) throws MalformedException;
    }

    private static interface IcuTemplateOptions {
        public String getDescription();

        public @Nullable String getMeaning();

        public @Nullable String getAlternateMessageId();

        public ImmutableMap<String, String> getPlaceholderExampleMap();

        public ImmutableMap<String, String> getPlaceholderOriginalCodeMap();

        public void checkForUnknownPlaceholders(Set<String> var1) throws MalformedException;

        public ImmutableSet<String> getPlaceholderNames();
    }

    private static interface JsMessageOptions {
        public boolean isEscapeLessThan();

        public boolean isUnescapeHtmlEntities();

        public ImmutableMap<String, String> getPlaceholderExampleMap();

        public ImmutableMap<String, String> getPlaceholderOriginalCodeMap();

        public void checkForUnknownPlaceholders(Set<String> var1) throws MalformedException;
    }

    static class ExtractedIcuTemplateParts {
        final ImmutableSet<String> extractedPlaceholderNames;
        final ImmutableList<JsMessage.Part> extractedParts;

        ExtractedIcuTemplateParts(ImmutableSet<String> extractedPlaceholderNames, ImmutableList<JsMessage.Part> extractedParts) {
            this.extractedPlaceholderNames = extractedPlaceholderNames;
            this.extractedParts = extractedParts;
        }
    }

    @VisibleForTesting
    static final class IcuMessageTemplateString {
        private final String template;

        IcuMessageTemplateString(String template) {
            this.template = template;
        }

        ExtractedIcuTemplateParts extractParts(Set<String> placholderNamesToExtract) {
            ImmutableSet.Builder extractedPlaceholderNames = ImmutableSet.builder();
            ImmutableList.Builder partsBuilder = ImmutableList.builder();
            Matcher matcher = ICU_PLACEHOLDER_RE.matcher(this.template);
            int remainingTemplateStartIndex = 0;
            while (matcher.find()) {
                String placeholderName = matcher.group(1);
                if (!placholderNamesToExtract.contains(placeholderName)) continue;
                extractedPlaceholderNames.add((Object)placeholderName);
                String nonPlaceholderPrefix = this.template.substring(remainingTemplateStartIndex, matcher.start());
                remainingTemplateStartIndex = matcher.end();
                partsBuilder.add((Object)JsMessage.StringPart.create(nonPlaceholderPrefix));
                partsBuilder.add((Object)JsMessage.PlaceholderReference.createForCanonicalName(placeholderName));
            }
            if (remainingTemplateStartIndex < this.template.length()) {
                String remainingTemplate = this.template.substring(remainingTemplateStartIndex);
                partsBuilder.add((Object)JsMessage.StringPart.create(remainingTemplate));
            }
            return new ExtractedIcuTemplateParts((ImmutableSet<String>)extractedPlaceholderNames.build(), (ImmutableList<JsMessage.Part>)partsBuilder.build());
        }
    }

    static interface InputForBuildJsMsg {
        public String getMessageKeyFromLhs();

        public String getSourceName();

        public String getMessageText();

        public ImmutableList<JsMessage.Part> getMessageParts();

        public Map<String, String> getPlaceholderExampleMap();

        public Map<String, String> getPlaceholderOriginalCodeMap();

        public String getDescription();

        public String getMeaning();

        public String getAlternateMessageId();
    }
}

