/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

public final class InjectTranspilationRuntimeLibraries
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean getterSetterSupported;

    public InjectTranspilationRuntimeLibraries(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.getterSetterSupported = !FeatureSet.ES3.contains(compiler.getOptions().getOutputFeatureSet());
    }

    @Override
    public void process(Node externs, Node root) {
        FeatureSet mustBeCompiledAway;
        FeatureSet used = FeatureSet.ES3;
        for (Node script = root.getFirstChild(); script != null; script = script.getNext()) {
            used = used.with(InjectTranspilationRuntimeLibraries.getScriptFeatures(script));
        }
        FeatureSet outputFeatures = this.compiler.getOptions().getOutputFeatureSet();
        if (!outputFeatures.contains(used)) {
            NodeTraversal.traverse(this.compiler, root, this);
        }
        if ((mustBeCompiledAway = used.without(outputFeatures)).contains(FeatureSet.Feature.TEMPLATE_LITERALS)) {
            TranspilationUtil.preloadTranspilationRuntimeFunction(this.compiler, "createtemplatetagfirstarg");
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.FOR_OF) || mustBeCompiledAway.contains(FeatureSet.Feature.ARRAY_DESTRUCTURING) || mustBeCompiledAway.contains(FeatureSet.Feature.OBJECT_PATTERN_REST)) {
            TranspilationUtil.preloadTranspilationRuntimeFunction(this.compiler, "makeIterator");
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.ARRAY_PATTERN_REST)) {
            TranspilationUtil.preloadTranspilationRuntimeFunction(this.compiler, "arrayFromIterator");
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.SPREAD_EXPRESSIONS) || mustBeCompiledAway.contains(FeatureSet.Feature.CLASS_EXTENDS)) {
            TranspilationUtil.preloadTranspilationRuntimeFunction(this.compiler, "arrayFromIterable");
        }
        if ((mustBeCompiledAway.contains(FeatureSet.Feature.OBJECT_LITERALS_WITH_SPREAD) || mustBeCompiledAway.contains(FeatureSet.Feature.OBJECT_PATTERN_REST)) && !outputFeatures.contains(FeatureSet.ES2015)) {
            this.compiler.ensureLibraryInjected("es6/object/assign", false);
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.CLASS_EXTENDS)) {
            TranspilationUtil.preloadTranspilationRuntimeFunction(this.compiler, "construct");
            TranspilationUtil.preloadTranspilationRuntimeFunction(this.compiler, "inherits");
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.CLASS_GETTER_SETTER)) {
            this.compiler.ensureLibraryInjected("util/global", false);
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.GENERATORS)) {
            this.compiler.ensureLibraryInjected("es6/generator_engine", false);
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.ASYNC_FUNCTIONS)) {
            this.compiler.ensureLibraryInjected("es6/execute_async_generator", false);
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.ASYNC_GENERATORS)) {
            this.compiler.ensureLibraryInjected("es6/async_generator_wrapper", false);
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.FOR_AWAIT_OF)) {
            this.compiler.ensureLibraryInjected("es6/util/makeasynciterator", false);
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.REST_PARAMETERS)) {
            this.compiler.ensureLibraryInjected("es6/util/restarguments", false);
        }
    }

    private static FeatureSet getScriptFeatures(Node script) {
        FeatureSet features = NodeUtil.getFeatureSetOfScript(script);
        return features != null ? features : FeatureSet.ES3;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETPROP: {
                if (n.isFromExterns()) break;
                this.visitGetprop(t, n);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (this.getterSetterSupported) break;
                TranspilationUtil.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                break;
            }
        }
    }

    private boolean isGlobalSymbol(NodeTraversal t, Node n) {
        if (!n.matchesName("Symbol")) {
            return false;
        }
        Var var = (Var)t.getScope().getVar("Symbol");
        return var == null || var.isGlobal();
    }

    private void visitGetprop(NodeTraversal t, Node n) {
        Node receiverNode = n.getFirstChild();
        if (this.isGlobalSymbol(t, receiverNode)) {
            this.compiler.ensureLibraryInjected("es6/symbol", false);
        }
    }
}

