/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import org.jspecify.nullness.Nullable;

class InferJSDocInfo
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;

    InferJSDocInfo(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        if (externs != null) {
            NodeTraversal.traverse(this.compiler, externs, this);
        }
        if (root != null) {
            NodeTraversal.traverse(this.compiler, root, this);
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: {
                this.inferJSDocForName(n, parent);
                return;
            }
            case STRING_KEY: 
            case GETTER_DEF: 
            case SETTER_DEF: 
            case MEMBER_FUNCTION_DEF: 
            case MEMBER_FIELD_DEF: {
                this.inferJSDocForObjectKeyOrClassField(n, parent);
                return;
            }
            case GETPROP: {
                this.inferJSDocForProperty(n, parent);
                return;
            }
        }
    }

    private void inferJSDocForName(Node n, Node parent) {
        JSType aliasedType;
        JSType inferredType;
        JSDocInfo typeDoc;
        if (parent == null) {
            return;
        }
        if (NodeUtil.isNameDeclaration(parent)) {
            JSDocInfo nameInfo = n.getJSDocInfo();
            typeDoc = nameInfo != null ? nameInfo : parent.getJSDocInfo();
            inferredType = n.getJSType();
            Node value = n.getFirstChild();
            aliasedType = value != null && value.isQualifiedName() ? value.getJSType() : null;
        } else if (NodeUtil.isFunctionDeclaration(parent) || NodeUtil.isClassDeclaration(parent)) {
            typeDoc = parent.getJSDocInfo();
            inferredType = parent.getJSType();
            aliasedType = null;
        } else if (parent.isAssign() && n.isFirstChildOf(parent)) {
            typeDoc = parent.getJSDocInfo();
            inferredType = n.getJSType();
            Node value = n.getNext();
            aliasedType = value.isQualifiedName() ? value.getJSType() : null;
        } else {
            return;
        }
        if (typeDoc == null) {
            return;
        }
        ObjectType objType = InferJSDocInfo.dereferenced(inferredType);
        if (InferJSDocInfo.shouldAttachJSDocToNominalTypeOrShape(objType, aliasedType)) {
            InferJSDocInfo.attachJSDocInfoToNominalTypeOrShape(objType, typeDoc, n.getString());
        }
    }

    private void inferJSDocForObjectKeyOrClassField(Node n, Node parent) {
        ObjectType owningType;
        JSDocInfo typeDoc = n.getJSDocInfo();
        if (typeDoc == null) {
            return;
        }
        if (parent.isClassMembers()) {
            FunctionType ctorType = JSType.toMaybeFunctionType(parent.getParent().getJSType());
            if (ctorType == null) {
                return;
            }
            owningType = n.isStaticMember() ? ctorType : (n.isMemberFieldDef() ? ctorType.getInstanceType() : ctorType.getPrototype());
        } else {
            owningType = InferJSDocInfo.dereferenced(parent.getJSType());
        }
        if (owningType == null) {
            return;
        }
        String propName = n.getString();
        if (owningType.hasOwnProperty(propName) && owningType.getPropertyJSDocInfo(propName) == null) {
            owningType.setPropertyJSDocInfo(propName, typeDoc);
        }
    }

    private void inferJSDocForProperty(Node n, Node parent) {
        ObjectType propType;
        JSType aliasedType;
        JSDocInfo typeDoc;
        if (parent.isAssign() && n.isFirstChildOf(parent)) {
            typeDoc = parent.getJSDocInfo();
            Node rhs = n.getNext();
            aliasedType = rhs.isQualifiedName() ? rhs.getJSType() : null;
        } else if (parent.isExprResult()) {
            typeDoc = n.getJSDocInfo();
            aliasedType = null;
        } else {
            return;
        }
        if (typeDoc == null || !typeDoc.containsDeclaration()) {
            return;
        }
        ObjectType lhsType = InferJSDocInfo.dereferenced(n.getFirstChild().getJSType());
        if (lhsType == null) {
            return;
        }
        String propName = n.getString();
        if (lhsType.hasOwnProperty(propName) && lhsType.getPropertyJSDocInfo(propName) == null) {
            lhsType.setPropertyJSDocInfo(propName, typeDoc);
        }
        if (InferJSDocInfo.shouldAttachJSDocToNominalTypeOrShape(propType = InferJSDocInfo.dereferenced(lhsType.getPropertyType(propName)), aliasedType)) {
            InferJSDocInfo.attachJSDocInfoToNominalTypeOrShape(propType, typeDoc, n.getQualifiedName());
        }
    }

    private static @Nullable ObjectType dereferenced(@Nullable JSType type) {
        return type == null ? null : type.dereference();
    }

    private static boolean shouldAttachJSDocToNominalTypeOrShape(@Nullable ObjectType type, @Nullable JSType aliasedType) {
        return type != null && type.getJSDocInfo() == null && !type.equals(aliasedType);
    }

    private static void attachJSDocInfoToNominalTypeOrShape(ObjectType objType, JSDocInfo docInfo, @Nullable String qName) {
        if (objType.isConstructor() || objType.isInterface()) {
            if (!InferJSDocInfo.isReferenceNameOf(objType, qName)) {
                return;
            }
            objType.setJSDocInfo(docInfo);
            JSType.toMaybeFunctionType(objType).getInstanceType().setJSDocInfo(docInfo);
        } else if (objType.isEnumType()) {
            EnumElementType elementType = objType.toMaybeEnumType().getElementsType();
            if (!InferJSDocInfo.isReferenceNameOf(elementType, qName)) {
                return;
            }
            objType.setJSDocInfo(docInfo);
            elementType.setJSDocInfo(docInfo);
        } else if (!objType.isNativeObjectType() && objType.isFunctionType()) {
            objType.setJSDocInfo(docInfo);
        }
    }

    private static boolean isReferenceNameOf(ObjectType type, String name) {
        return type.hasReferenceName() && type.getReferenceName().equals(name);
    }
}

