/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;

class Es6TemplateLiterals {
    private static final String TEMPLATELIT_VAR = "$jscomp$templatelit$";
    private final AstFactory astFactory;
    private final AbstractCompiler compiler;
    private final StaticScope namespace;

    Es6TemplateLiterals(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.namespace = this.compiler.getTranspilationNamespace();
    }

    void visitTemplateLiteral(NodeTraversal t, Node n) {
        int length = n.getChildCount();
        if (length == 0) {
            n.replaceWith(this.astFactory.createString("\"\""));
        } else {
            Node first = n.removeFirstChild();
            Preconditions.checkState((first.isTemplateLitString() && first.getCookedString() != null ? 1 : 0) != 0);
            Node firstStr = this.astFactory.createString(first.getCookedString());
            if (length == 1) {
                n.replaceWith(firstStr);
            } else {
                Node add = this.astFactory.createAdd(firstStr, n.removeFirstChild().removeFirstChild());
                for (int i = 2; i < length; ++i) {
                    Node child = n.removeFirstChild();
                    if (child.isTemplateLitString()) {
                        Preconditions.checkState((child.getCookedString() != null ? 1 : 0) != 0);
                        if (child.getCookedString().isEmpty()) continue;
                        if (i == 2 && first.getCookedString().isEmpty()) {
                            add = add.getSecondChild().detach();
                        }
                    }
                    add = this.astFactory.createAdd(add, child.isTemplateLitString() ? this.astFactory.createString(child.getCookedString()) : child.removeFirstChild());
                }
                n.replaceWith(add.srcrefTreeIfMissing(n));
            }
        }
        t.reportCodeChange();
    }

    void visitTaggedTemplateLiteral(NodeTraversal t, Node n, Node insertBefore) {
        Node callTemplateTagArgCreator;
        Node templateLit = n.getLastChild();
        Node siteObject = this.createCookedStringArray(templateLit);
        if (Es6TemplateLiterals.cookedAndRawStringsSame(templateLit)) {
            callTemplateTagArgCreator = this.astFactory.createCall(this.astFactory.createQName(this.namespace, "$jscomp.createTemplateTagFirstArg"), AstFactory.type(siteObject), siteObject.cloneTree());
        } else {
            Node raw = this.createRawStringArray(templateLit);
            callTemplateTagArgCreator = this.astFactory.createCall(this.astFactory.createQName(this.namespace, "$jscomp.createTemplateTagFirstArgWithRaw"), AstFactory.type(siteObject), siteObject.cloneTree(), raw);
        }
        JSDocInfo.Builder jsDocInfoBuilder = JSDocInfo.builder();
        jsDocInfoBuilder.recordNoInline();
        JSDocInfo info = jsDocInfoBuilder.build();
        CompilerInput input = t.getInput();
        String uniqueId = this.compiler.getUniqueIdSupplier().getUniqueId(input);
        Node tagFnFirstArgDeclaration = this.astFactory.createSingleVarNameDeclaration(TEMPLATELIT_VAR + uniqueId, callTemplateTagArgCreator).setJSDocInfo(info).srcrefTreeIfMissing(n);
        tagFnFirstArgDeclaration.insertBefore(insertBefore);
        t.reportCodeChange(tagFnFirstArgDeclaration);
        Node tagFnFirstArg = tagFnFirstArgDeclaration.getFirstChild().cloneNode();
        Node call = this.astFactory.createCall(n.removeFirstChild(), AstFactory.type(n), tagFnFirstArg);
        for (Node child = templateLit.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isTemplateLitString()) continue;
            call.addChildToBack(child.removeFirstChild());
        }
        call.srcrefTreeIfMissing(templateLit);
        call.putBooleanProp(Node.FREE_CALL, !call.getFirstChild().isGetProp());
        n.replaceWith(call);
        t.reportCodeChange();
    }

    private Node createRawStringArray(Node n) {
        Node array = this.astFactory.createArraylit(new Node[0]);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString()) continue;
            array.addChildToBack(this.astFactory.createString(child.getRawString()));
        }
        return array;
    }

    private Node createCookedStringArray(Node n) {
        Color templateArrayType = this.astFactory.isAddingColors() ? this.compiler.getColorRegistry().get(StandardColors.I_TEMPLATE_ARRAY_ID) : null;
        Node array = this.astFactory.createArraylit(new Node[0]).setColor(templateArrayType);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString()) continue;
            if (child.getCookedString() != null) {
                array.addChildToBack(this.astFactory.createString(child.getCookedString()));
                continue;
            }
            array.addChildToBack(this.astFactory.createVoid(this.astFactory.createNumber(0.0)));
        }
        return array;
    }

    private static boolean cookedAndRawStringsSame(Node n) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString() || child.getCookedString() != null && child.getCookedString().equals(child.getRawString())) continue;
            return false;
        }
        return true;
    }
}

