/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.parsing.ParsingUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;

public final class Es6RewriteDestructuring
implements NodeTraversal.Callback,
CompilerPass {
    public static final DiagnosticType UNEXPECTED_DESTRUCTURING_REST_PARAMETER = DiagnosticType.error("JSC_UNEXPECTED_DESTRUCTURING_REST_PARAMETER", "Es6RewriteDestructuring not expecting object pattern rest parameter");
    private final AbstractCompiler compiler;
    private final ObjectDestructuringRewriteMode rewriteMode;
    private final AstFactory astFactory;
    private final StaticScope namespace;
    private final FeatureSet featuresToTriggerRunningPass;
    private final FeatureSet featuresToMarkAsRemoved;
    private final Deque<PatternNestingLevel> patternNestingStack = new ArrayDeque<PatternNestingLevel>();
    static final String DESTRUCTURING_TEMP_VAR = "$jscomp$destructuring$var";
    private int destructuringVarCounter = 0;

    private Es6RewriteDestructuring(Builder builder) {
        this.compiler = builder.compiler;
        this.rewriteMode = builder.rewriteMode;
        this.astFactory = this.compiler.createAstFactory();
        this.namespace = this.compiler.getTranspilationNamespace();
        switch (this.rewriteMode) {
            case REWRITE_ALL_OBJECT_PATTERNS: {
                this.featuresToTriggerRunningPass = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.DEFAULT_PARAMETERS, FeatureSet.Feature.ARRAY_DESTRUCTURING, FeatureSet.Feature.ARRAY_PATTERN_REST, FeatureSet.Feature.OBJECT_DESTRUCTURING);
                this.featuresToMarkAsRemoved = this.featuresToTriggerRunningPass.with(FeatureSet.Feature.OBJECT_PATTERN_REST);
                break;
            }
            case REWRITE_OBJECT_REST: {
                this.featuresToMarkAsRemoved = this.featuresToTriggerRunningPass = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.OBJECT_PATTERN_REST);
                break;
            }
            default: {
                throw new AssertionError((Object)("Es6RewriteDestructuring cannot handle ObjectDestructuringRewriteMode " + this.rewriteMode));
            }
        }
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.patternNestingStack.isEmpty());
        NodeTraversal.traverse(this.compiler, root, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, root, this.featuresToMarkAsRemoved);
        Preconditions.checkState((boolean)this.patternNestingStack.isEmpty());
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(n);
            return scriptFeatures.containsAtLeastOneOf(this.featuresToTriggerRunningPass);
        }
        switch (n.getToken()) {
            case FUNCTION: {
                this.ensureArrowFunctionsHaveBlockBodies(t, n);
                break;
            }
            case PARAM_LIST: {
                this.pullDestructuringOutOfParams(n, parent);
                break;
            }
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                boolean hasRest;
                boolean bl = hasRest = n.isObjectPattern() && n.hasChildren() && n.getLastChild().isRest();
                if (!this.patternNestingStack.isEmpty() && hasRest) {
                    for (PatternNestingLevel level : this.patternNestingStack) {
                        if (level.hasNestedObjectRest) break;
                        level.hasNestedObjectRest = true;
                    }
                    this.patternNestingStack.peekLast().hasNestedObjectRest = true;
                }
                this.patternNestingStack.addLast(new PatternNestingLevel(n, hasRest));
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                this.visitPattern(t, n);
                if (n != this.patternNestingStack.getLast().pattern) break;
                this.patternNestingStack.removeLast();
                break;
            }
        }
    }

    private void ensureArrowFunctionsHaveBlockBodies(NodeTraversal t, Node function) {
        Node body = function.getLastChild();
        if (!body.isBlock()) {
            body.detach();
            Node replacement = IR.block(IR.returnNode(body)).srcrefTreeIfMissing(body);
            function.addChildToBack(replacement);
            t.reportCodeChange();
        }
    }

    private void pullDestructuringOutOfParams(Node paramList, Node function) {
        Node insertSpot = null;
        Node body = function.getLastChild();
        Node next = null;
        Node param = paramList.getFirstChild();
        while (param != null) {
            next = param.getNext();
            if (param.isDefaultValue()) {
                Node newParam;
                Node nameOrPattern = param.removeFirstChild();
                JSDocInfo jsDoc = nameOrPattern.getJSDocInfo();
                nameOrPattern.setJSDocInfo(null);
                Node defaultValue = param.removeFirstChild();
                boolean isNoop = false;
                if (nameOrPattern.isName()) {
                    if (defaultValue.isName()) {
                        isNoop = "undefined".equals(defaultValue.getString());
                    } else if (defaultValue.isVoid()) {
                        isNoop = NodeUtil.isImmutableValue(defaultValue.getFirstChild());
                    }
                }
                if (isNoop) {
                    newParam = nameOrPattern.cloneTree();
                } else {
                    newParam = nameOrPattern.isName() ? nameOrPattern : this.createTempVarNameNode(this.getTempVariableName(), AstFactory.type(nameOrPattern));
                    Node lhs = nameOrPattern.cloneTree();
                    Node rhs = this.defaultValueHook(newParam.cloneTree(), defaultValue);
                    Node newStatement = nameOrPattern.isName() ? IR.exprResult(this.astFactory.createAssign(lhs, rhs)) : IR.var(lhs, rhs);
                    newStatement.srcrefTreeIfMissing(param);
                    if (insertSpot == null) {
                        body.addChildToFront(newStatement);
                    } else {
                        newStatement.insertAfter(insertSpot);
                    }
                    insertSpot = newStatement;
                }
                param.replaceWith(newParam);
                newParam.setJSDocInfo(jsDoc);
                this.compiler.reportChangeToChangeScope(function);
            } else if (param.isDestructuringPattern()) {
                insertSpot = this.replacePatternParamWithTempVar(function, insertSpot, param, this.getTempVariableName());
                this.compiler.reportChangeToChangeScope(function);
            } else if (param.isRest() && param.getFirstChild().isDestructuringPattern()) {
                insertSpot = this.replacePatternParamWithTempVar(function, insertSpot, param.getFirstChild(), this.getTempVariableName());
                this.compiler.reportChangeToChangeScope(function);
            }
            param = next;
        }
    }

    private Node replacePatternParamWithTempVar(Node function, Node insertSpot, Node patternParam, String tempVarName) {
        AstFactory.Type paramType = AstFactory.type(patternParam);
        Node newParam = this.createTempVarNameNode(tempVarName, paramType);
        newParam.setJSDocInfo(patternParam.getJSDocInfo());
        patternParam.replaceWith(newParam);
        Node newDecl = IR.var(patternParam, this.createTempVarNameNode(tempVarName, paramType));
        newDecl.srcrefTreeIfMissing(patternParam);
        if (insertSpot == null) {
            function.getLastChild().addChildToFront(newDecl);
        } else {
            newDecl.insertAfter(insertSpot);
        }
        return newDecl;
    }

    private Node createTempVarNameNode(String name, AstFactory.Type type) {
        return this.astFactory.createConstantName(name, type);
    }

    private String getTempVariableName() {
        return DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
    }

    private void visitPattern(NodeTraversal t, Node pattern) {
        Node parent = pattern.getParent();
        switch (parent.getToken()) {
            case DESTRUCTURING_LHS: {
                Node declaration = parent.getParent();
                Node declarationParent = declaration.getParent();
                if (declarationParent.isVanillaFor()) {
                    this.visitDestructuringPatternInVanillaForInnerVars(t, pattern);
                    break;
                }
                if (NodeUtil.isEnhancedFor(declarationParent)) {
                    this.visitDestructuringPatternInEnhancedForInnerVars(pattern);
                    break;
                }
                this.replacePattern(t, pattern, pattern.getNext(), declaration, declaration);
                break;
            }
            case ASSIGN: {
                if (parent.getParent().isExprResult()) {
                    this.replacePattern(t, pattern, pattern.getNext(), parent, parent.getParent());
                    break;
                }
                this.wrapAssignOrDestructuringInCallToArrow(t, parent);
                break;
            }
            case ARRAY_PATTERN: 
            case OBJECT_REST: 
            case ITER_REST: 
            case STRING_KEY: 
            case DEFAULT_VALUE: 
            case COMPUTED_PROP: {
                break;
            }
            case FOR_OF: 
            case FOR_IN: 
            case FOR_AWAIT_OF: {
                this.visitDestructuringPatternInEnhancedForWithOuterVars(pattern);
                break;
            }
            case CATCH: {
                this.visitDestructuringPatternInCatch(t, pattern);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected parent");
            }
        }
    }

    private void replacePattern(NodeTraversal t, Node pattern, Node rhs, Node parent, Node nodeToDetach) {
        Preconditions.checkArgument((boolean)NodeUtil.isStatement(nodeToDetach), (Object)nodeToDetach);
        switch (pattern.getToken()) {
            case ARRAY_PATTERN: {
                this.replaceArrayPattern(t, pattern, rhs, parent, nodeToDetach);
                break;
            }
            case OBJECT_PATTERN: {
                this.replaceObjectPattern(t, pattern, rhs, parent, nodeToDetach);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    private void replaceObjectPattern(NodeTraversal t, Node objectPattern, Node rhs, Node parent, Node nodeToDetach) {
        String tempVarName = this.getTempVariableName();
        AstFactory.Type tempVarType = AstFactory.type(objectPattern);
        String restTempVarName = null;
        ArrayList<Node> propsToDeleteForRest = null;
        if (objectPattern.hasChildren() && objectPattern.getLastChild().isRest()) {
            propsToDeleteForRest = new ArrayList<Node>();
            restTempVarName = this.getTempVariableName();
        } else if (this.rewriteMode == ObjectDestructuringRewriteMode.REWRITE_OBJECT_REST && !this.patternNestingStack.peekLast().hasNestedObjectRest) {
            --this.destructuringVarCounter;
            return;
        }
        Node tempDecl = IR.var(this.createTempVarNameNode(tempVarName, tempVarType), rhs.detach()).srcrefTreeIfMissing(objectPattern);
        if (parent.isConst()) {
            JSDocInfo.Builder jsDoc = JSDocInfo.builder();
            jsDoc.recordConstancy();
            tempDecl.setJSDocInfo(jsDoc.build());
        }
        tempDecl.insertBefore(nodeToDetach);
        Node child = objectPattern.getFirstChild();
        while (child != null) {
            Node newNode;
            Node newRHS;
            Node newLHS;
            Node next = child.getNext();
            if (child.isStringKey()) {
                Node tempVarNameNode = this.createTempVarNameNode(tempVarName, tempVarType);
                Node getprop = child.isQuotedStringKey() ? this.astFactory.createGetElem(tempVarNameNode, this.astFactory.createString(child.getString())) : this.astFactory.createGetProp(tempVarNameNode, child.getString(), tempVarType);
                Node value = child.removeFirstChild();
                if (!value.isDefaultValue()) {
                    newLHS = value;
                    newRHS = getprop;
                } else {
                    newLHS = value.removeFirstChild();
                    Node defaultValue = value.removeFirstChild();
                    newRHS = this.defaultValueHook(getprop, defaultValue);
                }
                if (propsToDeleteForRest != null) {
                    propsToDeleteForRest.add(child);
                }
            } else if (child.isComputedProp()) {
                Node defaultValue;
                boolean hasDefault = child.getLastChild().isDefaultValue();
                Node propExpr = child.removeFirstChild();
                if (hasDefault) {
                    Node defaultNode = child.getLastChild();
                    newLHS = defaultNode.removeFirstChild();
                    defaultValue = defaultNode.removeFirstChild();
                } else {
                    newLHS = child.removeFirstChild();
                    defaultValue = null;
                }
                if (propsToDeleteForRest != null) {
                    String exprEvalTempVarName = this.getTempVariableName();
                    Node exprEvalTempVarModel = this.createTempVarNameNode(exprEvalTempVarName, AstFactory.type(propExpr));
                    Node exprEvalDecl = IR.var(exprEvalTempVarModel.cloneNode(), propExpr);
                    exprEvalDecl.srcrefTreeIfMissing(child);
                    exprEvalDecl.insertBefore(nodeToDetach);
                    propExpr = exprEvalTempVarModel.cloneNode();
                    propsToDeleteForRest.add(exprEvalTempVarModel.cloneNode());
                }
                if (hasDefault) {
                    Node getelem = this.astFactory.createGetElem(this.createTempVarNameNode(tempVarName, tempVarType), propExpr);
                    String intermediateTempVarName = this.getTempVariableName();
                    Node intermediateDecl = IR.var(this.createTempVarNameNode(intermediateTempVarName, AstFactory.type(getelem)), getelem);
                    intermediateDecl.srcrefTreeIfMissing(child);
                    intermediateDecl.insertBefore(nodeToDetach);
                    newRHS = this.defaultValueHook(this.createTempVarNameNode(intermediateTempVarName, AstFactory.type(getelem)), defaultValue);
                } else {
                    newRHS = this.astFactory.createGetElem(this.createTempVarNameNode(tempVarName, AstFactory.type(newLHS)), propExpr);
                }
            } else if (child.isRest()) {
                if (next != null) {
                    throw new IllegalStateException("object rest may not be followed by any properties");
                }
                Node assignCall = this.astFactory.createCall(this.astFactory.createQName(this.namespace, "Object.assign"), AstFactory.type(StandardColors.TOP_OBJECT), new Node[0]);
                assignCall.addChildToBack(this.astFactory.createObjectLit(new Node[0]));
                assignCall.addChildToBack(this.createTempVarNameNode(tempVarName, tempVarType));
                Node restTempDecl = IR.var(this.createTempVarNameNode(restTempVarName, tempVarType), assignCall);
                restTempDecl.srcrefTreeIfMissing(objectPattern);
                restTempDecl.insertAfter(tempDecl);
                Node restName = child.getOnlyChild();
                newLHS = restName.getString().startsWith(DESTRUCTURING_TEMP_VAR) ? this.createTempVarNameNode(restName.getString(), AstFactory.type(restName)) : this.astFactory.createName(restName.getString(), AstFactory.type(restName));
                newRHS = this.objectPatternRestRHS(objectPattern, child, restTempVarName, propsToDeleteForRest);
            } else {
                throw new IllegalStateException("unexpected child");
            }
            if (NodeUtil.isNameDeclaration(parent)) {
                if (parent.isConst()) {
                    newLHS.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                }
                newNode = IR.declaration(newLHS, newRHS, parent.getToken());
            } else if (parent.isAssign()) {
                newNode = IR.exprResult(this.astFactory.createAssign(newLHS, newRHS));
            } else {
                throw new IllegalStateException("not reached");
            }
            newNode.srcrefTreeIfMissing(child);
            newNode.insertBefore(nodeToDetach);
            this.visit(t, newLHS, newLHS.getParent());
            child = next;
        }
        nodeToDetach.detach();
        t.reportCodeChange();
    }

    private Node objectPatternRestRHS(Node objectPattern, Node rest, String restTempVarName, ArrayList<Node> statedProperties) {
        Preconditions.checkArgument((objectPattern.getLastChild() == rest ? 1 : 0) != 0);
        Node restTempVarModel = this.createTempVarNameNode(restTempVarName, AstFactory.type(objectPattern));
        Node result = restTempVarModel.cloneNode();
        if (!statedProperties.isEmpty()) {
            Iterator<Node> propItr = statedProperties.iterator();
            Node comma = this.deletionNodeForRestProperty(restTempVarModel.cloneNode(), propItr.next());
            while (propItr.hasNext()) {
                comma = this.astFactory.createComma(comma, this.deletionNodeForRestProperty(restTempVarModel.cloneNode(), propItr.next()));
            }
            result = this.astFactory.createComma(comma, result);
        }
        result.srcrefTreeIfMissing(rest);
        return result;
    }

    private Node deletionNodeForRestProperty(Node restTempVarNameNode, Node property) {
        Node get;
        switch (property.getToken()) {
            case STRING_KEY: {
                get = property.isQuotedStringKey() ? this.astFactory.createGetElem(restTempVarNameNode, this.astFactory.createString(property.getString())) : this.astFactory.createGetPropWithUnknownType(restTempVarNameNode, property.getString());
                break;
            }
            case NAME: {
                get = this.astFactory.createGetElem(restTempVarNameNode, property);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected property to delete node: " + property.toStringTree());
            }
        }
        return this.astFactory.createDelProp(get);
    }

    private void replaceArrayPattern(NodeTraversal t, Node arrayPattern, Node rhs, Node parent, Node nodeToDetach) {
        if (this.rewriteMode == ObjectDestructuringRewriteMode.REWRITE_OBJECT_REST && (this.patternNestingStack.isEmpty() || !this.patternNestingStack.peekLast().hasNestedObjectRest)) {
            return;
        }
        String tempVarName = this.getTempVariableName();
        Node makeIteratorCall = this.astFactory.createJSCompMakeIteratorCall(rhs.detach(), this.namespace);
        Node tempDecl = this.astFactory.createSingleVarNameDeclaration(tempVarName, makeIteratorCall);
        Node tempVarModel = tempDecl.getFirstChild();
        tempDecl.srcrefTreeIfMissing(arrayPattern);
        tempDecl.insertBefore(nodeToDetach);
        Node child = arrayPattern.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (child.isEmpty()) {
                Node nextCall = IR.exprResult(this.astFactory.createCallWithUnknownType(this.astFactory.createGetProp(tempVarModel.cloneNode(), "next", AstFactory.type(StandardColors.TOP_OBJECT)), new Node[0]));
                nextCall.srcrefTreeIfMissing(child);
                nextCall.insertBefore(nodeToDetach);
            } else {
                Node newNode;
                Node newRHS;
                Node newLHS;
                if (child.isDefaultValue()) {
                    String nextVarName = this.getTempVariableName();
                    Node nextCallDotValue = this.astFactory.createGetPropWithUnknownType(this.astFactory.createCallWithUnknownType(this.astFactory.createGetPropWithUnknownType(tempVarModel.cloneNode(), "next"), new Node[0]), "value");
                    AstFactory.Type nextVarType = AstFactory.type(nextCallDotValue);
                    Node var = IR.var(this.createTempVarNameNode(nextVarName, nextVarType), nextCallDotValue);
                    var.srcrefTreeIfMissing(child);
                    var.insertBefore(nodeToDetach);
                    newLHS = child.removeFirstChild();
                    newRHS = this.defaultValueHook(this.createTempVarNameNode(nextVarName, nextVarType), child.getLastChild().detach());
                } else if (child.isRest()) {
                    newLHS = child.removeFirstChild();
                    newRHS = this.astFactory.createJscompArrayFromIteratorCall(tempVarModel.cloneNode(), this.namespace);
                } else {
                    newLHS = child.detach();
                    newRHS = this.astFactory.createGetProp(this.astFactory.createCallWithUnknownType(this.astFactory.createGetPropWithUnknownType(tempVarModel.cloneNode(), "next"), new Node[0]), "value", AstFactory.type(child));
                }
                if (parent.isAssign()) {
                    Node assignment = this.astFactory.createAssign(newLHS, newRHS);
                    newNode = IR.exprResult(assignment);
                } else {
                    newNode = IR.declaration(newLHS, newRHS, parent.getToken());
                }
                newNode.srcrefTreeIfMissing(arrayPattern);
                newNode.insertBefore(nodeToDetach);
                this.visit(t, newLHS, newLHS.getParent());
            }
            child = next;
        }
        nodeToDetach.detach();
        t.reportCodeChange();
    }

    private void wrapAssignOrDestructuringInCallToArrow(NodeTraversal t, Node assignment) {
        String tempVarName = this.getTempVariableName();
        Node rhs = assignment.getLastChild().detach();
        Node tempVarModel = this.createTempVarNameNode(tempVarName, AstFactory.type(rhs));
        Node newAssignment = IR.let(tempVarModel.cloneNode(), rhs);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
        Node replacementExpr = this.astFactory.createAssign(assignment.removeFirstChild(), tempVarModel.cloneNode());
        Node exprResult = IR.exprResult(replacementExpr);
        Node returnNode = IR.returnNode(tempVarModel.cloneNode());
        Node block = IR.block(newAssignment, exprResult, returnNode);
        Node arrowFn = this.astFactory.createZeroArgFunction("", block, null);
        arrowFn.setIsArrowFunction(true);
        Node call = this.astFactory.createCall(arrowFn, AstFactory.type(rhs), new Node[0]);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.ARROW_FUNCTIONS, this.compiler);
        call.srcrefTreeIfMissing(assignment);
        call.putBooleanProp(Node.FREE_CALL, true);
        assignment.replaceWith(call);
        NodeUtil.markNewScopesChanged(call, this.compiler);
        this.replacePattern(t, replacementExpr.getFirstChild(), replacementExpr.getLastChild(), replacementExpr, exprResult);
    }

    private void visitDestructuringPatternInVanillaForInnerVars(NodeTraversal t, Node pattern) {
        Preconditions.checkArgument((boolean)pattern.isDestructuringPattern());
        Node destructuringLhs = pattern.getParent();
        Node declaration = destructuringLhs.getParent();
        Node insertionPoint = declaration.getParent();
        while (insertionPoint.getParent().isLabel()) {
            insertionPoint = insertionPoint.getParent();
        }
        switch (declaration.getToken()) {
            case CONST: {
                Node block = IR.block().srcref(insertionPoint);
                insertionPoint.replaceWith(block);
                block.addChildToBack(insertionPoint);
            }
            case VAR: {
                Node c = declaration.getFirstChild();
                while (c != destructuringLhs) {
                    Node newDeclaration = declaration.cloneNode();
                    newDeclaration.addChildToBack(c.detach());
                    newDeclaration.insertBefore(insertionPoint);
                    c = declaration.getFirstChild();
                }
                Node newDeclaration = declaration.cloneNode();
                newDeclaration.addChildToBack(destructuringLhs.detach());
                newDeclaration.insertBefore(insertionPoint);
                this.replacePattern(t, pattern, pattern.getNext(), newDeclaration, newDeclaration);
                if (declaration.hasChildren()) break;
                declaration.replaceWith(IR.empty());
                break;
            }
            case LET: {
                ParsingUtil.getParamOrPatternNames(pattern, name -> name.cloneNode().insertBefore(destructuringLhs));
                Node unusedVar = this.astFactory.createNameWithUnknownType(this.getTempVariableName() + "$unused").srcref(destructuringLhs);
                destructuringLhs.replaceWith(unusedVar);
                unusedVar.addChildToBack(destructuringLhs);
                this.wrapAssignOrDestructuringInCallToArrow(t, destructuringLhs);
                break;
            }
            default: {
                throw new IllegalStateException(declaration.toString());
            }
        }
        this.compiler.reportChangeToEnclosingScope(insertionPoint);
        NodeUtil.markNewScopesChanged(insertionPoint, this.compiler);
    }

    private void visitDestructuringPatternInEnhancedForInnerVars(Node pattern) {
        Preconditions.checkArgument((boolean)pattern.isDestructuringPattern());
        String tempVarName = this.getTempVariableName();
        Node destructuringLhs = pattern.getParent();
        Preconditions.checkState((boolean)destructuringLhs.isDestructuringLhs());
        Node declarationNode = destructuringLhs.getParent();
        Node forNode = declarationNode.getParent();
        Preconditions.checkState((boolean)NodeUtil.isEnhancedFor(forNode));
        Node block = forNode.getLastChild();
        destructuringLhs.replaceWith(this.createTempVarNameNode(tempVarName, AstFactory.type(pattern)).srcref(pattern));
        Token declarationType = declarationNode.getToken();
        Node decl = IR.declaration(pattern.detach(), this.createTempVarNameNode(tempVarName, AstFactory.type(pattern)), declarationType);
        decl.srcrefTreeIfMissing(pattern);
        Node newBlock = IR.block(decl);
        block.replaceWith(newBlock);
        newBlock.addChildToBack(block);
    }

    private void visitDestructuringPatternInEnhancedForWithOuterVars(Node pattern) {
        Preconditions.checkArgument((boolean)pattern.isDestructuringPattern());
        String tempVarName = this.getTempVariableName();
        Node forNode = pattern.getParent();
        Node block = forNode.getLastChild();
        Node name = this.createTempVarNameNode(tempVarName, AstFactory.type(pattern));
        Node decl = IR.var(name);
        decl.srcrefTreeIfMissing(pattern);
        decl.insertBefore(forNode);
        Node clonedName = name.cloneNode();
        clonedName.srcrefTreeIfMissing(pattern);
        pattern.replaceWith(clonedName);
        Node exprResult = IR.exprResult(this.astFactory.createAssign(pattern, this.createTempVarNameNode(tempVarName, AstFactory.type(pattern))));
        exprResult.srcrefTreeIfMissing(pattern);
        block.addChildToFront(exprResult);
    }

    private void visitDestructuringPatternInCatch(NodeTraversal t, Node pattern) {
        String tempVarName = this.getTempVariableName();
        Node catchBlock = pattern.getNext();
        AstFactory.Type patternType = AstFactory.type(pattern);
        pattern.replaceWith(this.createTempVarNameNode(tempVarName, patternType));
        catchBlock.addChildToFront(IR.declaration(pattern, this.createTempVarNameNode(tempVarName, patternType), Token.LET));
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
    }

    private Node defaultValueHook(Node getprop, Node defaultValue) {
        Node undefined = this.astFactory.createUndefinedValue();
        undefined.makeNonIndexable();
        Node getpropClone = getprop.cloneTree().setColor(getprop.getColor());
        return this.astFactory.createHook(this.astFactory.createSheq(getprop, undefined), defaultValue, getpropClone);
    }

    private static final class PatternNestingLevel {
        final Node pattern;
        boolean hasNestedObjectRest;

        public PatternNestingLevel(Node pattern, boolean hasNestedRest) {
            this.pattern = pattern;
            this.hasNestedObjectRest = hasNestedRest;
        }
    }

    static class Builder {
        private final AbstractCompiler compiler;
        private ObjectDestructuringRewriteMode rewriteMode = ObjectDestructuringRewriteMode.REWRITE_ALL_OBJECT_PATTERNS;

        public Builder(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @CanIgnoreReturnValue
        public Builder setDestructuringRewriteMode(ObjectDestructuringRewriteMode rewriteMode) {
            this.rewriteMode = rewriteMode;
            return this;
        }

        public Es6RewriteDestructuring build() {
            return new Es6RewriteDestructuring(this);
        }
    }

    static enum ObjectDestructuringRewriteMode {
        REWRITE_ALL_OBJECT_PATTERNS,
        REWRITE_OBJECT_REST;

    }
}

