/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.debugging.sourcemap.FilePosition;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.TypedCodeGenerator;
import com.google.javascript.jscomp.base.JSCompDoubles;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jspecify.nullness.Nullable;

public final class CodePrinter {
    private static SourceAndMappings toSource(Node root, Format outputFormat, CompilerOptions options, @Nullable LicenseTracker licenseTracker, boolean tagAsTypeSummary, boolean tagAsStrict, boolean lineBreak, Builder.CodeGeneratorFactory codeGeneratorFactory) {
        Preconditions.checkState((options.sourceMapDetailLevel != null ? 1 : 0) != 0);
        MappedCodePrinter mcp = outputFormat == Format.COMPACT ? new CompactCodePrinter(lineBreak, options.lineLengthThreshold, options.shouldGatherSourceMapInfo(), options.sourceMapDetailLevel, licenseTracker) : new PrettyCodePrinter(options.lineLengthThreshold, options.shouldGatherSourceMapInfo(), options.sourceMapDetailLevel, licenseTracker);
        CodeGenerator cg = codeGeneratorFactory.getCodeGenerator(outputFormat, mcp);
        if (tagAsTypeSummary) {
            cg.tagAsTypeSummary();
        }
        if (tagAsStrict) {
            cg.tagAsStrict();
        }
        cg.add(root);
        mcp.endFile();
        SourceAndMappings result = new SourceAndMappings();
        result.source = mcp.getCode();
        if (options.shouldGatherSourceMapInfo()) {
            result.mappings = mcp.getSourceMappings(result.source);
        }
        return result;
    }

    private CodePrinter() {
    }

    public static class SourceAndMappings {
        String source;
        @Nullable List<SourceMap.Mapping> mappings;
    }

    public static enum Format {
        COMPACT,
        PRETTY,
        TYPED;


        static Format fromOptions(CompilerOptions options, boolean outputTypes, boolean prettyPrint) {
            if (outputTypes) {
                return TYPED;
            }
            if (prettyPrint || options.getOutputFeatureSet().contains(FeatureSet.Feature.TYPE_ANNOTATION)) {
                return PRETTY;
            }
            return COMPACT;
        }
    }

    public static final class Builder {
        private final Node root;
        private CompilerOptions options = new CompilerOptions();
        private boolean lineBreak;
        private boolean prettyPrint;
        private boolean outputTypes = false;
        private boolean tagAsTypeSummary;
        private boolean tagAsStrict;
        private @Nullable LicenseTracker licenseTracker;
        private @Nullable JSTypeRegistry registry;
        private CodeGeneratorFactory codeGeneratorFactory = new CodeGeneratorFactory(){

            @Override
            public CodeGenerator getCodeGenerator(Format outputFormat, CodeConsumer cc) {
                return outputFormat == Format.TYPED ? new TypedCodeGenerator(cc, options, registry) : new CodeGenerator(cc, options);
            }
        };

        public Builder(Node node) {
            this.root = node;
        }

        @CanIgnoreReturnValue
        public Builder setCompilerOptions(CompilerOptions options) {
            this.options = options;
            this.prettyPrint = options.isPrettyPrint();
            this.lineBreak = options.lineBreak;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTypeRegistry(JSTypeRegistry registry) {
            this.registry = registry;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLineBreak(boolean lineBreak) {
            this.lineBreak = lineBreak;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOutputTypes(boolean outputTypes) {
            this.outputTypes = outputTypes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLicenseTracker(LicenseTracker licenseTracker) {
            this.licenseTracker = licenseTracker;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTagAsTypeSummary(boolean tagAsTypeSummary) {
            this.tagAsTypeSummary = tagAsTypeSummary;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTagAsStrict(boolean tagAsStrict) {
            this.tagAsStrict = tagAsStrict;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCodeGeneratorFactory(CodeGeneratorFactory factory) {
            this.codeGeneratorFactory = factory;
            return this;
        }

        public String build() {
            return this.buildWithSourceMappings().source;
        }

        public SourceAndMappings buildWithSourceMappings() {
            if (this.root == null) {
                throw new IllegalStateException("Cannot build without root node being specified");
            }
            return CodePrinter.toSource(this.root, Format.fromOptions(this.options, this.outputTypes, this.prettyPrint), this.options, this.licenseTracker, this.tagAsTypeSummary, this.tagAsStrict, this.lineBreak, this.codeGeneratorFactory);
        }

        public static interface CodeGeneratorFactory {
            public CodeGenerator getCodeGenerator(Format var1, CodeConsumer var2);
        }
    }

    public static interface LicenseTracker {
        public void trackLicensesForNode(Node var1);

        public ImmutableSet<String> emitLicenses();
    }

    static class CompactCodePrinter
    extends MappedCodePrinter {
        private final boolean lineBreak;
        private int lineStartPosition = 0;
        private int preferredBreakPosition = 0;

        private CompactCodePrinter(boolean lineBreak, int lineLengthThreshold, boolean createSrcMap, SourceMap.DetailLevel sourceMapDetailLevel, LicenseTracker licenseTracker) {
            super(lineLengthThreshold, createSrcMap, sourceMapDetailLevel, licenseTracker);
            this.lineBreak = lineBreak;
        }

        @Override
        void startNewLine() {
            if (this.lineLength <= 0 && !this.isInTemplateLiteral()) {
                return;
            }
            this.code.append('\n');
            this.lineLength = 0;
            ++this.lineIndex;
            this.lineStartPosition = this.code.length();
        }

        @Override
        void maybeLineBreak() {
            char ch;
            int len;
            if (this.lineBreak && this.sawFunction) {
                this.startNewLine();
                this.sawFunction = false;
            }
            if (this.preferredBreakPosition == (len = this.code.length()) - 1 && (ch = this.code.charAt(len - 1)) == ';') {
                this.preferredBreakPosition = len;
            }
            this.maybeCutLine();
        }

        @Override
        void maybeCutLine() {
            if (this.lineLength <= this.lineLengthThreshold) {
                return;
            }
            if (this.preferredBreakPosition > this.lineStartPosition && this.preferredBreakPosition < this.lineStartPosition + this.lineLength) {
                this.code.insert(this.preferredBreakPosition, '\n');
                this.reportLineCut(this.lineIndex, this.preferredBreakPosition - this.lineStartPosition);
                ++this.lineIndex;
                this.lineLength -= this.preferredBreakPosition - this.lineStartPosition;
                this.lineStartPosition = this.preferredBreakPosition + 1;
            } else {
                this.startNewLine();
            }
        }

        @Override
        void notePreferredLineBreak() {
            this.preferredBreakPosition = this.code.length();
        }
    }

    static class PrettyCodePrinter
    extends MappedCodePrinter {
        static final String INDENT = "  ";
        private int indent = 0;

        private PrettyCodePrinter(int lineLengthThreshold, boolean createSourceMap, SourceMap.DetailLevel sourceMapDetailLevel, @Nullable LicenseTracker licenseTracker) {
            super(lineLengthThreshold, createSourceMap, sourceMapDetailLevel, licenseTracker);
        }

        @Override
        void append(String str) {
            if (this.lineLength == 0 && !this.isInTemplateLiteral()) {
                for (int i = 0; i < this.indent; ++i) {
                    this.code.append(INDENT);
                    this.lineLength += INDENT.length();
                }
            }
            super.append(str);
        }

        @Override
        void addNumber(double x, Node n) {
            double d;
            Preconditions.checkState((boolean)JSCompDoubles.isPositive(x), (Object)x);
            String numberFromSource = PrettyCodePrinter.getNumberFromSource(n);
            if (numberFromSource == null) {
                super.addNumber(x, n);
                return;
            }
            try {
                d = Double.parseDouble(numberFromSource);
            }
            catch (NumberFormatException e) {
                super.addNumber(x, n);
                return;
            }
            if (x != d) {
                super.addNumber(x, n);
                return;
            }
            this.addConstant(numberFromSource);
        }

        @Override
        void startNewLine() {
            if (this.lineLength <= 0 && !this.isInTemplateLiteral()) {
                return;
            }
            this.code.append('\n');
            ++this.lineIndex;
            this.lineLength = 0;
        }

        @Override
        void maybeLineBreak() {
            this.maybeCutLine();
        }

        @Override
        void maybeCutLine() {
            if (this.lineLength > this.lineLengthThreshold) {
                this.startNewLine();
            }
        }

        @Override
        void endLine() {
            this.startNewLine();
        }

        @Override
        void appendBlockStart() {
            this.maybeInsertSpace();
            this.add("{");
            ++this.indent;
        }

        @Override
        void appendBlockEnd() {
            this.maybeEndStatement();
            this.endLine();
            --this.indent;
            this.add("}");
        }

        @Override
        void listSeparator() {
            this.add(", ");
            this.maybeLineBreak();
        }

        @Override
        void optionalListSeparator() {
            this.add(",");
            this.maybeLineBreak();
        }

        @Override
        void endFunction(boolean statementContext) {
            super.endFunction(statementContext);
            if (statementContext) {
                this.startNewLine();
            }
        }

        @Override
        void beginCaseBody() {
            super.beginCaseBody();
            ++this.indent;
            this.endLine();
        }

        @Override
        void endCaseBody() {
            super.endCaseBody();
            --this.indent;
        }

        @Override
        void appendOp(String op, boolean binOp) {
            if (this.getLastChar() != ' ' && binOp && op.charAt(0) != ',') {
                this.add(" ");
            }
            this.add(op);
            if (binOp) {
                this.add(" ");
            }
        }

        @Override
        boolean shouldPreserveExtras(Node n) {
            boolean onlyChildIsIf;
            if (!(n.isBlock() && n.isAddedBlock() && n.hasParent())) {
                return true;
            }
            Node parent = n.getParent();
            boolean isElse = parent.isIf() && parent.hasXChildren(3) && n == parent.getLastChild();
            boolean bl = onlyChildIsIf = n.hasOneChild() && n.getFirstChild().isIf();
            return !isElse || !onlyChildIsIf;
        }

        @Override
        void maybeInsertSpace() {
            if (this.getLastChar() != ' ' && this.getLastChar() != '\n') {
                this.add(" ");
            }
        }

        private static Node getTryForCatch(Node n) {
            return n.getGrandparent();
        }

        @Override
        boolean breakAfterBlockFor(Node n, boolean isStatementContext) {
            Preconditions.checkState((boolean)n.isBlock(), (Object)n);
            Node parent = n.getParent();
            Token type = parent.getToken();
            switch (type) {
                case DO: {
                    return false;
                }
                case FUNCTION: {
                    return false;
                }
                case TRY: {
                    return n != parent.getFirstChild();
                }
                case CATCH: {
                    return !NodeUtil.hasFinally(PrettyCodePrinter.getTryForCatch(parent));
                }
                case IF: {
                    return n == parent.getLastChild();
                }
            }
            return true;
        }

        @Override
        void endStatement(boolean needsSemicolon, boolean hasTrailingCommentOnSameLine) {
            this.add(";");
            if (!hasTrailingCommentOnSameLine) {
                this.endLine();
            }
            this.statementNeedsEnded = false;
        }

        @Override
        void endFile() {
            this.maybeEndStatement();
        }

        private static @Nullable String getNumberFromSource(Node n) {
            int offset;
            String srcCode;
            if (!n.isNumber()) {
                return null;
            }
            StaticSourceFile staticSrc = NodeUtil.getSourceFile(n);
            if (!(staticSrc instanceof SourceFile)) {
                return null;
            }
            SourceFile src = (SourceFile)staticSrc;
            try {
                srcCode = src.getCode();
            }
            catch (IOException e) {
                return null;
            }
            try {
                offset = n.getSourceOffset();
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            int endOffset = offset + n.getLength();
            if (offset < 0 || endOffset > srcCode.length()) {
                return null;
            }
            return srcCode.substring(offset, endOffset);
        }
    }

    private static abstract class MappedCodePrinter
    extends CodeConsumer {
        private final @Nullable Deque<SourceMap.Mapping> mappings;
        private final @Nullable List<SourceMap.Mapping> allMappings;
        private final @Nullable List<SourceMap.Mapping> completeMappings;
        private int firstCandidateMappingForCut = 0;
        private final boolean createSrcMap;
        private final SourceMap.DetailLevel sourceMapDetailLevel;
        private final @Nullable LicenseTracker licenseTracker;
        protected final StringBuilder code = new StringBuilder(1024);
        protected final int lineLengthThreshold;
        protected int lineLength = 0;
        protected int lineIndex = 0;

        MappedCodePrinter(int lineLengthThreshold, boolean createSrcMap, SourceMap.DetailLevel sourceMapDetailLevel, @Nullable LicenseTracker licenseTracker) {
            Preconditions.checkState((sourceMapDetailLevel != null ? 1 : 0) != 0);
            this.lineLengthThreshold = lineLengthThreshold <= 0 ? Integer.MAX_VALUE : lineLengthThreshold;
            this.createSrcMap = createSrcMap;
            this.sourceMapDetailLevel = sourceMapDetailLevel;
            this.mappings = createSrcMap ? new ArrayDeque() : null;
            this.allMappings = createSrcMap ? new ArrayList() : null;
            this.completeMappings = createSrcMap ? new ArrayList() : null;
            this.licenseTracker = licenseTracker;
        }

        @Override
        void append(String str) {
            this.code.append(str);
            this.lineLength += str.length();
        }

        @Override
        void trackLicenses(Node node) {
            if (this.licenseTracker != null) {
                this.licenseTracker.trackLicensesForNode(node);
            }
        }

        @Override
        void startSourceMapping(Node node) {
            Preconditions.checkState((this.sourceMapDetailLevel != null ? 1 : 0) != 0);
            Preconditions.checkState((node != null ? 1 : 0) != 0);
            if (this.createSrcMap && node.getSourceFileName() != null && node.getLineno() > 0 && this.sourceMapDetailLevel.apply(node)) {
                int line = this.getCurrentLineIndex();
                int index = this.getCurrentCharIndex();
                Preconditions.checkState((line >= 0 ? 1 : 0) != 0);
                SourceMap.Mapping mapping = new SourceMap.Mapping();
                mapping.node = node;
                mapping.start = new FilePosition(line, index);
                this.mappings.push(mapping);
                this.allMappings.add(mapping);
            }
        }

        @Override
        void endSourceMapping(Node node) {
            if (this.createSrcMap && !this.mappings.isEmpty() && this.mappings.peek().node == node) {
                SourceMap.Mapping mapping = this.mappings.pop();
                int line = this.getCurrentLineIndex();
                int index = this.getCurrentCharIndex();
                Preconditions.checkState((line >= 0 ? 1 : 0) != 0);
                mapping.end = new FilePosition(line, index);
                this.completeMappings.add(mapping);
            }
        }

        @Nullable List<SourceMap.Mapping> getSourceMappings(String code) {
            if (!this.createSrcMap) {
                return null;
            }
            ImmutableList<Integer> lineLengths = MappedCodePrinter.computeLineLengths(code);
            ArrayList<SourceMap.Mapping> fixedMappings = new ArrayList<SourceMap.Mapping>();
            for (SourceMap.Mapping mapping : this.allMappings) {
                SourceMap.Mapping adjusted = new SourceMap.Mapping();
                adjusted.node = mapping.node;
                adjusted.start = mapping.start;
                adjusted.end = MappedCodePrinter.adjustEndPosition(lineLengths, mapping.end);
                fixedMappings.add(adjusted);
            }
            return fixedMappings;
        }

        void reportLineCut(int lineIndex, int charIndex) {
            if (this.createSrcMap) {
                int mappingCount = this.allMappings.size();
                for (int i = this.firstCandidateMappingForCut; i < mappingCount; ++i) {
                    SourceMap.Mapping mapping = this.allMappings.get(i);
                    mapping.start = MappedCodePrinter.convertPositionAfterLineCut(mapping.start, lineIndex, charIndex);
                }
                this.firstCandidateMappingForCut = mappingCount;
                for (SourceMap.Mapping mapping : this.completeMappings) {
                    mapping.end = MappedCodePrinter.convertPositionAfterLineCut(mapping.end, lineIndex, charIndex);
                }
                this.completeMappings.clear();
            }
        }

        private static FilePosition convertPositionAfterLineCut(FilePosition position, int lineIndex, int characterPosition) {
            int originalLine = position.getLine();
            int originalChar = position.getColumn();
            if (originalLine == lineIndex && originalChar >= characterPosition) {
                return new FilePosition(originalLine + 1, originalChar - characterPosition);
            }
            return position;
        }

        public String getCode() {
            return this.code.toString();
        }

        @Override
        char getLastChar() {
            return this.code.length() > 0 ? this.code.charAt(this.code.length() - 1) : (char)'\u0000';
        }

        protected final int getCurrentCharIndex() {
            return this.lineLength;
        }

        protected final int getCurrentLineIndex() {
            return this.lineIndex;
        }

        private static ImmutableList<Integer> computeLineLengths(String code) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int lineStartPos = 0;
            int lineEndPos = code.indexOf(10);
            while (lineEndPos > -1) {
                builder.add((Object)(lineEndPos - lineStartPos));
                lineStartPos = lineEndPos + 1;
                lineEndPos = code.indexOf(10, lineStartPos);
            }
            return builder.build();
        }

        private static FilePosition adjustEndPosition(List<Integer> lineLengths, FilePosition endPosition) {
            int line = endPosition.getLine();
            if (line >= lineLengths.size()) {
                return endPosition;
            }
            Preconditions.checkState((endPosition.getColumn() <= lineLengths.get(line) ? 1 : 0) != 0, (String)"End position %s points to a column larger than line length %s", (Object)endPosition, (Object)lineLengths.get(line));
            if (endPosition.getColumn() == lineLengths.get(line).intValue()) {
                return new FilePosition(line + 1, 0);
            }
            return endPosition;
        }
    }
}

