/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.jstype.FunctionType;
import java.util.List;
import org.jspecify.nullness.Nullable;

@Immutable
public final class ClosureCodingConvention
extends CodingConventions.Proxy {
    private static final long serialVersionUID = 1L;
    static final DiagnosticType OBJECTLIT_EXPECTED = DiagnosticType.warning("JSC_REFLECT_OBJECTLIT_EXPECTED", "Object literal expected as second argument");
    private final ImmutableSet<String> indirectlyDeclaredProperties;
    private static final QualifiedName GOOG_DEFINECLASS = QualifiedName.of("goog.defineClass");
    private static final QualifiedName GOOG_FORWARDDECLARE = QualifiedName.of("goog.forwardDeclare");
    private static final QualifiedName GOOG_ADDSINGLETONGETTER = QualifiedName.of("goog.addSingletonGetter");
    private static final QualifiedName GOOG_ADDSINGLETONGETTER_MANGLED = QualifiedName.of("goog$addSingletonGetter");
    private static final QualifiedName GOOG_REFLECT_OBJECTPROPERTY = QualifiedName.of("goog.reflect.objectProperty");
    private static final QualifiedName GOOG_REFLECT_OBJECTPROPERTY_MANGLED = QualifiedName.of("goog$reflect$objectProperty");
    private static final QualifiedName GOOG_REFLECT_OBJECT = QualifiedName.of("goog.reflect.object");
    private static final QualifiedName JSCOMP_REFLECTOBJECT = QualifiedName.of("$jscomp.reflectObject");
    private static final QualifiedName GOOG_BIND = QualifiedName.of("goog.bind");
    private static final QualifiedName GOOG_PARTIAL = QualifiedName.of("goog.partial");
    static final Node googCacheReflect = IR.getprop(IR.name("goog"), "reflect", "cache");

    public ClosureCodingConvention() {
        this(CodingConventions.getDefault());
    }

    public ClosureCodingConvention(CodingConvention wrapped) {
        super(wrapped);
        ImmutableSet.Builder props = ImmutableSet.builder();
        props.add((Object[])new String[]{"superClass_", "instance_", "getInstance"});
        props.addAll(wrapped.getIndirectlyDeclaredProperties());
        this.indirectlyDeclaredProperties = props.build();
    }

    @Override
    public void applySubclassRelationship(NominalTypeBuilder parent, NominalTypeBuilder child, CodingConvention.SubclassType type) {
        super.applySubclassRelationship(parent, child, type);
        if (type == CodingConvention.SubclassType.INHERITS) {
            FunctionType childCtor = child.constructor();
            child.declareConstructorProperty("superClass_", parent.prototypeOrInstance(), childCtor.getSource());
            FunctionType qmarkCtor = childCtor.forgetParameterAndReturnTypes();
            child.declarePrototypeProperty("constructor", qmarkCtor, childCtor.getSource());
        }
    }

    @Override
    public @Nullable CodingConvention.SubclassRelationship getClassesDefinedByCall(Node callNode) {
        CodingConvention.SubclassRelationship relationship = super.getClassesDefinedByCall(callNode);
        if (relationship != null) {
            return relationship;
        }
        Node callName = callNode.getFirstChild();
        CodingConvention.SubclassType type = ClosureCodingConvention.typeofClassDefiningName(callName);
        if (type != null) {
            if (callNode.getChildCount() < 3) {
                return null;
            }
            Node subclass = callName.getNext();
            Node superclass = subclass.getNext();
            if (type == CodingConvention.SubclassType.MIXIN) {
                if (ClosureCodingConvention.endsWithPrototype(superclass)) {
                    superclass = superclass.getFirstChild();
                }
                if (ClosureCodingConvention.endsWithPrototype(subclass)) {
                    subclass = subclass.getFirstChild();
                }
            }
            if (subclass != null && subclass.isUnscopedQualifiedName() && superclass.isUnscopedQualifiedName()) {
                return new CodingConvention.SubclassRelationship(type, subclass, superclass);
            }
        }
        return null;
    }

    @Override
    public boolean isClassFactoryCall(Node callNode) {
        return GOOG_DEFINECLASS.matches(callNode.getFirstChild());
    }

    private static @Nullable CodingConvention.SubclassType typeofClassDefiningName(Node callName) {
        String name;
        int dollarIndex;
        String methodName = null;
        if (callName.isGetProp()) {
            methodName = callName.getString();
        } else if (callName.isName() && (dollarIndex = (name = callName.getString()).lastIndexOf(36)) != -1) {
            methodName = name.substring(dollarIndex + 1);
        }
        if (methodName != null) {
            if (methodName.equals("inherits")) {
                return CodingConvention.SubclassType.INHERITS;
            }
            if (methodName.equals("mixin")) {
                return CodingConvention.SubclassType.MIXIN;
            }
        }
        return null;
    }

    @Override
    public boolean isSuperClassReference(String propertyName) {
        return "superClass_".equals(propertyName) || super.isSuperClassReference(propertyName);
    }

    private static boolean endsWithPrototype(Node qualifiedName) {
        return qualifiedName.isGetProp() && qualifiedName.getString().equals("prototype");
    }

    @Override
    public boolean extractIsModuleFile(Node node, Node parent) {
        String namespace = ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.module");
        return namespace != null;
    }

    @Override
    public String extractClassNameIfProvide(Node node, Node parent) {
        String namespace = ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.provide");
        if (namespace == null) {
            namespace = ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.module");
        }
        return namespace;
    }

    @Override
    public String extractClassNameIfRequire(Node node, Node parent) {
        return ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.require");
    }

    private static String extractClassNameIfGoog(Node node, Node parent, String functionName) {
        Node target;
        Node callee;
        String className = null;
        if (NodeUtil.isExprCall(parent) && (callee = node.getFirstChild()) != null && callee.isGetProp() && callee.matchesQualifiedName(functionName) && (target = callee.getNext()) != null && target.isStringLit()) {
            className = target.getString();
        }
        return className;
    }

    @Override
    public String getExportPropertyFunction() {
        return "goog.exportProperty";
    }

    @Override
    public String getExportSymbolFunction() {
        return "goog.exportSymbol";
    }

    @Override
    public List<String> identifyTypeDeclarationCall(Node n) {
        Node typeDeclaration;
        Node callName = n.getFirstChild();
        if (GOOG_FORWARDDECLARE.matches(callName) && n.hasTwoChildren() && (typeDeclaration = n.getSecondChild()).isStringLit()) {
            return ImmutableList.of((Object)typeDeclaration.getString());
        }
        return super.identifyTypeDeclarationCall(n);
    }

    @Override
    public String getAbstractMethodName() {
        return "goog.abstractMethod";
    }

    @Override
    public String getSingletonGetterClassName(Node callNode) {
        Node callArg = callNode.getFirstChild();
        if (callNode.hasTwoChildren() && (GOOG_ADDSINGLETONGETTER.matches(callArg) || GOOG_ADDSINGLETONGETTER_MANGLED.matches(callArg))) {
            return callArg.getNext().getQualifiedName();
        }
        return super.getSingletonGetterClassName(callNode);
    }

    @Override
    public void applySingletonGetter(NominalTypeBuilder classType, FunctionType getterType) {
        Node defSite = classType.constructor().getSource();
        classType.declareConstructorProperty("getInstance", getterType, defSite);
        classType.declareConstructorProperty("instance_", classType.instance(), defSite);
    }

    @Override
    public boolean isPropertyTestFunction(Node call) {
        Preconditions.checkArgument((boolean)call.isCall());
        Node target = call.getFirstChild();
        if (target.isGetProp()) {
            Node src = target.getFirstChild();
            String prop = target.getString();
            if (src.isName() && src.getString().equals("goog") && (prop.equals("isArrayLike") || prop.equals("isObject"))) {
                return true;
            }
        }
        return super.isPropertyTestFunction(call);
    }

    @Override
    public boolean isPropertyRenameFunction(Node nameNode) {
        if (super.isPropertyRenameFunction(nameNode)) {
            return true;
        }
        return GOOG_REFLECT_OBJECTPROPERTY.matches(nameNode) || GOOG_REFLECT_OBJECTPROPERTY_MANGLED.matches(nameNode);
    }

    @Override
    public boolean isFunctionCallThatAlwaysThrows(Node n) {
        return super.isFunctionCallThatAlwaysThrows(n) || CodingConventions.defaultIsFunctionCallThatAlwaysThrows(n, "goog.asserts.fail");
    }

    @Override
    public @Nullable CodingConvention.ObjectLiteralCast getObjectLiteralCast(Node callNode) {
        Preconditions.checkArgument((boolean)callNode.isCall(), (String)"Expected call node but found %s", (Object)callNode);
        CodingConvention.ObjectLiteralCast proxyCast = super.getObjectLiteralCast(callNode);
        if (proxyCast != null) {
            return proxyCast;
        }
        Node callName = callNode.getFirstChild();
        if (!GOOG_REFLECT_OBJECT.matches(callName) && !JSCOMP_REFLECTOBJECT.matches(callName) || !callNode.hasXChildren(3)) {
            return null;
        }
        Node typeNode = callName.getNext();
        if (!typeNode.isQualifiedName()) {
            return null;
        }
        Node objectNode = typeNode.getNext();
        if (!objectNode.isObjectLit()) {
            return new CodingConvention.ObjectLiteralCast(null, null, OBJECTLIT_EXPECTED);
        }
        return new CodingConvention.ObjectLiteralCast(typeNode.getQualifiedName(), typeNode.getNext(), null);
    }

    public ImmutableSet<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
        return ImmutableSet.builder().addAll(super.getAssertionFunctions()).add((Object[])new CodingConvention.AssertionFunctionSpec[]{CodingConvention.AssertionFunctionSpec.forTruthy().setFunctionName("goog.asserts.assert").build(), ClosureCodingConvention.createGoogAssertOnReturn("Array"), ClosureCodingConvention.createGoogAssertOnReturn("Boolean"), ClosureCodingConvention.createGoogAssertOnReturn("Element"), ClosureCodingConvention.createGoogAssertOnReturn("Function"), ClosureCodingConvention.createGoogAssertOnReturn("Instanceof"), ClosureCodingConvention.createGoogAssertOnReturn("Number"), ClosureCodingConvention.createGoogAssertOnReturn("Object"), ClosureCodingConvention.createGoogAssertOnReturn("String")}).build();
    }

    private static CodingConvention.AssertionFunctionSpec createGoogAssertOnReturn(String assertedTypeName) {
        return CodingConvention.AssertionFunctionSpec.forMatchesReturn().setFunctionName("goog.asserts.assert" + assertedTypeName).build();
    }

    @Override
    public @Nullable CodingConvention.Bind describeFunctionBind(Node n, boolean callerChecksTypes, boolean iCheckTypes) {
        if (!n.isCall()) {
            return null;
        }
        Node callTarget = n.getFirstChild();
        if (callTarget.isQualifiedName()) {
            if (GOOG_BIND.matches(callTarget) || callTarget.matchesName("goog$bind")) {
                Node fn = callTarget.getNext();
                if (fn == null) {
                    return null;
                }
                Node thisValue = ClosureCodingConvention.safeNext(fn);
                Node parameters = ClosureCodingConvention.safeNext(thisValue);
                return new CodingConvention.Bind(fn, thisValue, parameters);
            }
            if (GOOG_PARTIAL.matches(callTarget) || callTarget.matchesName("goog$partial")) {
                Node fn = callTarget.getNext();
                if (fn == null) {
                    return null;
                }
                Node thisValue = null;
                Node parameters = ClosureCodingConvention.safeNext(fn);
                return new CodingConvention.Bind(fn, thisValue, parameters);
            }
        }
        return super.describeFunctionBind(n, callerChecksTypes, iCheckTypes);
    }

    @Override
    public @Nullable CodingConvention.Cache describeCachingCall(Node node) {
        int paramCount;
        if (!node.isCall()) {
            return null;
        }
        Node callTarget = node.getFirstChild();
        if (this.matchesCacheMethodName(callTarget) && 3 <= (paramCount = node.getChildCount() - 1) && paramCount <= 4) {
            Node cacheObj = callTarget.getNext();
            Node keyNode = cacheObj.getNext();
            Node valueFn = keyNode.getNext();
            Node keyFn = valueFn.getNext();
            return new CodingConvention.Cache(cacheObj, keyNode, valueFn, keyFn);
        }
        return super.describeCachingCall(node);
    }

    private boolean matchesCacheMethodName(Node target) {
        if (target.isGetProp()) {
            return target.matchesQualifiedName(googCacheReflect);
        }
        if (target.isName()) {
            return target.getString().equals("goog$reflect$cache");
        }
        return false;
    }

    public ImmutableSet<String> getIndirectlyDeclaredProperties() {
        return this.indirectlyDeclaredProperties;
    }

    private static @Nullable Node safeNext(Node n) {
        if (n != null) {
            return n.getNext();
        }
        return null;
    }
}

