/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jspecify.nullness.Nullable;

@GwtIncompatible(value="java.io, java.util.regex")
public class AllowlistWarningsGuard
extends WarningsGuard {
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n');
    private final ImmutableSet<String> allowlist;
    private static final Pattern LINE_NUMBER = Pattern.compile(":-?\\d+");

    public AllowlistWarningsGuard() {
        this((Set<String>)ImmutableSet.of());
    }

    public AllowlistWarningsGuard(Set<String> allowlist) {
        Preconditions.checkNotNull(allowlist);
        this.allowlist = AllowlistWarningsGuard.normalizeAllowlist(allowlist);
    }

    public static ImmutableSet<String> normalizeAllowlist(Set<String> allowlist) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String line : allowlist) {
            String trimmed = line.trim();
            if (trimmed.isEmpty() || trimmed.charAt(0) == '#') continue;
            result.add(LINE_NUMBER.matcher(trimmed).replaceFirst(":"));
        }
        return ImmutableSet.copyOf(result);
    }

    @Override
    public @Nullable CheckLevel level(JSError error) {
        if (error.getDefaultLevel().equals(CheckLevel.ERROR)) {
            return null;
        }
        if (!this.allowlist.isEmpty() && this.containWarning(this.formatWarning(error))) {
            return CheckLevel.WARNING;
        }
        return null;
    }

    protected boolean containWarning(String formattedWarning) {
        return this.allowlist.contains((Object)formattedWarning);
    }

    @Override
    public int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_BY_ALLOWLIST.getValue();
    }

    public static AllowlistWarningsGuard fromFile(File file) {
        return new AllowlistWarningsGuard(AllowlistWarningsGuard.loadAllowlistedJsWarnings(file));
    }

    public static Set<String> loadAllowlistedJsWarnings(File file) {
        return AllowlistWarningsGuard.loadAllowlistedJsWarnings(Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8));
    }

    protected static Set<String> loadAllowlistedJsWarnings(CharSource supplier) {
        try {
            return AllowlistWarningsGuard.loadAllowlistedJsWarnings(supplier.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Set<String> loadAllowlistedJsWarnings(Reader reader) throws IOException {
        Preconditions.checkNotNull((Object)reader);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(CharStreams.readLines((Readable)reader));
        return result;
    }

    protected String formatWarning(JSError error) {
        return this.formatWarning(error, false);
    }

    protected String formatWarning(JSError error, boolean withMetaData) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.normalizeSourceName(error.getSourceName())).append(":");
        if (withMetaData) {
            sb.append(error.getLineNumber());
        }
        List lines = LINE_SPLITTER.splitToList((CharSequence)error.getDescription());
        sb.append("  ").append((String)lines.get(0));
        if (withMetaData) {
            for (int i = 1; i < lines.size(); ++i) {
                sb.append("\n# ").append((String)lines.get(i));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String normalizeSourceName(String sourceName) {
        if (sourceName != null) {
            return sourceName.replaceFirst("blaze-out/[^/]*/(bin|genfiles)/", "");
        }
        return sourceName;
    }

    public static String getFirstLine(String warning) {
        int lineLength = warning.indexOf(10);
        if (lineLength > 0) {
            warning = warning.substring(0, lineLength);
        }
        return warning;
    }

    public class AllowlistBuilder
    implements ErrorHandler {
        private final Set<JSError> warnings = new LinkedHashSet<JSError>();
        private @Nullable String productName = null;
        private @Nullable String generatorTarget = null;
        private @Nullable String headerNote = null;

        @CanIgnoreReturnValue
        public AllowlistBuilder setProductName(String name) {
            this.productName = name;
            return this;
        }

        @CanIgnoreReturnValue
        public AllowlistBuilder setGeneratorTarget(String name) {
            this.generatorTarget = name;
            return this;
        }

        @CanIgnoreReturnValue
        public AllowlistBuilder setNote(String note) {
            this.headerNote = note;
            return this;
        }

        @Override
        public void report(CheckLevel level, JSError error) {
            if (error.getDefaultLevel().equals(CheckLevel.ERROR)) {
                return;
            }
            this.warnings.add(error);
        }

        public void writeAllowlist(File out) throws IOException {
            try (PrintStream stream = new PrintStream(out);){
                this.appendAllowlist(stream);
            }
        }

        public void appendAllowlist(PrintStream out) {
            out.append("# This is a list of legacy warnings that have yet to be fixed.\n");
            if (this.productName != null && !this.productName.isEmpty() && !this.warnings.isEmpty()) {
                out.append("# Please find some time and fix at least one of them and it will be the happiest day for " + this.productName + ".\n");
            }
            if (this.generatorTarget != null && !this.generatorTarget.isEmpty()) {
                out.append("# When you fix any of these warnings, run " + this.generatorTarget + " task.\n");
            }
            if (this.headerNote != null) {
                out.append("#" + Joiner.on((String)"\n# ").join(Splitter.on((char)'\n').split((CharSequence)this.headerNote)) + "\n");
            }
            TreeMultimap warningsByType = TreeMultimap.create();
            for (JSError warning : this.warnings) {
                warningsByType.put((Object)warning.getType(), (Object)AllowlistWarningsGuard.this.formatWarning(warning, true));
            }
            for (DiagnosticType type : warningsByType.keySet()) {
                if (DiagnosticGroups.DEPRECATED.matches(type)) continue;
                out.append("\n# Warning ").append(type.key).append(": ").println((String)Iterables.get((Iterable)LINE_SPLITTER.split((CharSequence)type.format), (int)0));
                for (String warning : warningsByType.get((Object)type)) {
                    out.println(warning);
                }
            }
            out.flush();
        }
    }
}

