/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.v4P0;

import java.util.List;
import java.util.function.Consumer;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0MacroVector;
import org.metaeffekt.core.security.cvss.v4P0.EqOperations;

public abstract class EqOperations1245
implements EqOperations {
    private static final EqOperations1 instanceEq1 = new EqOperations1();
    private static final EqOperations2 instanceEq2 = new EqOperations2();
    private static final EqOperations4 instanceEq4 = new EqOperations4();
    private static final EqOperations5 instanceEq5 = new EqOperations5();

    @Override
    public Cvss4P0MacroVector[] deriveNextLowerMacro(Cvss4P0MacroVector thisMacroVector) {
        return new Cvss4P0MacroVector[]{thisMacroVector.deriveNextLower(this.getEqNumber())};
    }

    @Override
    public double lookupScoresForNextLowerMacro(Cvss4P0MacroVector[] nextLowerMacro) {
        return nextLowerMacro[0].getLookupTableScore();
    }

    @Override
    public String[] getHighestSeverityVectors(Cvss4P0MacroVector thisMacroVector) {
        return this.getEq(thisMacroVector).getHighestSeverityVectorsUnparsed();
    }

    @Override
    public List<Consumer<Cvss4P0>> getHighestSeverityVectorsFn(Cvss4P0MacroVector thisMacroVector) {
        return this.getEq(thisMacroVector).getApplyHighestSeverityVectors();
    }

    @Override
    public int lookupMacroVectorDepth(Cvss4P0MacroVector thisMacroVector) {
        return this.getEq(thisMacroVector).getVectorDepth();
    }

    public abstract int getEqNumber();

    public abstract Cvss4P0MacroVector.EQ getEq(Cvss4P0MacroVector var1);

    public static EqOperations1 getInstanceEq1() {
        return instanceEq1;
    }

    public static EqOperations2 getInstanceEq2() {
        return instanceEq2;
    }

    public static EqOperations4 getInstanceEq4() {
        return instanceEq4;
    }

    public static EqOperations5 getInstanceEq5() {
        return instanceEq5;
    }

    public static class EqOperations5
    extends EqOperations1245 {
        @Override
        public Cvss4P0MacroVector.EQ getEq(Cvss4P0MacroVector thisMacroVector) {
            return thisMacroVector.getEq5();
        }

        @Override
        public String[] getRelevantAttributes() {
            return new String[0];
        }

        @Override
        public int getEqNumber() {
            return 5;
        }
    }

    public static class EqOperations4
    extends EqOperations1245 {
        @Override
        public Cvss4P0MacroVector.EQ getEq(Cvss4P0MacroVector thisMacroVector) {
            return thisMacroVector.getEq4();
        }

        @Override
        public String[] getRelevantAttributes() {
            return new String[]{"SC", "SI", "SA"};
        }

        @Override
        public int getEqNumber() {
            return 4;
        }
    }

    public static class EqOperations2
    extends EqOperations1245 {
        @Override
        public Cvss4P0MacroVector.EQ getEq(Cvss4P0MacroVector thisMacroVector) {
            return thisMacroVector.getEq2();
        }

        @Override
        public String[] getRelevantAttributes() {
            return new String[]{"AC", "AT"};
        }

        @Override
        public int getEqNumber() {
            return 2;
        }
    }

    public static class EqOperations1
    extends EqOperations1245 {
        @Override
        public Cvss4P0MacroVector.EQ getEq(Cvss4P0MacroVector thisMacroVector) {
            return thisMacroVector.getEq1();
        }

        @Override
        public String[] getRelevantAttributes() {
            return new String[]{"AV", "PR", "UI"};
        }

        @Override
        public int getEqNumber() {
            return 1;
        }
    }
}

