/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.v4P0;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0Lookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cvss4P0MacroVector {
    private static final Logger LOG = LoggerFactory.getLogger(Cvss4P0MacroVector.class);
    private final EQ eq1;
    private final EQ eq2;
    private final EQ eq3;
    private final EQ eq4;
    private final EQ eq5;
    private final EQ eq6;
    private final EQ jointEq3AndEq6;
    public static final EQ EQ_ERROR_DEFINITION = new EQ("9", -1, new String[0], Collections.emptyList(), vector -> true);
    public static final EQ[] EQ1_DEFINITIONS = new EQ[]{new EQ("0", 1, new String[]{"AV:N/PR:N/UI:N"}, Collections.singletonList(vector -> {
        vector.setAttackVector(Cvss4P0.AttackVector.NETWORK);
        vector.setPrivilegesRequired(Cvss4P0.PrivilegesRequired.NONE);
        vector.setUserInteraction(Cvss4P0.UserInteraction.NONE);
    }), vector -> Cvss4P0MacroVector.is(vector, "AV", "N") && Cvss4P0MacroVector.is(vector, "PR", "N") && Cvss4P0MacroVector.is(vector, "UI", "N")), new EQ("1", 4, new String[]{"AV:A/PR:N/UI:N", "AV:N/PR:L/UI:N", "AV:N/PR:N/UI:P"}, Arrays.asList(vector -> {
        vector.setAttackVector(Cvss4P0.AttackVector.ADJACENT_NETWORK);
        vector.setPrivilegesRequired(Cvss4P0.PrivilegesRequired.NONE);
        vector.setUserInteraction(Cvss4P0.UserInteraction.NONE);
    }, vector -> {
        vector.setAttackVector(Cvss4P0.AttackVector.NETWORK);
        vector.setPrivilegesRequired(Cvss4P0.PrivilegesRequired.LOW);
        vector.setUserInteraction(Cvss4P0.UserInteraction.NONE);
    }, vector -> {
        vector.setAttackVector(Cvss4P0.AttackVector.NETWORK);
        vector.setPrivilegesRequired(Cvss4P0.PrivilegesRequired.NONE);
        vector.setUserInteraction(Cvss4P0.UserInteraction.PASSIVE);
    }), vector -> !(!Cvss4P0MacroVector.is(vector, "AV", "N") && !Cvss4P0MacroVector.is(vector, "PR", "N") && !Cvss4P0MacroVector.is(vector, "UI", "N") || Cvss4P0MacroVector.is(vector, "AV", "N") && Cvss4P0MacroVector.is(vector, "PR", "N") && Cvss4P0MacroVector.is(vector, "UI", "N") || Cvss4P0MacroVector.is(vector, "AV", "P"))), new EQ("2", 5, new String[]{"AV:P/PR:N/UI:N", "AV:A/PR:L/UI:P"}, Arrays.asList(vector -> {
        vector.setAttackVector(Cvss4P0.AttackVector.PHYSICAL);
        vector.setPrivilegesRequired(Cvss4P0.PrivilegesRequired.NONE);
        vector.setUserInteraction(Cvss4P0.UserInteraction.NONE);
    }, vector -> {
        vector.setAttackVector(Cvss4P0.AttackVector.ADJACENT_NETWORK);
        vector.setPrivilegesRequired(Cvss4P0.PrivilegesRequired.LOW);
        vector.setUserInteraction(Cvss4P0.UserInteraction.PASSIVE);
    }), vector -> Cvss4P0MacroVector.is(vector, "AV", "P") || !Cvss4P0MacroVector.is(vector, "AV", "N") && !Cvss4P0MacroVector.is(vector, "PR", "N") && !Cvss4P0MacroVector.is(vector, "UI", "N"))};
    public static final EQ[] EQ2_DEFINITIONS = new EQ[]{new EQ("0", 1, new String[]{"AC:L/AT:N"}, Collections.singletonList(vector -> {
        vector.setAttackComplexity(Cvss4P0.AttackComplexity.LOW);
        vector.setAttackRequirements(Cvss4P0.AttackRequirements.NONE);
    }), vector -> Cvss4P0MacroVector.is(vector, "AC", "L") && Cvss4P0MacroVector.is(vector, "AT", "N")), new EQ("1", 2, new String[]{"AC:H/AT:N", "AC:L/AT:P"}, Arrays.asList(vector -> {
        vector.setAttackComplexity(Cvss4P0.AttackComplexity.HIGH);
        vector.setAttackRequirements(Cvss4P0.AttackRequirements.NONE);
    }, vector -> {
        vector.setAttackComplexity(Cvss4P0.AttackComplexity.LOW);
        vector.setAttackRequirements(Cvss4P0.AttackRequirements.PRESENT);
    }), vector -> !Cvss4P0MacroVector.is(vector, "AC", "L") || !Cvss4P0MacroVector.is(vector, "AT", "N"))};
    public static final EQ[] EQ3_DEFINITIONS = new EQ[]{new EQ("0", -1, new String[]{"VC:H/VI:H/VA:H"}, Collections.singletonList(vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
    }), vector -> Cvss4P0MacroVector.is(vector, "VC", "H") && Cvss4P0MacroVector.is(vector, "VI", "H")), new EQ("1", -1, new String[]{"VC:L/VI:H/VA:H", "VC:H/VI:L/VA:H"}, Arrays.asList(vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
    }), vector -> !(Cvss4P0MacroVector.is(vector, "VC", "H") && Cvss4P0MacroVector.is(vector, "VI", "H") || !Cvss4P0MacroVector.is(vector, "VC", "H") && !Cvss4P0MacroVector.is(vector, "VI", "H") && !Cvss4P0MacroVector.is(vector, "VA", "H"))), new EQ("2", -1, new String[]{"VC:L/VI:L/VA:L"}, Collections.singletonList(vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
    }), vector -> !Cvss4P0MacroVector.is(vector, "VC", "H") && !Cvss4P0MacroVector.is(vector, "VI", "H") && !Cvss4P0MacroVector.is(vector, "VA", "H"))};
    public static final EQ[] EQ4_DEFINITIONS = new EQ[]{new EQ("0", 6, new String[]{"SC:H/SI:S/SA:S"}, Collections.singletonList(vector -> {
        vector.setSubConfidentialityImpact(Cvss4P0.SubsequentCia.HIGH);
        vector.setSubIntegrityImpact(Cvss4P0.SubsequentCia.SAFETY);
        vector.setSubAvailabilityImpact(Cvss4P0.SubsequentCia.SAFETY);
    }), vector -> Cvss4P0MacroVector.is(vector, "MSI", "S") || Cvss4P0MacroVector.is(vector, "MSA", "S")), new EQ("1", 5, new String[]{"SC:H/SI:H/SA:H"}, Collections.singletonList(vector -> {
        vector.setSubConfidentialityImpact(Cvss4P0.SubsequentCia.HIGH);
        vector.setSubIntegrityImpact(Cvss4P0.SubsequentCia.HIGH);
        vector.setSubAvailabilityImpact(Cvss4P0.SubsequentCia.HIGH);
    }), vector -> !(Cvss4P0MacroVector.is(vector, "MSI", "S") && Cvss4P0MacroVector.is(vector, "MSA", "S") || !Cvss4P0MacroVector.is(vector, "SC", "H") && !Cvss4P0MacroVector.is(vector, "SI", "H") && !Cvss4P0MacroVector.is(vector, "SA", "H"))), new EQ("2", 4, new String[]{"SC:L/SI:L/SA:L"}, Collections.singletonList(vector -> {
        vector.setSubConfidentialityImpact(Cvss4P0.SubsequentCia.LOW);
        vector.setSubIntegrityImpact(Cvss4P0.SubsequentCia.LOW);
        vector.setSubAvailabilityImpact(Cvss4P0.SubsequentCia.LOW);
    }), vector -> (!Cvss4P0MacroVector.is(vector, "MSI", "S") || !Cvss4P0MacroVector.is(vector, "MSA", "S")) && !Cvss4P0MacroVector.is(vector, "SC", "H") && !Cvss4P0MacroVector.is(vector, "SI", "H") && !Cvss4P0MacroVector.is(vector, "SA", "H"))};
    public static final EQ[] EQ5_DEFINITIONS = new EQ[]{new EQ("0", 1, new String[]{"E:A"}, Collections.singletonList(vector -> vector.setExploitMaturity(Cvss4P0.ExploitMaturity.ATTACKED)), vector -> Cvss4P0MacroVector.is(vector, "E", "A")), new EQ("1", 1, new String[]{"E:P"}, Collections.singletonList(vector -> vector.setExploitMaturity(Cvss4P0.ExploitMaturity.POC)), vector -> Cvss4P0MacroVector.is(vector, "E", "P")), new EQ("2", 1, new String[]{"E:U"}, Collections.singletonList(vector -> vector.setExploitMaturity(Cvss4P0.ExploitMaturity.UNREPORTED)), vector -> Cvss4P0MacroVector.is(vector, "E", "U"))};
    @Deprecated
    protected static final EQ[] EQ6_DEFINITIONS_DOC = new EQ[]{new EQ("0", -1, new String[]{"AV:N/PR:N/UI:N"}, Collections.singletonList(vector -> {
        vector.setAttackVector(Cvss4P0.AttackVector.NETWORK);
        vector.setPrivilegesRequired(Cvss4P0.PrivilegesRequired.NONE);
        vector.setUserInteraction(Cvss4P0.UserInteraction.NONE);
    }), vector -> Cvss4P0MacroVector.is(vector, "AV", "N") && Cvss4P0MacroVector.is(vector, "PR", "N") && Cvss4P0MacroVector.is(vector, "UI", "N")), new EQ("1", -1, new String[]{"VC:H/VI:H/VA:H/CR:M/IR:M/AR:M", "VC:H/VI:H/VA:L/CR:M/IR:M/AR:H", "VC:H/VI:L/VA:H/CR:M/IR:H/AR:M", "VC:H/VI:L/VA:L/CR:M/IR:H/AR:H", "VC:L/VI:H/VA:H/CR:H/IR:M/AR:M", "VC:L/VI:H/VA:L/CR:H/IR:M/AR:H", "VC:L/VI:L/VA:H/CR:H/IR:H/AR:M", "VC:L/VI:L/VA:L/CR:H/IR:H/AR:H"}, Arrays.asList(vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }), vector -> Cvss4P0MacroVector.is(vector, "CR", "H") && Cvss4P0MacroVector.is(vector, "VC", "H") || Cvss4P0MacroVector.is(vector, "IR", "H") && Cvss4P0MacroVector.is(vector, "VI", "H") || Cvss4P0MacroVector.is(vector, "AR", "H") && Cvss4P0MacroVector.is(vector, "VA", "H"))};
    public static final EQ[] EQ6_DEFINITIONS = new EQ[]{new EQ("0", -1, new String[]{"AV:N/PR:N/UI:N"}, Collections.singletonList(vector -> {
        vector.setAttackVector(Cvss4P0.AttackVector.NETWORK);
        vector.setPrivilegesRequired(Cvss4P0.PrivilegesRequired.NONE);
        vector.setUserInteraction(Cvss4P0.UserInteraction.NONE);
    }), vector -> Cvss4P0MacroVector.is(vector, "CR", "H") && Cvss4P0MacroVector.is(vector, "VC", "H") || Cvss4P0MacroVector.is(vector, "IR", "H") && Cvss4P0MacroVector.is(vector, "VI", "H") || Cvss4P0MacroVector.is(vector, "AR", "H") && Cvss4P0MacroVector.is(vector, "VA", "H")), new EQ("1", -1, new String[]{"VC:H/VI:H/VA:H/CR:M/IR:M/AR:M", "VC:H/VI:H/VA:L/CR:M/IR:M/AR:H", "VC:H/VI:L/VA:H/CR:M/IR:H/AR:M", "VC:H/VI:L/VA:L/CR:M/IR:H/AR:H", "VC:L/VI:H/VA:H/CR:H/IR:M/AR:M", "VC:L/VI:H/VA:L/CR:H/IR:M/AR:H", "VC:L/VI:L/VA:H/CR:H/IR:H/AR:M", "VC:L/VI:L/VA:L/CR:H/IR:H/AR:H"}, Arrays.asList(vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }), vector -> !(Cvss4P0MacroVector.is(vector, "CR", "H") && Cvss4P0MacroVector.is(vector, "VC", "H") || Cvss4P0MacroVector.is(vector, "IR", "H") && Cvss4P0MacroVector.is(vector, "VI", "H") || Cvss4P0MacroVector.is(vector, "AR", "H") && Cvss4P0MacroVector.is(vector, "VA", "H")))};
    protected static final EQ[] JOINT_EQ3_EQ6_DEFINITIONS = new EQ[]{new EQ("00", 7, new String[]{"VC:H/VI:H/VA:H/CR:H/IR:H/AR:H"}, Collections.singletonList(vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }), vector -> Cvss4P0MacroVector.is(vector, "VC", "H") && Cvss4P0MacroVector.is(vector, "VI", "H") && (Cvss4P0MacroVector.is(vector, "CR", "H") || Cvss4P0MacroVector.is(vector, "IR", "H") || Cvss4P0MacroVector.is(vector, "AR", "H") && Cvss4P0MacroVector.is(vector, "VA", "H"))), new EQ("01", 6, new String[]{"VC:H/VI:H/VA:L/CR:M/IR:M/AR:H", "VC:H/VI:H/VA:H/CR:M/IR:M/AR:M"}, Arrays.asList(vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }), vector -> Cvss4P0MacroVector.is(vector, "VC", "H") && Cvss4P0MacroVector.is(vector, "VI", "H") && !Cvss4P0MacroVector.is(vector, "CR", "H") && !Cvss4P0MacroVector.is(vector, "IR", "H") && (!Cvss4P0MacroVector.is(vector, "AR", "H") || !Cvss4P0MacroVector.is(vector, "VA", "H"))), new EQ("10", 8, new String[]{"VC:L/VI:H/VA:H/CR:H/IR:H/AR:H", "VC:H/VI:L/VA:H/CR:H/IR:H/AR:H"}, Arrays.asList(vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }), vector -> (!Cvss4P0MacroVector.is(vector, "VC", "H") || !Cvss4P0MacroVector.is(vector, "VI", "H")) && (Cvss4P0MacroVector.is(vector, "VC", "H") || Cvss4P0MacroVector.is(vector, "VI", "H") || Cvss4P0MacroVector.is(vector, "VA", "H")) && (Cvss4P0MacroVector.is(vector, "CR", "H") && Cvss4P0MacroVector.is(vector, "VC", "H") || Cvss4P0MacroVector.is(vector, "IR", "H") && Cvss4P0MacroVector.is(vector, "VI", "H") || Cvss4P0MacroVector.is(vector, "AR", "H") && Cvss4P0MacroVector.is(vector, "VA", "H"))), new EQ("11", 8, new String[]{"VC:L/VI:H/VA:L/CR:H/IR:M/AR:H", "VC:L/VI:H/VA:H/CR:H/IR:M/AR:M", "VC:H/VI:L/VA:H/CR:M/IR:H/AR:M", "VC:H/VI:L/VA:L/CR:M/IR:H/AR:H", "VC:L/VI:L/VA:H/CR:H/IR:H/AR:M"}, Arrays.asList(vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }, vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.HIGH);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.MEDIUM);
    }), vector -> !(Cvss4P0MacroVector.is(vector, "VC", "H") && Cvss4P0MacroVector.is(vector, "VI", "H") || !Cvss4P0MacroVector.is(vector, "VC", "H") && !Cvss4P0MacroVector.is(vector, "VI", "H") && !Cvss4P0MacroVector.is(vector, "VA", "H") || Cvss4P0MacroVector.is(vector, "CR", "H") && Cvss4P0MacroVector.is(vector, "VC", "H") || Cvss4P0MacroVector.is(vector, "IR", "H") && Cvss4P0MacroVector.is(vector, "VI", "H") || Cvss4P0MacroVector.is(vector, "AR", "H") && Cvss4P0MacroVector.is(vector, "VA", "H"))), new EQ("20", 0, new String[0], Collections.emptyList(), vector -> false), new EQ("21", 10, new String[]{"VC:L/VI:L/VA:L/CR:H/IR:H/AR:H"}, Collections.singletonList(vector -> {
        vector.setVulnConfidentialityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnIntegrityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setVulnAvailabilityImpact(Cvss4P0.VulnerabilityCia.LOW);
        vector.setConfidentialityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setIntegrityRequirement(Cvss4P0.RequirementsCia.HIGH);
        vector.setAvailabilityRequirement(Cvss4P0.RequirementsCia.HIGH);
    }), vector -> !(Cvss4P0MacroVector.is(vector, "VC", "H") || Cvss4P0MacroVector.is(vector, "VI", "H") || Cvss4P0MacroVector.is(vector, "VA", "H") || Cvss4P0MacroVector.is(vector, "CR", "H") && Cvss4P0MacroVector.is(vector, "VC", "H") || Cvss4P0MacroVector.is(vector, "IR", "H") && Cvss4P0MacroVector.is(vector, "VI", "H") || Cvss4P0MacroVector.is(vector, "AR", "H") && Cvss4P0MacroVector.is(vector, "VA", "H")))};

    public Cvss4P0MacroVector(Cvss4P0 sourceVector) {
        this.eq1 = this.findMatchingEQ("1", EQ1_DEFINITIONS, sourceVector);
        this.eq2 = this.findMatchingEQ("2", EQ2_DEFINITIONS, sourceVector);
        this.eq3 = this.findMatchingEQ("3", EQ3_DEFINITIONS, sourceVector);
        this.eq4 = this.findMatchingEQ("4", EQ4_DEFINITIONS, sourceVector);
        this.eq5 = this.findMatchingEQ("5", EQ5_DEFINITIONS, sourceVector);
        this.eq6 = this.findMatchingEQ("6", EQ6_DEFINITIONS, sourceVector);
        this.jointEq3AndEq6 = this.findMatchingEQ("3,6", JOINT_EQ3_EQ6_DEFINITIONS, sourceVector);
    }

    public Cvss4P0MacroVector(EQ eq1, EQ eq2, EQ eq3, EQ eq4, EQ eq5, EQ eq6, EQ jointEq3AndEq6) {
        this.eq1 = eq1;
        this.eq2 = eq2;
        this.eq3 = eq3;
        this.eq4 = eq4;
        this.eq5 = eq5;
        this.eq6 = eq6;
        this.jointEq3AndEq6 = jointEq3AndEq6;
    }

    private EQ findMatchingEQ(String eqType, EQ[] definitions, Cvss4P0 sourceVector) {
        for (EQ eq : definitions) {
            if (!eq.matchesConstraints(sourceVector)) continue;
            return eq;
        }
        throw new IllegalStateException("No matching EQ found for " + eqType + " and vector " + sourceVector);
    }

    public EQ getEq1() {
        return this.eq1;
    }

    public EQ getEq2() {
        return this.eq2;
    }

    public EQ getEq3() {
        return this.eq3;
    }

    public EQ getEq4() {
        return this.eq4;
    }

    public EQ getEq5() {
        return this.eq5;
    }

    public EQ getEq6() {
        return this.eq6;
    }

    public EQ getJointEq3AndEq6() {
        return this.jointEq3AndEq6;
    }

    public EQ getEQ(int i) {
        switch (i) {
            case 1: {
                return this.eq1;
            }
            case 2: {
                return this.eq2;
            }
            case 3: {
                return this.eq3;
            }
            case 4: {
                return this.eq4;
            }
            case 5: {
                return this.eq5;
            }
            case 6: {
                return this.eq6;
            }
            case 7: {
                return this.jointEq3AndEq6;
            }
        }
        throw new IllegalArgumentException("Invalid EQ index: " + i);
    }

    public double getLookupTableScore() {
        return Cvss4P0Lookup.getMacroVectorScore(this);
    }

    public String toString() {
        return this.eq1.getLevel() + this.eq2.getLevel() + this.eq3.getLevel() + this.eq4.getLevel() + this.eq5.getLevel() + this.eq6.getLevel();
    }

    public Cvss4P0MacroVector deriveNextLower(int i) {
        EQ eq1 = i != 1 ? this.eq1 : Cvss4P0MacroVector.getNextLower(EQ1_DEFINITIONS, this.eq1);
        EQ eq2 = i != 2 ? this.eq2 : Cvss4P0MacroVector.getNextLower(EQ2_DEFINITIONS, this.eq2);
        EQ eq3 = i != 3 ? this.eq3 : Cvss4P0MacroVector.getNextLower(EQ3_DEFINITIONS, this.eq3);
        EQ eq4 = i != 4 ? this.eq4 : Cvss4P0MacroVector.getNextLower(EQ4_DEFINITIONS, this.eq4);
        EQ eq5 = i != 5 ? this.eq5 : Cvss4P0MacroVector.getNextLower(EQ5_DEFINITIONS, this.eq5);
        EQ eq6 = i != 6 ? this.eq6 : Cvss4P0MacroVector.getNextLower(EQ6_DEFINITIONS, this.eq6);
        EQ jointEq3AndEq6 = i != 7 ? this.jointEq3AndEq6 : Cvss4P0MacroVector.getNextLower(JOINT_EQ3_EQ6_DEFINITIONS, this.jointEq3AndEq6);
        return new Cvss4P0MacroVector(eq1, eq2, eq3, eq4, eq5, eq6, jointEq3AndEq6);
    }

    private static int getIndexInDefinitions(EQ[] definitions, EQ eq) {
        for (int i = 0; i < definitions.length; ++i) {
            if (definitions[i] != eq) continue;
            return i;
        }
        throw new IllegalStateException("EQ not found in definitions: " + eq);
    }

    private static EQ getNextLower(EQ[] definitions, EQ eq) {
        int index = Cvss4P0MacroVector.getIndexInDefinitions(definitions, eq);
        return definitions.length > index + 1 ? definitions[index + 1] : EQ_ERROR_DEFINITION;
    }

    private static boolean is(Cvss4P0 vector, String attribute, String value) {
        String comparisonValue = Cvss4P0MacroVector.getComparisonMetric(vector, attribute).getShortIdentifier();
        return value.equals(comparisonValue);
    }

    private static Cvss4P0 v(String vector) {
        return new Cvss4P0(vector);
    }

    public static Cvss4P0.Cvss4P0Attribute getComparisonMetric(Cvss4P0 vector, String attribute) {
        String modifiedSelected;
        Cvss4P0.Cvss4P0Attribute selected = vector.getVectorArgument(attribute);
        if ("E".equals(attribute) && Cvss4P0.ExploitMaturity.NOT_DEFINED.equals(selected)) {
            return Cvss4P0.ExploitMaturity.ATTACKED;
        }
        if (("CR".equals(attribute) || "IR".equals(attribute) || "AR".equals(attribute)) && Cvss4P0.RequirementsCia.NOT_DEFINED.equals(selected)) {
            return Cvss4P0.RequirementsCia.HIGH;
        }
        if ("MSI".equals(attribute) && Cvss4P0.ModifiedSubsequentIntegrityAvailability.NOT_DEFINED.equals(selected) && "S".equals(vector.getVectorArgument("SI").getShortIdentifier())) {
            return Cvss4P0.ModifiedSubsequentIntegrityAvailability.SAFETY;
        }
        if ("MSA".equals(attribute) && Cvss4P0.ModifiedSubsequentIntegrityAvailability.NOT_DEFINED.equals(selected) && "S".equals(vector.getVectorArgument("SA").getShortIdentifier())) {
            return Cvss4P0.ModifiedSubsequentIntegrityAvailability.SAFETY;
        }
        Cvss4P0.Cvss4P0Attribute modifiedAttribute = vector.getVectorArgument("M" + attribute);
        if (modifiedAttribute != null && (modifiedSelected = modifiedAttribute.getShortIdentifier()) != null && !"X".equals(modifiedSelected)) {
            return modifiedAttribute;
        }
        return selected;
    }

    public static class EQ {
        private final String level;
        private final int vectorDepth;
        private final String[] highestSeverityVectorsUnparsed;
        private final Cvss4P0[] highestSeverityVectors;
        private final List<Consumer<Cvss4P0>> applyHighestSeverityVectors;
        private final Predicate<Cvss4P0> predicate;

        public EQ(String level, int vectorDepth, String[] highestSeverityVectors, List<Consumer<Cvss4P0>> applyHighestSeverityVectors, Predicate<Cvss4P0> predicate) {
            this.level = level;
            this.vectorDepth = vectorDepth;
            this.highestSeverityVectorsUnparsed = highestSeverityVectors;
            this.highestSeverityVectors = (Cvss4P0[])Arrays.stream(highestSeverityVectors).map(Cvss4P0::new).toArray(Cvss4P0[]::new);
            this.applyHighestSeverityVectors = applyHighestSeverityVectors;
            this.predicate = predicate;
        }

        public String getLevel() {
            return this.level;
        }

        public int getLevelAsInt() {
            return Integer.parseInt(this.level);
        }

        public int getVectorDepth() {
            return this.vectorDepth;
        }

        public Cvss4P0[] getHighestSeverityVectors() {
            return this.highestSeverityVectors;
        }

        public String[] getHighestSeverityVectorsUnparsed() {
            return this.highestSeverityVectorsUnparsed;
        }

        public List<Consumer<Cvss4P0>> getApplyHighestSeverityVectors() {
            return this.applyHighestSeverityVectors;
        }

        public boolean matchesConstraints(Cvss4P0 vector) {
            return this.predicate.test(vector);
        }
    }
}

