/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.v4P0;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.MultiScoreCvssVector;
import org.metaeffekt.core.security.cvss.processor.BakedCvssVectorScores;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0MacroVector;
import org.metaeffekt.core.security.cvss.v4P0.EqOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cvss4P0
extends CvssVector {
    private static final Logger LOG = LoggerFactory.getLogger(Cvss4P0.class);
    private static final MathContext ROUNDING_MATH_CONTEXT = new MathContext(17, RoundingMode.HALF_UP);
    private static final double ROUNDING_EPSILON = Math.pow(10.0, -6.0);
    public static final String[] VECTOR_PARTS = new String[]{"AV", "AC", "AT", "PR", "UI", "VC", "VI", "VA", "SC", "SI", "SA", "S", "AU", "R", "V", "RE", "U", "MAV", "MAC", "MAT", "MPR", "MUI", "MVC", "MVI", "MVA", "MSC", "MSI", "MSA", "CR", "IR", "AR", "E"};
    private AttackVector attackVector = AttackVector.NOT_DEFINED;
    private AttackComplexity attackComplexity = AttackComplexity.NOT_DEFINED;
    private AttackRequirements attackRequirements = AttackRequirements.NOT_DEFINED;
    private PrivilegesRequired privilegesRequired = PrivilegesRequired.NOT_DEFINED;
    private UserInteraction userInteraction = UserInteraction.NOT_DEFINED;
    private VulnerabilityCia vulnConfidentialityImpact = VulnerabilityCia.NOT_DEFINED;
    private VulnerabilityCia vulnIntegrityImpact = VulnerabilityCia.NOT_DEFINED;
    private VulnerabilityCia vulnAvailabilityImpact = VulnerabilityCia.NOT_DEFINED;
    private SubsequentCia subConfidentialityImpact = SubsequentCia.NOT_DEFINED;
    private SubsequentCia subIntegrityImpact = SubsequentCia.NOT_DEFINED;
    private SubsequentCia subAvailabilityImpact = SubsequentCia.NOT_DEFINED;
    private Safety safety = Safety.NOT_DEFINED;
    private Automatable automatable = Automatable.NOT_DEFINED;
    private Recovery recovery = Recovery.NOT_DEFINED;
    private ValueDensity valueDensity = ValueDensity.NOT_DEFINED;
    private VulnerabilityResponseEffort vulnerabilityResponseEffort = VulnerabilityResponseEffort.NOT_DEFINED;
    private ProviderUrgency providerUrgency = ProviderUrgency.NOT_DEFINED;
    private ModifiedAttackVector modifiedAttackVector = ModifiedAttackVector.NOT_DEFINED;
    private ModifiedAttackComplexity modifiedAttackComplexity = ModifiedAttackComplexity.NOT_DEFINED;
    private ModifiedAttackRequirements modifiedAttackRequirements = ModifiedAttackRequirements.NOT_DEFINED;
    private ModifiedPrivilegesRequired modifiedPrivilegesRequired = ModifiedPrivilegesRequired.NOT_DEFINED;
    private ModifiedUserInteraction modifiedUserInteraction = ModifiedUserInteraction.NOT_DEFINED;
    private ModifiedVulnerabilityCia modifiedVulnConfidentialityImpact = ModifiedVulnerabilityCia.NOT_DEFINED;
    private ModifiedVulnerabilityCia modifiedVulnIntegrityImpact = ModifiedVulnerabilityCia.NOT_DEFINED;
    private ModifiedVulnerabilityCia modifiedVulnAvailabilityImpact = ModifiedVulnerabilityCia.NOT_DEFINED;
    private ModifiedSubsequentConfidentiality modifiedSubConfidentialityImpact = ModifiedSubsequentConfidentiality.NOT_DEFINED;
    private ModifiedSubsequentIntegrityAvailability modifiedSubIntegrityImpact = ModifiedSubsequentIntegrityAvailability.NOT_DEFINED;
    private ModifiedSubsequentIntegrityAvailability modifiedSubAvailabilityImpact = ModifiedSubsequentIntegrityAvailability.NOT_DEFINED;
    private RequirementsCia confidentialityRequirement = RequirementsCia.NOT_DEFINED;
    private RequirementsCia integrityRequirement = RequirementsCia.NOT_DEFINED;
    private RequirementsCia availabilityRequirement = RequirementsCia.NOT_DEFINED;
    private ExploitMaturity exploitMaturity = ExploitMaturity.NOT_DEFINED;
    private static final Pattern TRAILING_SLASH_PATTERN = Pattern.compile("/$");
    private static final Map<Class<?>, Map<String, Object>> ATTRIBUTE_CACHE = new HashMap();
    public static final List<Set<Cvss4P0Attribute>> ATTRIBUTE_SEVERITY_ORDER = Arrays.asList(Cvss4P0.setOf(AttackRequirements.PRESENT, ModifiedAttackRequirements.PRESENT), Cvss4P0.setOf(AttackRequirements.NONE, ModifiedAttackRequirements.NONE), Cvss4P0.setOf(AttackRequirements.NOT_DEFINED, ModifiedAttackRequirements.NOT_DEFINED), Collections.singleton(Safety.NOT_DEFINED), Collections.singleton(Safety.NEGLIGIBLE), Collections.singleton(Safety.PRESENT), Collections.singleton(Automatable.NOT_DEFINED), Collections.singleton(Automatable.NO), Collections.singleton(Automatable.YES), Collections.singleton(ValueDensity.NOT_DEFINED), Collections.singleton(ValueDensity.DIFFUSE), Collections.singleton(ValueDensity.CONCENTRATED), Cvss4P0.setOf(AttackComplexity.HIGH, ModifiedAttackComplexity.HIGH), Cvss4P0.setOf(AttackComplexity.LOW, ModifiedAttackComplexity.LOW), Cvss4P0.setOf(AttackComplexity.NOT_DEFINED, ModifiedAttackComplexity.NOT_DEFINED), Cvss4P0.setOf(PrivilegesRequired.HIGH, ModifiedPrivilegesRequired.HIGH), Cvss4P0.setOf(PrivilegesRequired.LOW, ModifiedPrivilegesRequired.LOW), Cvss4P0.setOf(PrivilegesRequired.NONE, ModifiedPrivilegesRequired.NONE), Cvss4P0.setOf(PrivilegesRequired.NOT_DEFINED, ModifiedPrivilegesRequired.NOT_DEFINED), Cvss4P0.setOf(UserInteraction.ACTIVE, ModifiedUserInteraction.ACTIVE), Cvss4P0.setOf(UserInteraction.PASSIVE, ModifiedUserInteraction.PASSIVE), Cvss4P0.setOf(UserInteraction.NONE, ModifiedUserInteraction.NONE), Cvss4P0.setOf(UserInteraction.NOT_DEFINED, ModifiedUserInteraction.NOT_DEFINED), Cvss4P0.setOf(VulnerabilityCia.NOT_DEFINED, ModifiedVulnerabilityCia.NOT_DEFINED), Cvss4P0.setOf(VulnerabilityCia.NONE, ModifiedVulnerabilityCia.NONE), Cvss4P0.setOf(VulnerabilityCia.LOW, ModifiedVulnerabilityCia.LOW), Cvss4P0.setOf(VulnerabilityCia.HIGH, ModifiedVulnerabilityCia.HIGH), Cvss4P0.setOf(ModifiedSubsequentConfidentiality.NOT_DEFINED, ModifiedSubsequentIntegrityAvailability.NOT_DEFINED, SubsequentCia.NOT_DEFINED), Cvss4P0.setOf(ModifiedSubsequentConfidentiality.NEGLIGIBLE, ModifiedSubsequentIntegrityAvailability.NEGLIGIBLE, SubsequentCia.NONE), Cvss4P0.setOf(ModifiedSubsequentConfidentiality.LOW, ModifiedSubsequentIntegrityAvailability.LOW, SubsequentCia.LOW), Cvss4P0.setOf(ModifiedSubsequentConfidentiality.HIGH, ModifiedSubsequentIntegrityAvailability.HIGH, SubsequentCia.HIGH), Cvss4P0.setOf(ModifiedSubsequentIntegrityAvailability.SAFETY, SubsequentCia.SAFETY), Collections.singleton(RequirementsCia.LOW), Collections.singleton(RequirementsCia.MEDIUM), Collections.singleton(RequirementsCia.HIGH), Collections.singleton(RequirementsCia.NOT_DEFINED), Collections.singleton(ExploitMaturity.UNREPORTED), Collections.singleton(ExploitMaturity.POC), Collections.singleton(ExploitMaturity.ATTACKED), Collections.singleton(ExploitMaturity.NOT_DEFINED), Collections.singleton(Recovery.NOT_DEFINED), Collections.singleton(Recovery.AUTOMATIC), Collections.singleton(Recovery.USER), Collections.singleton(Recovery.IRRECOVERABLE), Collections.singleton(VulnerabilityResponseEffort.NOT_DEFINED), Collections.singleton(VulnerabilityResponseEffort.LOW), Collections.singleton(VulnerabilityResponseEffort.MODERATE), Collections.singleton(VulnerabilityResponseEffort.HIGH), Collections.singleton(ProviderUrgency.NOT_DEFINED), Collections.singleton(ProviderUrgency.CLEAR), Collections.singleton(ProviderUrgency.GREEN), Collections.singleton(ProviderUrgency.AMBER), Collections.singleton(ProviderUrgency.RED), Cvss4P0.setOf(AttackVector.NOT_DEFINED, ModifiedAttackVector.NOT_DEFINED), Cvss4P0.setOf(AttackVector.PHYSICAL, ModifiedAttackVector.PHYSICAL), Cvss4P0.setOf(AttackVector.LOCAL, ModifiedAttackVector.LOCAL), Cvss4P0.setOf(AttackVector.ADJACENT_NETWORK, ModifiedAttackVector.ADJACENT_NETWORK), Cvss4P0.setOf(AttackVector.NETWORK, ModifiedAttackVector.NETWORK));

    public Cvss4P0() {
    }

    public Cvss4P0(String vector) {
        super.applyVector(vector);
    }

    public Cvss4P0(String vector, CvssSource source) {
        super(source);
        super.applyVector(vector);
    }

    public Cvss4P0(String vector, CvssSource source, JSONObject applicabilityCondition) {
        super(source, applicabilityCondition);
        super.applyVector(vector);
    }

    public Cvss4P0(String vector, Collection<CvssSource> sources, JSONObject applicabilityCondition) {
        super(sources, applicabilityCondition);
        super.applyVector(vector);
    }

    public Cvss4P0MacroVector getMacroVector() {
        return new Cvss4P0MacroVector(this);
    }

    @Override
    public boolean applyVectorArgument(String identifier, String value) {
        switch (identifier) {
            case "AV": {
                this.attackVector = AttackVector.fromString(value);
                break;
            }
            case "AC": {
                this.attackComplexity = AttackComplexity.fromString(value);
                break;
            }
            case "AT": {
                this.attackRequirements = AttackRequirements.fromString(value);
                break;
            }
            case "PR": {
                this.privilegesRequired = PrivilegesRequired.fromString(value);
                break;
            }
            case "UI": {
                this.userInteraction = UserInteraction.fromString(value);
                break;
            }
            case "VC": {
                this.vulnConfidentialityImpact = VulnerabilityCia.fromString(value);
                break;
            }
            case "VI": {
                this.vulnIntegrityImpact = VulnerabilityCia.fromString(value);
                break;
            }
            case "VA": {
                this.vulnAvailabilityImpact = VulnerabilityCia.fromString(value);
                break;
            }
            case "SC": {
                this.subConfidentialityImpact = SubsequentCia.fromString(value);
                break;
            }
            case "SI": {
                this.subIntegrityImpact = SubsequentCia.fromString(value);
                break;
            }
            case "SA": {
                this.subAvailabilityImpact = SubsequentCia.fromString(value);
                break;
            }
            case "S": {
                this.safety = Safety.fromString(value);
                break;
            }
            case "AU": {
                this.automatable = Automatable.fromString(value);
                break;
            }
            case "R": {
                this.recovery = Recovery.fromString(value);
                break;
            }
            case "V": {
                this.valueDensity = ValueDensity.fromString(value);
                break;
            }
            case "RE": {
                this.vulnerabilityResponseEffort = VulnerabilityResponseEffort.fromString(value);
                break;
            }
            case "U": {
                this.providerUrgency = ProviderUrgency.fromString(value);
                break;
            }
            case "MAV": {
                this.modifiedAttackVector = ModifiedAttackVector.fromString(value);
                break;
            }
            case "MAC": {
                this.modifiedAttackComplexity = ModifiedAttackComplexity.fromString(value);
                break;
            }
            case "MAT": {
                this.modifiedAttackRequirements = ModifiedAttackRequirements.fromString(value);
                break;
            }
            case "MPR": {
                this.modifiedPrivilegesRequired = ModifiedPrivilegesRequired.fromString(value);
                break;
            }
            case "MUI": {
                this.modifiedUserInteraction = ModifiedUserInteraction.fromString(value);
                break;
            }
            case "MVC": {
                this.modifiedVulnConfidentialityImpact = ModifiedVulnerabilityCia.fromString(value);
                break;
            }
            case "MVI": {
                this.modifiedVulnIntegrityImpact = ModifiedVulnerabilityCia.fromString(value);
                break;
            }
            case "MVA": {
                this.modifiedVulnAvailabilityImpact = ModifiedVulnerabilityCia.fromString(value);
                break;
            }
            case "MSC": {
                this.modifiedSubConfidentialityImpact = ModifiedSubsequentConfidentiality.fromString(value);
                break;
            }
            case "MSI": {
                this.modifiedSubIntegrityImpact = ModifiedSubsequentIntegrityAvailability.fromString(value);
                break;
            }
            case "MSA": {
                this.modifiedSubAvailabilityImpact = ModifiedSubsequentIntegrityAvailability.fromString(value);
                break;
            }
            case "CR": {
                this.confidentialityRequirement = RequirementsCia.fromString(value);
                break;
            }
            case "IR": {
                this.integrityRequirement = RequirementsCia.fromString(value);
                break;
            }
            case "AR": {
                this.availabilityRequirement = RequirementsCia.fromString(value);
                break;
            }
            case "E": {
                this.exploitMaturity = ExploitMaturity.fromString(value);
                break;
            }
            default: {
                LOG.debug("Unknown CVSS 4.0 vector argument: [{}] [{}]", (Object)identifier, (Object)value);
                return false;
            }
        }
        return true;
    }

    @Override
    public Cvss4P0Attribute getVectorArgument(String identifier) {
        switch (identifier) {
            case "AV": {
                return this.attackVector;
            }
            case "AC": {
                return this.attackComplexity;
            }
            case "AT": {
                return this.attackRequirements;
            }
            case "PR": {
                return this.privilegesRequired;
            }
            case "UI": {
                return this.userInteraction;
            }
            case "VC": {
                return this.vulnConfidentialityImpact;
            }
            case "VI": {
                return this.vulnIntegrityImpact;
            }
            case "VA": {
                return this.vulnAvailabilityImpact;
            }
            case "SC": {
                return this.subConfidentialityImpact;
            }
            case "SI": {
                return this.subIntegrityImpact;
            }
            case "SA": {
                return this.subAvailabilityImpact;
            }
            case "S": {
                return this.safety;
            }
            case "AU": {
                return this.automatable;
            }
            case "R": {
                return this.recovery;
            }
            case "V": {
                return this.valueDensity;
            }
            case "RE": {
                return this.vulnerabilityResponseEffort;
            }
            case "U": {
                return this.providerUrgency;
            }
            case "MAV": {
                return this.modifiedAttackVector;
            }
            case "MAC": {
                return this.modifiedAttackComplexity;
            }
            case "MAT": {
                return this.modifiedAttackRequirements;
            }
            case "MPR": {
                return this.modifiedPrivilegesRequired;
            }
            case "MUI": {
                return this.modifiedUserInteraction;
            }
            case "MVC": {
                return this.modifiedVulnConfidentialityImpact;
            }
            case "MVI": {
                return this.modifiedVulnIntegrityImpact;
            }
            case "MVA": {
                return this.modifiedVulnAvailabilityImpact;
            }
            case "MSC": {
                return this.modifiedSubConfidentialityImpact;
            }
            case "MSI": {
                return this.modifiedSubIntegrityImpact;
            }
            case "MSA": {
                return this.modifiedSubAvailabilityImpact;
            }
            case "CR": {
                return this.confidentialityRequirement;
            }
            case "IR": {
                return this.integrityRequirement;
            }
            case "AR": {
                return this.availabilityRequirement;
            }
            case "E": {
                return this.exploitMaturity;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cvss4P0)) {
            return false;
        }
        Cvss4P0 cvss4P0 = (Cvss4P0)o;
        return this.attackVector == cvss4P0.attackVector && this.attackComplexity == cvss4P0.attackComplexity && this.attackRequirements == cvss4P0.attackRequirements && this.privilegesRequired == cvss4P0.privilegesRequired && this.userInteraction == cvss4P0.userInteraction && this.vulnConfidentialityImpact == cvss4P0.vulnConfidentialityImpact && this.vulnIntegrityImpact == cvss4P0.vulnIntegrityImpact && this.vulnAvailabilityImpact == cvss4P0.vulnAvailabilityImpact && this.subConfidentialityImpact == cvss4P0.subConfidentialityImpact && this.subIntegrityImpact == cvss4P0.subIntegrityImpact && this.subAvailabilityImpact == cvss4P0.subAvailabilityImpact && this.modifiedAttackVector == cvss4P0.modifiedAttackVector && this.modifiedAttackComplexity == cvss4P0.modifiedAttackComplexity && this.modifiedAttackRequirements == cvss4P0.modifiedAttackRequirements && this.modifiedPrivilegesRequired == cvss4P0.modifiedPrivilegesRequired && this.modifiedUserInteraction == cvss4P0.modifiedUserInteraction && this.modifiedVulnConfidentialityImpact == cvss4P0.modifiedVulnConfidentialityImpact && this.modifiedVulnIntegrityImpact == cvss4P0.modifiedVulnIntegrityImpact && this.modifiedVulnAvailabilityImpact == cvss4P0.modifiedVulnAvailabilityImpact && this.modifiedSubConfidentialityImpact == cvss4P0.modifiedSubConfidentialityImpact && this.modifiedSubIntegrityImpact == cvss4P0.modifiedSubIntegrityImpact && this.modifiedSubAvailabilityImpact == cvss4P0.modifiedSubAvailabilityImpact && this.confidentialityRequirement == cvss4P0.confidentialityRequirement && this.integrityRequirement == cvss4P0.integrityRequirement && this.availabilityRequirement == cvss4P0.availabilityRequirement && this.exploitMaturity == cvss4P0.exploitMaturity && this.safety == cvss4P0.safety && this.automatable == cvss4P0.automatable && this.recovery == cvss4P0.recovery && this.valueDensity == cvss4P0.valueDensity && this.vulnerabilityResponseEffort == cvss4P0.vulnerabilityResponseEffort && this.providerUrgency == cvss4P0.providerUrgency;
    }

    public void fillLeastSevereBaseMetrics() {
        this.attackVector = AttackVector.NETWORK;
        this.attackComplexity = AttackComplexity.LOW;
        this.attackRequirements = AttackRequirements.NONE;
        this.privilegesRequired = PrivilegesRequired.NONE;
        this.userInteraction = UserInteraction.NONE;
        this.vulnConfidentialityImpact = VulnerabilityCia.NONE;
        this.vulnIntegrityImpact = VulnerabilityCia.NONE;
        this.vulnAvailabilityImpact = VulnerabilityCia.NONE;
        this.subConfidentialityImpact = SubsequentCia.NONE;
        this.subIntegrityImpact = SubsequentCia.NONE;
        this.subAvailabilityImpact = SubsequentCia.NONE;
    }

    @Override
    public boolean isBaseFullyDefined() {
        return this.attackVector != AttackVector.NOT_DEFINED && this.attackComplexity != AttackComplexity.NOT_DEFINED && this.attackRequirements != AttackRequirements.NOT_DEFINED && this.privilegesRequired != PrivilegesRequired.NOT_DEFINED && this.userInteraction != UserInteraction.NOT_DEFINED && this.vulnConfidentialityImpact != VulnerabilityCia.NOT_DEFINED && this.vulnIntegrityImpact != VulnerabilityCia.NOT_DEFINED && this.vulnAvailabilityImpact != VulnerabilityCia.NOT_DEFINED && this.subConfidentialityImpact != SubsequentCia.NOT_DEFINED && this.subIntegrityImpact != SubsequentCia.NOT_DEFINED && this.subAvailabilityImpact != SubsequentCia.NOT_DEFINED;
    }

    @Override
    public boolean isAnyBaseDefined() {
        return this.attackVector != AttackVector.NOT_DEFINED || this.attackComplexity != AttackComplexity.NOT_DEFINED || this.attackRequirements != AttackRequirements.NOT_DEFINED || this.privilegesRequired != PrivilegesRequired.NOT_DEFINED || this.userInteraction != UserInteraction.NOT_DEFINED || this.vulnConfidentialityImpact != VulnerabilityCia.NOT_DEFINED || this.vulnIntegrityImpact != VulnerabilityCia.NOT_DEFINED || this.vulnAvailabilityImpact != VulnerabilityCia.NOT_DEFINED || this.subConfidentialityImpact != SubsequentCia.NOT_DEFINED || this.subIntegrityImpact != SubsequentCia.NOT_DEFINED || this.subAvailabilityImpact != SubsequentCia.NOT_DEFINED;
    }

    public boolean isAnyEnvironmentalDefined() {
        return this.modifiedAttackVector != ModifiedAttackVector.NOT_DEFINED || this.modifiedAttackComplexity != ModifiedAttackComplexity.NOT_DEFINED || this.modifiedAttackRequirements != ModifiedAttackRequirements.NOT_DEFINED || this.modifiedPrivilegesRequired != ModifiedPrivilegesRequired.NOT_DEFINED || this.modifiedUserInteraction != ModifiedUserInteraction.NOT_DEFINED || this.modifiedVulnConfidentialityImpact != ModifiedVulnerabilityCia.NOT_DEFINED || this.modifiedVulnIntegrityImpact != ModifiedVulnerabilityCia.NOT_DEFINED || this.modifiedVulnAvailabilityImpact != ModifiedVulnerabilityCia.NOT_DEFINED || this.modifiedSubConfidentialityImpact != ModifiedSubsequentConfidentiality.NOT_DEFINED || this.modifiedSubIntegrityImpact != ModifiedSubsequentIntegrityAvailability.NOT_DEFINED || this.modifiedSubAvailabilityImpact != ModifiedSubsequentIntegrityAvailability.NOT_DEFINED || this.confidentialityRequirement != RequirementsCia.NOT_DEFINED || this.integrityRequirement != RequirementsCia.NOT_DEFINED || this.availabilityRequirement != RequirementsCia.NOT_DEFINED;
    }

    public boolean isEnvironmentalFullyDefined() {
        return this.modifiedAttackVector != ModifiedAttackVector.NOT_DEFINED && this.modifiedAttackComplexity != ModifiedAttackComplexity.NOT_DEFINED && this.modifiedAttackRequirements != ModifiedAttackRequirements.NOT_DEFINED && this.modifiedPrivilegesRequired != ModifiedPrivilegesRequired.NOT_DEFINED && this.modifiedUserInteraction != ModifiedUserInteraction.NOT_DEFINED && this.modifiedVulnConfidentialityImpact != ModifiedVulnerabilityCia.NOT_DEFINED && this.modifiedVulnIntegrityImpact != ModifiedVulnerabilityCia.NOT_DEFINED && this.modifiedVulnAvailabilityImpact != ModifiedVulnerabilityCia.NOT_DEFINED && this.modifiedSubConfidentialityImpact != ModifiedSubsequentConfidentiality.NOT_DEFINED && this.modifiedSubIntegrityImpact != ModifiedSubsequentIntegrityAvailability.NOT_DEFINED && this.modifiedSubAvailabilityImpact != ModifiedSubsequentIntegrityAvailability.NOT_DEFINED && this.confidentialityRequirement != RequirementsCia.NOT_DEFINED && this.integrityRequirement != RequirementsCia.NOT_DEFINED && this.availabilityRequirement != RequirementsCia.NOT_DEFINED;
    }

    public boolean isAnyThreatDefined() {
        return this.exploitMaturity != ExploitMaturity.NOT_DEFINED;
    }

    public boolean isThreatFullyDefined() {
        return this.exploitMaturity != ExploitMaturity.NOT_DEFINED;
    }

    private void clearEnvironmental() {
        this.modifiedAttackVector = ModifiedAttackVector.NOT_DEFINED;
        this.modifiedAttackComplexity = ModifiedAttackComplexity.NOT_DEFINED;
        this.modifiedAttackRequirements = ModifiedAttackRequirements.NOT_DEFINED;
        this.modifiedPrivilegesRequired = ModifiedPrivilegesRequired.NOT_DEFINED;
        this.modifiedUserInteraction = ModifiedUserInteraction.NOT_DEFINED;
        this.modifiedVulnConfidentialityImpact = ModifiedVulnerabilityCia.NOT_DEFINED;
        this.modifiedVulnIntegrityImpact = ModifiedVulnerabilityCia.NOT_DEFINED;
        this.modifiedVulnAvailabilityImpact = ModifiedVulnerabilityCia.NOT_DEFINED;
        this.modifiedSubConfidentialityImpact = ModifiedSubsequentConfidentiality.NOT_DEFINED;
        this.modifiedSubIntegrityImpact = ModifiedSubsequentIntegrityAvailability.NOT_DEFINED;
        this.modifiedSubAvailabilityImpact = ModifiedSubsequentIntegrityAvailability.NOT_DEFINED;
    }

    private void clearThreat() {
        this.exploitMaturity = ExploitMaturity.NOT_DEFINED;
    }

    @Override
    public double getBaseScore() {
        if (this.isAnyEnvironmentalDefined() || this.isAnyThreatDefined()) {
            Cvss4P0 vector = this.clone();
            vector.clearEnvironmental();
            vector.clearThreat();
            return vector.getOverallScore();
        }
        return this.getOverallScore();
    }

    public double getEnvironmentalScore() {
        if (this.isAnyEnvironmentalDefined()) {
            if (this.isAnyThreatDefined()) {
                Cvss4P0 vector = this.clone();
                vector.clearThreat();
                return vector.getOverallScore();
            }
            return this.getOverallScore();
        }
        return Double.NaN;
    }

    public double getThreatScore() {
        if (this.isAnyThreatDefined()) {
            if (this.isAnyEnvironmentalDefined()) {
                Cvss4P0 vector = this.clone();
                vector.clearEnvironmental();
                return vector.getOverallScore();
            }
            return this.getOverallScore();
        }
        return Double.NaN;
    }

    @Override
    public double getOverallScore() {
        List allHighestSeverityVectors;
        List<Cvss4P0> highestSeverityVectorCombinations;
        if (!this.isBaseFullyDefined()) {
            return 0.0;
        }
        if (Stream.of("VC", "VI", "VA", "SC", "SI", "SA").map(attr -> Cvss4P0MacroVector.getComparisonMetric(this, attr)).allMatch(value -> value.getShortIdentifier().equals("N"))) {
            return 0.0;
        }
        Cvss4P0MacroVector thisMacroVector = this.getMacroVector();
        double thisMacroVectorScore = thisMacroVector.getLookupTableScore();
        EqOperations[] eqOperations = EqOperations.getEqImplementations();
        if (!(thisMacroVector.getEq3().getLevel() + thisMacroVector.getEq6().getLevel()).equalsIgnoreCase(thisMacroVector.getJointEq3AndEq6().getLevel())) {
            LOG.warn("CVSS 4.0: Joint Eq3 and Eq6 level [{}] does not match Eq3 [{}] and Eq6 [{}]", new Object[]{thisMacroVector.getJointEq3AndEq6().getLevel(), thisMacroVector.getEq3().getLevel(), thisMacroVector.getEq6().getLevel()});
        }
        if ((highestSeverityVectorCombinations = this.generateCvssPermutationsFn((List)(allHighestSeverityVectors = Arrays.stream(eqOperations).map(eqOp -> eqOp.getHighestSeverityVectorsFn(thisMacroVector)).collect(Collectors.toList())).get(0), (List)allHighestSeverityVectors.get(1), (List)allHighestSeverityVectors.get(2), (List)allHighestSeverityVectors.get(3), (List)allHighestSeverityVectors.get(4))).isEmpty()) {
            LOG.warn("No max vectors found for {}", (Object)thisMacroVector);
            return 0.0;
        }
        Map<String, Integer> highestSeveritySeverityDistances = Cvss4P0.calculateSeverityDistancesByComparingToHighestSeverityVectors(this, highestSeverityVectorCombinations);
        Average meanScoreAdjustment = new Average();
        for (EqOperations eqOps : eqOperations) {
            Cvss4P0MacroVector[] nextLessSevereMacroVector = eqOps.deriveNextLowerMacro(thisMacroVector);
            double nextLowerMacroScore = eqOps.lookupScoresForNextLowerMacro(nextLessSevereMacroVector);
            double availableSeverityReduction = thisMacroVectorScore - nextLowerMacroScore;
            int macroVectorDepth = eqOps.lookupMacroVectorDepth(thisMacroVector);
            int severityDistanceFromThisToHighestSeverity = Arrays.stream(eqOps.getRelevantAttributes()).mapToInt(highestSeveritySeverityDistances::get).sum();
            if (Double.isNaN(availableSeverityReduction) || (double)macroVectorDepth == 0.0) continue;
            double percentageToNextSeverityDistance = (double)severityDistanceFromThisToHighestSeverity / (double)macroVectorDepth;
            double normalizedSeverityDistance = percentageToNextSeverityDistance * availableSeverityReduction;
            meanScoreAdjustment.add(normalizedSeverityDistance);
        }
        double adjustedOriginalMacroVectorScore = thisMacroVectorScore - meanScoreAdjustment.getOrDefault(0.0);
        if (adjustedOriginalMacroVectorScore < 0.0) {
            return 0.0;
        }
        if (adjustedOriginalMacroVectorScore > 10.0) {
            return 10.0;
        }
        return Double.parseDouble(this.javaScriptToFixed(adjustedOriginalMacroVectorScore, 1));
    }

    private String javaScriptToFixed(double number, int fractionDigits) {
        return new BigDecimal(number + ROUNDING_EPSILON, ROUNDING_MATH_CONTEXT).setScale(fractionDigits, RoundingMode.HALF_UP).toPlainString().replace(",", ".");
    }

    private static Map<String, Integer> calculateSeverityDistancesByComparingToHighestSeverityVectors(Cvss4P0 comparisonVector, List<Cvss4P0> highestSeverityVectors) {
        LinkedHashMap<String, Integer> severityDistances = new LinkedHashMap<String, Integer>();
        for (Cvss4P0 maxVector : highestSeverityVectors) {
            severityDistances.put("AV", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "AV"), maxVector.getAttackVector()));
            severityDistances.put("PR", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "PR"), maxVector.getPrivilegesRequired()));
            severityDistances.put("UI", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "UI"), maxVector.getUserInteraction()));
            severityDistances.put("AC", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "AC"), maxVector.getAttackComplexity()));
            severityDistances.put("AT", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "AT"), maxVector.getAttackRequirements()));
            severityDistances.put("VC", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "VC"), maxVector.getVulnConfidentialityImpact()));
            severityDistances.put("VI", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "VI"), maxVector.getVulnIntegrityImpact()));
            severityDistances.put("VA", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "VA"), maxVector.getVulnAvailabilityImpact()));
            severityDistances.put("SC", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "SC"), maxVector.getSubConfidentialityImpact()));
            severityDistances.put("CR", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "CR"), maxVector.getConfidentialityRequirement()));
            severityDistances.put("IR", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "IR"), maxVector.getIntegrityRequirement()));
            severityDistances.put("AR", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, "AR"), maxVector.getAvailabilityRequirement()));
            boolean isModifiedSubIntegrityImpactSafety = ModifiedSubsequentIntegrityAvailability.SAFETY == comparisonVector.getModifiedSubIntegrityImpact();
            boolean isModifiedSubAvailabilityImpactSafety = ModifiedSubsequentIntegrityAvailability.SAFETY == comparisonVector.getModifiedSubAvailabilityImpact();
            String subIntegrityImpactKey = isModifiedSubIntegrityImpactSafety ? "MSI" : "SI";
            String subAvailabilityImpactKey = isModifiedSubAvailabilityImpactSafety ? "MSA" : "SA";
            severityDistances.put("SI", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, subIntegrityImpactKey), maxVector.getSubIntegrityImpact()));
            severityDistances.put("SA", Cvss4P0.severityDistance(Cvss4P0MacroVector.getComparisonMetric(comparisonVector, subAvailabilityImpactKey), maxVector.getSubAvailabilityImpact()));
            boolean anyNegative = severityDistances.values().stream().anyMatch(val -> val < 0);
            if (!anyNegative) break;
            severityDistances.clear();
        }
        if (severityDistances.isEmpty()) {
            LOG.warn("No severity distances found for [{}]: {}", (Object)comparisonVector.getMacroVector(), (Object)comparisonVector);
            LOG.info("Max vectors:");
            for (Cvss4P0 maxVector : highestSeverityVectors) {
                LOG.info(" {}", (Object)Cvss4P0.toString(new Cvss4P0[]{maxVector}, "AV", "PR", "UI", "AC", "AT", "VC", "VI", "VA", "CR", "IR", "AR", "SC", "SI", "SA", "E"));
            }
        }
        return severityDistances;
    }

    private List<Cvss4P0> generateCvssPermutationsFn(List<Consumer<Cvss4P0>> eq1_max_vectors, List<Consumer<Cvss4P0>> eq2_max_vectors, List<Consumer<Cvss4P0>> eq3_eq6_max_vectors, List<Consumer<Cvss4P0>> eq4_max_vectors, List<Consumer<Cvss4P0>> eq5_max_vectors) {
        ArrayList<Cvss4P0> highestSeverityVectors = new ArrayList<Cvss4P0>();
        for (Consumer<Cvss4P0> eq1Max : eq1_max_vectors) {
            for (Consumer<Cvss4P0> eq2Max : eq2_max_vectors) {
                for (Consumer<Cvss4P0> eq3Eq6Max : eq3_eq6_max_vectors) {
                    for (Consumer<Cvss4P0> eq4Max : eq4_max_vectors) {
                        for (Consumer<Cvss4P0> eq5Max : eq5_max_vectors) {
                            Cvss4P0 vector = new Cvss4P0();
                            eq1Max.accept(vector);
                            eq2Max.accept(vector);
                            eq3Eq6Max.accept(vector);
                            eq4Max.accept(vector);
                            eq5Max.accept(vector);
                            highestSeverityVectors.add(vector);
                        }
                    }
                }
            }
        }
        return highestSeverityVectors;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int severityDistance(Cvss4P0Attribute part1, Cvss4P0Attribute part2) {
        Cvss4P0Attribute effectiveAttribute2;
        Cvss4P0Attribute effectiveAttribute1;
        block5: {
            Cvss4P0Attribute worseCaseAttribute2;
            Cvss4P0Attribute worseCaseAttribute1;
            block6: {
                worseCaseAttribute1 = "X".equals(part1.getShortIdentifier()) ? part1.getWorseCase() : part1;
                worseCaseAttribute2 = "X".equals(part2.getShortIdentifier()) ? part2.getWorseCase() : part2;
                Class<?> clazz1 = worseCaseAttribute1.getClass();
                Class<?> clazz2 = worseCaseAttribute2.getClass();
                if (!clazz1.isEnum() || !clazz2.isEnum()) {
                    LOG.warn("Cannot compute severity distance for [{}] and [{}], assuming distance is 0", (Object)worseCaseAttribute1, (Object)worseCaseAttribute2);
                    return 0;
                }
                Enum worseCaseEnum1 = (Enum)((Object)worseCaseAttribute1);
                Enum worseCaseEnum2 = (Enum)((Object)worseCaseAttribute2);
                if (clazz1.equals(clazz2)) break block6;
                boolean isModifiedAttribute1 = worseCaseAttribute1.getClass().getSimpleName().startsWith("Modified");
                boolean isModifiedAttribute2 = worseCaseAttribute2.getClass().getSimpleName().startsWith("Modified");
                if (isModifiedAttribute1 && !isModifiedAttribute2) {
                    Cvss4P0Attribute[] enum1Values = (Cvss4P0Attribute[])worseCaseEnum1.getClass().getEnumConstants();
                    effectiveAttribute1 = worseCaseAttribute1;
                    effectiveAttribute2 = Arrays.stream(enum1Values).filter(v -> v.getShortIdentifier().equals(worseCaseAttribute2.getShortIdentifier())).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find modified enum value for " + worseCaseAttribute2));
                    break block5;
                } else if (!isModifiedAttribute1 && isModifiedAttribute2) {
                    Cvss4P0Attribute[] enum2Values = (Cvss4P0Attribute[])worseCaseEnum2.getClass().getEnumConstants();
                    effectiveAttribute1 = Arrays.stream(enum2Values).filter(v -> v.getShortIdentifier().equals(worseCaseAttribute1.getShortIdentifier())).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find modified enum value for " + worseCaseAttribute1));
                    effectiveAttribute2 = worseCaseAttribute2;
                    break block5;
                } else {
                    LOG.warn("Cannot compute severity distance for [{}] and [{}], assuming distance is 0", (Object)worseCaseAttribute1, (Object)worseCaseAttribute2);
                    return 0;
                }
            }
            effectiveAttribute1 = worseCaseAttribute1;
            effectiveAttribute2 = worseCaseAttribute2;
        }
        Enum effectiveEnum1 = (Enum)((Object)effectiveAttribute1);
        Enum effectiveEnum2 = (Enum)((Object)effectiveAttribute2);
        int ordinal1 = effectiveEnum1.ordinal();
        int ordinal2 = effectiveEnum2.ordinal();
        return ordinal1 - ordinal2;
    }

    public static int severityDistance(Cvss4P0 v1, Cvss4P0 v2) {
        return Arrays.stream(VECTOR_PARTS).map(p -> Cvss4P0.severityDistance(v1.getVectorArgument((String)p), v2.getVectorArgument((String)p))).reduce(0, Integer::sum);
    }

    public int severityDistance(Cvss4P0 other) {
        return Cvss4P0.severityDistance(this, other);
    }

    @Override
    protected void completeVector() {
    }

    @Override
    public Cvss4P0 clone() {
        Cvss4P0 clone = super.cloneInternal(new Cvss4P0());
        clone.attackVector = this.attackVector;
        clone.attackComplexity = this.attackComplexity;
        clone.attackRequirements = this.attackRequirements;
        clone.privilegesRequired = this.privilegesRequired;
        clone.userInteraction = this.userInteraction;
        clone.vulnConfidentialityImpact = this.vulnConfidentialityImpact;
        clone.vulnIntegrityImpact = this.vulnIntegrityImpact;
        clone.vulnAvailabilityImpact = this.vulnAvailabilityImpact;
        clone.subConfidentialityImpact = this.subConfidentialityImpact;
        clone.subIntegrityImpact = this.subIntegrityImpact;
        clone.subAvailabilityImpact = this.subAvailabilityImpact;
        clone.exploitMaturity = this.exploitMaturity;
        clone.confidentialityRequirement = this.confidentialityRequirement;
        clone.integrityRequirement = this.integrityRequirement;
        clone.availabilityRequirement = this.availabilityRequirement;
        clone.modifiedAttackVector = this.modifiedAttackVector;
        clone.modifiedAttackComplexity = this.modifiedAttackComplexity;
        clone.modifiedAttackRequirements = this.modifiedAttackRequirements;
        clone.modifiedPrivilegesRequired = this.modifiedPrivilegesRequired;
        clone.modifiedUserInteraction = this.modifiedUserInteraction;
        clone.modifiedVulnConfidentialityImpact = this.modifiedVulnConfidentialityImpact;
        clone.modifiedVulnIntegrityImpact = this.modifiedVulnIntegrityImpact;
        clone.modifiedVulnAvailabilityImpact = this.modifiedVulnAvailabilityImpact;
        clone.modifiedSubConfidentialityImpact = this.modifiedSubConfidentialityImpact;
        clone.modifiedSubIntegrityImpact = this.modifiedSubIntegrityImpact;
        clone.modifiedSubAvailabilityImpact = this.modifiedSubAvailabilityImpact;
        clone.safety = this.safety;
        clone.automatable = this.automatable;
        clone.recovery = this.recovery;
        clone.valueDensity = this.valueDensity;
        clone.vulnerabilityResponseEffort = this.vulnerabilityResponseEffort;
        clone.providerUrgency = this.providerUrgency;
        return clone;
    }

    public static String getVersionName() {
        return "CVSS:4.0";
    }

    @Override
    public String getName() {
        return Cvss4P0.getVersionName();
    }

    @Override
    public String getNistFirstWebEditorLink() {
        return String.format("https://www.first.org/cvss/calculator/4.0#%s", this);
    }

    public String getNomenclature() {
        boolean baseDefined = this.isAnyBaseDefined();
        boolean environmentalDefined = this.isAnyEnvironmentalDefined();
        boolean threatDefined = this.isAnyThreatDefined();
        return "CVSS-" + (baseDefined ? "B" : "") + (threatDefined ? "T" : "") + (environmentalDefined ? "E" : "");
    }

    @Override
    public String toString(boolean filterUndefinedProperties) {
        StringBuilder vector = new StringBuilder();
        vector.append(this.getName()).append("/");
        boolean appendAnyways = !filterUndefinedProperties;
        this.appendIfNotDefault(vector, "AV", this.attackVector, AttackVector.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "AC", this.attackComplexity, AttackComplexity.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "AT", this.attackRequirements, AttackRequirements.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "PR", this.privilegesRequired, PrivilegesRequired.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "UI", this.userInteraction, UserInteraction.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "VC", this.vulnConfidentialityImpact, VulnerabilityCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "VI", this.vulnIntegrityImpact, VulnerabilityCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "VA", this.vulnAvailabilityImpact, VulnerabilityCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "SC", this.subConfidentialityImpact, SubsequentCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "SI", this.subIntegrityImpact, SubsequentCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "SA", this.subAvailabilityImpact, SubsequentCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "E", this.exploitMaturity, ExploitMaturity.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "CR", this.confidentialityRequirement, RequirementsCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "IR", this.integrityRequirement, RequirementsCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "AR", this.availabilityRequirement, RequirementsCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MAV", this.modifiedAttackVector, ModifiedAttackVector.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MAC", this.modifiedAttackComplexity, ModifiedAttackComplexity.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MAT", this.modifiedAttackRequirements, ModifiedAttackRequirements.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MPR", this.modifiedPrivilegesRequired, ModifiedPrivilegesRequired.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MUI", this.modifiedUserInteraction, ModifiedUserInteraction.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MVC", this.modifiedVulnConfidentialityImpact, ModifiedVulnerabilityCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MVI", this.modifiedVulnIntegrityImpact, ModifiedVulnerabilityCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MVA", this.modifiedVulnAvailabilityImpact, ModifiedVulnerabilityCia.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MSC", this.modifiedSubConfidentialityImpact, ModifiedSubsequentConfidentiality.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MSI", this.modifiedSubIntegrityImpact, ModifiedSubsequentIntegrityAvailability.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "MSA", this.modifiedSubAvailabilityImpact, ModifiedSubsequentIntegrityAvailability.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "S", this.safety, Safety.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "AU", this.automatable, Automatable.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "R", this.recovery, Recovery.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "V", this.valueDensity, ValueDensity.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "RE", this.vulnerabilityResponseEffort, VulnerabilityResponseEffort.NOT_DEFINED, appendAnyways);
        this.appendIfNotDefault(vector, "U", this.providerUrgency, ProviderUrgency.NOT_DEFINED, appendAnyways);
        return TRAILING_SLASH_PATTERN.matcher(vector.toString()).replaceAll("");
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public int size() {
        int size = 0;
        if (this.attackVector != AttackVector.NOT_DEFINED) {
            ++size;
        }
        if (this.attackComplexity != AttackComplexity.NOT_DEFINED) {
            ++size;
        }
        if (this.attackRequirements != AttackRequirements.NOT_DEFINED) {
            ++size;
        }
        if (this.privilegesRequired != PrivilegesRequired.NOT_DEFINED) {
            ++size;
        }
        if (this.userInteraction != UserInteraction.NOT_DEFINED) {
            ++size;
        }
        if (this.vulnConfidentialityImpact != VulnerabilityCia.NOT_DEFINED) {
            ++size;
        }
        if (this.vulnIntegrityImpact != VulnerabilityCia.NOT_DEFINED) {
            ++size;
        }
        if (this.vulnAvailabilityImpact != VulnerabilityCia.NOT_DEFINED) {
            ++size;
        }
        if (this.subConfidentialityImpact != SubsequentCia.NOT_DEFINED) {
            ++size;
        }
        if (this.subIntegrityImpact != SubsequentCia.NOT_DEFINED) {
            ++size;
        }
        if (this.subAvailabilityImpact != SubsequentCia.NOT_DEFINED) {
            ++size;
        }
        if (this.safety != Safety.NOT_DEFINED) {
            ++size;
        }
        if (this.automatable != Automatable.NOT_DEFINED) {
            ++size;
        }
        if (this.recovery != Recovery.NOT_DEFINED) {
            ++size;
        }
        if (this.valueDensity != ValueDensity.NOT_DEFINED) {
            ++size;
        }
        if (this.vulnerabilityResponseEffort != VulnerabilityResponseEffort.NOT_DEFINED) {
            ++size;
        }
        if (this.providerUrgency != ProviderUrgency.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedAttackVector != ModifiedAttackVector.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedAttackComplexity != ModifiedAttackComplexity.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedAttackRequirements != ModifiedAttackRequirements.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedPrivilegesRequired != ModifiedPrivilegesRequired.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedUserInteraction != ModifiedUserInteraction.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedVulnConfidentialityImpact != ModifiedVulnerabilityCia.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedVulnIntegrityImpact != ModifiedVulnerabilityCia.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedVulnAvailabilityImpact != ModifiedVulnerabilityCia.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedSubConfidentialityImpact != ModifiedSubsequentConfidentiality.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedSubIntegrityImpact != ModifiedSubsequentIntegrityAvailability.NOT_DEFINED) {
            ++size;
        }
        if (this.modifiedSubAvailabilityImpact != ModifiedSubsequentIntegrityAvailability.NOT_DEFINED) {
            ++size;
        }
        if (this.confidentialityRequirement != RequirementsCia.NOT_DEFINED) {
            ++size;
        }
        if (this.integrityRequirement != RequirementsCia.NOT_DEFINED) {
            ++size;
        }
        if (this.availabilityRequirement != RequirementsCia.NOT_DEFINED) {
            ++size;
        }
        if (this.exploitMaturity != ExploitMaturity.NOT_DEFINED) {
            ++size;
        }
        return size;
    }

    public String toString(String ... attributes) {
        StringBuilder vector = new StringBuilder();
        vector.append("CVSS:4.0/");
        for (String attribute : attributes) {
            vector.append(attribute).append(":").append(this.getVectorArgument(attribute).getShortIdentifier()).append("/");
        }
        return TRAILING_SLASH_PATTERN.matcher(vector.toString()).replaceAll("");
    }

    public static String toString(Cvss4P0[] vector, String ... attributes) {
        StringJoiner array = new StringJoiner(", ", "[", "]");
        for (Cvss4P0 v : vector) {
            array.add(v.toString(attributes));
        }
        return array.toString();
    }

    private <T extends Cvss4P0Attribute> void appendIfNotDefault(StringBuilder vector, String partName, T currentValue, T defaultValue, boolean appendAnyways) {
        if (appendAnyways || currentValue != defaultValue) {
            vector.append(partName).append(":").append(currentValue.getShortIdentifier()).append("/");
        }
    }

    @Override
    public BakedCvssVectorScores bakeScores() {
        return BakedCvssVectorScores.fromNullableCvss(this);
    }

    @Override
    public Map<String, CvssVector.CvssVectorAttribute[]> getAttributes() {
        LinkedHashMap<String, CvssVector.CvssVectorAttribute[]> attributes = new LinkedHashMap<String, CvssVector.CvssVectorAttribute[]>();
        attributes.put("AV", AttackVector.values());
        attributes.put("AC", AttackComplexity.values());
        attributes.put("AT", AttackRequirements.values());
        attributes.put("PR", PrivilegesRequired.values());
        attributes.put("UI", UserInteraction.values());
        attributes.put("VC", VulnerabilityCia.values());
        attributes.put("VI", VulnerabilityCia.values());
        attributes.put("VA", VulnerabilityCia.values());
        attributes.put("SC", SubsequentCia.values());
        attributes.put("SI", SubsequentCia.values());
        attributes.put("SA", SubsequentCia.values());
        attributes.put("S", Safety.values());
        attributes.put("AU", Automatable.values());
        attributes.put("R", Recovery.values());
        attributes.put("V", ValueDensity.values());
        attributes.put("RE", VulnerabilityResponseEffort.values());
        attributes.put("U", ProviderUrgency.values());
        attributes.put("CR", RequirementsCia.values());
        attributes.put("IR", RequirementsCia.values());
        attributes.put("AR", RequirementsCia.values());
        attributes.put("MAV", ModifiedAttackVector.values());
        attributes.put("MAC", ModifiedAttackComplexity.values());
        attributes.put("MAT", ModifiedAttackRequirements.values());
        attributes.put("MPR", ModifiedPrivilegesRequired.values());
        attributes.put("MUI", ModifiedUserInteraction.values());
        attributes.put("MVC", ModifiedVulnerabilityCia.values());
        attributes.put("MVI", ModifiedVulnerabilityCia.values());
        attributes.put("MVA", ModifiedVulnerabilityCia.values());
        attributes.put("MSC", ModifiedSubsequentConfidentiality.values());
        attributes.put("MSI", ModifiedSubsequentIntegrityAvailability.values());
        attributes.put("MSA", ModifiedSubsequentIntegrityAvailability.values());
        attributes.put("E", ExploitMaturity.values());
        return attributes;
    }

    public AttackVector getAttackVector() {
        return this.attackVector;
    }

    public void setAttackVector(AttackVector attackVector) {
        this.attackVector = attackVector;
    }

    public AttackComplexity getAttackComplexity() {
        return this.attackComplexity;
    }

    public void setAttackComplexity(AttackComplexity attackComplexity) {
        this.attackComplexity = attackComplexity;
    }

    public AttackRequirements getAttackRequirements() {
        return this.attackRequirements;
    }

    public void setAttackRequirements(AttackRequirements attackRequirements) {
        this.attackRequirements = attackRequirements;
    }

    public PrivilegesRequired getPrivilegesRequired() {
        return this.privilegesRequired;
    }

    public void setPrivilegesRequired(PrivilegesRequired privilegesRequired) {
        this.privilegesRequired = privilegesRequired;
    }

    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    public VulnerabilityCia getVulnConfidentialityImpact() {
        return this.vulnConfidentialityImpact;
    }

    public void setVulnConfidentialityImpact(VulnerabilityCia vulnConfidentialityImpact) {
        this.vulnConfidentialityImpact = vulnConfidentialityImpact;
    }

    public VulnerabilityCia getVulnIntegrityImpact() {
        return this.vulnIntegrityImpact;
    }

    public void setVulnIntegrityImpact(VulnerabilityCia vulnIntegrityImpact) {
        this.vulnIntegrityImpact = vulnIntegrityImpact;
    }

    public VulnerabilityCia getVulnAvailabilityImpact() {
        return this.vulnAvailabilityImpact;
    }

    public void setVulnAvailabilityImpact(VulnerabilityCia vulnAvailabilityImpact) {
        this.vulnAvailabilityImpact = vulnAvailabilityImpact;
    }

    public SubsequentCia getSubConfidentialityImpact() {
        return this.subConfidentialityImpact;
    }

    public void setSubConfidentialityImpact(SubsequentCia subConfidentialityImpact) {
        this.subConfidentialityImpact = subConfidentialityImpact;
    }

    public SubsequentCia getSubIntegrityImpact() {
        return this.subIntegrityImpact;
    }

    public void setSubIntegrityImpact(SubsequentCia subIntegrityImpact) {
        this.subIntegrityImpact = subIntegrityImpact;
    }

    public SubsequentCia getSubAvailabilityImpact() {
        return this.subAvailabilityImpact;
    }

    public void setSubAvailabilityImpact(SubsequentCia subAvailabilityImpact) {
        this.subAvailabilityImpact = subAvailabilityImpact;
    }

    public Safety getSafety() {
        return this.safety;
    }

    public void setSafety(Safety safety) {
        this.safety = safety;
    }

    public Automatable getAutomatable() {
        return this.automatable;
    }

    public void setAutomatable(Automatable automatable) {
        this.automatable = automatable;
    }

    public Recovery getRecovery() {
        return this.recovery;
    }

    public void setRecovery(Recovery recovery) {
        this.recovery = recovery;
    }

    public ValueDensity getValueDensity() {
        return this.valueDensity;
    }

    public void setValueDensity(ValueDensity valueDensity) {
        this.valueDensity = valueDensity;
    }

    public VulnerabilityResponseEffort getVulnerabilityResponseEffort() {
        return this.vulnerabilityResponseEffort;
    }

    public void setVulnerabilityResponseEffort(VulnerabilityResponseEffort vulnerabilityResponseEffort) {
        this.vulnerabilityResponseEffort = vulnerabilityResponseEffort;
    }

    public ProviderUrgency getProviderUrgency() {
        return this.providerUrgency;
    }

    public void setProviderUrgency(ProviderUrgency providerUrgency) {
        this.providerUrgency = providerUrgency;
    }

    public ModifiedAttackVector getModifiedAttackVector() {
        return this.modifiedAttackVector;
    }

    public void setModifiedAttackVector(ModifiedAttackVector modifiedAttackVector) {
        this.modifiedAttackVector = modifiedAttackVector;
    }

    public ModifiedAttackComplexity getModifiedAttackComplexity() {
        return this.modifiedAttackComplexity;
    }

    public void setModifiedAttackComplexity(ModifiedAttackComplexity modifiedAttackComplexity) {
        this.modifiedAttackComplexity = modifiedAttackComplexity;
    }

    public ModifiedAttackRequirements getModifiedAttackRequirements() {
        return this.modifiedAttackRequirements;
    }

    public void setModifiedAttackRequirements(ModifiedAttackRequirements modifiedAttackRequirements) {
        this.modifiedAttackRequirements = modifiedAttackRequirements;
    }

    public ModifiedPrivilegesRequired getModifiedPrivilegesRequired() {
        return this.modifiedPrivilegesRequired;
    }

    public void setModifiedPrivilegesRequired(ModifiedPrivilegesRequired modifiedPrivilegesRequired) {
        this.modifiedPrivilegesRequired = modifiedPrivilegesRequired;
    }

    public ModifiedUserInteraction getModifiedUserInteraction() {
        return this.modifiedUserInteraction;
    }

    public void setModifiedUserInteraction(ModifiedUserInteraction modifiedUserInteraction) {
        this.modifiedUserInteraction = modifiedUserInteraction;
    }

    public ModifiedVulnerabilityCia getModifiedVulnConfidentialityImpact() {
        return this.modifiedVulnConfidentialityImpact;
    }

    public void setModifiedVulnConfidentialityImpact(ModifiedVulnerabilityCia modifiedVulnConfidentialityImpact) {
        this.modifiedVulnConfidentialityImpact = modifiedVulnConfidentialityImpact;
    }

    public ModifiedVulnerabilityCia getModifiedVulnIntegrityImpact() {
        return this.modifiedVulnIntegrityImpact;
    }

    public void setModifiedVulnIntegrityImpact(ModifiedVulnerabilityCia modifiedVulnIntegrityImpact) {
        this.modifiedVulnIntegrityImpact = modifiedVulnIntegrityImpact;
    }

    public ModifiedVulnerabilityCia getModifiedVulnAvailabilityImpact() {
        return this.modifiedVulnAvailabilityImpact;
    }

    public void setModifiedVulnAvailabilityImpact(ModifiedVulnerabilityCia modifiedVulnAvailabilityImpact) {
        this.modifiedVulnAvailabilityImpact = modifiedVulnAvailabilityImpact;
    }

    public ModifiedSubsequentConfidentiality getModifiedSubConfidentialityImpact() {
        return this.modifiedSubConfidentialityImpact;
    }

    public void setModifiedSubConfidentialityImpact(ModifiedSubsequentConfidentiality modifiedSubConfidentialityImpact) {
        this.modifiedSubConfidentialityImpact = modifiedSubConfidentialityImpact;
    }

    public ModifiedSubsequentIntegrityAvailability getModifiedSubIntegrityImpact() {
        return this.modifiedSubIntegrityImpact;
    }

    public void setModifiedSubIntegrityImpact(ModifiedSubsequentIntegrityAvailability modifiedSubIntegrityImpact) {
        this.modifiedSubIntegrityImpact = modifiedSubIntegrityImpact;
    }

    public ModifiedSubsequentIntegrityAvailability getModifiedSubAvailabilityImpact() {
        return this.modifiedSubAvailabilityImpact;
    }

    public void setModifiedSubAvailabilityImpact(ModifiedSubsequentIntegrityAvailability modifiedSubAvailabilityImpact) {
        this.modifiedSubAvailabilityImpact = modifiedSubAvailabilityImpact;
    }

    public RequirementsCia getConfidentialityRequirement() {
        return this.confidentialityRequirement;
    }

    public void setConfidentialityRequirement(RequirementsCia confidentialityRequirement) {
        this.confidentialityRequirement = confidentialityRequirement;
    }

    public RequirementsCia getIntegrityRequirement() {
        return this.integrityRequirement;
    }

    public void setIntegrityRequirement(RequirementsCia integrityRequirement) {
        this.integrityRequirement = integrityRequirement;
    }

    public RequirementsCia getAvailabilityRequirement() {
        return this.availabilityRequirement;
    }

    public void setAvailabilityRequirement(RequirementsCia availabilityRequirement) {
        this.availabilityRequirement = availabilityRequirement;
    }

    public ExploitMaturity getExploitMaturity() {
        return this.exploitMaturity;
    }

    public void setExploitMaturity(ExploitMaturity exploitMaturity) {
        this.exploitMaturity = exploitMaturity;
    }

    public static Optional<Cvss4P0> optionalParse(String vector) {
        if (vector == null || StringUtils.isEmpty((CharSequence)MultiScoreCvssVector.normalizeVector(vector))) {
            return Optional.empty();
        }
        return Optional.of(new Cvss4P0(vector));
    }

    private static <T> Set<T> setOf(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    public static interface Cvss4P0Attribute
    extends CvssVector.CvssVectorAttribute {
        public Cvss4P0Attribute getWorseCase();

        public static <T extends Cvss4P0Attribute> T fromString(String part, Class<T> clazz, T defaultValue) {
            Map<String, Cvss4P0Attribute> cache;
            if (ATTRIBUTE_CACHE.containsKey(clazz)) {
                cache = (Map)ATTRIBUTE_CACHE.get(clazz);
            } else {
                cache = new HashMap();
                ATTRIBUTE_CACHE.put(clazz, cache);
            }
            if (cache.containsKey(part)) {
                return (T)((Cvss4P0Attribute)cache.get(part));
            }
            for (Cvss4P0Attribute value : (Cvss4P0Attribute[])clazz.getEnumConstants()) {
                if (value.getShortIdentifier().equalsIgnoreCase(part)) {
                    cache.put(part, value);
                    return (T)value;
                }
                if (!value.getIdentifier().equalsIgnoreCase(part)) continue;
                cache.put(part, value);
                return (T)value;
            }
            cache.put(part, defaultValue);
            return defaultValue;
        }

        @Override
        default public boolean isSet() {
            return !this.getIdentifier().equals("NOT_DEFINED") && !this.getIdentifier().equals("NULL");
        }
    }

    public static enum ExploitMaturity implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        UNREPORTED("UNREPORTED", "U"),
        POC("POC", "P"),
        ATTACKED("ATTACKED", "A");

        private final String identifier;
        private final String shortIdentifier;

        private ExploitMaturity(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ExploitMaturity fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ExploitMaturity.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ExploitMaturity getWorseCase() {
            return ATTACKED;
        }
    }

    public static enum RequirementsCia implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        HIGH("HIGH", "H"),
        MEDIUM("MEDIUM", "M"),
        LOW("LOW", "L");

        private final String identifier;
        private final String shortIdentifier;

        private RequirementsCia(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static RequirementsCia fromString(String part) {
            return Cvss4P0Attribute.fromString(part, RequirementsCia.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public RequirementsCia getWorseCase() {
            return HIGH;
        }
    }

    public static enum ModifiedSubsequentIntegrityAvailability implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        SAFETY("SAFETY", "S"),
        HIGH("HIGH", "H"),
        LOW("LOW", "L"),
        NEGLIGIBLE("NEGLIGIBLE", "N");

        private final String identifier;
        private final String shortIdentifier;

        private ModifiedSubsequentIntegrityAvailability(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ModifiedSubsequentIntegrityAvailability fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ModifiedSubsequentIntegrityAvailability.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ModifiedSubsequentIntegrityAvailability getWorseCase() {
            return SAFETY;
        }
    }

    public static enum ModifiedSubsequentConfidentiality implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        HIGH("HIGH", "H"),
        LOW("LOW", "L"),
        NEGLIGIBLE("NEGLIGIBLE", "N");

        private final String identifier;
        private final String shortIdentifier;

        private ModifiedSubsequentConfidentiality(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ModifiedSubsequentConfidentiality fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ModifiedSubsequentConfidentiality.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ModifiedSubsequentConfidentiality getWorseCase() {
            return HIGH;
        }
    }

    public static enum ModifiedVulnerabilityCia implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        HIGH("HIGH", "H"),
        LOW("LOW", "L"),
        NONE("NONE", "N");

        private final String identifier;
        private final String shortIdentifier;

        private ModifiedVulnerabilityCia(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ModifiedVulnerabilityCia fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ModifiedVulnerabilityCia.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ModifiedVulnerabilityCia getWorseCase() {
            return HIGH;
        }
    }

    public static enum ModifiedUserInteraction implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        NONE("NONE", "N"),
        PASSIVE("PASSIVE", "P"),
        ACTIVE("ACTIVE", "A");

        private final String identifier;
        private final String shortIdentifier;

        private ModifiedUserInteraction(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ModifiedUserInteraction fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ModifiedUserInteraction.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ModifiedUserInteraction getWorseCase() {
            return NONE;
        }
    }

    public static enum ModifiedPrivilegesRequired implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        NONE("NONE", "N"),
        LOW("LOW", "L"),
        HIGH("HIGH", "H");

        private final String identifier;
        private final String shortIdentifier;

        private ModifiedPrivilegesRequired(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ModifiedPrivilegesRequired fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ModifiedPrivilegesRequired.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ModifiedPrivilegesRequired getWorseCase() {
            return NONE;
        }
    }

    public static enum ModifiedAttackRequirements implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        NONE("NONE", "N"),
        PRESENT("PRESENT", "P");

        private final String identifier;
        private final String shortIdentifier;

        private ModifiedAttackRequirements(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ModifiedAttackRequirements fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ModifiedAttackRequirements.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ModifiedAttackRequirements getWorseCase() {
            return PRESENT;
        }
    }

    public static enum ModifiedAttackComplexity implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        LOW("LOW", "L"),
        HIGH("HIGH", "H");

        public final String identifier;
        public final String shortIdentifier;

        private ModifiedAttackComplexity(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ModifiedAttackComplexity fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ModifiedAttackComplexity.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ModifiedAttackComplexity getWorseCase() {
            return LOW;
        }
    }

    public static enum ModifiedAttackVector implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        NETWORK("NETWORK", "N"),
        ADJACENT_NETWORK("ADJACENT", "A"),
        LOCAL("LOCAL", "L"),
        PHYSICAL("PHYSICAL", "P");

        public final String identifier;
        public final String shortIdentifier;

        private ModifiedAttackVector(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ModifiedAttackVector fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ModifiedAttackVector.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ModifiedAttackVector getWorseCase() {
            return NETWORK;
        }
    }

    public static enum ProviderUrgency implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        CLEAR("CLEAR", "Clear"),
        GREEN("GREEN", "Green"),
        AMBER("AMBER", "Amber"),
        RED("RED", "Red");

        private final String identifier;
        private final String shortIdentifier;

        private ProviderUrgency(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ProviderUrgency fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ProviderUrgency.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ProviderUrgency getWorseCase() {
            return RED;
        }
    }

    public static enum VulnerabilityResponseEffort implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        LOW("LOW", "L"),
        MODERATE("MODERATE", "M"),
        HIGH("HIGH", "H");

        private final String identifier;
        private final String shortIdentifier;

        private VulnerabilityResponseEffort(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static VulnerabilityResponseEffort fromString(String part) {
            return Cvss4P0Attribute.fromString(part, VulnerabilityResponseEffort.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public VulnerabilityResponseEffort getWorseCase() {
            return HIGH;
        }
    }

    public static enum ValueDensity implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        DIFFUSE("DIFFUSE", "D"),
        CONCENTRATED("CONCENTRATED", "C");

        private final String identifier;
        private final String shortIdentifier;

        private ValueDensity(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static ValueDensity fromString(String part) {
            return Cvss4P0Attribute.fromString(part, ValueDensity.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public ValueDensity getWorseCase() {
            return CONCENTRATED;
        }
    }

    public static enum Recovery implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        AUTOMATIC("AUTOMATIC", "A"),
        USER("USER", "U"),
        IRRECOVERABLE("IRRECOVERABLE", "I");

        private final String identifier;
        private final String shortIdentifier;

        private Recovery(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static Recovery fromString(String part) {
            return Cvss4P0Attribute.fromString(part, Recovery.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public Recovery getWorseCase() {
            return IRRECOVERABLE;
        }
    }

    public static enum Automatable implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        NO("NO", "N"),
        YES("YES", "Y");

        private final String identifier;
        private final String shortIdentifier;

        private Automatable(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static Automatable fromString(String part) {
            return Cvss4P0Attribute.fromString(part, Automatable.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public Automatable getWorseCase() {
            return YES;
        }
    }

    public static enum Safety implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        NEGLIGIBLE("NEGLIGIBLE", "N"),
        PRESENT("PRESENT", "P");

        private final String identifier;
        private final String shortIdentifier;

        private Safety(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static Safety fromString(String part) {
            return Cvss4P0Attribute.fromString(part, Safety.class, NOT_DEFINED);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public Safety getWorseCase() {
            return PRESENT;
        }
    }

    public static enum SubsequentCia implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        SAFETY("SAFETY", "S"),
        HIGH("HIGH", "H"),
        LOW("LOW", "L"),
        NONE("NONE", "N");

        public final String identifier;
        public final String shortIdentifier;

        private SubsequentCia(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static SubsequentCia fromString(String part) {
            return Cvss4P0Attribute.fromString(part, SubsequentCia.class, NONE);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public SubsequentCia getWorseCase() {
            return HIGH;
        }
    }

    public static enum VulnerabilityCia implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        HIGH("HIGH", "H"),
        LOW("LOW", "L"),
        NONE("NONE", "N");

        public final String identifier;
        public final String shortIdentifier;

        private VulnerabilityCia(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static VulnerabilityCia fromString(String part) {
            return Cvss4P0Attribute.fromString(part, VulnerabilityCia.class, NONE);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public VulnerabilityCia getWorseCase() {
            return HIGH;
        }
    }

    public static enum UserInteraction implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        NONE("NONE", "N"),
        PASSIVE("PASSIVE", "P"),
        ACTIVE("ACTIVE", "A");

        private final String identifier;
        private final String shortIdentifier;

        private UserInteraction(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static UserInteraction fromString(String part) {
            return Cvss4P0Attribute.fromString(part, UserInteraction.class, NONE);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public UserInteraction getWorseCase() {
            return NONE;
        }
    }

    public static enum PrivilegesRequired implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        NONE("NONE", "N"),
        LOW("LOW", "L"),
        HIGH("HIGH", "H");

        public final String identifier;
        public final String shortIdentifier;

        private PrivilegesRequired(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static PrivilegesRequired fromString(String part) {
            return Cvss4P0Attribute.fromString(part, PrivilegesRequired.class, NONE);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public PrivilegesRequired getWorseCase() {
            return NONE;
        }
    }

    public static enum AttackRequirements implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        NONE("NONE", "N"),
        PRESENT("PRESENT", "P");

        private final String identifier;
        private final String shortIdentifier;

        private AttackRequirements(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static AttackRequirements fromString(String part) {
            return Cvss4P0Attribute.fromString(part, AttackRequirements.class, NONE);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public AttackRequirements getWorseCase() {
            return NONE;
        }
    }

    public static enum AttackComplexity implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        LOW("LOW", "L"),
        HIGH("HIGH", "H");

        public final String identifier;
        public final String shortIdentifier;

        private AttackComplexity(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static AttackComplexity fromString(String part) {
            return Cvss4P0Attribute.fromString(part, AttackComplexity.class, LOW);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public AttackComplexity getWorseCase() {
            return LOW;
        }
    }

    public static enum AttackVector implements Cvss4P0Attribute
    {
        NOT_DEFINED("NOT_DEFINED", "X"),
        NETWORK("NETWORK", "N"),
        ADJACENT_NETWORK("ADJACENT", "A"),
        LOCAL("LOCAL", "L"),
        PHYSICAL("PHYSICAL", "P");

        public final String identifier;
        public final String shortIdentifier;

        private AttackVector(String identifier, String shortIdentifier) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
        }

        public static AttackVector fromString(String part) {
            return Cvss4P0Attribute.fromString(part, AttackVector.class, NETWORK);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public AttackVector getWorseCase() {
            return NETWORK;
        }
    }

    private static class Average {
        private double sum = 0.0;
        private int count = 0;

        private Average() {
        }

        public void add(double value) {
            this.sum += value;
            ++this.count;
        }

        public Double getOrDefault(Double defaultValue) {
            if (this.count == 0) {
                return defaultValue;
            }
            return this.sum / (double)this.count;
        }
    }
}

