/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.v3;

import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.MultiScoreCvssVector;
import org.metaeffekt.core.security.cvss.v3.Cvss3;

public final class Cvss3P0
extends Cvss3 {
    public Cvss3P0() {
    }

    public Cvss3P0(String vector) {
        super(vector);
    }

    public Cvss3P0(String vector, CvssSource source) {
        super(vector, source);
    }

    public Cvss3P0(String vector, CvssSource source, JSONObject applicabilityCondition) {
        super(vector, source, applicabilityCondition);
    }

    public Cvss3P0(String vector, Collection<CvssSource> sources, JSONObject applicabilityCondition) {
        super(vector, sources, applicabilityCondition);
        super.applyVector(vector);
    }

    @Override
    protected double calculateAdjustedImpact() {
        double miss = this.calculateMISS();
        if (this.isModifiedScope()) {
            return 6.42 * miss;
        }
        return 7.52 * (miss - 0.029) - 3.25 * Math.pow(miss - 0.02, 15.0);
    }

    @Override
    public double roundUp(double value) {
        return Math.ceil(value * 10.0) / 10.0;
    }

    @Override
    public Cvss3P0 clone() {
        return super.cloneInternal(new Cvss3P0());
    }

    public Optional<Cvss3P0> optionalParse(String vector) {
        if (vector == null || StringUtils.isEmpty((CharSequence)MultiScoreCvssVector.normalizeVector(vector))) {
            return Optional.empty();
        }
        return Optional.of(new Cvss3P0(vector));
    }

    public static String getVersionName() {
        return "CVSS:3.0";
    }

    @Override
    public String getName() {
        return Cvss3P0.getVersionName();
    }
}

