/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;

public class CvssVectorSet
implements Cloneable {
    private final List<CvssVector> cvssVectors = new ArrayList<CvssVector>();

    public CvssVectorSet() {
    }

    public CvssVectorSet(CvssVectorSet other) {
        this.addAllCvssVectors(other);
    }

    public CvssVectorSet(Collection<CvssVector> other) {
        this.addAllCvssVectors(other);
    }

    public void removeForSourceAndCondition(CvssSource source, JSONObject condition) {
        this.cvssVectors.removeIf(sourcedCvssVector -> Objects.equals(sourcedCvssVector.getCvssSource(), source) && Objects.equals(sourcedCvssVector.getApplicabilityCondition(), condition));
    }

    public void removeForNonMatchingConditionAttribute(String attribute, Object value) {
        this.cvssVectors.removeIf(sourcedCvssVector -> !Objects.equals(sourcedCvssVector.getApplicabilityCondition().opt(attribute), value));
    }

    public void addCvssVector(CvssSource source, String cvssVector) {
        CvssVector vector = source.parseVector(cvssVector).deriveAddSource(source);
        this.addCvssVector(vector);
    }

    public void addCvssVector(CvssVector cvssVector) {
        this.cvssVectors.add(cvssVector);
    }

    public void addAllCvssVectors(Collection<CvssVector> cvssVectors) {
        this.cvssVectors.addAll(cvssVectors);
    }

    public void addAllCvssVectors(CvssVectorSet vectorSet) {
        this.cvssVectors.addAll(vectorSet.getCvssVectors().stream().map(CvssVector::clone).collect(Collectors.toList()));
    }

    public List<CvssVector> getCvssVectors() {
        return this.cvssVectors;
    }

    public CvssVector getCvssVectorBySource(CvssSource source) {
        return this.cvssVectors.stream().filter(sourcedCvssVector -> sourcedCvssVector.getCvssSources().stream().anyMatch(s -> s.equals(source))).findFirst().orElse(null);
    }

    public boolean isEmpty() {
        return this.cvssVectors.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public int size() {
        return this.cvssVectors.size();
    }

    public void clear() {
        this.cvssVectors.clear();
    }

    public CvssVectorSet clone() {
        return new CvssVectorSet(this);
    }

    public String toString() {
        return this.cvssVectors.toString();
    }

    public JSONArray toJson() {
        return CvssVector.toJson(this.cvssVectors);
    }

    public static CvssVectorSet fromJson(JSONArray json) {
        return new CvssVectorSet(CvssVector.fromJson(json));
    }
}

