/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.processor;

import java.util.List;
import java.util.function.Function;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.processor.CvssSelector;
import org.metaeffekt.core.security.cvss.processor.CvssVectorSet;
import org.metaeffekt.core.security.cvss.v2.Cvss2;
import org.metaeffekt.core.security.cvss.v3.Cvss3P1;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvssSelectionResult {
    private static final Logger LOG = LoggerFactory.getLogger(CvssSelectionResult.class);
    private final CvssVectorSet allVectors;
    private final Cvss2 initialCvss2;
    private final Cvss2 contextCvss2;
    private final Cvss3P1 initialCvss3;
    private final Cvss3P1 contextCvss3;
    private final Cvss4P0 initialCvss4;
    private final Cvss4P0 contextCvss4;
    private final CvssVector selectedInitialCvss;
    private final CvssVector selectedContextCvss;
    public static final CustomVectorScoreSelector CUSTOM_VECTOR_SCORE_SELECTOR_MAX = (v1, s1, v2, s2) -> {
        if (s1 > s2) {
            return v1;
        }
        return v2;
    };

    public CvssSelectionResult(CvssVectorSet allVectors, CvssSelector initialSelector, CvssSelector contextSelector, List<CvssScoreVersionSelectionPolicy> versionSelectionPolicy) {
        this.allVectors = allVectors;
        this.initialCvss2 = initialSelector.selectVector(allVectors, Cvss2.class);
        this.contextCvss2 = contextSelector.selectVector(allVectors, Cvss2.class);
        this.initialCvss3 = initialSelector.selectVector(allVectors, Cvss3P1.class);
        this.contextCvss3 = contextSelector.selectVector(allVectors, Cvss3P1.class);
        this.initialCvss4 = initialSelector.selectVector(allVectors, Cvss4P0.class);
        this.contextCvss4 = contextSelector.selectVector(allVectors, Cvss4P0.class);
        this.selectedInitialCvss = this.selectVersionedCvss(versionSelectionPolicy, this.initialCvss2, this.initialCvss3, this.initialCvss4);
        this.selectedContextCvss = this.selectVersionedCvss(versionSelectionPolicy, this.contextCvss2, this.contextCvss3, this.contextCvss4);
    }

    protected CvssSelectionResult(CvssVectorSet allVectors, Cvss2 initialCvss2, Cvss2 contextCvss2, Cvss3P1 initialCvss3, Cvss3P1 contextCvss3, Cvss4P0 initialCvss4, Cvss4P0 contextCvss4, CvssVector selectedInitialCvss, CvssVector selectedContextCvss) {
        this.allVectors = allVectors;
        this.initialCvss2 = initialCvss2;
        this.contextCvss2 = contextCvss2;
        this.initialCvss3 = initialCvss3;
        this.contextCvss3 = contextCvss3;
        this.initialCvss4 = initialCvss4;
        this.contextCvss4 = contextCvss4;
        this.selectedInitialCvss = selectedInitialCvss;
        this.selectedContextCvss = selectedContextCvss;
    }

    public boolean hasInitialCvss() {
        return this.initialCvss2 != null || this.initialCvss3 != null || this.initialCvss4 != null;
    }

    public boolean hasContextCvss() {
        return this.contextCvss2 != null || this.contextCvss3 != null || this.contextCvss4 != null;
    }

    public boolean hasAnyCvss() {
        return this.hasInitialCvss() || this.hasContextCvss();
    }

    public CvssVector getSelectedContextIfAvailableOtherwiseInitial() {
        if (this.selectedContextCvss != null) {
            return this.selectedContextCvss;
        }
        return this.selectedInitialCvss;
    }

    public CvssVector getSelectedByCustomMetric(Function<CvssVector, Double> scoreMapper, CustomVectorScoreSelector customVectorScoreSelector) {
        if (this.selectedContextCvss != null && this.selectedInitialCvss != null) {
            return customVectorScoreSelector.select(this.selectedContextCvss, scoreMapper.apply(this.selectedContextCvss), this.selectedInitialCvss, scoreMapper.apply(this.selectedInitialCvss));
        }
        if (this.selectedContextCvss != null) {
            return this.selectedContextCvss;
        }
        if (this.selectedInitialCvss != null) {
            return this.selectedInitialCvss;
        }
        return null;
    }

    private CvssVector selectVersionedCvss(List<CvssScoreVersionSelectionPolicy> versionSelectionPolicy, CvssVector ... vectorScores) {
        Cvss2 foundV2 = this.findOfVersion(Cvss2.class, vectorScores);
        Cvss3P1 foundV3 = this.findOfVersion(Cvss3P1.class, vectorScores);
        Cvss4P0 foundV4 = this.findOfVersion(Cvss4P0.class, vectorScores);
        if (foundV2 == null && foundV3 == null && foundV4 == null) {
            return null;
        }
        if (versionSelectionPolicy.isEmpty()) {
            if (foundV4 != null) {
                return foundV4;
            }
            if (foundV3 != null) {
                return foundV3;
            }
            return foundV2;
        }
        block9: for (CvssScoreVersionSelectionPolicy cvssSelectionPolicy : versionSelectionPolicy) {
            switch (cvssSelectionPolicy) {
                case HIGHEST: {
                    int highestScore = -1;
                    CvssVector highestScoreVector = null;
                    for (CvssVector vectorScore : vectorScores) {
                        if (vectorScore == null || !(vectorScore.getOverallScore() > (double)highestScore)) continue;
                        highestScore = (int)vectorScore.getOverallScore();
                        highestScoreVector = vectorScore;
                    }
                    if (highestScoreVector == null) continue block9;
                    return highestScoreVector;
                }
                case LOWEST: {
                    int lowestScore = Integer.MAX_VALUE;
                    CvssVector lowestScoreVector = null;
                    for (CvssVector vectorScore : vectorScores) {
                        if (vectorScore == null || !(vectorScore.getOverallScore() < (double)lowestScore)) continue;
                        lowestScore = (int)vectorScore.getOverallScore();
                        lowestScoreVector = vectorScore;
                    }
                    if (lowestScoreVector == null) break;
                    return lowestScoreVector;
                }
                case LATEST: {
                    if (foundV4 != null) {
                        return foundV4;
                    }
                    if (foundV3 != null) {
                        return foundV3;
                    }
                    return foundV2;
                }
                case OLDEST: {
                    if (foundV2 != null) {
                        return foundV2;
                    }
                    if (foundV3 != null) {
                        return foundV3;
                    }
                    return foundV4;
                }
                case V2: {
                    if (foundV2 == null) break;
                    return foundV2;
                }
                case V3: {
                    if (foundV3 == null) break;
                    return foundV3;
                }
                case V4: {
                    if (foundV4 == null) break;
                    return foundV4;
                }
            }
        }
        LOG.warn("No matching CVSS version found for selection policy, consider adding a non-fixed version selector (like [{}] or [{}]) to the end of your versionSelectionPolicy: {}", new Object[]{CvssScoreVersionSelectionPolicy.LATEST, CvssScoreVersionSelectionPolicy.HIGHEST, versionSelectionPolicy});
        return null;
    }

    private <T extends CvssVector> T findOfVersion(Class<T> cvssVersion, CvssVector ... vectors) {
        for (CvssVector vector : vectors) {
            if (vector == null || !vector.getClass().equals(cvssVersion)) continue;
            return (T)vector;
        }
        return null;
    }

    public CvssVector findWithSourceInInitial(CvssVector vector) {
        if (vector == null) {
            return null;
        }
        if (this.initialCvss2 != null && this.initialCvss2.containsSource(vector.getCvssSource())) {
            return this.initialCvss2;
        }
        if (this.initialCvss3 != null && this.initialCvss3.containsSource(vector.getCvssSource())) {
            return this.initialCvss3;
        }
        if (this.initialCvss4 != null && this.initialCvss4.containsSource(vector.getCvssSource())) {
            return this.initialCvss4;
        }
        return null;
    }

    public CvssVector findWithSourceInContext(CvssVector vector) {
        if (vector == null) {
            return null;
        }
        if (this.contextCvss2 != null && this.contextCvss2.containsSource(vector.getCvssSource())) {
            return this.contextCvss2;
        }
        if (this.contextCvss3 != null && this.contextCvss3.containsSource(vector.getCvssSource())) {
            return this.contextCvss3;
        }
        if (this.contextCvss4 != null && this.contextCvss4.containsSource(vector.getCvssSource())) {
            return this.contextCvss4;
        }
        return null;
    }

    public boolean isInitial(CvssVector vector) {
        return vector == this.initialCvss2 || vector == this.initialCvss3 || vector == this.initialCvss4;
    }

    public boolean isContext(CvssVector vector) {
        return vector == this.contextCvss2 || vector == this.contextCvss3 || vector == this.contextCvss4;
    }

    public CvssVectorSet getAllVectors() {
        return this.allVectors;
    }

    public Cvss2 getInitialCvss2() {
        return this.initialCvss2;
    }

    public Cvss2 getContextCvss2() {
        return this.contextCvss2;
    }

    public Cvss3P1 getInitialCvss3() {
        return this.initialCvss3;
    }

    public Cvss3P1 getContextCvss3() {
        return this.contextCvss3;
    }

    public Cvss4P0 getInitialCvss4() {
        return this.initialCvss4;
    }

    public Cvss4P0 getContextCvss4() {
        return this.contextCvss4;
    }

    public CvssVector getSelectedInitialCvss() {
        return this.selectedInitialCvss;
    }

    public CvssVector getSelectedContextCvss() {
        return this.selectedContextCvss;
    }

    public String toString() {
        return "CvssSelectionResult{allVectors=" + this.allVectors + ", initialCvss2=" + this.initialCvss2 + ", contextCvss2=" + this.contextCvss2 + ", initialCvss3=" + this.initialCvss3 + ", contextCvss3=" + this.contextCvss3 + ", initialCvss4=" + this.initialCvss4 + ", contextCvss4=" + this.contextCvss4 + ", selectedInitialCvss=" + this.selectedInitialCvss + ", selectedContextCvss=" + this.selectedContextCvss + '}';
    }

    public CvssSelectionResult deriveInitialOnlySelectionResult() {
        return new CvssSelectionResult(this.allVectors, this.initialCvss2, null, this.initialCvss3, null, this.initialCvss4, null, this.selectedInitialCvss, null);
    }

    public CvssSelectionResult deriveContextOnlySelectionResult() {
        return new CvssSelectionResult(this.allVectors, null, this.contextCvss2, null, this.contextCvss3, null, this.contextCvss4, null, this.selectedContextCvss);
    }

    public static interface CustomVectorScoreSelector {
        public CvssVector select(CvssVector var1, double var2, CvssVector var4, double var5);
    }

    public static enum CvssScoreVersionSelectionPolicy {
        HIGHEST,
        LOWEST,
        LATEST,
        OLDEST,
        V2,
        V3,
        V4;

    }
}

