/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.processor;

import java.util.Objects;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.MultiScoreCvssVector;
import org.metaeffekt.core.security.cvss.processor.LruLinkedHashMap;
import org.metaeffekt.core.security.cvss.v3.Cvss3P0;
import org.metaeffekt.core.security.cvss.v3.Cvss3P1;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;

public class BakedCvssVectorScores {
    private static final LruLinkedHashMap<String, BakedCvssVectorScores> cache = new LruLinkedHashMap(5000);
    private final Class<? extends CvssVector> cvssVersion;
    private final String vector;
    private final double base;
    private final double impact;
    private final double exploitability;
    private final double temporal;
    private final double threat;
    private final double environmental;
    private final double adjustedImpact;
    private final double overall;

    protected BakedCvssVectorScores(CvssVector vector) {
        this.cvssVersion = vector.getClass();
        this.vector = vector.toString();
        this.base = vector.getBaseScore();
        this.overall = vector.getOverallScore();
        if (vector instanceof MultiScoreCvssVector) {
            MultiScoreCvssVector cast = (MultiScoreCvssVector)vector;
            this.impact = cast.getImpactScore();
            this.exploitability = cast.getExploitabilityScore();
            this.threat = Double.NaN;
            this.temporal = cast.getTemporalScore();
            this.environmental = cast.getEnvironmentalScore();
            this.adjustedImpact = cast.getAdjustedImpactScore();
        } else if (this.cvssVersion == Cvss4P0.class) {
            this.impact = Double.NaN;
            this.exploitability = Double.NaN;
            this.threat = ((Cvss4P0)vector).getThreatScore();
            this.temporal = Double.NaN;
            this.environmental = ((Cvss4P0)vector).getEnvironmentalScore();
            this.adjustedImpact = Double.NaN;
        } else {
            this.impact = Double.NaN;
            this.exploitability = Double.NaN;
            this.threat = Double.NaN;
            this.temporal = Double.NaN;
            this.environmental = Double.NaN;
            this.adjustedImpact = Double.NaN;
        }
    }

    public static BakedCvssVectorScores fromNullableCvss(CvssVector cvss) {
        if (cvss == null) {
            return null;
        }
        String cvssString = cvss.toString();
        if (cache.containsKey(cvssString)) {
            return (BakedCvssVectorScores)cache.get(cvssString);
        }
        BakedCvssVectorScores scores = new BakedCvssVectorScores(cvss);
        cache.put(cvssString, scores);
        return scores;
    }

    public double getBaseScore() {
        return this.base;
    }

    public double getImpactScore() {
        return this.impact;
    }

    public double getExploitabilityScore() {
        return this.exploitability;
    }

    public double getTemporalScore() {
        return this.temporal;
    }

    public double getThreatScore() {
        return this.threat;
    }

    public double getEnvironmentalScore() {
        return this.environmental;
    }

    public double getAdjustedImpactScore() {
        return this.adjustedImpact;
    }

    public double getOverallScore() {
        return this.overall;
    }

    public boolean isBaseScoreAvailable() {
        return !Double.isNaN(this.base);
    }

    public boolean isImpactScoreAvailable() {
        return !Double.isNaN(this.impact);
    }

    public boolean isExploitabilityScoreAvailable() {
        return !Double.isNaN(this.exploitability);
    }

    public boolean isTemporalScoreAvailable() {
        return !Double.isNaN(this.temporal);
    }

    public boolean isThreatScoreAvailable() {
        return !Double.isNaN(this.threat);
    }

    public boolean isEnvironmentalScoreAvailable() {
        return !Double.isNaN(this.environmental);
    }

    public boolean isAdjustedImpactScoreAvailable() {
        return !Double.isNaN(this.adjustedImpact);
    }

    public boolean isOverallScoreAvailable() {
        return !Double.isNaN(this.overall);
    }

    public boolean hasNormalizedBaseScore() {
        return this.getUnNormalizedBaseScoreMax() != 10.0;
    }

    public boolean hasNormalizedImpactScore() {
        return this.getUnNormalizedImpactScoreMax() != 10.0;
    }

    public boolean hasNormalizedExploitabilityScore() {
        return this.getUnNormalizedExploitabilityScoreMax() != 10.0;
    }

    public boolean hasNormalizedTemporalScore() {
        return this.getUnNormalizedTemporalScoreMax() != 10.0;
    }

    public boolean hasNormalizedEnvironmentalScore() {
        return this.getUnNormalizedEnvironmentalScoreMax() != 10.0;
    }

    public boolean hasNormalizedAdjustedImpactScore() {
        return this.getUnNormalizedAdjustedImpactScoreMax() != 10.0;
    }

    public boolean hasNormalizedOverallScore() {
        return this.getUnNormalizedOverallScoreMax() != 10.0;
    }

    public double getUnNormalizedBaseScoreMax() {
        return 10.0;
    }

    public double getUnNormalizedImpactScoreMax() {
        if (this.cvssVersion == Cvss3P1.class || this.cvssVersion == Cvss3P0.class) {
            return 6.0;
        }
        return 10.0;
    }

    public double getUnNormalizedExploitabilityScoreMax() {
        if (this.cvssVersion == Cvss3P1.class || this.cvssVersion == Cvss3P0.class) {
            return 3.9;
        }
        return 10.0;
    }

    public double getUnNormalizedTemporalScoreMax() {
        return 10.0;
    }

    public double getUnNormalizedEnvironmentalScoreMax() {
        return 10.0;
    }

    public double getUnNormalizedAdjustedImpactScoreMax() {
        if (this.cvssVersion == Cvss3P1.class || this.cvssVersion == Cvss3P0.class) {
            return 6.1;
        }
        return 10.0;
    }

    public double getUnNormalizedOverallScoreMax() {
        return 10.0;
    }

    public double getNormalizedBaseScore() {
        return this.normalizeScore(this.base, this.getUnNormalizedBaseScoreMax());
    }

    public double getNormalizedImpactScore() {
        return this.normalizeScore(this.impact, this.getUnNormalizedImpactScoreMax());
    }

    public double getNormalizedExploitabilityScore() {
        return this.normalizeScore(this.exploitability, this.getUnNormalizedExploitabilityScoreMax());
    }

    public double getNormalizedTemporalScore() {
        return this.normalizeScore(this.temporal, this.getUnNormalizedTemporalScoreMax());
    }

    public double getNormalizedEnvironmentalScore() {
        return this.normalizeScore(this.environmental, this.getUnNormalizedEnvironmentalScoreMax());
    }

    public double getNormalizedAdjustedImpactScore() {
        return this.normalizeScore(this.adjustedImpact, this.getUnNormalizedAdjustedImpactScoreMax());
    }

    public double getNormalizedOverallScore() {
        return this.normalizeScore(this.overall, this.getUnNormalizedOverallScoreMax());
    }

    public String toString() {
        return this.vector;
    }

    public double normalizeScore(double score, double max) {
        if (Double.isNaN(score)) {
            return score;
        }
        if (max == 10.0) {
            return score;
        }
        return this.round(this.mapRange(score, 0.0, max, 0.0, 10.0), 1);
    }

    private double mapRange(double value, double min, double max, double newMin, double newMax) {
        return (value - min) / (max - min) * (newMax - newMin) + newMin;
    }

    private double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BakedCvssVectorScores that = (BakedCvssVectorScores)o;
        return Double.compare(this.base, that.base) == 0 && Double.compare(this.impact, that.impact) == 0 && Double.compare(this.exploitability, that.exploitability) == 0 && Double.compare(this.temporal, that.temporal) == 0 && Double.compare(this.environmental, that.environmental) == 0 && Double.compare(this.adjustedImpact, that.adjustedImpact) == 0 && Double.compare(this.overall, that.overall) == 0 && Objects.equals(this.vector, that.vector);
    }

    public int hashCode() {
        return Objects.hash(this.vector, this.base, this.impact, this.exploitability, this.temporal, this.environmental, this.adjustedImpact, this.overall);
    }
}

