/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import org.json.JSONObject;
import org.metaeffekt.core.security.cvss.CvssSeverityRanges;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.processor.BakedCvssVectorScores;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiScoreCvssVector
extends CvssVector {
    private static final Logger LOG = LoggerFactory.getLogger(MultiScoreCvssVector.class);

    public MultiScoreCvssVector() {
    }

    public MultiScoreCvssVector(CvssSource source) {
        super(source);
    }

    public MultiScoreCvssVector(CvssSource source, JSONObject applicabilityCondition) {
        super(source, applicabilityCondition);
    }

    public MultiScoreCvssVector(Collection<CvssSource> sources, JSONObject applicabilityCondition) {
        super(sources, applicabilityCondition);
    }

    public abstract double getImpactScore();

    public abstract double getExploitabilityScore();

    public abstract double getTemporalScore();

    public abstract double getEnvironmentalScore();

    public abstract double getAdjustedImpactScore();

    public abstract CvssSeverityRanges.SeverityRange getDefaultSeverityCategory();

    public CvssSeverityRanges.SeverityRange getSeverityCategory(CvssSeverityRanges ranges) {
        return ranges.getRange(this.getOverallScore());
    }

    public abstract boolean isAnyTemporalDefined();

    public abstract boolean isTemporalFullyDefined();

    public abstract boolean isAnyEnvironmentalDefined();

    public abstract boolean isEnvironmentalFullyDefined();

    public abstract void clearTemporal();

    public abstract void clearEnvironmental();

    public static <T extends MultiScoreCvssVector> double getMaxScore(Function<MultiScoreCvssVector, Double> scoreType, MultiScoreCvssVector ... cvsses) {
        return Arrays.stream(cvsses).filter(Objects::nonNull).map(scoreType).max(Double::compare).orElse(-1.0);
    }

    public static <T extends MultiScoreCvssVector> T getMaxVector(Function<T, Double> scoreType, T ... cvsses) {
        return (T)((MultiScoreCvssVector)Arrays.stream(cvsses).filter(Objects::nonNull).max(Comparator.comparingDouble(scoreType::apply)).orElse(null));
    }

    public static double getMaxScore(Function<BakedCvssVectorScores, Double> scoreType, BakedCvssVectorScores ... cvsses) {
        return Arrays.stream(cvsses).filter(Objects::nonNull).map(scoreType).max(Double::compare).orElse(-1.0);
    }
}

