/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KnownCvssEntities {
    private static final Logger LOG = LoggerFactory.getLogger(KnownCvssEntities.class);
    public static final Map<String, CvssSource.CvssEntity> ENTITIES_BY_KEYNAME = new HashMap<String, CvssSource.CvssEntity>();
    public static final Map<String, CvssSource.CvssEntity> ENTITIES_BY_NAME = new HashMap<String, CvssSource.CvssEntity>();
    public static final Map<String, CvssSource.CvssEntity> ENTITIES_BY_EMAIL = new HashMap<String, CvssSource.CvssEntity>();
    public static final CvssSource.CvssEntity OTHER;
    public static final CvssSource.CvssEntity NVD;
    public static final CvssSource.CvssEntity GHSA;
    public static final CvssSource.CvssEntity OSV;
    public static final CvssSource.CvssEntity ANDROID;
    public static final CvssSource.CvssEntity ALMA;
    public static final CvssSource.CvssEntity OSS_FUZZ;
    public static final CvssSource.CvssEntity DEBIAN;
    public static final CvssSource.CvssEntity ROCKY;
    public static final CvssSource.CvssEntity SUSE;
    public static final CvssSource.CvssEntity PSF;
    public static final CvssSource.CvssEntity RHEL;
    public static final CvssSource.CvssEntity MINI;
    public static final CvssSource.CvssEntity ECHO;
    public static final CvssSource.CvssEntity ALPINE;
    public static final CvssSource.CvssEntity CSAF;
    public static final CvssSource.CvssEntity CERT_SEI;
    public static final CvssSource.CvssEntity MSRC;
    public static final CvssSource.CvssEntity ASSESSMENT;
    public static final CvssSource.CvssEntity ASSESSMENT_LOWER;
    public static final CvssSource.CvssEntity ASSESSMENT_HIGHER;
    public static final CvssSource.CvssEntity ASSESSMENT_LOWER_METRIC;
    public static final CvssSource.CvssEntity ASSESSMENT_HIGHER_METRIC;
    public static final CvssSource.CvssEntity ASSESSMENT_ALL;

    public static List<CvssSource.CvssEntity> getEntities() {
        return new ArrayList<CvssSource.CvssEntity>(ENTITIES_BY_KEYNAME.values());
    }

    public static Map<String, CvssSource.CvssEntity> getEntitiesByKeyName() {
        return new HashMap<String, CvssSource.CvssEntity>(ENTITIES_BY_KEYNAME);
    }

    public static Optional<CvssSource.CvssEntity> findByNameOrMail(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ObjectUtils.firstNonNull((Object[])new CvssSource.CvssEntity[]{ENTITIES_BY_NAME.get(name), ENTITIES_BY_EMAIL.get(name), ENTITIES_BY_KEYNAME.get(name)}));
    }

    public static CvssSource.CvssEntity findByNameOrMailOrCreateNew(String name) {
        return KnownCvssEntities.findByNameOrMail(name).orElseGet(() -> new CvssSource.CvssEntity(name));
    }

    private static void parseEntitiesFromResource(String resourcePath, Class<?> clazz) {
        try (InputStream is = clazz.getResourceAsStream(resourcePath);){
            if (is == null) {
                throw new IllegalStateException("Resource not found: " + resourcePath);
            }
            try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                 BufferedReader reader = new BufferedReader(isr);){
                JSONTokener tokener = new JSONTokener((Reader)reader);
                JSONObject json = new JSONObject(tokener);
                KnownCvssEntities.parseEntitiesFromJson(json);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read resource to parse as CVSS entities: " + resourcePath, e);
        }
    }

    public static void parseEntitiesFromJson(JSONObject json) {
        Set entityKeys = json.keySet();
        HashMap<String, List<String>> dependencyGraph = new HashMap<String, List<String>>();
        HashSet<String> roots = new HashSet<String>();
        for (String key : entityKeys) {
            JSONObject entity = json.getJSONObject(key);
            String root = entity.optString("root", "");
            String topLevelRoot = entity.optString("topLevelRoot", "");
            if (!root.isEmpty()) {
                dependencyGraph.computeIfAbsent(root, k -> new ArrayList()).add(key);
            }
            if (!topLevelRoot.isEmpty() && !topLevelRoot.equals(root)) {
                dependencyGraph.computeIfAbsent(topLevelRoot, k -> new ArrayList()).add(key);
            }
            if (!root.isEmpty() || !topLevelRoot.isEmpty()) continue;
            roots.add(key);
        }
        ArrayList<String> sortedKeys = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String root : roots) {
            KnownCvssEntities.topologicalSort(root, dependencyGraph, visited, sortedKeys);
        }
        for (int i = sortedKeys.size() - 1; i >= 0; --i) {
            String key = (String)sortedKeys.get(i);
            CvssSource.CvssEntity cvssEntity = KnownCvssEntities.parseEntityFromJson(json.getJSONObject(key));
            ENTITIES_BY_KEYNAME.put(key, cvssEntity);
            if (cvssEntity.getName() != null) {
                ENTITIES_BY_NAME.put(cvssEntity.getName(), cvssEntity);
            }
            if (cvssEntity.getEmail() == null) continue;
            ENTITIES_BY_EMAIL.put(cvssEntity.getEmail(), cvssEntity);
        }
    }

    private static CvssSource.CvssEntity parseEntityFromJson(JSONObject json) {
        CvssSource.CvssEntity rootEntity;
        String name = json.optString("name", null);
        String email = json.optString("email", null);
        String url = json.optString("url", null);
        String cveOrgDetailsLink = json.optString("cveOrgDetailsLink", null);
        String description = json.optString("description", null);
        String country = json.optString("country", null);
        String role = json.optString("role", null);
        List<String> organizationTypes = json.has("organizationTypes") ? json.getJSONArray("organizationTypes").toList().stream().map(Object::toString).collect(Collectors.toList()) : Collections.emptyList();
        String topLevelRoot = json.optString("topLevelRoot", null);
        String root = json.optString("root", null);
        List<CvssSource.ReportStep> reportSteps = CvssSource.ReportStep.fromJson(json.optJSONArray("reportSteps"));
        CvssSource.CvssEntity topLevelRootEntity = topLevelRoot != null ? ENTITIES_BY_KEYNAME.get(topLevelRoot) : null;
        CvssSource.CvssEntity cvssEntity = rootEntity = root != null ? ENTITIES_BY_KEYNAME.get(root) : null;
        if (topLevelRoot != null && topLevelRootEntity == null) {
            throw new IllegalStateException("Failed to find top level root entity [" + topLevelRoot + "] on entity [" + name + "]");
        }
        if (root != null && rootEntity == null) {
            throw new IllegalStateException("Failed to find root entity [" + root + "] on entity [" + name + "]");
        }
        return new CvssSource.CvssEntity(name, email, KnownCvssEntities.parseUrl(url), KnownCvssEntities.parseUrl(cveOrgDetailsLink), description, country, role, organizationTypes, topLevelRootEntity, rootEntity, reportSteps);
    }

    private static URL parseUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to parse URL: " + url, e);
        }
    }

    private static void topologicalSort(String node, Map<String, List<String>> dependencyGraph, Set<String> visited, List<String> sortedKeys) {
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        List<String> dependencies = dependencyGraph.get(node);
        if (dependencies != null) {
            for (String dep : dependencies) {
                KnownCvssEntities.topologicalSort(dep, dependencyGraph, visited, sortedKeys);
            }
        }
        sortedKeys.add(node);
    }

    static {
        KnownCvssEntities.parseEntitiesFromResource("/cvss/entities/cna.json", KnownCvssEntities.class);
        KnownCvssEntities.parseEntitiesFromResource("/cvss/entities/assessment.json", KnownCvssEntities.class);
        KnownCvssEntities.parseEntitiesFromResource("/cvss/entities/other.json", KnownCvssEntities.class);
        OTHER = ENTITIES_BY_KEYNAME.get("OTHER");
        NVD = ENTITIES_BY_KEYNAME.get("NIST_NVD");
        GHSA = (CvssSource.CvssEntity)ObjectUtils.firstNonNull((Object[])new CvssSource.CvssEntity[]{ENTITIES_BY_KEYNAME.get("CVE_CNA_GITHUB_M"), ENTITIES_BY_NAME.get("GitHub, Inc.")});
        OSV = ENTITIES_BY_KEYNAME.get("OSV");
        ANDROID = ENTITIES_BY_KEYNAME.get("ANDROID");
        ALMA = ENTITIES_BY_KEYNAME.get("ALMA");
        OSS_FUZZ = ENTITIES_BY_KEYNAME.get("OSS-FUZZ");
        DEBIAN = ENTITIES_BY_KEYNAME.get("DEBIAN");
        ROCKY = ENTITIES_BY_KEYNAME.get("ROCKY");
        SUSE = ENTITIES_BY_KEYNAME.get("SUSE");
        PSF = ENTITIES_BY_KEYNAME.get("PSF");
        RHEL = ENTITIES_BY_KEYNAME.get("RHEL");
        MINI = ENTITIES_BY_KEYNAME.get("MINI");
        ECHO = ENTITIES_BY_KEYNAME.get("ECHO");
        ALPINE = ENTITIES_BY_KEYNAME.get("ALPINE");
        CSAF = ENTITIES_BY_KEYNAME.get("CSAF");
        CERT_SEI = ENTITIES_BY_KEYNAME.get("CERT_SEI");
        MSRC = ENTITIES_BY_KEYNAME.get("CVE_CNA_MICROSOFT");
        ASSESSMENT = ENTITIES_BY_KEYNAME.get("ASSESSMENT");
        ASSESSMENT_LOWER = ENTITIES_BY_KEYNAME.get("ASSESSMENT_LOWER");
        ASSESSMENT_HIGHER = ENTITIES_BY_KEYNAME.get("ASSESSMENT_HIGHER");
        ASSESSMENT_LOWER_METRIC = ENTITIES_BY_KEYNAME.get("ASSESSMENT_LOWER_METRIC");
        ASSESSMENT_HIGHER_METRIC = ENTITIES_BY_KEYNAME.get("ASSESSMENT_HIGHER_METRIC");
        ASSESSMENT_ALL = ENTITIES_BY_KEYNAME.get("ASSESSMENT_ALL");
    }
}

