/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss;

import java.util.Arrays;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.core.util.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvssSeverityRanges {
    private static final Logger LOG = LoggerFactory.getLogger(CvssSeverityRanges.class);
    private final SeverityRange[] ranges;
    public static final SeverityRange UNDEFINED_SEVERITY_RANGE = new SeverityRange("Undefined:strong-gray:-100.0:100.0", -1);
    public static final CvssSeverityRanges CVSS_2_SEVERITY_RANGES = new CvssSeverityRanges("Low:strong-yellow::3.9,Medium:strong-light-orange:4.0:6.9,High:strong-red:7.0:");
    public static final CvssSeverityRanges CVSS_3_SEVERITY_RANGES = new CvssSeverityRanges("None:pastel-gray::0.0,Low:strong-yellow:0.1:3.9,Medium:strong-light-orange:4.0:6.9,High:strong-dark-orange:7.0:8.9,Critical:strong-red:9.0:");
    public static final CvssSeverityRanges PRIORITY_SCORE_SEVERITY_RANGES = new CvssSeverityRanges("none:pastel-gray::4.9,elevated:strong-light-orange:5.0:6.9,due:strong-dark-orange:7.0:8.9,escalate:strong-red:9.0:");
    public static final CvssSeverityRanges EPSS_SCORE_SEVERITY_RANGES = new CvssSeverityRanges(">0.8:strong-red:0.8:,>0.1:strong-light-orange:0.1:0.8,>0.01:strong-yellow:0.01:0.1,\u22640.01:pastel-gray::0.01");

    public CvssSeverityRanges() {
        this("cvss3");
    }

    public CvssSeverityRanges(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            LOG.warn("No severity ranges defined. Using default (v3) ranges.");
            this.ranges = CvssSeverityRanges.CVSS_3_SEVERITY_RANGES.ranges;
            return;
        }
        if (input.equals("cvss3") || input.equals("cvss4")) {
            this.ranges = CvssSeverityRanges.CVSS_3_SEVERITY_RANGES.ranges;
        } else if (input.equals("cvss2")) {
            this.ranges = CvssSeverityRanges.CVSS_2_SEVERITY_RANGES.ranges;
        } else {
            String[] splitRangesInputs = input.split(", ?");
            this.ranges = new SeverityRange[splitRangesInputs.length];
            for (int i = 0; i < splitRangesInputs.length; ++i) {
                this.ranges[i] = new SeverityRange(splitRangesInputs[i], i);
            }
        }
    }

    public SeverityRange getRange(double score) {
        for (SeverityRange range : this.ranges) {
            if (!range.matches(score)) continue;
            return range;
        }
        return UNDEFINED_SEVERITY_RANGE;
    }

    public SeverityRange getRangeByName(String name) {
        for (SeverityRange range : this.ranges) {
            if (!range.getName().equals(name)) continue;
            return range;
        }
        return UNDEFINED_SEVERITY_RANGE;
    }

    public SeverityRange getRangeByNameInsensitive(String name) {
        for (SeverityRange range : this.ranges) {
            if (!range.getName().equalsIgnoreCase(name)) continue;
            return range;
        }
        return UNDEFINED_SEVERITY_RANGE;
    }

    public SeverityRange[] getRanges() {
        return this.ranges;
    }

    public String getRangeNames() {
        return Arrays.stream(this.ranges).map(SeverityRange::getName).collect(Collectors.joining(", "));
    }

    public String toString() {
        return Arrays.stream(this.ranges).map(SeverityRange::toString).collect(Collectors.joining(","));
    }

    private static String getAvailableColors() {
        StringJoiner colors = new StringJoiner(", ");
        for (ColorScheme value : ColorScheme.values()) {
            colors.add(value.getCssRootName());
        }
        return colors.toString();
    }

    public static class SeverityRange
    implements Comparable<SeverityRange> {
        private final String name;
        private final ColorScheme color;
        private final double floor;
        private final double ceil;
        private final int index;
        private static final Pattern RANGE_PATTERN = Pattern.compile("([^:]+):([^:]+):([^:]*):([^:]*)");

        private SeverityRange(String input, int index) {
            Matcher matcher = RANGE_PATTERN.matcher(input);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Range pattern does not match format [NAME:COLOR:FLOOR:CEIL] in " + input);
            }
            this.name = matcher.group(1).trim();
            this.color = ColorScheme.getColor(matcher.group(2));
            if (this.color == null) {
                throw new IllegalArgumentException("Range color unknown in [" + input + "]. available colors are [" + CvssSeverityRanges.getAvailableColors() + "]");
            }
            String floorStr = matcher.group(3).trim();
            String ceilStr = matcher.group(4).trim();
            this.floor = StringUtils.isEmpty((CharSequence)floorStr) ? -1.7976931348623157E308 : Double.parseDouble(floorStr);
            double d = this.ceil = StringUtils.isEmpty((CharSequence)ceilStr) ? Double.MAX_VALUE : Double.parseDouble(ceilStr);
            if (floorStr.isEmpty() && ceilStr.isEmpty()) {
                throw new IllegalArgumentException("Both floor and ceil cannot be empty in [" + input + "]");
            }
            if (this.floor > this.ceil) {
                throw new IllegalArgumentException("Range floor [" + this.floor + "] must be smaller than range ceil [" + this.ceil + "] in [" + input + "]");
            }
            this.index = index;
        }

        public boolean matches(double score) {
            return score >= this.floor && score <= this.ceil;
        }

        public String getName() {
            return this.name;
        }

        public ColorScheme getColor() {
            return this.color;
        }

        public double getFloor() {
            return this.floor;
        }

        public double getCeil() {
            return this.ceil;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public int compareTo(SeverityRange o) {
            return Double.compare(this.floor, o.floor);
        }

        public String toString() {
            return String.format("%s:%s:%s:%s", this.name, this.color.getCssRootName(), this.floor == -1.7976931348623157E308 ? "" : Double.valueOf(this.floor), this.ceil == Double.MAX_VALUE ? "" : Double.valueOf(this.ceil));
        }
    }
}

