/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.ExtendedDismaxQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.util.SolrPluginUtils;

public class XWikiDismaxQParserPlugin
extends ExtendedDismaxQParserPlugin {
    private static final Pattern LIST_SEPARATOR = Pattern.compile("\\s*,\\s*");
    private static final Pattern FIELD_PATTERN = Pattern.compile("(?:^|[+\\-(\\s])([a-z_][\\p{L}\\p{N}_\\-.$]*):");
    private static final String WILDCARD = "*";

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return super.createParser(qstr, localParams, this.withFieldAliases(qstr, params), req);
    }

    public SolrParams withFieldAliases(String query, SolrParams parameters) {
        Set<String> fieldNames = this.extractFieldNames(query);
        String defaultQueryFields = parameters.get("qf");
        if (defaultQueryFields != null) {
            fieldNames.addAll(SolrPluginUtils.parseFieldBoosts((String)defaultQueryFields).keySet());
        }
        if (fieldNames.isEmpty()) {
            return parameters;
        }
        HashMap<String, String> aliasParameters = new HashMap<String, String>();
        this.addMultilingualFieldAliases(fieldNames, aliasParameters, parameters);
        this.addTypedDynamicFieldAliases(fieldNames, aliasParameters, parameters);
        return aliasParameters.isEmpty() ? parameters : SolrParams.wrapDefaults((SolrParams)new MapSolrParams(aliasParameters), (SolrParams)parameters);
    }

    private void addMultilingualFieldAliases(Set<String> fieldNames, Map<String, String> aliasParameters, SolrParams parameters) {
        List<String> multilingualFields = XWikiDismaxQParserPlugin.getListParameter("xwiki.multilingualFields", parameters);
        if (multilingualFields.isEmpty()) {
            return;
        }
        List<String> supportedLocales = XWikiDismaxQParserPlugin.getSupportedLocales(parameters);
        for (String fieldName : fieldNames) {
            if (!this.matchesFieldName(fieldName, multilingualFields)) continue;
            this.addAliases(fieldName, supportedLocales, aliasParameters);
        }
    }

    private void addTypedDynamicFieldAliases(Set<String> fieldNames, Map<String, String> aliasParameters, SolrParams parameters) {
        List<String> typedDynamicFields = XWikiDismaxQParserPlugin.getListParameter("xwiki.typedDynamicFields", parameters);
        List<String> dynamicFieldTypes = XWikiDismaxQParserPlugin.getListParameter("xwiki.dynamicFieldTypes", parameters);
        if (typedDynamicFields.isEmpty() || dynamicFieldTypes.isEmpty()) {
            return;
        }
        for (String fieldName : fieldNames) {
            if (!this.matchesFieldName(fieldName, typedDynamicFields)) continue;
            this.addAliases(fieldName, dynamicFieldTypes, aliasParameters);
        }
    }

    public Set<String> extractFieldNames(String query) {
        HashSet<String> fieldNames = new HashSet<String>();
        Matcher matcher = FIELD_PATTERN.matcher(query);
        while (matcher.find()) {
            fieldNames.add(matcher.group(1));
        }
        return fieldNames;
    }

    private static List<String> getListParameter(String parameter, SolrParams parameters) {
        String value = parameters.get(parameter);
        if (value != null) {
            return Arrays.asList(LIST_SEPARATOR.split(value));
        }
        return Collections.emptyList();
    }

    private static List<String> getSupportedLocales(SolrParams parameters) {
        ArrayList<String> supportedLocalesList = new ArrayList<String>();
        supportedLocalesList.add("_");
        String supportedLocales = parameters.get("xwiki.supportedLocales");
        if (supportedLocales != null) {
            supportedLocalesList.addAll(Arrays.asList(LIST_SEPARATOR.split(supportedLocales)));
        }
        return supportedLocalesList;
    }

    private boolean matchesFieldName(String fieldName, List<String> fieldNamePatterns) {
        for (String fieldNamePattern : fieldNamePatterns) {
            if (fieldNamePattern.equals(fieldName)) {
                return true;
            }
            if (!(fieldNamePattern.endsWith(WILDCARD) ? fieldName.startsWith(fieldNamePattern.substring(0, fieldNamePattern.length() - 1)) : fieldNamePattern.startsWith(WILDCARD) && fieldName.endsWith(fieldNamePattern.substring(1)))) continue;
            return true;
        }
        return false;
    }

    private void addAliases(String fieldName, List<String> suffixes, Map<String, String> aliasParameters) {
        String aliasParameterName = String.format("f.%s.qf", fieldName);
        StringBuilder aliasParameterValue = new StringBuilder();
        for (String suffix : suffixes) {
            aliasParameterValue.append(' ').append(fieldName).append('_').append(suffix);
        }
        String previousValue = aliasParameters.get(aliasParameterName);
        aliasParameters.put(aliasParameterName, (String)(previousValue == null ? aliasParameterValue.substring(1) : previousValue + aliasParameterValue.toString()));
    }
}

