/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.linkchecker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.internal.transformation.linkchecker.HTTPChecker;
import org.xwiki.rendering.internal.transformation.linkchecker.LinkCheckerThread;
import org.xwiki.rendering.internal.transformation.linkchecker.LinkQueueItem;
import org.xwiki.rendering.transformation.linkchecker.InvalidURLEvent;
import org.xwiki.rendering.transformation.linkchecker.LinkCheckerThreadInitializer;
import org.xwiki.rendering.transformation.linkchecker.LinkCheckerTransformationConfiguration;
import org.xwiki.rendering.transformation.linkchecker.LinkState;
import org.xwiki.rendering.transformation.linkchecker.LinkStateManager;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultLinkCheckerThread
extends Thread
implements LinkCheckerThread {
    private static final String EVENT_DATA_SOURCE = "source";
    private static final String EVENT_DATA_URL = "url";
    private static final String EVENT_DATA_STATE = "state";
    private static final String EVENT_DATA_CONTEXTDATA = "contextData";
    @Inject
    private Logger logger;
    @Inject
    private Provider<List<LinkCheckerThreadInitializer>> linkCheckerThreadInitializersProvider;
    @Inject
    private LinkStateManager linkStateManager;
    @Inject
    private Provider<ObservationManager> observationManagerProvider;
    @Inject
    private HTTPChecker httpChecker;
    @Inject
    private LinkCheckerTransformationConfiguration configuration;
    private Queue<LinkQueueItem> linkQueue;
    private volatile boolean shouldStop;

    @Override
    public void startProcessing(Queue<LinkQueueItem> linkQueue) {
        this.linkQueue = linkQueue;
        this.start();
    }

    @Override
    public void run(Queue<LinkQueueItem> linkQueue) {
        this.linkQueue = linkQueue;
        this.run();
    }

    @Override
    public void run() {
        for (LinkCheckerThreadInitializer initializer : (List)this.linkCheckerThreadInitializersProvider.get()) {
            initializer.initialize();
        }
        while (!this.shouldStop) {
            try {
                this.processLinkQueue();
                Thread.sleep(300L);
            }
            catch (Exception e) {
                this.logger.error("Link checker Thread was stopped due to some problem", (Throwable)e);
                break;
            }
        }
    }

    @Override
    public void stopProcessing() {
        this.shouldStop = true;
        this.interrupt();
    }

    protected void processLinkQueue() {
        long timeout = this.configuration.getCheckTimeout();
        List<Pattern> excludedReferencePatterns = this.configuration.getExcludedReferencePatterns();
        LinkQueueItem queueItem = null;
        boolean shouldBeChecked = false;
        while (!this.linkQueue.isEmpty() && !shouldBeChecked && (shouldBeChecked = this.isExcluded((queueItem = this.linkQueue.poll()).getContentReference(), excludedReferencePatterns))) {
            LinkState state;
            Map<String, LinkState> contentReferences = this.linkStateManager.getLinkStates().get(queueItem.getLinkReference());
            if (contentReferences == null || (state = contentReferences.get(queueItem.getContentReference())) == null || System.currentTimeMillis() - state.getLastCheckedTime() > timeout) continue;
            shouldBeChecked = false;
        }
        if (shouldBeChecked && queueItem != null) {
            this.checkLink(queueItem);
        }
    }

    private boolean isExcluded(String contentReference, List<Pattern> excludedReferencePatterns) {
        for (Pattern pattern : excludedReferencePatterns) {
            Matcher matcher = pattern.matcher(contentReference);
            if (!matcher.matches()) continue;
            return false;
        }
        return true;
    }

    private void checkLink(LinkQueueItem queueItem) {
        int responseCode = this.httpChecker.check(queueItem.getLinkReference());
        Map<String, LinkState> contentReferences = this.linkStateManager.getLinkStates().get(queueItem.getLinkReference());
        if (contentReferences == null) {
            contentReferences = new ConcurrentHashMap<String, LinkState>();
        }
        LinkState state = new LinkState(responseCode, System.currentTimeMillis(), queueItem.getContextData());
        contentReferences.put(queueItem.getContentReference(), state);
        this.linkStateManager.getLinkStates().put(queueItem.getLinkReference(), contentReferences);
        if (responseCode < 200 || responseCode > 299) {
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put(EVENT_DATA_URL, queueItem.getLinkReference());
            eventData.put(EVENT_DATA_SOURCE, queueItem.getContentReference());
            eventData.put(EVENT_DATA_STATE, state);
            eventData.put(EVENT_DATA_CONTEXTDATA, queueItem.getContextData());
            this.sendEvent(queueItem.getLinkReference(), eventData);
        }
    }

    private void sendEvent(String url, Map<String, Object> data) {
        try {
            ObservationManager observationManager = (ObservationManager)this.observationManagerProvider.get();
            observationManager.notify((Event)new InvalidURLEvent(url), data);
        }
        catch (Exception e) {
            this.logger.warn("The Invalid URL Event for URL [{}] (source [{}]) wasn't sent as no Observation Manager Component was found", (Object)url, data.get(EVENT_DATA_SOURCE));
        }
    }
}

